<?php
/**
 * SalesDataCreditmemoInterface
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * SalesDataCreditmemoInterface Class Doc Comment
 *
 * @category Class
 * @description Credit memo interface. After a customer places and pays for an order and an invoice has been issued, the merchant can create a credit memo to refund all or part of the amount paid for any returned or undelivered items. The memo restores funds to the customer account so that the customer can make future purchases.
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SalesDataCreditmemoInterface implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'sales-data-creditmemo-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'adjustment' => 'float',
        'adjustment_negative' => 'float',
        'adjustment_positive' => 'float',
        'base_adjustment' => 'float',
        'base_adjustment_negative' => 'float',
        'base_adjustment_positive' => 'float',
        'base_currency_code' => 'string',
        'base_discount_amount' => 'float',
        'base_grand_total' => 'float',
        'base_discount_tax_compensation_amount' => 'float',
        'base_shipping_amount' => 'float',
        'base_shipping_discount_tax_compensation_amnt' => 'float',
        'base_shipping_incl_tax' => 'float',
        'base_shipping_tax_amount' => 'float',
        'base_subtotal' => 'float',
        'base_subtotal_incl_tax' => 'float',
        'base_tax_amount' => 'float',
        'base_to_global_rate' => 'float',
        'base_to_order_rate' => 'float',
        'billing_address_id' => 'int',
        'created_at' => 'string',
        'creditmemo_status' => 'int',
        'discount_amount' => 'float',
        'discount_description' => 'string',
        'email_sent' => 'int',
        'entity_id' => 'int',
        'global_currency_code' => 'string',
        'grand_total' => 'float',
        'discount_tax_compensation_amount' => 'float',
        'increment_id' => 'string',
        'invoice_id' => 'int',
        'order_currency_code' => 'string',
        'order_id' => 'int',
        'shipping_address_id' => 'int',
        'shipping_amount' => 'float',
        'shipping_discount_tax_compensation_amount' => 'float',
        'shipping_incl_tax' => 'float',
        'shipping_tax_amount' => 'float',
        'state' => 'int',
        'store_currency_code' => 'string',
        'store_id' => 'int',
        'store_to_base_rate' => 'float',
        'store_to_order_rate' => 'float',
        'subtotal' => 'float',
        'subtotal_incl_tax' => 'float',
        'tax_amount' => 'float',
        'transaction_id' => 'string',
        'updated_at' => 'string',
        'items' => '\Swagger\Client\Model\SalesDataCreditmemoItemInterface[]',
        'comments' => '\Swagger\Client\Model\SalesDataCreditmemoCommentInterface[]',
        'extension_attributes' => '\Swagger\Client\Model\SalesDataCreditmemoExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'adjustment' => null,
        'adjustment_negative' => null,
        'adjustment_positive' => null,
        'base_adjustment' => null,
        'base_adjustment_negative' => null,
        'base_adjustment_positive' => null,
        'base_currency_code' => null,
        'base_discount_amount' => null,
        'base_grand_total' => null,
        'base_discount_tax_compensation_amount' => null,
        'base_shipping_amount' => null,
        'base_shipping_discount_tax_compensation_amnt' => null,
        'base_shipping_incl_tax' => null,
        'base_shipping_tax_amount' => null,
        'base_subtotal' => null,
        'base_subtotal_incl_tax' => null,
        'base_tax_amount' => null,
        'base_to_global_rate' => null,
        'base_to_order_rate' => null,
        'billing_address_id' => null,
        'created_at' => null,
        'creditmemo_status' => null,
        'discount_amount' => null,
        'discount_description' => null,
        'email_sent' => null,
        'entity_id' => null,
        'global_currency_code' => null,
        'grand_total' => null,
        'discount_tax_compensation_amount' => null,
        'increment_id' => null,
        'invoice_id' => null,
        'order_currency_code' => null,
        'order_id' => null,
        'shipping_address_id' => null,
        'shipping_amount' => null,
        'shipping_discount_tax_compensation_amount' => null,
        'shipping_incl_tax' => null,
        'shipping_tax_amount' => null,
        'state' => null,
        'store_currency_code' => null,
        'store_id' => null,
        'store_to_base_rate' => null,
        'store_to_order_rate' => null,
        'subtotal' => null,
        'subtotal_incl_tax' => null,
        'tax_amount' => null,
        'transaction_id' => null,
        'updated_at' => null,
        'items' => null,
        'comments' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'adjustment' => 'adjustment',
        'adjustment_negative' => 'adjustmentNegative',
        'adjustment_positive' => 'adjustmentPositive',
        'base_adjustment' => 'baseAdjustment',
        'base_adjustment_negative' => 'baseAdjustmentNegative',
        'base_adjustment_positive' => 'baseAdjustmentPositive',
        'base_currency_code' => 'baseCurrencyCode',
        'base_discount_amount' => 'baseDiscountAmount',
        'base_grand_total' => 'baseGrandTotal',
        'base_discount_tax_compensation_amount' => 'baseDiscountTaxCompensationAmount',
        'base_shipping_amount' => 'baseShippingAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'baseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'baseShippingInclTax',
        'base_shipping_tax_amount' => 'baseShippingTaxAmount',
        'base_subtotal' => 'baseSubtotal',
        'base_subtotal_incl_tax' => 'baseSubtotalInclTax',
        'base_tax_amount' => 'baseTaxAmount',
        'base_to_global_rate' => 'baseToGlobalRate',
        'base_to_order_rate' => 'baseToOrderRate',
        'billing_address_id' => 'billingAddressId',
        'created_at' => 'createdAt',
        'creditmemo_status' => 'creditmemoStatus',
        'discount_amount' => 'discountAmount',
        'discount_description' => 'discountDescription',
        'email_sent' => 'emailSent',
        'entity_id' => 'entityId',
        'global_currency_code' => 'globalCurrencyCode',
        'grand_total' => 'grandTotal',
        'discount_tax_compensation_amount' => 'discountTaxCompensationAmount',
        'increment_id' => 'incrementId',
        'invoice_id' => 'invoiceId',
        'order_currency_code' => 'orderCurrencyCode',
        'order_id' => 'orderId',
        'shipping_address_id' => 'shippingAddressId',
        'shipping_amount' => 'shippingAmount',
        'shipping_discount_tax_compensation_amount' => 'shippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'shippingInclTax',
        'shipping_tax_amount' => 'shippingTaxAmount',
        'state' => 'state',
        'store_currency_code' => 'storeCurrencyCode',
        'store_id' => 'storeId',
        'store_to_base_rate' => 'storeToBaseRate',
        'store_to_order_rate' => 'storeToOrderRate',
        'subtotal' => 'subtotal',
        'subtotal_incl_tax' => 'subtotalInclTax',
        'tax_amount' => 'taxAmount',
        'transaction_id' => 'transactionId',
        'updated_at' => 'updatedAt',
        'items' => 'items',
        'comments' => 'comments',
        'extension_attributes' => 'extensionAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'adjustment' => 'setAdjustment',
        'adjustment_negative' => 'setAdjustmentNegative',
        'adjustment_positive' => 'setAdjustmentPositive',
        'base_adjustment' => 'setBaseAdjustment',
        'base_adjustment_negative' => 'setBaseAdjustmentNegative',
        'base_adjustment_positive' => 'setBaseAdjustmentPositive',
        'base_currency_code' => 'setBaseCurrencyCode',
        'base_discount_amount' => 'setBaseDiscountAmount',
        'base_grand_total' => 'setBaseGrandTotal',
        'base_discount_tax_compensation_amount' => 'setBaseDiscountTaxCompensationAmount',
        'base_shipping_amount' => 'setBaseShippingAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'setBaseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'setBaseShippingInclTax',
        'base_shipping_tax_amount' => 'setBaseShippingTaxAmount',
        'base_subtotal' => 'setBaseSubtotal',
        'base_subtotal_incl_tax' => 'setBaseSubtotalInclTax',
        'base_tax_amount' => 'setBaseTaxAmount',
        'base_to_global_rate' => 'setBaseToGlobalRate',
        'base_to_order_rate' => 'setBaseToOrderRate',
        'billing_address_id' => 'setBillingAddressId',
        'created_at' => 'setCreatedAt',
        'creditmemo_status' => 'setCreditmemoStatus',
        'discount_amount' => 'setDiscountAmount',
        'discount_description' => 'setDiscountDescription',
        'email_sent' => 'setEmailSent',
        'entity_id' => 'setEntityId',
        'global_currency_code' => 'setGlobalCurrencyCode',
        'grand_total' => 'setGrandTotal',
        'discount_tax_compensation_amount' => 'setDiscountTaxCompensationAmount',
        'increment_id' => 'setIncrementId',
        'invoice_id' => 'setInvoiceId',
        'order_currency_code' => 'setOrderCurrencyCode',
        'order_id' => 'setOrderId',
        'shipping_address_id' => 'setShippingAddressId',
        'shipping_amount' => 'setShippingAmount',
        'shipping_discount_tax_compensation_amount' => 'setShippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'setShippingInclTax',
        'shipping_tax_amount' => 'setShippingTaxAmount',
        'state' => 'setState',
        'store_currency_code' => 'setStoreCurrencyCode',
        'store_id' => 'setStoreId',
        'store_to_base_rate' => 'setStoreToBaseRate',
        'store_to_order_rate' => 'setStoreToOrderRate',
        'subtotal' => 'setSubtotal',
        'subtotal_incl_tax' => 'setSubtotalInclTax',
        'tax_amount' => 'setTaxAmount',
        'transaction_id' => 'setTransactionId',
        'updated_at' => 'setUpdatedAt',
        'items' => 'setItems',
        'comments' => 'setComments',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'adjustment' => 'getAdjustment',
        'adjustment_negative' => 'getAdjustmentNegative',
        'adjustment_positive' => 'getAdjustmentPositive',
        'base_adjustment' => 'getBaseAdjustment',
        'base_adjustment_negative' => 'getBaseAdjustmentNegative',
        'base_adjustment_positive' => 'getBaseAdjustmentPositive',
        'base_currency_code' => 'getBaseCurrencyCode',
        'base_discount_amount' => 'getBaseDiscountAmount',
        'base_grand_total' => 'getBaseGrandTotal',
        'base_discount_tax_compensation_amount' => 'getBaseDiscountTaxCompensationAmount',
        'base_shipping_amount' => 'getBaseShippingAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'getBaseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'getBaseShippingInclTax',
        'base_shipping_tax_amount' => 'getBaseShippingTaxAmount',
        'base_subtotal' => 'getBaseSubtotal',
        'base_subtotal_incl_tax' => 'getBaseSubtotalInclTax',
        'base_tax_amount' => 'getBaseTaxAmount',
        'base_to_global_rate' => 'getBaseToGlobalRate',
        'base_to_order_rate' => 'getBaseToOrderRate',
        'billing_address_id' => 'getBillingAddressId',
        'created_at' => 'getCreatedAt',
        'creditmemo_status' => 'getCreditmemoStatus',
        'discount_amount' => 'getDiscountAmount',
        'discount_description' => 'getDiscountDescription',
        'email_sent' => 'getEmailSent',
        'entity_id' => 'getEntityId',
        'global_currency_code' => 'getGlobalCurrencyCode',
        'grand_total' => 'getGrandTotal',
        'discount_tax_compensation_amount' => 'getDiscountTaxCompensationAmount',
        'increment_id' => 'getIncrementId',
        'invoice_id' => 'getInvoiceId',
        'order_currency_code' => 'getOrderCurrencyCode',
        'order_id' => 'getOrderId',
        'shipping_address_id' => 'getShippingAddressId',
        'shipping_amount' => 'getShippingAmount',
        'shipping_discount_tax_compensation_amount' => 'getShippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'getShippingInclTax',
        'shipping_tax_amount' => 'getShippingTaxAmount',
        'state' => 'getState',
        'store_currency_code' => 'getStoreCurrencyCode',
        'store_id' => 'getStoreId',
        'store_to_base_rate' => 'getStoreToBaseRate',
        'store_to_order_rate' => 'getStoreToOrderRate',
        'subtotal' => 'getSubtotal',
        'subtotal_incl_tax' => 'getSubtotalInclTax',
        'tax_amount' => 'getTaxAmount',
        'transaction_id' => 'getTransactionId',
        'updated_at' => 'getUpdatedAt',
        'items' => 'getItems',
        'comments' => 'getComments',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['adjustment'] = isset($data['adjustment']) ? $data['adjustment'] : null;
        $this->container['adjustment_negative'] = isset($data['adjustment_negative']) ? $data['adjustment_negative'] : null;
        $this->container['adjustment_positive'] = isset($data['adjustment_positive']) ? $data['adjustment_positive'] : null;
        $this->container['base_adjustment'] = isset($data['base_adjustment']) ? $data['base_adjustment'] : null;
        $this->container['base_adjustment_negative'] = isset($data['base_adjustment_negative']) ? $data['base_adjustment_negative'] : null;
        $this->container['base_adjustment_positive'] = isset($data['base_adjustment_positive']) ? $data['base_adjustment_positive'] : null;
        $this->container['base_currency_code'] = isset($data['base_currency_code']) ? $data['base_currency_code'] : null;
        $this->container['base_discount_amount'] = isset($data['base_discount_amount']) ? $data['base_discount_amount'] : null;
        $this->container['base_grand_total'] = isset($data['base_grand_total']) ? $data['base_grand_total'] : null;
        $this->container['base_discount_tax_compensation_amount'] = isset($data['base_discount_tax_compensation_amount']) ? $data['base_discount_tax_compensation_amount'] : null;
        $this->container['base_shipping_amount'] = isset($data['base_shipping_amount']) ? $data['base_shipping_amount'] : null;
        $this->container['base_shipping_discount_tax_compensation_amnt'] = isset($data['base_shipping_discount_tax_compensation_amnt']) ? $data['base_shipping_discount_tax_compensation_amnt'] : null;
        $this->container['base_shipping_incl_tax'] = isset($data['base_shipping_incl_tax']) ? $data['base_shipping_incl_tax'] : null;
        $this->container['base_shipping_tax_amount'] = isset($data['base_shipping_tax_amount']) ? $data['base_shipping_tax_amount'] : null;
        $this->container['base_subtotal'] = isset($data['base_subtotal']) ? $data['base_subtotal'] : null;
        $this->container['base_subtotal_incl_tax'] = isset($data['base_subtotal_incl_tax']) ? $data['base_subtotal_incl_tax'] : null;
        $this->container['base_tax_amount'] = isset($data['base_tax_amount']) ? $data['base_tax_amount'] : null;
        $this->container['base_to_global_rate'] = isset($data['base_to_global_rate']) ? $data['base_to_global_rate'] : null;
        $this->container['base_to_order_rate'] = isset($data['base_to_order_rate']) ? $data['base_to_order_rate'] : null;
        $this->container['billing_address_id'] = isset($data['billing_address_id']) ? $data['billing_address_id'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['creditmemo_status'] = isset($data['creditmemo_status']) ? $data['creditmemo_status'] : null;
        $this->container['discount_amount'] = isset($data['discount_amount']) ? $data['discount_amount'] : null;
        $this->container['discount_description'] = isset($data['discount_description']) ? $data['discount_description'] : null;
        $this->container['email_sent'] = isset($data['email_sent']) ? $data['email_sent'] : null;
        $this->container['entity_id'] = isset($data['entity_id']) ? $data['entity_id'] : null;
        $this->container['global_currency_code'] = isset($data['global_currency_code']) ? $data['global_currency_code'] : null;
        $this->container['grand_total'] = isset($data['grand_total']) ? $data['grand_total'] : null;
        $this->container['discount_tax_compensation_amount'] = isset($data['discount_tax_compensation_amount']) ? $data['discount_tax_compensation_amount'] : null;
        $this->container['increment_id'] = isset($data['increment_id']) ? $data['increment_id'] : null;
        $this->container['invoice_id'] = isset($data['invoice_id']) ? $data['invoice_id'] : null;
        $this->container['order_currency_code'] = isset($data['order_currency_code']) ? $data['order_currency_code'] : null;
        $this->container['order_id'] = isset($data['order_id']) ? $data['order_id'] : null;
        $this->container['shipping_address_id'] = isset($data['shipping_address_id']) ? $data['shipping_address_id'] : null;
        $this->container['shipping_amount'] = isset($data['shipping_amount']) ? $data['shipping_amount'] : null;
        $this->container['shipping_discount_tax_compensation_amount'] = isset($data['shipping_discount_tax_compensation_amount']) ? $data['shipping_discount_tax_compensation_amount'] : null;
        $this->container['shipping_incl_tax'] = isset($data['shipping_incl_tax']) ? $data['shipping_incl_tax'] : null;
        $this->container['shipping_tax_amount'] = isset($data['shipping_tax_amount']) ? $data['shipping_tax_amount'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['store_currency_code'] = isset($data['store_currency_code']) ? $data['store_currency_code'] : null;
        $this->container['store_id'] = isset($data['store_id']) ? $data['store_id'] : null;
        $this->container['store_to_base_rate'] = isset($data['store_to_base_rate']) ? $data['store_to_base_rate'] : null;
        $this->container['store_to_order_rate'] = isset($data['store_to_order_rate']) ? $data['store_to_order_rate'] : null;
        $this->container['subtotal'] = isset($data['subtotal']) ? $data['subtotal'] : null;
        $this->container['subtotal_incl_tax'] = isset($data['subtotal_incl_tax']) ? $data['subtotal_incl_tax'] : null;
        $this->container['tax_amount'] = isset($data['tax_amount']) ? $data['tax_amount'] : null;
        $this->container['transaction_id'] = isset($data['transaction_id']) ? $data['transaction_id'] : null;
        $this->container['updated_at'] = isset($data['updated_at']) ? $data['updated_at'] : null;
        $this->container['items'] = isset($data['items']) ? $data['items'] : null;
        $this->container['comments'] = isset($data['comments']) ? $data['comments'] : null;
        $this->container['extension_attributes'] = isset($data['extension_attributes']) ? $data['extension_attributes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['order_id'] === null) {
            $invalidProperties[] = "'order_id' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['order_id'] === null) {
            return false;
        }
        if ($this->container['items'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets adjustment
     *
     * @return float
     */
    public function getAdjustment()
    {
        return $this->container['adjustment'];
    }

    /**
     * Sets adjustment
     *
     * @param float $adjustment Credit memo adjustment.
     *
     * @return $this
     */
    public function setAdjustment($adjustment)
    {
        $this->container['adjustment'] = $adjustment;

        return $this;
    }

    /**
     * Gets adjustment_negative
     *
     * @return float
     */
    public function getAdjustmentNegative()
    {
        return $this->container['adjustment_negative'];
    }

    /**
     * Sets adjustment_negative
     *
     * @param float $adjustment_negative Credit memo negative adjustment.
     *
     * @return $this
     */
    public function setAdjustmentNegative($adjustment_negative)
    {
        $this->container['adjustment_negative'] = $adjustment_negative;

        return $this;
    }

    /**
     * Gets adjustment_positive
     *
     * @return float
     */
    public function getAdjustmentPositive()
    {
        return $this->container['adjustment_positive'];
    }

    /**
     * Sets adjustment_positive
     *
     * @param float $adjustment_positive Credit memo positive adjustment.
     *
     * @return $this
     */
    public function setAdjustmentPositive($adjustment_positive)
    {
        $this->container['adjustment_positive'] = $adjustment_positive;

        return $this;
    }

    /**
     * Gets base_adjustment
     *
     * @return float
     */
    public function getBaseAdjustment()
    {
        return $this->container['base_adjustment'];
    }

    /**
     * Sets base_adjustment
     *
     * @param float $base_adjustment Credit memo base adjustment.
     *
     * @return $this
     */
    public function setBaseAdjustment($base_adjustment)
    {
        $this->container['base_adjustment'] = $base_adjustment;

        return $this;
    }

    /**
     * Gets base_adjustment_negative
     *
     * @return float
     */
    public function getBaseAdjustmentNegative()
    {
        return $this->container['base_adjustment_negative'];
    }

    /**
     * Sets base_adjustment_negative
     *
     * @param float $base_adjustment_negative Credit memo negative base adjustment.
     *
     * @return $this
     */
    public function setBaseAdjustmentNegative($base_adjustment_negative)
    {
        $this->container['base_adjustment_negative'] = $base_adjustment_negative;

        return $this;
    }

    /**
     * Gets base_adjustment_positive
     *
     * @return float
     */
    public function getBaseAdjustmentPositive()
    {
        return $this->container['base_adjustment_positive'];
    }

    /**
     * Sets base_adjustment_positive
     *
     * @param float $base_adjustment_positive Credit memo positive base adjustment.
     *
     * @return $this
     */
    public function setBaseAdjustmentPositive($base_adjustment_positive)
    {
        $this->container['base_adjustment_positive'] = $base_adjustment_positive;

        return $this;
    }

    /**
     * Gets base_currency_code
     *
     * @return string
     */
    public function getBaseCurrencyCode()
    {
        return $this->container['base_currency_code'];
    }

    /**
     * Sets base_currency_code
     *
     * @param string $base_currency_code Credit memo base currency code.
     *
     * @return $this
     */
    public function setBaseCurrencyCode($base_currency_code)
    {
        $this->container['base_currency_code'] = $base_currency_code;

        return $this;
    }

    /**
     * Gets base_discount_amount
     *
     * @return float
     */
    public function getBaseDiscountAmount()
    {
        return $this->container['base_discount_amount'];
    }

    /**
     * Sets base_discount_amount
     *
     * @param float $base_discount_amount Credit memo base discount amount.
     *
     * @return $this
     */
    public function setBaseDiscountAmount($base_discount_amount)
    {
        $this->container['base_discount_amount'] = $base_discount_amount;

        return $this;
    }

    /**
     * Gets base_grand_total
     *
     * @return float
     */
    public function getBaseGrandTotal()
    {
        return $this->container['base_grand_total'];
    }

    /**
     * Sets base_grand_total
     *
     * @param float $base_grand_total Credit memo base grand total.
     *
     * @return $this
     */
    public function setBaseGrandTotal($base_grand_total)
    {
        $this->container['base_grand_total'] = $base_grand_total;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_amount
     *
     * @return float
     */
    public function getBaseDiscountTaxCompensationAmount()
    {
        return $this->container['base_discount_tax_compensation_amount'];
    }

    /**
     * Sets base_discount_tax_compensation_amount
     *
     * @param float $base_discount_tax_compensation_amount Credit memo base discount tax compensation amount.
     *
     * @return $this
     */
    public function setBaseDiscountTaxCompensationAmount($base_discount_tax_compensation_amount)
    {
        $this->container['base_discount_tax_compensation_amount'] = $base_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets base_shipping_amount
     *
     * @return float
     */
    public function getBaseShippingAmount()
    {
        return $this->container['base_shipping_amount'];
    }

    /**
     * Sets base_shipping_amount
     *
     * @param float $base_shipping_amount Credit memo base shipping amount.
     *
     * @return $this
     */
    public function setBaseShippingAmount($base_shipping_amount)
    {
        $this->container['base_shipping_amount'] = $base_shipping_amount;

        return $this;
    }

    /**
     * Gets base_shipping_discount_tax_compensation_amnt
     *
     * @return float
     */
    public function getBaseShippingDiscountTaxCompensationAmnt()
    {
        return $this->container['base_shipping_discount_tax_compensation_amnt'];
    }

    /**
     * Sets base_shipping_discount_tax_compensation_amnt
     *
     * @param float $base_shipping_discount_tax_compensation_amnt Credit memo base shipping discount tax compensation amount.
     *
     * @return $this
     */
    public function setBaseShippingDiscountTaxCompensationAmnt($base_shipping_discount_tax_compensation_amnt)
    {
        $this->container['base_shipping_discount_tax_compensation_amnt'] = $base_shipping_discount_tax_compensation_amnt;

        return $this;
    }

    /**
     * Gets base_shipping_incl_tax
     *
     * @return float
     */
    public function getBaseShippingInclTax()
    {
        return $this->container['base_shipping_incl_tax'];
    }

    /**
     * Sets base_shipping_incl_tax
     *
     * @param float $base_shipping_incl_tax Credit memo base shipping including tax.
     *
     * @return $this
     */
    public function setBaseShippingInclTax($base_shipping_incl_tax)
    {
        $this->container['base_shipping_incl_tax'] = $base_shipping_incl_tax;

        return $this;
    }

    /**
     * Gets base_shipping_tax_amount
     *
     * @return float
     */
    public function getBaseShippingTaxAmount()
    {
        return $this->container['base_shipping_tax_amount'];
    }

    /**
     * Sets base_shipping_tax_amount
     *
     * @param float $base_shipping_tax_amount Credit memo base shipping tax amount.
     *
     * @return $this
     */
    public function setBaseShippingTaxAmount($base_shipping_tax_amount)
    {
        $this->container['base_shipping_tax_amount'] = $base_shipping_tax_amount;

        return $this;
    }

    /**
     * Gets base_subtotal
     *
     * @return float
     */
    public function getBaseSubtotal()
    {
        return $this->container['base_subtotal'];
    }

    /**
     * Sets base_subtotal
     *
     * @param float $base_subtotal Credit memo base subtotal.
     *
     * @return $this
     */
    public function setBaseSubtotal($base_subtotal)
    {
        $this->container['base_subtotal'] = $base_subtotal;

        return $this;
    }

    /**
     * Gets base_subtotal_incl_tax
     *
     * @return float
     */
    public function getBaseSubtotalInclTax()
    {
        return $this->container['base_subtotal_incl_tax'];
    }

    /**
     * Sets base_subtotal_incl_tax
     *
     * @param float $base_subtotal_incl_tax Credit memo base subtotal including tax.
     *
     * @return $this
     */
    public function setBaseSubtotalInclTax($base_subtotal_incl_tax)
    {
        $this->container['base_subtotal_incl_tax'] = $base_subtotal_incl_tax;

        return $this;
    }

    /**
     * Gets base_tax_amount
     *
     * @return float
     */
    public function getBaseTaxAmount()
    {
        return $this->container['base_tax_amount'];
    }

    /**
     * Sets base_tax_amount
     *
     * @param float $base_tax_amount Credit memo base tax amount.
     *
     * @return $this
     */
    public function setBaseTaxAmount($base_tax_amount)
    {
        $this->container['base_tax_amount'] = $base_tax_amount;

        return $this;
    }

    /**
     * Gets base_to_global_rate
     *
     * @return float
     */
    public function getBaseToGlobalRate()
    {
        return $this->container['base_to_global_rate'];
    }

    /**
     * Sets base_to_global_rate
     *
     * @param float $base_to_global_rate Credit memo base-to-global rate.
     *
     * @return $this
     */
    public function setBaseToGlobalRate($base_to_global_rate)
    {
        $this->container['base_to_global_rate'] = $base_to_global_rate;

        return $this;
    }

    /**
     * Gets base_to_order_rate
     *
     * @return float
     */
    public function getBaseToOrderRate()
    {
        return $this->container['base_to_order_rate'];
    }

    /**
     * Sets base_to_order_rate
     *
     * @param float $base_to_order_rate Credit memo base-to-order rate.
     *
     * @return $this
     */
    public function setBaseToOrderRate($base_to_order_rate)
    {
        $this->container['base_to_order_rate'] = $base_to_order_rate;

        return $this;
    }

    /**
     * Gets billing_address_id
     *
     * @return int
     */
    public function getBillingAddressId()
    {
        return $this->container['billing_address_id'];
    }

    /**
     * Sets billing_address_id
     *
     * @param int $billing_address_id Credit memo billing address ID.
     *
     * @return $this
     */
    public function setBillingAddressId($billing_address_id)
    {
        $this->container['billing_address_id'] = $billing_address_id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at Credit memo created-at timestamp.
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets creditmemo_status
     *
     * @return int
     */
    public function getCreditmemoStatus()
    {
        return $this->container['creditmemo_status'];
    }

    /**
     * Sets creditmemo_status
     *
     * @param int $creditmemo_status Credit memo status.
     *
     * @return $this
     */
    public function setCreditmemoStatus($creditmemo_status)
    {
        $this->container['creditmemo_status'] = $creditmemo_status;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param float $discount_amount Credit memo discount amount.
     *
     * @return $this
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets discount_description
     *
     * @return string
     */
    public function getDiscountDescription()
    {
        return $this->container['discount_description'];
    }

    /**
     * Sets discount_description
     *
     * @param string $discount_description Credit memo discount description.
     *
     * @return $this
     */
    public function setDiscountDescription($discount_description)
    {
        $this->container['discount_description'] = $discount_description;

        return $this;
    }

    /**
     * Gets email_sent
     *
     * @return int
     */
    public function getEmailSent()
    {
        return $this->container['email_sent'];
    }

    /**
     * Sets email_sent
     *
     * @param int $email_sent Credit memo email sent flag value.
     *
     * @return $this
     */
    public function setEmailSent($email_sent)
    {
        $this->container['email_sent'] = $email_sent;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int $entity_id Credit memo ID.
     *
     * @return $this
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets global_currency_code
     *
     * @return string
     */
    public function getGlobalCurrencyCode()
    {
        return $this->container['global_currency_code'];
    }

    /**
     * Sets global_currency_code
     *
     * @param string $global_currency_code Credit memo global currency code.
     *
     * @return $this
     */
    public function setGlobalCurrencyCode($global_currency_code)
    {
        $this->container['global_currency_code'] = $global_currency_code;

        return $this;
    }

    /**
     * Gets grand_total
     *
     * @return float
     */
    public function getGrandTotal()
    {
        return $this->container['grand_total'];
    }

    /**
     * Sets grand_total
     *
     * @param float $grand_total Credit memo grand total.
     *
     * @return $this
     */
    public function setGrandTotal($grand_total)
    {
        $this->container['grand_total'] = $grand_total;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_amount
     *
     * @return float
     */
    public function getDiscountTaxCompensationAmount()
    {
        return $this->container['discount_tax_compensation_amount'];
    }

    /**
     * Sets discount_tax_compensation_amount
     *
     * @param float $discount_tax_compensation_amount Credit memo discount tax compensation amount.
     *
     * @return $this
     */
    public function setDiscountTaxCompensationAmount($discount_tax_compensation_amount)
    {
        $this->container['discount_tax_compensation_amount'] = $discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets increment_id
     *
     * @return string
     */
    public function getIncrementId()
    {
        return $this->container['increment_id'];
    }

    /**
     * Sets increment_id
     *
     * @param string $increment_id Credit memo increment ID.
     *
     * @return $this
     */
    public function setIncrementId($increment_id)
    {
        $this->container['increment_id'] = $increment_id;

        return $this;
    }

    /**
     * Gets invoice_id
     *
     * @return int
     */
    public function getInvoiceId()
    {
        return $this->container['invoice_id'];
    }

    /**
     * Sets invoice_id
     *
     * @param int $invoice_id Credit memo invoice ID.
     *
     * @return $this
     */
    public function setInvoiceId($invoice_id)
    {
        $this->container['invoice_id'] = $invoice_id;

        return $this;
    }

    /**
     * Gets order_currency_code
     *
     * @return string
     */
    public function getOrderCurrencyCode()
    {
        return $this->container['order_currency_code'];
    }

    /**
     * Sets order_currency_code
     *
     * @param string $order_currency_code Credit memo order currency code.
     *
     * @return $this
     */
    public function setOrderCurrencyCode($order_currency_code)
    {
        $this->container['order_currency_code'] = $order_currency_code;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int $order_id Credit memo order ID.
     *
     * @return $this
     */
    public function setOrderId($order_id)
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets shipping_address_id
     *
     * @return int
     */
    public function getShippingAddressId()
    {
        return $this->container['shipping_address_id'];
    }

    /**
     * Sets shipping_address_id
     *
     * @param int $shipping_address_id Credit memo shipping address ID.
     *
     * @return $this
     */
    public function setShippingAddressId($shipping_address_id)
    {
        $this->container['shipping_address_id'] = $shipping_address_id;

        return $this;
    }

    /**
     * Gets shipping_amount
     *
     * @return float
     */
    public function getShippingAmount()
    {
        return $this->container['shipping_amount'];
    }

    /**
     * Sets shipping_amount
     *
     * @param float $shipping_amount Credit memo shipping amount.
     *
     * @return $this
     */
    public function setShippingAmount($shipping_amount)
    {
        $this->container['shipping_amount'] = $shipping_amount;

        return $this;
    }

    /**
     * Gets shipping_discount_tax_compensation_amount
     *
     * @return float
     */
    public function getShippingDiscountTaxCompensationAmount()
    {
        return $this->container['shipping_discount_tax_compensation_amount'];
    }

    /**
     * Sets shipping_discount_tax_compensation_amount
     *
     * @param float $shipping_discount_tax_compensation_amount Credit memo shipping discount tax compensation amount.
     *
     * @return $this
     */
    public function setShippingDiscountTaxCompensationAmount($shipping_discount_tax_compensation_amount)
    {
        $this->container['shipping_discount_tax_compensation_amount'] = $shipping_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets shipping_incl_tax
     *
     * @return float
     */
    public function getShippingInclTax()
    {
        return $this->container['shipping_incl_tax'];
    }

    /**
     * Sets shipping_incl_tax
     *
     * @param float $shipping_incl_tax Credit memo shipping including tax.
     *
     * @return $this
     */
    public function setShippingInclTax($shipping_incl_tax)
    {
        $this->container['shipping_incl_tax'] = $shipping_incl_tax;

        return $this;
    }

    /**
     * Gets shipping_tax_amount
     *
     * @return float
     */
    public function getShippingTaxAmount()
    {
        return $this->container['shipping_tax_amount'];
    }

    /**
     * Sets shipping_tax_amount
     *
     * @param float $shipping_tax_amount Credit memo shipping tax amount.
     *
     * @return $this
     */
    public function setShippingTaxAmount($shipping_tax_amount)
    {
        $this->container['shipping_tax_amount'] = $shipping_tax_amount;

        return $this;
    }

    /**
     * Gets state
     *
     * @return int
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param int $state Credit memo state.
     *
     * @return $this
     */
    public function setState($state)
    {
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets store_currency_code
     *
     * @return string
     */
    public function getStoreCurrencyCode()
    {
        return $this->container['store_currency_code'];
    }

    /**
     * Sets store_currency_code
     *
     * @param string $store_currency_code Credit memo store currency code.
     *
     * @return $this
     */
    public function setStoreCurrencyCode($store_currency_code)
    {
        $this->container['store_currency_code'] = $store_currency_code;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int $store_id Credit memo store ID.
     *
     * @return $this
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets store_to_base_rate
     *
     * @return float
     */
    public function getStoreToBaseRate()
    {
        return $this->container['store_to_base_rate'];
    }

    /**
     * Sets store_to_base_rate
     *
     * @param float $store_to_base_rate Credit memo store-to-base rate.
     *
     * @return $this
     */
    public function setStoreToBaseRate($store_to_base_rate)
    {
        $this->container['store_to_base_rate'] = $store_to_base_rate;

        return $this;
    }

    /**
     * Gets store_to_order_rate
     *
     * @return float
     */
    public function getStoreToOrderRate()
    {
        return $this->container['store_to_order_rate'];
    }

    /**
     * Sets store_to_order_rate
     *
     * @param float $store_to_order_rate Credit memo store-to-order rate.
     *
     * @return $this
     */
    public function setStoreToOrderRate($store_to_order_rate)
    {
        $this->container['store_to_order_rate'] = $store_to_order_rate;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return float
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param float $subtotal Credit memo subtotal.
     *
     * @return $this
     */
    public function setSubtotal($subtotal)
    {
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets subtotal_incl_tax
     *
     * @return float
     */
    public function getSubtotalInclTax()
    {
        return $this->container['subtotal_incl_tax'];
    }

    /**
     * Sets subtotal_incl_tax
     *
     * @param float $subtotal_incl_tax Credit memo subtotal including tax.
     *
     * @return $this
     */
    public function setSubtotalInclTax($subtotal_incl_tax)
    {
        $this->container['subtotal_incl_tax'] = $subtotal_incl_tax;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return float
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param float $tax_amount Credit memo tax amount.
     *
     * @return $this
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string $transaction_id Credit memo transaction ID.
     *
     * @return $this
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string $updated_at Credit memo updated-at timestamp.
     *
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Swagger\Client\Model\SalesDataCreditmemoItemInterface[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Swagger\Client\Model\SalesDataCreditmemoItemInterface[] $items Array of credit memo items.
     *
     * @return $this
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return \Swagger\Client\Model\SalesDataCreditmemoCommentInterface[]
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param \Swagger\Client\Model\SalesDataCreditmemoCommentInterface[] $comments Array of any credit memo comments. Otherwise, null.
     *
     * @return $this
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Swagger\Client\Model\SalesDataCreditmemoExtensionInterface
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Swagger\Client\Model\SalesDataCreditmemoExtensionInterface $extension_attributes extension_attributes
     *
     * @return $this
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


