<?php
/**
 * CatalogInventoryStockRegistryV1Api
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Magento Enterprise Edition 2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Swagger\Client\ApiException;
use Swagger\Client\Configuration;
use Swagger\Client\HeaderSelector;
use Swagger\Client\ObjectSerializer;

/**
 * CatalogInventoryStockRegistryV1Api Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CatalogInventoryStockRegistryV1Api
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetLowStockItemsGet
     *
     * @param  int $scope_id scope_id (required)
     * @param  float $qty qty (required)
     * @param  int $current_page current_page (optional)
     * @param  int $page_size page_size (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\CatalogInventoryDataStockStatusCollectionInterface
     */
    public function catalogInventoryStockRegistryV1GetLowStockItemsGet($scope_id, $qty, $current_page = null, $page_size = null)
    {
        list($response) = $this->catalogInventoryStockRegistryV1GetLowStockItemsGetWithHttpInfo($scope_id, $qty, $current_page, $page_size);
        return $response;
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetLowStockItemsGetWithHttpInfo
     *
     * @param  int $scope_id (required)
     * @param  float $qty (required)
     * @param  int $current_page (optional)
     * @param  int $page_size (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\CatalogInventoryDataStockStatusCollectionInterface, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogInventoryStockRegistryV1GetLowStockItemsGetWithHttpInfo($scope_id, $qty, $current_page = null, $page_size = null)
    {
        $returnType = '\Swagger\Client\Model\CatalogInventoryDataStockStatusCollectionInterface';
        $request = $this->catalogInventoryStockRegistryV1GetLowStockItemsGetRequest($scope_id, $qty, $current_page, $page_size);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\CatalogInventoryDataStockStatusCollectionInterface',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetLowStockItemsGetAsync
     *
     * 
     *
     * @param  int $scope_id (required)
     * @param  float $qty (required)
     * @param  int $current_page (optional)
     * @param  int $page_size (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1GetLowStockItemsGetAsync($scope_id, $qty, $current_page = null, $page_size = null)
    {
        return $this->catalogInventoryStockRegistryV1GetLowStockItemsGetAsyncWithHttpInfo($scope_id, $qty, $current_page, $page_size)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetLowStockItemsGetAsyncWithHttpInfo
     *
     * 
     *
     * @param  int $scope_id (required)
     * @param  float $qty (required)
     * @param  int $current_page (optional)
     * @param  int $page_size (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1GetLowStockItemsGetAsyncWithHttpInfo($scope_id, $qty, $current_page = null, $page_size = null)
    {
        $returnType = '\Swagger\Client\Model\CatalogInventoryDataStockStatusCollectionInterface';
        $request = $this->catalogInventoryStockRegistryV1GetLowStockItemsGetRequest($scope_id, $qty, $current_page, $page_size);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogInventoryStockRegistryV1GetLowStockItemsGet'
     *
     * @param  int $scope_id (required)
     * @param  float $qty (required)
     * @param  int $current_page (optional)
     * @param  int $page_size (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function catalogInventoryStockRegistryV1GetLowStockItemsGetRequest($scope_id, $qty, $current_page = null, $page_size = null)
    {
        // verify the required parameter 'scope_id' is set
        if ($scope_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $scope_id when calling catalogInventoryStockRegistryV1GetLowStockItemsGet'
            );
        }
        // verify the required parameter 'qty' is set
        if ($qty === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $qty when calling catalogInventoryStockRegistryV1GetLowStockItemsGet'
            );
        }

        $resourcePath = '/V1/stockItems/lowStock/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($scope_id !== null) {
            $queryParams['scopeId'] = ObjectSerializer::toQueryValue($scope_id);
        }
        // query params
        if ($qty !== null) {
            $queryParams['qty'] = ObjectSerializer::toQueryValue($qty);
        }
        // query params
        if ($current_page !== null) {
            $queryParams['currentPage'] = ObjectSerializer::toQueryValue($current_page);
        }
        // query params
        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($page_size);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockItemBySkuGet
     *
     * @param  string $product_sku product_sku (required)
     * @param  int $scope_id scope_id (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\CatalogInventoryDataStockItemInterface
     */
    public function catalogInventoryStockRegistryV1GetStockItemBySkuGet($product_sku, $scope_id = null)
    {
        list($response) = $this->catalogInventoryStockRegistryV1GetStockItemBySkuGetWithHttpInfo($product_sku, $scope_id);
        return $response;
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockItemBySkuGetWithHttpInfo
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\CatalogInventoryDataStockItemInterface, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogInventoryStockRegistryV1GetStockItemBySkuGetWithHttpInfo($product_sku, $scope_id = null)
    {
        $returnType = '\Swagger\Client\Model\CatalogInventoryDataStockItemInterface';
        $request = $this->catalogInventoryStockRegistryV1GetStockItemBySkuGetRequest($product_sku, $scope_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\CatalogInventoryDataStockItemInterface',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockItemBySkuGetAsync
     *
     * 
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1GetStockItemBySkuGetAsync($product_sku, $scope_id = null)
    {
        return $this->catalogInventoryStockRegistryV1GetStockItemBySkuGetAsyncWithHttpInfo($product_sku, $scope_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockItemBySkuGetAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1GetStockItemBySkuGetAsyncWithHttpInfo($product_sku, $scope_id = null)
    {
        $returnType = '\Swagger\Client\Model\CatalogInventoryDataStockItemInterface';
        $request = $this->catalogInventoryStockRegistryV1GetStockItemBySkuGetRequest($product_sku, $scope_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogInventoryStockRegistryV1GetStockItemBySkuGet'
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function catalogInventoryStockRegistryV1GetStockItemBySkuGetRequest($product_sku, $scope_id = null)
    {
        // verify the required parameter 'product_sku' is set
        if ($product_sku === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_sku when calling catalogInventoryStockRegistryV1GetStockItemBySkuGet'
            );
        }

        $resourcePath = '/V1/stockItems/{productSku}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($scope_id !== null) {
            $queryParams['scopeId'] = ObjectSerializer::toQueryValue($scope_id);
        }

        // path params
        if ($product_sku !== null) {
            $resourcePath = str_replace(
                '{' . 'productSku' . '}',
                ObjectSerializer::toPathValue($product_sku),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockStatusBySkuGet
     *
     * @param  string $product_sku product_sku (required)
     * @param  int $scope_id scope_id (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\CatalogInventoryDataStockStatusInterface
     */
    public function catalogInventoryStockRegistryV1GetStockStatusBySkuGet($product_sku, $scope_id = null)
    {
        list($response) = $this->catalogInventoryStockRegistryV1GetStockStatusBySkuGetWithHttpInfo($product_sku, $scope_id);
        return $response;
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockStatusBySkuGetWithHttpInfo
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\CatalogInventoryDataStockStatusInterface, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogInventoryStockRegistryV1GetStockStatusBySkuGetWithHttpInfo($product_sku, $scope_id = null)
    {
        $returnType = '\Swagger\Client\Model\CatalogInventoryDataStockStatusInterface';
        $request = $this->catalogInventoryStockRegistryV1GetStockStatusBySkuGetRequest($product_sku, $scope_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\CatalogInventoryDataStockStatusInterface',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockStatusBySkuGetAsync
     *
     * 
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1GetStockStatusBySkuGetAsync($product_sku, $scope_id = null)
    {
        return $this->catalogInventoryStockRegistryV1GetStockStatusBySkuGetAsyncWithHttpInfo($product_sku, $scope_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogInventoryStockRegistryV1GetStockStatusBySkuGetAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1GetStockStatusBySkuGetAsyncWithHttpInfo($product_sku, $scope_id = null)
    {
        $returnType = '\Swagger\Client\Model\CatalogInventoryDataStockStatusInterface';
        $request = $this->catalogInventoryStockRegistryV1GetStockStatusBySkuGetRequest($product_sku, $scope_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogInventoryStockRegistryV1GetStockStatusBySkuGet'
     *
     * @param  string $product_sku (required)
     * @param  int $scope_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function catalogInventoryStockRegistryV1GetStockStatusBySkuGetRequest($product_sku, $scope_id = null)
    {
        // verify the required parameter 'product_sku' is set
        if ($product_sku === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_sku when calling catalogInventoryStockRegistryV1GetStockStatusBySkuGet'
            );
        }

        $resourcePath = '/V1/stockStatuses/{productSku}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($scope_id !== null) {
            $queryParams['scopeId'] = ObjectSerializer::toQueryValue($scope_id);
        }

        // path params
        if ($product_sku !== null) {
            $resourcePath = str_replace(
                '{' . 'productSku' . '}',
                ObjectSerializer::toPathValue($product_sku),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation catalogInventoryStockRegistryV1UpdateStockItemBySkuPut
     *
     * @param  string $product_sku product_sku (required)
     * @param  string $item_id item_id (required)
     * @param  \Swagger\Client\Model\Body82 $body body (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int
     */
    public function catalogInventoryStockRegistryV1UpdateStockItemBySkuPut($product_sku, $item_id, $body = null)
    {
        list($response) = $this->catalogInventoryStockRegistryV1UpdateStockItemBySkuPutWithHttpInfo($product_sku, $item_id, $body);
        return $response;
    }

    /**
     * Operation catalogInventoryStockRegistryV1UpdateStockItemBySkuPutWithHttpInfo
     *
     * @param  string $product_sku (required)
     * @param  string $item_id (required)
     * @param  \Swagger\Client\Model\Body82 $body (optional)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int, HTTP status code, HTTP response headers (array of strings)
     */
    public function catalogInventoryStockRegistryV1UpdateStockItemBySkuPutWithHttpInfo($product_sku, $item_id, $body = null)
    {
        $returnType = 'int';
        $request = $this->catalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest($product_sku, $item_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation catalogInventoryStockRegistryV1UpdateStockItemBySkuPutAsync
     *
     * 
     *
     * @param  string $product_sku (required)
     * @param  string $item_id (required)
     * @param  \Swagger\Client\Model\Body82 $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1UpdateStockItemBySkuPutAsync($product_sku, $item_id, $body = null)
    {
        return $this->catalogInventoryStockRegistryV1UpdateStockItemBySkuPutAsyncWithHttpInfo($product_sku, $item_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation catalogInventoryStockRegistryV1UpdateStockItemBySkuPutAsyncWithHttpInfo
     *
     * 
     *
     * @param  string $product_sku (required)
     * @param  string $item_id (required)
     * @param  \Swagger\Client\Model\Body82 $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function catalogInventoryStockRegistryV1UpdateStockItemBySkuPutAsyncWithHttpInfo($product_sku, $item_id, $body = null)
    {
        $returnType = 'int';
        $request = $this->catalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest($product_sku, $item_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'catalogInventoryStockRegistryV1UpdateStockItemBySkuPut'
     *
     * @param  string $product_sku (required)
     * @param  string $item_id (required)
     * @param  \Swagger\Client\Model\Body82 $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function catalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest($product_sku, $item_id, $body = null)
    {
        // verify the required parameter 'product_sku' is set
        if ($product_sku === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_sku when calling catalogInventoryStockRegistryV1UpdateStockItemBySkuPut'
            );
        }
        // verify the required parameter 'item_id' is set
        if ($item_id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $item_id when calling catalogInventoryStockRegistryV1UpdateStockItemBySkuPut'
            );
        }

        $resourcePath = '/V1/products/{productSku}/stockItems/{itemId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($product_sku !== null) {
            $resourcePath = str_replace(
                '{' . 'productSku' . '}',
                ObjectSerializer::toPathValue($product_sku),
                $resourcePath
            );
        }
        // path params
        if ($item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'itemId' . '}',
                ObjectSerializer::toPathValue($item_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
