# SwaggerClient-php
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0
- Build package: io.swagger.codegen.languages.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/GIT_USER_ID/GIT_REPO_ID.git"
    }
  ],
  "require": {
    "GIT_USER_ID/GIT_REPO_ID": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/SwaggerClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new Swagger\Client\Api\BackendModuleServiceV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->backendModuleServiceV1GetModulesGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BackendModuleServiceV1Api->backendModuleServiceV1GetModulesGet: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *http://t2010.vg/rest/default*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BackendModuleServiceV1Api* | [**backendModuleServiceV1GetModulesGet**](docs/Api/BackendModuleServiceV1Api.md#backendmoduleservicev1getmodulesget) | **GET** /V1/modules | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1AddChildByProductSkuPost**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1addchildbyproductskupost) | **POST** /V1/bundle-products/{sku}/links/{optionId} | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1GetChildrenGet**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1getchildrenget) | **GET** /V1/bundle-products/{productSku}/children | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1RemoveChildDelete**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1removechilddelete) | **DELETE** /V1/bundle-products/{sku}/options/{optionId}/children/{childSku} | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1SaveChildPut**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1savechildput) | **PUT** /V1/bundle-products/{sku}/links/{id} | 
*BundleProductOptionManagementV1Api* | [**bundleProductOptionManagementV1SavePost**](docs/Api/BundleProductOptionManagementV1Api.md#bundleproductoptionmanagementv1savepost) | **POST** /V1/bundle-products/options/add | 
*BundleProductOptionManagementV1Api* | [**bundleProductOptionManagementV1SavePut**](docs/Api/BundleProductOptionManagementV1Api.md#bundleproductoptionmanagementv1saveput) | **PUT** /V1/bundle-products/options/{optionId} | 
*BundleProductOptionRepositoryV1Api* | [**bundleProductOptionRepositoryV1DeleteByIdDelete**](docs/Api/BundleProductOptionRepositoryV1Api.md#bundleproductoptionrepositoryv1deletebyiddelete) | **DELETE** /V1/bundle-products/{sku}/options/{optionId} | 
*BundleProductOptionRepositoryV1Api* | [**bundleProductOptionRepositoryV1GetGet**](docs/Api/BundleProductOptionRepositoryV1Api.md#bundleproductoptionrepositoryv1getget) | **GET** /V1/bundle-products/{sku}/options/{optionId} | 
*BundleProductOptionRepositoryV1Api* | [**bundleProductOptionRepositoryV1GetListGet**](docs/Api/BundleProductOptionRepositoryV1Api.md#bundleproductoptionrepositoryv1getlistget) | **GET** /V1/bundle-products/{sku}/options/all | 
*BundleProductOptionTypeListV1Api* | [**bundleProductOptionTypeListV1GetItemsGet**](docs/Api/BundleProductOptionTypeListV1Api.md#bundleproductoptiontypelistv1getitemsget) | **GET** /V1/bundle-products/options/types | 
*CatalogAttributeSetManagementV1Api* | [**catalogAttributeSetManagementV1CreatePost**](docs/Api/CatalogAttributeSetManagementV1Api.md#catalogattributesetmanagementv1createpost) | **POST** /V1/products/attribute-sets | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1DeleteByIdDelete**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1deletebyiddelete) | **DELETE** /V1/products/attribute-sets/{attributeSetId} | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1GetGet**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1getget) | **GET** /V1/products/attribute-sets/{attributeSetId} | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1GetListGet**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1getlistget) | **GET** /V1/products/attribute-sets/sets/list | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1SavePut**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1saveput) | **PUT** /V1/products/attribute-sets/{attributeSetId} | 
*CatalogCategoryAttributeOptionManagementV1Api* | [**catalogCategoryAttributeOptionManagementV1GetItemsGet**](docs/Api/CatalogCategoryAttributeOptionManagementV1Api.md#catalogcategoryattributeoptionmanagementv1getitemsget) | **GET** /V1/categories/attributes/{attributeCode}/options | 
*CatalogCategoryAttributeRepositoryV1Api* | [**catalogCategoryAttributeRepositoryV1GetGet**](docs/Api/CatalogCategoryAttributeRepositoryV1Api.md#catalogcategoryattributerepositoryv1getget) | **GET** /V1/categories/attributes/{attributeCode} | 
*CatalogCategoryAttributeRepositoryV1Api* | [**catalogCategoryAttributeRepositoryV1GetListGet**](docs/Api/CatalogCategoryAttributeRepositoryV1Api.md#catalogcategoryattributerepositoryv1getlistget) | **GET** /V1/categories/attributes | 
*CatalogCategoryLinkManagementV1Api* | [**catalogCategoryLinkManagementV1GetAssignedProductsGet**](docs/Api/CatalogCategoryLinkManagementV1Api.md#catalogcategorylinkmanagementv1getassignedproductsget) | **GET** /V1/categories/{categoryId}/products | 
*CatalogCategoryLinkRepositoryV1Api* | [**catalogCategoryLinkRepositoryV1DeleteByIdsDelete**](docs/Api/CatalogCategoryLinkRepositoryV1Api.md#catalogcategorylinkrepositoryv1deletebyidsdelete) | **DELETE** /V1/categories/{categoryId}/products/{sku} | 
*CatalogCategoryLinkRepositoryV1Api* | [**catalogCategoryLinkRepositoryV1SavePost**](docs/Api/CatalogCategoryLinkRepositoryV1Api.md#catalogcategorylinkrepositoryv1savepost) | **POST** /V1/categories/{categoryId}/products | 
*CatalogCategoryLinkRepositoryV1Api* | [**catalogCategoryLinkRepositoryV1SavePut**](docs/Api/CatalogCategoryLinkRepositoryV1Api.md#catalogcategorylinkrepositoryv1saveput) | **PUT** /V1/categories/{categoryId}/products | 
*CatalogCategoryManagementV1Api* | [**catalogCategoryManagementV1GetTreeGet**](docs/Api/CatalogCategoryManagementV1Api.md#catalogcategorymanagementv1gettreeget) | **GET** /V1/categories | 
*CatalogCategoryManagementV1Api* | [**catalogCategoryManagementV1MovePut**](docs/Api/CatalogCategoryManagementV1Api.md#catalogcategorymanagementv1moveput) | **PUT** /V1/categories/{categoryId}/move | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1DeleteByIdentifierDelete**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1deletebyidentifierdelete) | **DELETE** /V1/categories/{categoryId} | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1GetGet**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1getget) | **GET** /V1/categories/{categoryId} | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1SavePost**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1savepost) | **POST** /V1/categories | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1SavePut**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1saveput) | **PUT** /V1/categories/{id} | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1GetLowStockItemsGet**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1getlowstockitemsget) | **GET** /V1/stockItems/lowStock/ | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1GetStockItemBySkuGet**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1getstockitembyskuget) | **GET** /V1/stockItems/{productSku} | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1GetStockStatusBySkuGet**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1getstockstatusbyskuget) | **GET** /V1/stockStatuses/{productSku} | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1UpdateStockItemBySkuPut**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1updatestockitembyskuput) | **PUT** /V1/products/{productSku}/stockItems/{itemId} | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1deletebyiddelete) | **DELETE** /V1/products/attribute-sets/groups/{groupId} | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1GetListGet**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1getlistget) | **GET** /V1/products/attribute-sets/groups/list | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1SavePost**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1savepost) | **POST** /V1/products/attribute-sets/groups | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1SavePut**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1saveput) | **PUT** /V1/products/attribute-sets/{attributeSetId}/groups | 
*CatalogProductAttributeManagementV1Api* | [**catalogProductAttributeManagementV1AssignPost**](docs/Api/CatalogProductAttributeManagementV1Api.md#catalogproductattributemanagementv1assignpost) | **POST** /V1/products/attribute-sets/attributes | 
*CatalogProductAttributeManagementV1Api* | [**catalogProductAttributeManagementV1GetAttributesGet**](docs/Api/CatalogProductAttributeManagementV1Api.md#catalogproductattributemanagementv1getattributesget) | **GET** /V1/products/attribute-sets/{attributeSetId}/attributes | 
*CatalogProductAttributeManagementV1Api* | [**catalogProductAttributeManagementV1UnassignDelete**](docs/Api/CatalogProductAttributeManagementV1Api.md#catalogproductattributemanagementv1unassigndelete) | **DELETE** /V1/products/attribute-sets/{attributeSetId}/attributes/{attributeCode} | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1CreatePost**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1createpost) | **POST** /V1/products/{sku}/media | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1GetGet**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1getget) | **GET** /V1/products/{sku}/media/{entryId} | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1GetListGet**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1getlistget) | **GET** /V1/products/{sku}/media | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1RemoveDelete**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1removedelete) | **DELETE** /V1/products/{sku}/media/{entryId} | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1UpdatePut**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1updateput) | **PUT** /V1/products/{sku}/media/{entryId} | 
*CatalogProductAttributeOptionManagementV1Api* | [**catalogProductAttributeOptionManagementV1AddPost**](docs/Api/CatalogProductAttributeOptionManagementV1Api.md#catalogproductattributeoptionmanagementv1addpost) | **POST** /V1/products/attributes/{attributeCode}/options | 
*CatalogProductAttributeOptionManagementV1Api* | [**catalogProductAttributeOptionManagementV1DeleteDelete**](docs/Api/CatalogProductAttributeOptionManagementV1Api.md#catalogproductattributeoptionmanagementv1deletedelete) | **DELETE** /V1/products/attributes/{attributeCode}/options/{optionId} | 
*CatalogProductAttributeOptionManagementV1Api* | [**catalogProductAttributeOptionManagementV1GetItemsGet**](docs/Api/CatalogProductAttributeOptionManagementV1Api.md#catalogproductattributeoptionmanagementv1getitemsget) | **GET** /V1/products/attributes/{attributeCode}/options | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1deletebyiddelete) | **DELETE** /V1/products/attributes/{attributeCode} | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1GetGet**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1getget) | **GET** /V1/products/attributes/{attributeCode} | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1GetListGet**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1getlistget) | **GET** /V1/products/attributes | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1SavePost**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1savepost) | **POST** /V1/products/attributes | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1SavePut**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1saveput) | **PUT** /V1/products/attributes/{attributeCode} | 
*CatalogProductAttributeTypesListV1Api* | [**catalogProductAttributeTypesListV1GetItemsGet**](docs/Api/CatalogProductAttributeTypesListV1Api.md#catalogproductattributetypeslistv1getitemsget) | **GET** /V1/products/attributes/types | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1DeleteByIdentifierDelete**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1deletebyidentifierdelete) | **DELETE** /V1/products/{sku}/options/{optionId} | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1GetGet**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1getget) | **GET** /V1/products/{sku}/options/{optionId} | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1GetListGet**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1getlistget) | **GET** /V1/products/{sku}/options | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1SavePost**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1savepost) | **POST** /V1/products/options | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1SavePut**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1saveput) | **PUT** /V1/products/options/{optionId} | 
*CatalogProductCustomOptionTypeListV1Api* | [**catalogProductCustomOptionTypeListV1GetItemsGet**](docs/Api/CatalogProductCustomOptionTypeListV1Api.md#catalogproductcustomoptiontypelistv1getitemsget) | **GET** /V1/products/options/types | 
*CatalogProductLinkManagementV1Api* | [**catalogProductLinkManagementV1GetLinkedItemsByTypeGet**](docs/Api/CatalogProductLinkManagementV1Api.md#catalogproductlinkmanagementv1getlinkeditemsbytypeget) | **GET** /V1/products/{sku}/links/{type} | 
*CatalogProductLinkManagementV1Api* | [**catalogProductLinkManagementV1SetProductLinksPost**](docs/Api/CatalogProductLinkManagementV1Api.md#catalogproductlinkmanagementv1setproductlinkspost) | **POST** /V1/products/{sku}/links | 
*CatalogProductLinkRepositoryV1Api* | [**catalogProductLinkRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductLinkRepositoryV1Api.md#catalogproductlinkrepositoryv1deletebyiddelete) | **DELETE** /V1/products/{sku}/links/{type}/{linkedProductSku} | 
*CatalogProductLinkRepositoryV1Api* | [**catalogProductLinkRepositoryV1SavePut**](docs/Api/CatalogProductLinkRepositoryV1Api.md#catalogproductlinkrepositoryv1saveput) | **PUT** /V1/products/{sku}/links | 
*CatalogProductLinkTypeListV1Api* | [**catalogProductLinkTypeListV1GetItemAttributesGet**](docs/Api/CatalogProductLinkTypeListV1Api.md#catalogproductlinktypelistv1getitemattributesget) | **GET** /V1/products/links/{type}/attributes | 
*CatalogProductLinkTypeListV1Api* | [**catalogProductLinkTypeListV1GetItemsGet**](docs/Api/CatalogProductLinkTypeListV1Api.md#catalogproductlinktypelistv1getitemsget) | **GET** /V1/products/links/types | 
*CatalogProductMediaAttributeManagementV1Api* | [**catalogProductMediaAttributeManagementV1GetListGet**](docs/Api/CatalogProductMediaAttributeManagementV1Api.md#catalogproductmediaattributemanagementv1getlistget) | **GET** /V1/products/media/types/{attributeSetName} | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1deletebyiddelete) | **DELETE** /V1/products/{sku} | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1GetGet**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1getget) | **GET** /V1/products/{sku} | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1GetListGet**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1getlistget) | **GET** /V1/products | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1SavePost**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1savepost) | **POST** /V1/products | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1SavePut**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1saveput) | **PUT** /V1/products/{sku} | 
*CatalogProductTierPriceManagementV1Api* | [**catalogProductTierPriceManagementV1AddPost**](docs/Api/CatalogProductTierPriceManagementV1Api.md#catalogproducttierpricemanagementv1addpost) | **POST** /V1/products/{sku}/group-prices/{customerGroupId}/tiers/{qty}/price/{price} | 
*CatalogProductTierPriceManagementV1Api* | [**catalogProductTierPriceManagementV1GetListGet**](docs/Api/CatalogProductTierPriceManagementV1Api.md#catalogproducttierpricemanagementv1getlistget) | **GET** /V1/products/{sku}/group-prices/{customerGroupId}/tiers | 
*CatalogProductTierPriceManagementV1Api* | [**catalogProductTierPriceManagementV1RemoveDelete**](docs/Api/CatalogProductTierPriceManagementV1Api.md#catalogproducttierpricemanagementv1removedelete) | **DELETE** /V1/products/{sku}/group-prices/{customerGroupId}/tiers/{qty} | 
*CatalogProductTypeListV1Api* | [**catalogProductTypeListV1GetProductTypesGet**](docs/Api/CatalogProductTypeListV1Api.md#catalogproducttypelistv1getproducttypesget) | **GET** /V1/products/types | 
*CatalogProductWebsiteLinkRepositoryV1Api* | [**catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductWebsiteLinkRepositoryV1Api.md#catalogproductwebsitelinkrepositoryv1deletebyiddelete) | **DELETE** /V1/products/{sku}/websites/{websiteId} | 
*CatalogProductWebsiteLinkRepositoryV1Api* | [**catalogProductWebsiteLinkRepositoryV1SavePost**](docs/Api/CatalogProductWebsiteLinkRepositoryV1Api.md#catalogproductwebsitelinkrepositoryv1savepost) | **POST** /V1/products/{sku}/websites | 
*CatalogProductWebsiteLinkRepositoryV1Api* | [**catalogProductWebsiteLinkRepositoryV1SavePut**](docs/Api/CatalogProductWebsiteLinkRepositoryV1Api.md#catalogproductwebsitelinkrepositoryv1saveput) | **PUT** /V1/products/{sku}/websites | 
*CheckoutAgreementsCheckoutAgreementsRepositoryV1Api* | [**checkoutAgreementsCheckoutAgreementsRepositoryV1GetListGet**](docs/Api/CheckoutAgreementsCheckoutAgreementsRepositoryV1Api.md#checkoutagreementscheckoutagreementsrepositoryv1getlistget) | **GET** /V1/carts/licence | 
*CheckoutGuestPaymentInformationManagementV1Api* | [**checkoutGuestPaymentInformationManagementV1GetPaymentInformationGet**](docs/Api/CheckoutGuestPaymentInformationManagementV1Api.md#checkoutguestpaymentinformationmanagementv1getpaymentinformationget) | **GET** /V1/guest-carts/{cartId}/payment-information | 
*CheckoutGuestPaymentInformationManagementV1Api* | [**checkoutGuestPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPost**](docs/Api/CheckoutGuestPaymentInformationManagementV1Api.md#checkoutguestpaymentinformationmanagementv1savepaymentinformationandplaceorderpost) | **POST** /V1/guest-carts/{cartId}/payment-information | 
*CheckoutGuestPaymentInformationManagementV1Api* | [**checkoutGuestPaymentInformationManagementV1SavePaymentInformationPost**](docs/Api/CheckoutGuestPaymentInformationManagementV1Api.md#checkoutguestpaymentinformationmanagementv1savepaymentinformationpost) | **POST** /V1/guest-carts/{cartId}/set-payment-information | 
*CheckoutGuestShippingInformationManagementV1Api* | [**checkoutGuestShippingInformationManagementV1SaveAddressInformationPost**](docs/Api/CheckoutGuestShippingInformationManagementV1Api.md#checkoutguestshippinginformationmanagementv1saveaddressinformationpost) | **POST** /V1/guest-carts/{cartId}/shipping-information | 
*CheckoutGuestTotalsInformationManagementV1Api* | [**checkoutGuestTotalsInformationManagementV1CalculatePost**](docs/Api/CheckoutGuestTotalsInformationManagementV1Api.md#checkoutguesttotalsinformationmanagementv1calculatepost) | **POST** /V1/guest-carts/{cartId}/totals-information | 
*CheckoutPaymentInformationManagementV1Api* | [**checkoutPaymentInformationManagementV1GetPaymentInformationGet**](docs/Api/CheckoutPaymentInformationManagementV1Api.md#checkoutpaymentinformationmanagementv1getpaymentinformationget) | **GET** /V1/carts/mine/payment-information | 
*CheckoutPaymentInformationManagementV1Api* | [**checkoutPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPost**](docs/Api/CheckoutPaymentInformationManagementV1Api.md#checkoutpaymentinformationmanagementv1savepaymentinformationandplaceorderpost) | **POST** /V1/carts/mine/payment-information | 
*CheckoutPaymentInformationManagementV1Api* | [**checkoutPaymentInformationManagementV1SavePaymentInformationPost**](docs/Api/CheckoutPaymentInformationManagementV1Api.md#checkoutpaymentinformationmanagementv1savepaymentinformationpost) | **POST** /V1/carts/mine/set-payment-information | 
*CheckoutShippingInformationManagementV1Api* | [**checkoutShippingInformationManagementV1SaveAddressInformationPost**](docs/Api/CheckoutShippingInformationManagementV1Api.md#checkoutshippinginformationmanagementv1saveaddressinformationpost) | **POST** /V1/carts/mine/shipping-information | 
*CheckoutShippingInformationManagementV1Api* | [**checkoutShippingInformationManagementV1SaveAddressInformationPost_0**](docs/Api/CheckoutShippingInformationManagementV1Api.md#checkoutshippinginformationmanagementv1saveaddressinformationpost_0) | **POST** /V1/carts/{cartId}/shipping-information | 
*CheckoutTotalsInformationManagementV1Api* | [**checkoutTotalsInformationManagementV1CalculatePost**](docs/Api/CheckoutTotalsInformationManagementV1Api.md#checkouttotalsinformationmanagementv1calculatepost) | **POST** /V1/carts/{cartId}/totals-information | 
*CheckoutTotalsInformationManagementV1Api* | [**checkoutTotalsInformationManagementV1CalculatePost_0**](docs/Api/CheckoutTotalsInformationManagementV1Api.md#checkouttotalsinformationmanagementv1calculatepost_0) | **POST** /V1/carts/mine/totals-information | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1DeleteByIdDelete**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1deletebyiddelete) | **DELETE** /V1/cmsBlock/{blockId} | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1GetByIdGet**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1getbyidget) | **GET** /V1/cmsBlock/{blockId} | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1GetListGet**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1getlistget) | **GET** /V1/cmsBlock/search | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1SavePost**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1savepost) | **POST** /V1/cmsBlock | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1SavePut**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1saveput) | **PUT** /V1/cmsBlock/{id} | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1DeleteByIdDelete**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1deletebyiddelete) | **DELETE** /V1/cmsPage/{pageId} | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1GetByIdGet**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1getbyidget) | **GET** /V1/cmsPage/{pageId} | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1GetListGet**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1getlistget) | **GET** /V1/cmsPage/search | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1SavePost**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1savepost) | **POST** /V1/cmsPage | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1SavePut**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1saveput) | **PUT** /V1/cmsPage/{id} | 
*ConfigurableProductConfigurableProductManagementV1Api* | [**configurableProductConfigurableProductManagementV1GenerateVariationPut**](docs/Api/ConfigurableProductConfigurableProductManagementV1Api.md#configurableproductconfigurableproductmanagementv1generatevariationput) | **PUT** /V1/configurable-products/variation | 
*ConfigurableProductLinkManagementV1Api* | [**configurableProductLinkManagementV1AddChildPost**](docs/Api/ConfigurableProductLinkManagementV1Api.md#configurableproductlinkmanagementv1addchildpost) | **POST** /V1/configurable-products/{sku}/child | 
*ConfigurableProductLinkManagementV1Api* | [**configurableProductLinkManagementV1GetChildrenGet**](docs/Api/ConfigurableProductLinkManagementV1Api.md#configurableproductlinkmanagementv1getchildrenget) | **GET** /V1/configurable-products/{sku}/children | 
*ConfigurableProductLinkManagementV1Api* | [**configurableProductLinkManagementV1RemoveChildDelete**](docs/Api/ConfigurableProductLinkManagementV1Api.md#configurableproductlinkmanagementv1removechilddelete) | **DELETE** /V1/configurable-products/{sku}/children/{childSku} | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1DeleteByIdDelete**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1deletebyiddelete) | **DELETE** /V1/configurable-products/{sku}/options/{id} | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1GetGet**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1getget) | **GET** /V1/configurable-products/{sku}/options/{id} | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1GetListGet**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1getlistget) | **GET** /V1/configurable-products/{sku}/options/all | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1SavePost**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1savepost) | **POST** /V1/configurable-products/{sku}/options | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1SavePut**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1saveput) | **PUT** /V1/configurable-products/{sku}/options/{id} | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ActivateByIdPut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1activatebyidput) | **PUT** /V1/customers/me/activate | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ActivatePut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1activateput) | **PUT** /V1/customers/{email}/activate | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ChangePasswordByIdPut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1changepasswordbyidput) | **PUT** /V1/customers/me/password | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1CreateAccountPost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1createaccountpost) | **POST** /V1/customers | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetConfirmationStatusGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getconfirmationstatusget) | **GET** /V1/customers/{customerId}/confirm | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultBillingAddressGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultbillingaddressget) | **GET** /V1/customers/me/billingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultBillingAddressGet_0**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultbillingaddressget_0) | **GET** /V1/customers/{customerId}/billingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultShippingAddressGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultshippingaddressget) | **GET** /V1/customers/me/shippingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultShippingAddressGet_0**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultshippingaddressget_0) | **GET** /V1/customers/{customerId}/shippingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1InitiatePasswordResetPut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1initiatepasswordresetput) | **PUT** /V1/customers/password | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1IsEmailAvailablePost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1isemailavailablepost) | **POST** /V1/customers/isEmailAvailable | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1IsReadonlyGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1isreadonlyget) | **GET** /V1/customers/{customerId}/permissions/readonly | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ResendConfirmationPost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1resendconfirmationpost) | **POST** /V1/customers/confirm | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ValidatePut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1validateput) | **PUT** /V1/customers/validate | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ValidateResetPasswordLinkTokenGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1validateresetpasswordlinktokenget) | **GET** /V1/customers/{customerId}/password/resetLinkToken/{resetPasswordLinkToken} | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetAllAttributesMetadataGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getallattributesmetadataget) | **GET** /V1/attributeMetadata/customerAddress | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetAttributeMetadataGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getattributemetadataget) | **GET** /V1/attributeMetadata/customerAddress/attribute/{attributeCode} | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetAttributesGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getattributesget) | **GET** /V1/attributeMetadata/customerAddress/form/{formCode} | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetCustomAttributesMetadataGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getcustomattributesmetadataget) | **GET** /V1/attributeMetadata/customerAddress/custom | 
*CustomerAddressRepositoryV1Api* | [**customerAddressRepositoryV1DeleteByIdDelete**](docs/Api/CustomerAddressRepositoryV1Api.md#customeraddressrepositoryv1deletebyiddelete) | **DELETE** /V1/addresses/{addressId} | 
*CustomerAddressRepositoryV1Api* | [**customerAddressRepositoryV1GetByIdGet**](docs/Api/CustomerAddressRepositoryV1Api.md#customeraddressrepositoryv1getbyidget) | **GET** /V1/customers/addresses/{addressId} | 
*CustomerBalanceBalanceManagementV1Api* | [**customerBalanceBalanceManagementV1ApplyPost**](docs/Api/CustomerBalanceBalanceManagementV1Api.md#customerbalancebalancemanagementv1applypost) | **POST** /V1/carts/mine/balance/apply | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetAllAttributesMetadataGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getallattributesmetadataget) | **GET** /V1/attributeMetadata/customer | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetAttributeMetadataGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getattributemetadataget) | **GET** /V1/attributeMetadata/customer/attribute/{attributeCode} | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetAttributesGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getattributesget) | **GET** /V1/attributeMetadata/customer/form/{formCode} | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetCustomAttributesMetadataGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getcustomattributesmetadataget) | **GET** /V1/attributeMetadata/customer/custom | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1DeleteByIdDelete**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1deletebyiddelete) | **DELETE** /V1/customers/{customerId} | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1GetByIdGet**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1getbyidget) | **GET** /V1/customers/{customerId} | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1GetByIdGet_0**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1getbyidget_0) | **GET** /V1/customers/me | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1GetListGet**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1getlistget) | **GET** /V1/customers/search | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1SavePut**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1saveput) | **PUT** /V1/customers/{id} | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1SavePut_0**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1saveput_0) | **PUT** /V1/customers/me | 
*CustomerGroupManagementV1Api* | [**customerGroupManagementV1GetDefaultGroupGet**](docs/Api/CustomerGroupManagementV1Api.md#customergroupmanagementv1getdefaultgroupget) | **GET** /V1/customerGroups/default/{storeId} | 
*CustomerGroupManagementV1Api* | [**customerGroupManagementV1GetDefaultGroupGet_0**](docs/Api/CustomerGroupManagementV1Api.md#customergroupmanagementv1getdefaultgroupget_0) | **GET** /V1/customerGroups/default | 
*CustomerGroupManagementV1Api* | [**customerGroupManagementV1IsReadonlyGet**](docs/Api/CustomerGroupManagementV1Api.md#customergroupmanagementv1isreadonlyget) | **GET** /V1/customerGroups/{id}/permissions | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1DeleteByIdDelete**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1deletebyiddelete) | **DELETE** /V1/customerGroups/{id} | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1GetByIdGet**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1getbyidget) | **GET** /V1/customerGroups/{id} | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1GetListGet**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1getlistget) | **GET** /V1/customerGroups/search | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1SavePost**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1savepost) | **POST** /V1/customerGroups | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1SavePut**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1saveput) | **PUT** /V1/customerGroups/{id} | 
*DirectoryCountryInformationAcquirerV1Api* | [**directoryCountryInformationAcquirerV1GetCountriesInfoGet**](docs/Api/DirectoryCountryInformationAcquirerV1Api.md#directorycountryinformationacquirerv1getcountriesinfoget) | **GET** /V1/directory/countries | 
*DirectoryCountryInformationAcquirerV1Api* | [**directoryCountryInformationAcquirerV1GetCountryInfoGet**](docs/Api/DirectoryCountryInformationAcquirerV1Api.md#directorycountryinformationacquirerv1getcountryinfoget) | **GET** /V1/directory/countries/{countryId} | 
*DirectoryCurrencyInformationAcquirerV1Api* | [**directoryCurrencyInformationAcquirerV1GetCurrencyInfoGet**](docs/Api/DirectoryCurrencyInformationAcquirerV1Api.md#directorycurrencyinformationacquirerv1getcurrencyinfoget) | **GET** /V1/directory/currency | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1DeleteDelete**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1deletedelete) | **DELETE** /V1/products/downloadable-links/{id} | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1GetListGet**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1getlistget) | **GET** /V1/products/{sku}/downloadable-links | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1SavePost**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1savepost) | **POST** /V1/products/{sku}/downloadable-links | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1SavePut**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1saveput) | **PUT** /V1/products/{sku}/downloadable-links/{id} | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1DeleteDelete**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1deletedelete) | **DELETE** /V1/products/downloadable-links/samples/{id} | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1GetListGet**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1getlistget) | **GET** /V1/products/{sku}/downloadable-links/samples | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1SavePost**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1savepost) | **POST** /V1/products/{sku}/downloadable-links/samples | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1SavePut**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1saveput) | **PUT** /V1/products/{sku}/downloadable-links/samples/{id} | 
*EavAttributeSetManagementV1Api* | [**eavAttributeSetManagementV1CreatePost**](docs/Api/EavAttributeSetManagementV1Api.md#eavattributesetmanagementv1createpost) | **POST** /V1/eav/attribute-sets | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1DeleteByIdDelete**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1deletebyiddelete) | **DELETE** /V1/eav/attribute-sets/{attributeSetId} | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1GetGet**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1getget) | **GET** /V1/eav/attribute-sets/{attributeSetId} | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1GetListGet**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1getlistget) | **GET** /V1/eav/attribute-sets/list | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1SavePut**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1saveput) | **PUT** /V1/eav/attribute-sets/{attributeSetId} | 
*GiftCardAccountGiftCardAccountManagementV1Api* | [**giftCardAccountGiftCardAccountManagementV1CheckGiftCardGet**](docs/Api/GiftCardAccountGiftCardAccountManagementV1Api.md#giftcardaccountgiftcardaccountmanagementv1checkgiftcardget) | **GET** /V1/carts/mine/checkGiftCard/{giftCardCode} | 
*GiftCardAccountGiftCardAccountManagementV1Api* | [**giftCardAccountGiftCardAccountManagementV1DeleteByQuoteIdDelete**](docs/Api/GiftCardAccountGiftCardAccountManagementV1Api.md#giftcardaccountgiftcardaccountmanagementv1deletebyquoteiddelete) | **DELETE** /V1/carts/{quoteId}/giftCards/{giftCardCode} | 
*GiftCardAccountGiftCardAccountManagementV1Api* | [**giftCardAccountGiftCardAccountManagementV1GetListByQuoteIdGet**](docs/Api/GiftCardAccountGiftCardAccountManagementV1Api.md#giftcardaccountgiftcardaccountmanagementv1getlistbyquoteidget) | **GET** /V1/carts/{quoteId}/giftCards | 
*GiftCardAccountGiftCardAccountManagementV1Api* | [**giftCardAccountGiftCardAccountManagementV1SaveByQuoteIdPost**](docs/Api/GiftCardAccountGiftCardAccountManagementV1Api.md#giftcardaccountgiftcardaccountmanagementv1savebyquoteidpost) | **POST** /V1/carts/mine/giftCards | 
*GiftCardAccountGiftCardAccountManagementV1Api* | [**giftCardAccountGiftCardAccountManagementV1SaveByQuoteIdPut**](docs/Api/GiftCardAccountGiftCardAccountManagementV1Api.md#giftcardaccountgiftcardaccountmanagementv1savebyquoteidput) | **PUT** /V1/carts/{cartId}/giftCards | 
*GiftCardAccountGuestGiftCardAccountManagementV1Api* | [**giftCardAccountGuestGiftCardAccountManagementV1AddGiftCardPost**](docs/Api/GiftCardAccountGuestGiftCardAccountManagementV1Api.md#giftcardaccountguestgiftcardaccountmanagementv1addgiftcardpost) | **POST** /V1/carts/guest-carts/{cartId}/giftCards | 
*GiftCardAccountGuestGiftCardAccountManagementV1Api* | [**giftCardAccountGuestGiftCardAccountManagementV1CheckGiftCardGet**](docs/Api/GiftCardAccountGuestGiftCardAccountManagementV1Api.md#giftcardaccountguestgiftcardaccountmanagementv1checkgiftcardget) | **GET** /V1/carts/guest-carts/{cartId}/checkGiftCard/{giftCardCode} | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1GetGet**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1getget) | **GET** /V1/carts/{cartId}/gift-message | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1GetGet_0**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1getget_0) | **GET** /V1/carts/mine/gift-message | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1SavePost**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1savepost) | **POST** /V1/carts/{cartId}/gift-message | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1SavePost_0**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1savepost_0) | **POST** /V1/carts/mine/gift-message | 
*GiftMessageGuestCartRepositoryV1Api* | [**giftMessageGuestCartRepositoryV1GetGet**](docs/Api/GiftMessageGuestCartRepositoryV1Api.md#giftmessageguestcartrepositoryv1getget) | **GET** /V1/guest-carts/{cartId}/gift-message | 
*GiftMessageGuestCartRepositoryV1Api* | [**giftMessageGuestCartRepositoryV1SavePost**](docs/Api/GiftMessageGuestCartRepositoryV1Api.md#giftmessageguestcartrepositoryv1savepost) | **POST** /V1/guest-carts/{cartId}/gift-message | 
*GiftMessageGuestItemRepositoryV1Api* | [**giftMessageGuestItemRepositoryV1GetGet**](docs/Api/GiftMessageGuestItemRepositoryV1Api.md#giftmessageguestitemrepositoryv1getget) | **GET** /V1/guest-carts/{cartId}/gift-message/{itemId} | 
*GiftMessageGuestItemRepositoryV1Api* | [**giftMessageGuestItemRepositoryV1SavePost**](docs/Api/GiftMessageGuestItemRepositoryV1Api.md#giftmessageguestitemrepositoryv1savepost) | **POST** /V1/guest-carts/{cartId}/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1GetGet**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1getget) | **GET** /V1/carts/{cartId}/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1GetGet_0**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1getget_0) | **GET** /V1/carts/mine/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1SavePost**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1savepost) | **POST** /V1/carts/{cartId}/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1SavePost_0**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1savepost_0) | **POST** /V1/carts/mine/gift-message/{itemId} | 
*GiftRegistryGuestCartShippingMethodManagementV1Api* | [**giftRegistryGuestCartShippingMethodManagementV1EstimateByRegistryIdPost**](docs/Api/GiftRegistryGuestCartShippingMethodManagementV1Api.md#giftregistryguestcartshippingmethodmanagementv1estimatebyregistryidpost) | **POST** /V1/guest-giftregistry/{cartId}/estimate-shipping-methods | 
*GiftRegistryShippingMethodManagementV1Api* | [**giftRegistryShippingMethodManagementV1EstimateByRegistryIdPost**](docs/Api/GiftRegistryShippingMethodManagementV1Api.md#giftregistryshippingmethodmanagementv1estimatebyregistryidpost) | **POST** /V1/giftregistry/mine/estimate-shipping-methods | 
*GiftWrappingWrappingRepositoryV1Api* | [**giftWrappingWrappingRepositoryV1DeleteByIdDelete**](docs/Api/GiftWrappingWrappingRepositoryV1Api.md#giftwrappingwrappingrepositoryv1deletebyiddelete) | **DELETE** /V1/gift-wrappings/{id} | 
*GiftWrappingWrappingRepositoryV1Api* | [**giftWrappingWrappingRepositoryV1GetGet**](docs/Api/GiftWrappingWrappingRepositoryV1Api.md#giftwrappingwrappingrepositoryv1getget) | **GET** /V1/gift-wrappings/{id} | 
*GiftWrappingWrappingRepositoryV1Api* | [**giftWrappingWrappingRepositoryV1GetListGet**](docs/Api/GiftWrappingWrappingRepositoryV1Api.md#giftwrappingwrappingrepositoryv1getlistget) | **GET** /V1/gift-wrappings | 
*GiftWrappingWrappingRepositoryV1Api* | [**giftWrappingWrappingRepositoryV1SavePost**](docs/Api/GiftWrappingWrappingRepositoryV1Api.md#giftwrappingwrappingrepositoryv1savepost) | **POST** /V1/gift-wrappings | 
*GiftWrappingWrappingRepositoryV1Api* | [**giftWrappingWrappingRepositoryV1SavePut**](docs/Api/GiftWrappingWrappingRepositoryV1Api.md#giftwrappingwrappingrepositoryv1saveput) | **PUT** /V1/gift-wrappings/{wrappingId} | 
*IntegrationAdminTokenServiceV1Api* | [**integrationAdminTokenServiceV1CreateAdminAccessTokenPost**](docs/Api/IntegrationAdminTokenServiceV1Api.md#integrationadmintokenservicev1createadminaccesstokenpost) | **POST** /V1/integration/admin/token | 
*IntegrationCustomerTokenServiceV1Api* | [**integrationCustomerTokenServiceV1CreateCustomerAccessTokenPost**](docs/Api/IntegrationCustomerTokenServiceV1Api.md#integrationcustomertokenservicev1createcustomeraccesstokenpost) | **POST** /V1/integration/customer/token | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1AssignPost**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1assignpost) | **POST** /V1/carts/{cartId}/billing-address | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1AssignPost_0**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1assignpost_0) | **POST** /V1/carts/mine/billing-address | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1GetGet**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1getget) | **GET** /V1/carts/{cartId}/billing-address | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1GetGet_0**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1getget_0) | **GET** /V1/carts/mine/billing-address | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1DeleteByIdDelete**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1deletebyiddelete) | **DELETE** /V1/carts/{cartId}/items/{itemId} | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1DeleteByIdDelete_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1deletebyiddelete_0) | **DELETE** /V1/carts/mine/items/{itemId} | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1GetListGet**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1getlistget) | **GET** /V1/carts/{cartId}/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1GetListGet_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1getlistget_0) | **GET** /V1/carts/mine/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePost**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1savepost) | **POST** /V1/carts/{cartId}/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePost_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1savepost_0) | **POST** /V1/carts/mine/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePut**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1saveput) | **PUT** /V1/carts/{cartId}/items/{itemId} | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePut_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1saveput_0) | **PUT** /V1/carts/mine/items/{itemId} | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1AssignCustomerPut**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1assigncustomerput) | **PUT** /V1/carts/{cartId} | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1CreateEmptyCartForCustomerPost**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1createemptycartforcustomerpost) | **POST** /V1/customers/{customerId}/carts | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1CreateEmptyCartForCustomerPost_0**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1createemptycartforcustomerpost_0) | **POST** /V1/carts/mine | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1CreateEmptyCartPost**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1createemptycartpost) | **POST** /V1/carts/ | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1GetCartForCustomerGet**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1getcartforcustomerget) | **GET** /V1/carts/mine | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1PlaceOrderPut**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1placeorderput) | **PUT** /V1/carts/mine/order | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1PlaceOrderPut_0**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1placeorderput_0) | **PUT** /V1/carts/{cartId}/order | 
*QuoteCartRepositoryV1Api* | [**quoteCartRepositoryV1GetGet**](docs/Api/QuoteCartRepositoryV1Api.md#quotecartrepositoryv1getget) | **GET** /V1/carts/{cartId} | 
*QuoteCartRepositoryV1Api* | [**quoteCartRepositoryV1GetListGet**](docs/Api/QuoteCartRepositoryV1Api.md#quotecartrepositoryv1getlistget) | **GET** /V1/carts/search | 
*QuoteCartTotalManagementV1Api* | [**quoteCartTotalManagementV1CollectTotalsPut**](docs/Api/QuoteCartTotalManagementV1Api.md#quotecarttotalmanagementv1collecttotalsput) | **PUT** /V1/carts/mine/collect-totals | 
*QuoteCartTotalRepositoryV1Api* | [**quoteCartTotalRepositoryV1GetGet**](docs/Api/QuoteCartTotalRepositoryV1Api.md#quotecarttotalrepositoryv1getget) | **GET** /V1/carts/{cartId}/totals | 
*QuoteCartTotalRepositoryV1Api* | [**quoteCartTotalRepositoryV1GetGet_0**](docs/Api/QuoteCartTotalRepositoryV1Api.md#quotecarttotalrepositoryv1getget_0) | **GET** /V1/carts/mine/totals | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1GetGet**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1getget) | **GET** /V1/carts/{cartId}/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1GetGet_0**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1getget_0) | **GET** /V1/carts/mine/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1RemoveDelete**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1removedelete) | **DELETE** /V1/carts/{cartId}/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1RemoveDelete_0**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1removedelete_0) | **DELETE** /V1/carts/mine/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1SetPut**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1setput) | **PUT** /V1/carts/{cartId}/coupons/{couponCode} | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1SetPut_0**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1setput_0) | **PUT** /V1/carts/mine/coupons/{couponCode} | 
*QuoteGuestBillingAddressManagementV1Api* | [**quoteGuestBillingAddressManagementV1AssignPost**](docs/Api/QuoteGuestBillingAddressManagementV1Api.md#quoteguestbillingaddressmanagementv1assignpost) | **POST** /V1/guest-carts/{cartId}/billing-address | 
*QuoteGuestBillingAddressManagementV1Api* | [**quoteGuestBillingAddressManagementV1GetGet**](docs/Api/QuoteGuestBillingAddressManagementV1Api.md#quoteguestbillingaddressmanagementv1getget) | **GET** /V1/guest-carts/{cartId}/billing-address | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1DeleteByIdDelete**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1deletebyiddelete) | **DELETE** /V1/guest-carts/{cartId}/items/{itemId} | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1GetListGet**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1getlistget) | **GET** /V1/guest-carts/{cartId}/items | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1SavePost**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1savepost) | **POST** /V1/guest-carts/{cartId}/items | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1SavePut**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1saveput) | **PUT** /V1/guest-carts/{cartId}/items/{itemId} | 
*QuoteGuestCartManagementV1Api* | [**quoteGuestCartManagementV1AssignCustomerPut**](docs/Api/QuoteGuestCartManagementV1Api.md#quoteguestcartmanagementv1assigncustomerput) | **PUT** /V1/guest-carts/{cartId} | 
*QuoteGuestCartManagementV1Api* | [**quoteGuestCartManagementV1CreateEmptyCartPost**](docs/Api/QuoteGuestCartManagementV1Api.md#quoteguestcartmanagementv1createemptycartpost) | **POST** /V1/guest-carts | 
*QuoteGuestCartManagementV1Api* | [**quoteGuestCartManagementV1PlaceOrderPut**](docs/Api/QuoteGuestCartManagementV1Api.md#quoteguestcartmanagementv1placeorderput) | **PUT** /V1/guest-carts/{cartId}/order | 
*QuoteGuestCartRepositoryV1Api* | [**quoteGuestCartRepositoryV1GetGet**](docs/Api/QuoteGuestCartRepositoryV1Api.md#quoteguestcartrepositoryv1getget) | **GET** /V1/guest-carts/{cartId} | 
*QuoteGuestCartTotalManagementV1Api* | [**quoteGuestCartTotalManagementV1CollectTotalsPut**](docs/Api/QuoteGuestCartTotalManagementV1Api.md#quoteguestcarttotalmanagementv1collecttotalsput) | **PUT** /V1/guest-carts/{cartId}/collect-totals | 
*QuoteGuestCartTotalRepositoryV1Api* | [**quoteGuestCartTotalRepositoryV1GetGet**](docs/Api/QuoteGuestCartTotalRepositoryV1Api.md#quoteguestcarttotalrepositoryv1getget) | **GET** /V1/guest-carts/{cartId}/totals | 
*QuoteGuestCouponManagementV1Api* | [**quoteGuestCouponManagementV1GetGet**](docs/Api/QuoteGuestCouponManagementV1Api.md#quoteguestcouponmanagementv1getget) | **GET** /V1/guest-carts/{cartId}/coupons | 
*QuoteGuestCouponManagementV1Api* | [**quoteGuestCouponManagementV1RemoveDelete**](docs/Api/QuoteGuestCouponManagementV1Api.md#quoteguestcouponmanagementv1removedelete) | **DELETE** /V1/guest-carts/{cartId}/coupons | 
*QuoteGuestCouponManagementV1Api* | [**quoteGuestCouponManagementV1SetPut**](docs/Api/QuoteGuestCouponManagementV1Api.md#quoteguestcouponmanagementv1setput) | **PUT** /V1/guest-carts/{cartId}/coupons/{couponCode} | 
*QuoteGuestPaymentMethodManagementV1Api* | [**quoteGuestPaymentMethodManagementV1GetGet**](docs/Api/QuoteGuestPaymentMethodManagementV1Api.md#quoteguestpaymentmethodmanagementv1getget) | **GET** /V1/guest-carts/{cartId}/selected-payment-method | 
*QuoteGuestPaymentMethodManagementV1Api* | [**quoteGuestPaymentMethodManagementV1GetListGet**](docs/Api/QuoteGuestPaymentMethodManagementV1Api.md#quoteguestpaymentmethodmanagementv1getlistget) | **GET** /V1/guest-carts/{cartId}/payment-methods | 
*QuoteGuestPaymentMethodManagementV1Api* | [**quoteGuestPaymentMethodManagementV1SetPut**](docs/Api/QuoteGuestPaymentMethodManagementV1Api.md#quoteguestpaymentmethodmanagementv1setput) | **PUT** /V1/guest-carts/{cartId}/selected-payment-method | 
*QuoteGuestShipmentEstimationV1Api* | [**quoteGuestShipmentEstimationV1EstimateByExtendedAddressPost**](docs/Api/QuoteGuestShipmentEstimationV1Api.md#quoteguestshipmentestimationv1estimatebyextendedaddresspost) | **POST** /V1/guest-carts/{cartId}/estimate-shipping-methods | 
*QuoteGuestShippingMethodManagementV1Api* | [**quoteGuestShippingMethodManagementV1GetListGet**](docs/Api/QuoteGuestShippingMethodManagementV1Api.md#quoteguestshippingmethodmanagementv1getlistget) | **GET** /V1/guest-carts/{cartId}/shipping-methods | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetGet**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getget) | **GET** /V1/carts/{cartId}/selected-payment-method | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetGet_0**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getget_0) | **GET** /V1/carts/mine/selected-payment-method | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetListGet**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getlistget) | **GET** /V1/carts/{cartId}/payment-methods | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetListGet_0**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getlistget_0) | **GET** /V1/carts/mine/payment-methods | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1SetPut**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1setput) | **PUT** /V1/carts/{cartId}/selected-payment-method | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1SetPut_0**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1setput_0) | **PUT** /V1/carts/mine/selected-payment-method | 
*QuoteShipmentEstimationV1Api* | [**quoteShipmentEstimationV1EstimateByExtendedAddressPost**](docs/Api/QuoteShipmentEstimationV1Api.md#quoteshipmentestimationv1estimatebyextendedaddresspost) | **POST** /V1/carts/{cartId}/estimate-shipping-methods | 
*QuoteShipmentEstimationV1Api* | [**quoteShipmentEstimationV1EstimateByExtendedAddressPost_0**](docs/Api/QuoteShipmentEstimationV1Api.md#quoteshipmentestimationv1estimatebyextendedaddresspost_0) | **POST** /V1/carts/mine/estimate-shipping-methods | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1EstimateByAddressIdPost**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1estimatebyaddressidpost) | **POST** /V1/carts/{cartId}/estimate-shipping-methods-by-address-id | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1EstimateByAddressIdPost_0**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1estimatebyaddressidpost_0) | **POST** /V1/carts/mine/estimate-shipping-methods-by-address-id | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1GetListGet**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1getlistget) | **GET** /V1/carts/{cartId}/shipping-methods | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1GetListGet_0**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1getlistget_0) | **GET** /V1/carts/mine/shipping-methods | 
*RewardRewardManagementV1Api* | [**rewardRewardManagementV1SetPost**](docs/Api/RewardRewardManagementV1Api.md#rewardrewardmanagementv1setpost) | **POST** /V1/reward/mine/use-reward | 
*RmaCommentManagementV1Api* | [**rmaCommentManagementV1AddCommentPost**](docs/Api/RmaCommentManagementV1Api.md#rmacommentmanagementv1addcommentpost) | **POST** /V1/returns/{id}/comments | 
*RmaCommentManagementV1Api* | [**rmaCommentManagementV1CommentsListGet**](docs/Api/RmaCommentManagementV1Api.md#rmacommentmanagementv1commentslistget) | **GET** /V1/returns/{id}/comments | 
*RmaRmaAttributesManagementV1Api* | [**rmaRmaAttributesManagementV1GetAllAttributesMetadataGet**](docs/Api/RmaRmaAttributesManagementV1Api.md#rmarmaattributesmanagementv1getallattributesmetadataget) | **GET** /V1/returnsAttributeMetadata | 
*RmaRmaAttributesManagementV1Api* | [**rmaRmaAttributesManagementV1GetAttributeMetadataGet**](docs/Api/RmaRmaAttributesManagementV1Api.md#rmarmaattributesmanagementv1getattributemetadataget) | **GET** /V1/returnsAttributeMetadata/{attributeCode} | 
*RmaRmaAttributesManagementV1Api* | [**rmaRmaAttributesManagementV1GetAttributesGet**](docs/Api/RmaRmaAttributesManagementV1Api.md#rmarmaattributesmanagementv1getattributesget) | **GET** /V1/returnsAttributeMetadata/form/{formCode} | 
*RmaRmaAttributesManagementV1Api* | [**rmaRmaAttributesManagementV1GetCustomAttributesMetadataGet**](docs/Api/RmaRmaAttributesManagementV1Api.md#rmarmaattributesmanagementv1getcustomattributesmetadataget) | **GET** /V1/returnsAttributeMetadata/custom | 
*RmaRmaManagementV1Api* | [**rmaRmaManagementV1SaveRmaPost**](docs/Api/RmaRmaManagementV1Api.md#rmarmamanagementv1savermapost) | **POST** /V1/returns | 
*RmaRmaManagementV1Api* | [**rmaRmaManagementV1SaveRmaPut**](docs/Api/RmaRmaManagementV1Api.md#rmarmamanagementv1savermaput) | **PUT** /V1/returns/{id} | 
*RmaRmaManagementV1Api* | [**rmaRmaManagementV1SearchGet**](docs/Api/RmaRmaManagementV1Api.md#rmarmamanagementv1searchget) | **GET** /V1/returns | 
*RmaRmaRepositoryV1Api* | [**rmaRmaRepositoryV1DeleteDelete**](docs/Api/RmaRmaRepositoryV1Api.md#rmarmarepositoryv1deletedelete) | **DELETE** /V1/returns/{id} | 
*RmaRmaRepositoryV1Api* | [**rmaRmaRepositoryV1GetGet**](docs/Api/RmaRmaRepositoryV1Api.md#rmarmarepositoryv1getget) | **GET** /V1/returns/{id} | 
*RmaTrackManagementV1Api* | [**rmaTrackManagementV1AddTrackPost**](docs/Api/RmaTrackManagementV1Api.md#rmatrackmanagementv1addtrackpost) | **POST** /V1/returns/{id}/tracking-numbers | 
*RmaTrackManagementV1Api* | [**rmaTrackManagementV1GetShippingLabelPdfGet**](docs/Api/RmaTrackManagementV1Api.md#rmatrackmanagementv1getshippinglabelpdfget) | **GET** /V1/returns/{id}/labels | 
*RmaTrackManagementV1Api* | [**rmaTrackManagementV1GetTracksGet**](docs/Api/RmaTrackManagementV1Api.md#rmatrackmanagementv1gettracksget) | **GET** /V1/returns/{id}/tracking-numbers | 
*RmaTrackManagementV1Api* | [**rmaTrackManagementV1RemoveTrackByIdDelete**](docs/Api/RmaTrackManagementV1Api.md#rmatrackmanagementv1removetrackbyiddelete) | **DELETE** /V1/returns/{id}/tracking-numbers/{trackId} | 
*SalesCreditmemoCommentRepositoryV1Api* | [**salesCreditmemoCommentRepositoryV1SavePost**](docs/Api/SalesCreditmemoCommentRepositoryV1Api.md#salescreditmemocommentrepositoryv1savepost) | **POST** /V1/creditmemo/{id}/comments | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1CancelPut**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1cancelput) | **PUT** /V1/creditmemo/{id} | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1GetCommentsListGet**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1getcommentslistget) | **GET** /V1/creditmemo/{id}/comments | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1NotifyPost**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1notifypost) | **POST** /V1/creditmemo/{id}/emails | 
*SalesCreditmemoRepositoryV1Api* | [**salesCreditmemoRepositoryV1GetGet**](docs/Api/SalesCreditmemoRepositoryV1Api.md#salescreditmemorepositoryv1getget) | **GET** /V1/creditmemo/{id} | 
*SalesCreditmemoRepositoryV1Api* | [**salesCreditmemoRepositoryV1GetListGet**](docs/Api/SalesCreditmemoRepositoryV1Api.md#salescreditmemorepositoryv1getlistget) | **GET** /V1/creditmemos | 
*SalesCreditmemoRepositoryV1Api* | [**salesCreditmemoRepositoryV1SavePost**](docs/Api/SalesCreditmemoRepositoryV1Api.md#salescreditmemorepositoryv1savepost) | **POST** /V1/creditmemo | 
*SalesInvoiceCommentRepositoryV1Api* | [**salesInvoiceCommentRepositoryV1SavePost**](docs/Api/SalesInvoiceCommentRepositoryV1Api.md#salesinvoicecommentrepositoryv1savepost) | **POST** /V1/invoices/comments | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1GetCommentsListGet**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1getcommentslistget) | **GET** /V1/invoices/{id}/comments | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1NotifyPost**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1notifypost) | **POST** /V1/invoices/{id}/emails | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1SetCapturePost**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1setcapturepost) | **POST** /V1/invoices/{id}/capture | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1SetVoidPost**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1setvoidpost) | **POST** /V1/invoices/{id}/void | 
*SalesInvoiceOrderV1Api* | [**salesInvoiceOrderV1ExecutePost**](docs/Api/SalesInvoiceOrderV1Api.md#salesinvoiceorderv1executepost) | **POST** /V1/order/{orderId}/invoice | 
*SalesInvoiceRepositoryV1Api* | [**salesInvoiceRepositoryV1GetGet**](docs/Api/SalesInvoiceRepositoryV1Api.md#salesinvoicerepositoryv1getget) | **GET** /V1/invoices/{id} | 
*SalesInvoiceRepositoryV1Api* | [**salesInvoiceRepositoryV1GetListGet**](docs/Api/SalesInvoiceRepositoryV1Api.md#salesinvoicerepositoryv1getlistget) | **GET** /V1/invoices | 
*SalesInvoiceRepositoryV1Api* | [**salesInvoiceRepositoryV1SavePost**](docs/Api/SalesInvoiceRepositoryV1Api.md#salesinvoicerepositoryv1savepost) | **POST** /V1/invoices/ | 
*SalesOrderAddressRepositoryV1Api* | [**salesOrderAddressRepositoryV1SavePut**](docs/Api/SalesOrderAddressRepositoryV1Api.md#salesorderaddressrepositoryv1saveput) | **PUT** /V1/orders/{parent_id} | 
*SalesOrderItemRepositoryV1Api* | [**salesOrderItemRepositoryV1GetGet**](docs/Api/SalesOrderItemRepositoryV1Api.md#salesorderitemrepositoryv1getget) | **GET** /V1/orders/items/{id} | 
*SalesOrderItemRepositoryV1Api* | [**salesOrderItemRepositoryV1GetListGet**](docs/Api/SalesOrderItemRepositoryV1Api.md#salesorderitemrepositoryv1getlistget) | **GET** /V1/orders/items | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1AddCommentPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1addcommentpost) | **POST** /V1/orders/{id}/comments | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1CancelPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1cancelpost) | **POST** /V1/orders/{id}/cancel | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1GetCommentsListGet**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1getcommentslistget) | **GET** /V1/orders/{id}/comments | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1GetStatusGet**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1getstatusget) | **GET** /V1/orders/{id}/statuses | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1HoldPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1holdpost) | **POST** /V1/orders/{id}/hold | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1NotifyPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1notifypost) | **POST** /V1/orders/{id}/emails | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1UnHoldPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1unholdpost) | **POST** /V1/orders/{id}/unhold | 
*SalesOrderRepositoryV1Api* | [**salesOrderRepositoryV1GetGet**](docs/Api/SalesOrderRepositoryV1Api.md#salesorderrepositoryv1getget) | **GET** /V1/orders/{id} | 
*SalesOrderRepositoryV1Api* | [**salesOrderRepositoryV1GetListGet**](docs/Api/SalesOrderRepositoryV1Api.md#salesorderrepositoryv1getlistget) | **GET** /V1/orders | 
*SalesRefundInvoiceV1Api* | [**salesRefundInvoiceV1ExecutePost**](docs/Api/SalesRefundInvoiceV1Api.md#salesrefundinvoicev1executepost) | **POST** /V1/invoice/{invoiceId}/refund | 
*SalesRefundOrderV1Api* | [**salesRefundOrderV1ExecutePost**](docs/Api/SalesRefundOrderV1Api.md#salesrefundorderv1executepost) | **POST** /V1/order/{orderId}/refund | 
*SalesRuleCouponManagementV1Api* | [**salesRuleCouponManagementV1DeleteByCodesPost**](docs/Api/SalesRuleCouponManagementV1Api.md#salesrulecouponmanagementv1deletebycodespost) | **POST** /V1/coupons/deleteByCodes | 
*SalesRuleCouponManagementV1Api* | [**salesRuleCouponManagementV1DeleteByIdsPost**](docs/Api/SalesRuleCouponManagementV1Api.md#salesrulecouponmanagementv1deletebyidspost) | **POST** /V1/coupons/deleteByIds | 
*SalesRuleCouponManagementV1Api* | [**salesRuleCouponManagementV1GeneratePost**](docs/Api/SalesRuleCouponManagementV1Api.md#salesrulecouponmanagementv1generatepost) | **POST** /V1/coupons/generate | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1DeleteByIdDelete**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1deletebyiddelete) | **DELETE** /V1/coupons/{couponId} | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1GetByIdGet**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1getbyidget) | **GET** /V1/coupons/{couponId} | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1GetListGet**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1getlistget) | **GET** /V1/coupons/search | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1SavePost**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1savepost) | **POST** /V1/coupons | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1SavePut**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1saveput) | **PUT** /V1/coupons/{couponId} | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1DeleteByIdDelete**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1deletebyiddelete) | **DELETE** /V1/salesRules/{ruleId} | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1GetByIdGet**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1getbyidget) | **GET** /V1/salesRules/{ruleId} | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1GetListGet**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1getlistget) | **GET** /V1/salesRules/search | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1SavePost**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1savepost) | **POST** /V1/salesRules | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1SavePut**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1saveput) | **PUT** /V1/salesRules/{ruleId} | 
*SalesShipOrderV1Api* | [**salesShipOrderV1ExecutePost**](docs/Api/SalesShipOrderV1Api.md#salesshiporderv1executepost) | **POST** /V1/order/{orderId}/ship | 
*SalesShipmentCommentRepositoryV1Api* | [**salesShipmentCommentRepositoryV1SavePost**](docs/Api/SalesShipmentCommentRepositoryV1Api.md#salesshipmentcommentrepositoryv1savepost) | **POST** /V1/shipment/{id}/comments | 
*SalesShipmentManagementV1Api* | [**salesShipmentManagementV1GetCommentsListGet**](docs/Api/SalesShipmentManagementV1Api.md#salesshipmentmanagementv1getcommentslistget) | **GET** /V1/shipment/{id}/comments | 
*SalesShipmentManagementV1Api* | [**salesShipmentManagementV1GetLabelGet**](docs/Api/SalesShipmentManagementV1Api.md#salesshipmentmanagementv1getlabelget) | **GET** /V1/shipment/{id}/label | 
*SalesShipmentManagementV1Api* | [**salesShipmentManagementV1NotifyPost**](docs/Api/SalesShipmentManagementV1Api.md#salesshipmentmanagementv1notifypost) | **POST** /V1/shipment/{id}/emails | 
*SalesShipmentRepositoryV1Api* | [**salesShipmentRepositoryV1GetGet**](docs/Api/SalesShipmentRepositoryV1Api.md#salesshipmentrepositoryv1getget) | **GET** /V1/shipment/{id} | 
*SalesShipmentRepositoryV1Api* | [**salesShipmentRepositoryV1GetListGet**](docs/Api/SalesShipmentRepositoryV1Api.md#salesshipmentrepositoryv1getlistget) | **GET** /V1/shipments | 
*SalesShipmentRepositoryV1Api* | [**salesShipmentRepositoryV1SavePost**](docs/Api/SalesShipmentRepositoryV1Api.md#salesshipmentrepositoryv1savepost) | **POST** /V1/shipment/ | 
*SalesShipmentTrackRepositoryV1Api* | [**salesShipmentTrackRepositoryV1DeleteByIdDelete**](docs/Api/SalesShipmentTrackRepositoryV1Api.md#salesshipmenttrackrepositoryv1deletebyiddelete) | **DELETE** /V1/shipment/track/{id} | 
*SalesShipmentTrackRepositoryV1Api* | [**salesShipmentTrackRepositoryV1SavePost**](docs/Api/SalesShipmentTrackRepositoryV1Api.md#salesshipmenttrackrepositoryv1savepost) | **POST** /V1/shipment/track | 
*SalesTransactionRepositoryV1Api* | [**salesTransactionRepositoryV1GetGet**](docs/Api/SalesTransactionRepositoryV1Api.md#salestransactionrepositoryv1getget) | **GET** /V1/transactions/{id} | 
*SalesTransactionRepositoryV1Api* | [**salesTransactionRepositoryV1GetListGet**](docs/Api/SalesTransactionRepositoryV1Api.md#salestransactionrepositoryv1getlistget) | **GET** /V1/transactions | 
*SearchV1Api* | [**searchV1SearchGet**](docs/Api/SearchV1Api.md#searchv1searchget) | **GET** /V1/search | 
*StoreGroupRepositoryV1Api* | [**storeGroupRepositoryV1GetListGet**](docs/Api/StoreGroupRepositoryV1Api.md#storegrouprepositoryv1getlistget) | **GET** /V1/store/storeGroups | 
*StoreStoreConfigManagerV1Api* | [**storeStoreConfigManagerV1GetStoreConfigsGet**](docs/Api/StoreStoreConfigManagerV1Api.md#storestoreconfigmanagerv1getstoreconfigsget) | **GET** /V1/store/storeConfigs | 
*StoreStoreRepositoryV1Api* | [**storeStoreRepositoryV1GetListGet**](docs/Api/StoreStoreRepositoryV1Api.md#storestorerepositoryv1getlistget) | **GET** /V1/store/storeViews | 
*StoreWebsiteRepositoryV1Api* | [**storeWebsiteRepositoryV1GetListGet**](docs/Api/StoreWebsiteRepositoryV1Api.md#storewebsiterepositoryv1getlistget) | **GET** /V1/store/websites | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1DeleteByIdDelete**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1deletebyiddelete) | **DELETE** /V1/taxClasses/{taxClassId} | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1GetGet**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1getget) | **GET** /V1/taxClasses/{taxClassId} | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1GetListGet**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1getlistget) | **GET** /V1/taxClasses/search | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1SavePost**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1savepost) | **POST** /V1/taxClasses | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1SavePut**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1saveput) | **PUT** /V1/taxClasses/{classId} | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1DeleteByIdDelete**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1deletebyiddelete) | **DELETE** /V1/taxRates/{rateId} | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1GetGet**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1getget) | **GET** /V1/taxRates/{rateId} | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1GetListGet**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1getlistget) | **GET** /V1/taxRates/search | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1SavePost**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1savepost) | **POST** /V1/taxRates | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1SavePut**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1saveput) | **PUT** /V1/taxRates | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1DeleteByIdDelete**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1deletebyiddelete) | **DELETE** /V1/taxRules/{ruleId} | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1GetGet**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1getget) | **GET** /V1/taxRules/{ruleId} | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1GetListGet**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1getlistget) | **GET** /V1/taxRules/search | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1SavePost**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1savepost) | **POST** /V1/taxRules | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1SavePut**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1saveput) | **PUT** /V1/taxRules | 


## Documentation For Models

 - [Body](docs/Model/Body.md)
 - [Body1](docs/Model/Body1.md)
 - [Body10](docs/Model/Body10.md)
 - [Body100](docs/Model/Body100.md)
 - [Body101](docs/Model/Body101.md)
 - [Body102](docs/Model/Body102.md)
 - [Body103](docs/Model/Body103.md)
 - [Body104](docs/Model/Body104.md)
 - [Body105](docs/Model/Body105.md)
 - [Body106](docs/Model/Body106.md)
 - [Body107](docs/Model/Body107.md)
 - [Body108](docs/Model/Body108.md)
 - [Body109](docs/Model/Body109.md)
 - [Body11](docs/Model/Body11.md)
 - [Body110](docs/Model/Body110.md)
 - [Body111](docs/Model/Body111.md)
 - [Body112](docs/Model/Body112.md)
 - [Body113](docs/Model/Body113.md)
 - [Body114](docs/Model/Body114.md)
 - [Body115](docs/Model/Body115.md)
 - [Body116](docs/Model/Body116.md)
 - [Body117](docs/Model/Body117.md)
 - [Body118](docs/Model/Body118.md)
 - [Body119](docs/Model/Body119.md)
 - [Body12](docs/Model/Body12.md)
 - [Body120](docs/Model/Body120.md)
 - [Body121](docs/Model/Body121.md)
 - [Body122](docs/Model/Body122.md)
 - [Body123](docs/Model/Body123.md)
 - [Body124](docs/Model/Body124.md)
 - [Body125](docs/Model/Body125.md)
 - [Body126](docs/Model/Body126.md)
 - [Body127](docs/Model/Body127.md)
 - [Body128](docs/Model/Body128.md)
 - [Body129](docs/Model/Body129.md)
 - [Body13](docs/Model/Body13.md)
 - [Body130](docs/Model/Body130.md)
 - [Body131](docs/Model/Body131.md)
 - [Body132](docs/Model/Body132.md)
 - [Body133](docs/Model/Body133.md)
 - [Body14](docs/Model/Body14.md)
 - [Body15](docs/Model/Body15.md)
 - [Body16](docs/Model/Body16.md)
 - [Body17](docs/Model/Body17.md)
 - [Body18](docs/Model/Body18.md)
 - [Body19](docs/Model/Body19.md)
 - [Body2](docs/Model/Body2.md)
 - [Body20](docs/Model/Body20.md)
 - [Body21](docs/Model/Body21.md)
 - [Body22](docs/Model/Body22.md)
 - [Body23](docs/Model/Body23.md)
 - [Body24](docs/Model/Body24.md)
 - [Body25](docs/Model/Body25.md)
 - [Body26](docs/Model/Body26.md)
 - [Body27](docs/Model/Body27.md)
 - [Body28](docs/Model/Body28.md)
 - [Body29](docs/Model/Body29.md)
 - [Body3](docs/Model/Body3.md)
 - [Body30](docs/Model/Body30.md)
 - [Body31](docs/Model/Body31.md)
 - [Body32](docs/Model/Body32.md)
 - [Body33](docs/Model/Body33.md)
 - [Body34](docs/Model/Body34.md)
 - [Body35](docs/Model/Body35.md)
 - [Body36](docs/Model/Body36.md)
 - [Body37](docs/Model/Body37.md)
 - [Body38](docs/Model/Body38.md)
 - [Body39](docs/Model/Body39.md)
 - [Body4](docs/Model/Body4.md)
 - [Body40](docs/Model/Body40.md)
 - [Body41](docs/Model/Body41.md)
 - [Body42](docs/Model/Body42.md)
 - [Body43](docs/Model/Body43.md)
 - [Body44](docs/Model/Body44.md)
 - [Body45](docs/Model/Body45.md)
 - [Body46](docs/Model/Body46.md)
 - [Body47](docs/Model/Body47.md)
 - [Body48](docs/Model/Body48.md)
 - [Body49](docs/Model/Body49.md)
 - [Body5](docs/Model/Body5.md)
 - [Body50](docs/Model/Body50.md)
 - [Body51](docs/Model/Body51.md)
 - [Body52](docs/Model/Body52.md)
 - [Body53](docs/Model/Body53.md)
 - [Body54](docs/Model/Body54.md)
 - [Body55](docs/Model/Body55.md)
 - [Body56](docs/Model/Body56.md)
 - [Body57](docs/Model/Body57.md)
 - [Body58](docs/Model/Body58.md)
 - [Body59](docs/Model/Body59.md)
 - [Body6](docs/Model/Body6.md)
 - [Body60](docs/Model/Body60.md)
 - [Body61](docs/Model/Body61.md)
 - [Body62](docs/Model/Body62.md)
 - [Body63](docs/Model/Body63.md)
 - [Body64](docs/Model/Body64.md)
 - [Body65](docs/Model/Body65.md)
 - [Body66](docs/Model/Body66.md)
 - [Body67](docs/Model/Body67.md)
 - [Body68](docs/Model/Body68.md)
 - [Body69](docs/Model/Body69.md)
 - [Body7](docs/Model/Body7.md)
 - [Body70](docs/Model/Body70.md)
 - [Body71](docs/Model/Body71.md)
 - [Body72](docs/Model/Body72.md)
 - [Body73](docs/Model/Body73.md)
 - [Body74](docs/Model/Body74.md)
 - [Body75](docs/Model/Body75.md)
 - [Body76](docs/Model/Body76.md)
 - [Body77](docs/Model/Body77.md)
 - [Body78](docs/Model/Body78.md)
 - [Body79](docs/Model/Body79.md)
 - [Body8](docs/Model/Body8.md)
 - [Body80](docs/Model/Body80.md)
 - [Body81](docs/Model/Body81.md)
 - [Body82](docs/Model/Body82.md)
 - [Body83](docs/Model/Body83.md)
 - [Body84](docs/Model/Body84.md)
 - [Body85](docs/Model/Body85.md)
 - [Body86](docs/Model/Body86.md)
 - [Body87](docs/Model/Body87.md)
 - [Body88](docs/Model/Body88.md)
 - [Body89](docs/Model/Body89.md)
 - [Body9](docs/Model/Body9.md)
 - [Body90](docs/Model/Body90.md)
 - [Body91](docs/Model/Body91.md)
 - [Body92](docs/Model/Body92.md)
 - [Body93](docs/Model/Body93.md)
 - [Body94](docs/Model/Body94.md)
 - [Body95](docs/Model/Body95.md)
 - [Body96](docs/Model/Body96.md)
 - [Body97](docs/Model/Body97.md)
 - [Body98](docs/Model/Body98.md)
 - [Body99](docs/Model/Body99.md)
 - [BundleDataBundleOptionExtensionInterface](docs/Model/BundleDataBundleOptionExtensionInterface.md)
 - [BundleDataBundleOptionInterface](docs/Model/BundleDataBundleOptionInterface.md)
 - [BundleDataLinkExtensionInterface](docs/Model/BundleDataLinkExtensionInterface.md)
 - [BundleDataLinkInterface](docs/Model/BundleDataLinkInterface.md)
 - [BundleDataOptionExtensionInterface](docs/Model/BundleDataOptionExtensionInterface.md)
 - [BundleDataOptionInterface](docs/Model/BundleDataOptionInterface.md)
 - [BundleDataOptionTypeExtensionInterface](docs/Model/BundleDataOptionTypeExtensionInterface.md)
 - [BundleDataOptionTypeInterface](docs/Model/BundleDataOptionTypeInterface.md)
 - [CatalogDataCategoryAttributeInterface](docs/Model/CatalogDataCategoryAttributeInterface.md)
 - [CatalogDataCategoryAttributeSearchResultsInterface](docs/Model/CatalogDataCategoryAttributeSearchResultsInterface.md)
 - [CatalogDataCategoryExtensionInterface](docs/Model/CatalogDataCategoryExtensionInterface.md)
 - [CatalogDataCategoryInterface](docs/Model/CatalogDataCategoryInterface.md)
 - [CatalogDataCategoryProductLinkExtensionInterface](docs/Model/CatalogDataCategoryProductLinkExtensionInterface.md)
 - [CatalogDataCategoryProductLinkInterface](docs/Model/CatalogDataCategoryProductLinkInterface.md)
 - [CatalogDataCategoryTreeInterface](docs/Model/CatalogDataCategoryTreeInterface.md)
 - [CatalogDataCustomOptionExtensionInterface](docs/Model/CatalogDataCustomOptionExtensionInterface.md)
 - [CatalogDataCustomOptionInterface](docs/Model/CatalogDataCustomOptionInterface.md)
 - [CatalogDataEavAttributeExtensionInterface](docs/Model/CatalogDataEavAttributeExtensionInterface.md)
 - [CatalogDataProductAttributeInterface](docs/Model/CatalogDataProductAttributeInterface.md)
 - [CatalogDataProductAttributeMediaGalleryEntryExtensionInterface](docs/Model/CatalogDataProductAttributeMediaGalleryEntryExtensionInterface.md)
 - [CatalogDataProductAttributeMediaGalleryEntryInterface](docs/Model/CatalogDataProductAttributeMediaGalleryEntryInterface.md)
 - [CatalogDataProductAttributeSearchResultsInterface](docs/Model/CatalogDataProductAttributeSearchResultsInterface.md)
 - [CatalogDataProductAttributeTypeExtensionInterface](docs/Model/CatalogDataProductAttributeTypeExtensionInterface.md)
 - [CatalogDataProductAttributeTypeInterface](docs/Model/CatalogDataProductAttributeTypeInterface.md)
 - [CatalogDataProductCustomOptionExtensionInterface](docs/Model/CatalogDataProductCustomOptionExtensionInterface.md)
 - [CatalogDataProductCustomOptionInterface](docs/Model/CatalogDataProductCustomOptionInterface.md)
 - [CatalogDataProductCustomOptionTypeExtensionInterface](docs/Model/CatalogDataProductCustomOptionTypeExtensionInterface.md)
 - [CatalogDataProductCustomOptionTypeInterface](docs/Model/CatalogDataProductCustomOptionTypeInterface.md)
 - [CatalogDataProductCustomOptionValuesInterface](docs/Model/CatalogDataProductCustomOptionValuesInterface.md)
 - [CatalogDataProductExtensionInterface](docs/Model/CatalogDataProductExtensionInterface.md)
 - [CatalogDataProductInterface](docs/Model/CatalogDataProductInterface.md)
 - [CatalogDataProductLinkAttributeExtensionInterface](docs/Model/CatalogDataProductLinkAttributeExtensionInterface.md)
 - [CatalogDataProductLinkAttributeInterface](docs/Model/CatalogDataProductLinkAttributeInterface.md)
 - [CatalogDataProductLinkExtensionInterface](docs/Model/CatalogDataProductLinkExtensionInterface.md)
 - [CatalogDataProductLinkInterface](docs/Model/CatalogDataProductLinkInterface.md)
 - [CatalogDataProductLinkTypeExtensionInterface](docs/Model/CatalogDataProductLinkTypeExtensionInterface.md)
 - [CatalogDataProductLinkTypeInterface](docs/Model/CatalogDataProductLinkTypeInterface.md)
 - [CatalogDataProductOptionExtensionInterface](docs/Model/CatalogDataProductOptionExtensionInterface.md)
 - [CatalogDataProductOptionInterface](docs/Model/CatalogDataProductOptionInterface.md)
 - [CatalogDataProductSearchResultsInterface](docs/Model/CatalogDataProductSearchResultsInterface.md)
 - [CatalogDataProductTierPriceExtensionInterface](docs/Model/CatalogDataProductTierPriceExtensionInterface.md)
 - [CatalogDataProductTierPriceInterface](docs/Model/CatalogDataProductTierPriceInterface.md)
 - [CatalogDataProductTypeExtensionInterface](docs/Model/CatalogDataProductTypeExtensionInterface.md)
 - [CatalogDataProductTypeInterface](docs/Model/CatalogDataProductTypeInterface.md)
 - [CatalogDataProductWebsiteLinkInterface](docs/Model/CatalogDataProductWebsiteLinkInterface.md)
 - [CatalogInventoryDataStockItemExtensionInterface](docs/Model/CatalogInventoryDataStockItemExtensionInterface.md)
 - [CatalogInventoryDataStockItemInterface](docs/Model/CatalogInventoryDataStockItemInterface.md)
 - [CatalogInventoryDataStockStatusCollectionInterface](docs/Model/CatalogInventoryDataStockStatusCollectionInterface.md)
 - [CatalogInventoryDataStockStatusExtensionInterface](docs/Model/CatalogInventoryDataStockStatusExtensionInterface.md)
 - [CatalogInventoryDataStockStatusInterface](docs/Model/CatalogInventoryDataStockStatusInterface.md)
 - [CatalogInventoryStockStatusCriteriaInterface](docs/Model/CatalogInventoryStockStatusCriteriaInterface.md)
 - [CheckoutAgreementsDataAgreementExtensionInterface](docs/Model/CheckoutAgreementsDataAgreementExtensionInterface.md)
 - [CheckoutAgreementsDataAgreementInterface](docs/Model/CheckoutAgreementsDataAgreementInterface.md)
 - [CheckoutDataPaymentDetailsExtensionInterface](docs/Model/CheckoutDataPaymentDetailsExtensionInterface.md)
 - [CheckoutDataPaymentDetailsInterface](docs/Model/CheckoutDataPaymentDetailsInterface.md)
 - [CheckoutDataShippingInformationExtensionInterface](docs/Model/CheckoutDataShippingInformationExtensionInterface.md)
 - [CheckoutDataShippingInformationInterface](docs/Model/CheckoutDataShippingInformationInterface.md)
 - [CheckoutDataTotalsInformationExtensionInterface](docs/Model/CheckoutDataTotalsInformationExtensionInterface.md)
 - [CheckoutDataTotalsInformationInterface](docs/Model/CheckoutDataTotalsInformationInterface.md)
 - [CmsDataBlockInterface](docs/Model/CmsDataBlockInterface.md)
 - [CmsDataBlockSearchResultsInterface](docs/Model/CmsDataBlockSearchResultsInterface.md)
 - [CmsDataPageInterface](docs/Model/CmsDataPageInterface.md)
 - [CmsDataPageSearchResultsInterface](docs/Model/CmsDataPageSearchResultsInterface.md)
 - [ConfigurableProductDataConfigurableItemOptionValueExtensionInterface](docs/Model/ConfigurableProductDataConfigurableItemOptionValueExtensionInterface.md)
 - [ConfigurableProductDataConfigurableItemOptionValueInterface](docs/Model/ConfigurableProductDataConfigurableItemOptionValueInterface.md)
 - [ConfigurableProductDataOptionExtensionInterface](docs/Model/ConfigurableProductDataOptionExtensionInterface.md)
 - [ConfigurableProductDataOptionInterface](docs/Model/ConfigurableProductDataOptionInterface.md)
 - [ConfigurableProductDataOptionValueExtensionInterface](docs/Model/ConfigurableProductDataOptionValueExtensionInterface.md)
 - [ConfigurableProductDataOptionValueInterface](docs/Model/ConfigurableProductDataOptionValueInterface.md)
 - [CustomerDataAddressExtensionInterface](docs/Model/CustomerDataAddressExtensionInterface.md)
 - [CustomerDataAddressInterface](docs/Model/CustomerDataAddressInterface.md)
 - [CustomerDataAttributeMetadataInterface](docs/Model/CustomerDataAttributeMetadataInterface.md)
 - [CustomerDataCustomerExtensionInterface](docs/Model/CustomerDataCustomerExtensionInterface.md)
 - [CustomerDataCustomerInterface](docs/Model/CustomerDataCustomerInterface.md)
 - [CustomerDataCustomerSearchResultsInterface](docs/Model/CustomerDataCustomerSearchResultsInterface.md)
 - [CustomerDataGroupExtensionInterface](docs/Model/CustomerDataGroupExtensionInterface.md)
 - [CustomerDataGroupInterface](docs/Model/CustomerDataGroupInterface.md)
 - [CustomerDataGroupSearchResultsInterface](docs/Model/CustomerDataGroupSearchResultsInterface.md)
 - [CustomerDataOptionInterface](docs/Model/CustomerDataOptionInterface.md)
 - [CustomerDataRegionExtensionInterface](docs/Model/CustomerDataRegionExtensionInterface.md)
 - [CustomerDataRegionInterface](docs/Model/CustomerDataRegionInterface.md)
 - [CustomerDataValidationResultsInterface](docs/Model/CustomerDataValidationResultsInterface.md)
 - [CustomerDataValidationRuleInterface](docs/Model/CustomerDataValidationRuleInterface.md)
 - [DirectoryDataCountryInformationExtensionInterface](docs/Model/DirectoryDataCountryInformationExtensionInterface.md)
 - [DirectoryDataCountryInformationInterface](docs/Model/DirectoryDataCountryInformationInterface.md)
 - [DirectoryDataCurrencyInformationExtensionInterface](docs/Model/DirectoryDataCurrencyInformationExtensionInterface.md)
 - [DirectoryDataCurrencyInformationInterface](docs/Model/DirectoryDataCurrencyInformationInterface.md)
 - [DirectoryDataExchangeRateExtensionInterface](docs/Model/DirectoryDataExchangeRateExtensionInterface.md)
 - [DirectoryDataExchangeRateInterface](docs/Model/DirectoryDataExchangeRateInterface.md)
 - [DirectoryDataRegionInformationExtensionInterface](docs/Model/DirectoryDataRegionInformationExtensionInterface.md)
 - [DirectoryDataRegionInformationInterface](docs/Model/DirectoryDataRegionInformationInterface.md)
 - [DownloadableDataDownloadableOptionInterface](docs/Model/DownloadableDataDownloadableOptionInterface.md)
 - [DownloadableDataFileContentExtensionInterface](docs/Model/DownloadableDataFileContentExtensionInterface.md)
 - [DownloadableDataFileContentInterface](docs/Model/DownloadableDataFileContentInterface.md)
 - [DownloadableDataLinkExtensionInterface](docs/Model/DownloadableDataLinkExtensionInterface.md)
 - [DownloadableDataLinkInterface](docs/Model/DownloadableDataLinkInterface.md)
 - [DownloadableDataSampleExtensionInterface](docs/Model/DownloadableDataSampleExtensionInterface.md)
 - [DownloadableDataSampleInterface](docs/Model/DownloadableDataSampleInterface.md)
 - [EavDataAttributeFrontendLabelInterface](docs/Model/EavDataAttributeFrontendLabelInterface.md)
 - [EavDataAttributeGroupExtensionInterface](docs/Model/EavDataAttributeGroupExtensionInterface.md)
 - [EavDataAttributeGroupInterface](docs/Model/EavDataAttributeGroupInterface.md)
 - [EavDataAttributeGroupSearchResultsInterface](docs/Model/EavDataAttributeGroupSearchResultsInterface.md)
 - [EavDataAttributeOptionInterface](docs/Model/EavDataAttributeOptionInterface.md)
 - [EavDataAttributeOptionLabelInterface](docs/Model/EavDataAttributeOptionLabelInterface.md)
 - [EavDataAttributeSetExtensionInterface](docs/Model/EavDataAttributeSetExtensionInterface.md)
 - [EavDataAttributeSetInterface](docs/Model/EavDataAttributeSetInterface.md)
 - [EavDataAttributeSetSearchResultsInterface](docs/Model/EavDataAttributeSetSearchResultsInterface.md)
 - [EavDataAttributeValidationRuleInterface](docs/Model/EavDataAttributeValidationRuleInterface.md)
 - [ErrorErrors](docs/Model/ErrorErrors.md)
 - [ErrorErrorsItem](docs/Model/ErrorErrorsItem.md)
 - [ErrorParameters](docs/Model/ErrorParameters.md)
 - [ErrorParametersItem](docs/Model/ErrorParametersItem.md)
 - [ErrorResponse](docs/Model/ErrorResponse.md)
 - [FrameworkAttributeInterface](docs/Model/FrameworkAttributeInterface.md)
 - [FrameworkCriteriaInterface](docs/Model/FrameworkCriteriaInterface.md)
 - [FrameworkDataImageContentInterface](docs/Model/FrameworkDataImageContentInterface.md)
 - [FrameworkDataVideoContentInterface](docs/Model/FrameworkDataVideoContentInterface.md)
 - [FrameworkFilter](docs/Model/FrameworkFilter.md)
 - [FrameworkMetadataObjectInterface](docs/Model/FrameworkMetadataObjectInterface.md)
 - [FrameworkSearchAggregationInterface](docs/Model/FrameworkSearchAggregationInterface.md)
 - [FrameworkSearchAggregationValueInterface](docs/Model/FrameworkSearchAggregationValueInterface.md)
 - [FrameworkSearchBucketInterface](docs/Model/FrameworkSearchBucketInterface.md)
 - [FrameworkSearchCriteriaInterface](docs/Model/FrameworkSearchCriteriaInterface.md)
 - [FrameworkSearchDocumentInterface](docs/Model/FrameworkSearchDocumentInterface.md)
 - [FrameworkSearchFilterGroup](docs/Model/FrameworkSearchFilterGroup.md)
 - [FrameworkSearchSearchCriteriaInterface](docs/Model/FrameworkSearchSearchCriteriaInterface.md)
 - [FrameworkSearchSearchResultInterface](docs/Model/FrameworkSearchSearchResultInterface.md)
 - [FrameworkSortOrder](docs/Model/FrameworkSortOrder.md)
 - [GiftCardAccountDataGiftCardAccountExtensionInterface](docs/Model/GiftCardAccountDataGiftCardAccountExtensionInterface.md)
 - [GiftCardAccountDataGiftCardAccountInterface](docs/Model/GiftCardAccountDataGiftCardAccountInterface.md)
 - [GiftCardDataGiftCardOptionExtensionInterface](docs/Model/GiftCardDataGiftCardOptionExtensionInterface.md)
 - [GiftCardDataGiftCardOptionInterface](docs/Model/GiftCardDataGiftCardOptionInterface.md)
 - [GiftCardDataGiftcardAmountExtensionInterface](docs/Model/GiftCardDataGiftcardAmountExtensionInterface.md)
 - [GiftCardDataGiftcardAmountInterface](docs/Model/GiftCardDataGiftcardAmountInterface.md)
 - [GiftMessageDataMessageExtensionInterface](docs/Model/GiftMessageDataMessageExtensionInterface.md)
 - [GiftMessageDataMessageInterface](docs/Model/GiftMessageDataMessageInterface.md)
 - [GiftWrappingDataWrappingExtensionInterface](docs/Model/GiftWrappingDataWrappingExtensionInterface.md)
 - [GiftWrappingDataWrappingInterface](docs/Model/GiftWrappingDataWrappingInterface.md)
 - [GiftWrappingDataWrappingSearchResultsInterface](docs/Model/GiftWrappingDataWrappingSearchResultsInterface.md)
 - [QuoteDataAddressExtensionInterface](docs/Model/QuoteDataAddressExtensionInterface.md)
 - [QuoteDataAddressInterface](docs/Model/QuoteDataAddressInterface.md)
 - [QuoteDataCartExtensionInterface](docs/Model/QuoteDataCartExtensionInterface.md)
 - [QuoteDataCartInterface](docs/Model/QuoteDataCartInterface.md)
 - [QuoteDataCartItemExtensionInterface](docs/Model/QuoteDataCartItemExtensionInterface.md)
 - [QuoteDataCartItemInterface](docs/Model/QuoteDataCartItemInterface.md)
 - [QuoteDataCartSearchResultsInterface](docs/Model/QuoteDataCartSearchResultsInterface.md)
 - [QuoteDataCurrencyExtensionInterface](docs/Model/QuoteDataCurrencyExtensionInterface.md)
 - [QuoteDataCurrencyInterface](docs/Model/QuoteDataCurrencyInterface.md)
 - [QuoteDataPaymentExtensionInterface](docs/Model/QuoteDataPaymentExtensionInterface.md)
 - [QuoteDataPaymentInterface](docs/Model/QuoteDataPaymentInterface.md)
 - [QuoteDataPaymentMethodInterface](docs/Model/QuoteDataPaymentMethodInterface.md)
 - [QuoteDataProductOptionExtensionInterface](docs/Model/QuoteDataProductOptionExtensionInterface.md)
 - [QuoteDataProductOptionInterface](docs/Model/QuoteDataProductOptionInterface.md)
 - [QuoteDataShippingMethodExtensionInterface](docs/Model/QuoteDataShippingMethodExtensionInterface.md)
 - [QuoteDataShippingMethodInterface](docs/Model/QuoteDataShippingMethodInterface.md)
 - [QuoteDataTotalSegmentExtensionInterface](docs/Model/QuoteDataTotalSegmentExtensionInterface.md)
 - [QuoteDataTotalSegmentInterface](docs/Model/QuoteDataTotalSegmentInterface.md)
 - [QuoteDataTotalsAdditionalDataExtensionInterface](docs/Model/QuoteDataTotalsAdditionalDataExtensionInterface.md)
 - [QuoteDataTotalsAdditionalDataInterface](docs/Model/QuoteDataTotalsAdditionalDataInterface.md)
 - [QuoteDataTotalsExtensionInterface](docs/Model/QuoteDataTotalsExtensionInterface.md)
 - [QuoteDataTotalsInterface](docs/Model/QuoteDataTotalsInterface.md)
 - [QuoteDataTotalsItemExtensionInterface](docs/Model/QuoteDataTotalsItemExtensionInterface.md)
 - [QuoteDataTotalsItemInterface](docs/Model/QuoteDataTotalsItemInterface.md)
 - [RmaDataCommentExtensionInterface](docs/Model/RmaDataCommentExtensionInterface.md)
 - [RmaDataCommentInterface](docs/Model/RmaDataCommentInterface.md)
 - [RmaDataCommentSearchResultInterface](docs/Model/RmaDataCommentSearchResultInterface.md)
 - [RmaDataItemExtensionInterface](docs/Model/RmaDataItemExtensionInterface.md)
 - [RmaDataItemInterface](docs/Model/RmaDataItemInterface.md)
 - [RmaDataRmaExtensionInterface](docs/Model/RmaDataRmaExtensionInterface.md)
 - [RmaDataRmaInterface](docs/Model/RmaDataRmaInterface.md)
 - [RmaDataRmaSearchResultInterface](docs/Model/RmaDataRmaSearchResultInterface.md)
 - [RmaDataTrackExtensionInterface](docs/Model/RmaDataTrackExtensionInterface.md)
 - [RmaDataTrackInterface](docs/Model/RmaDataTrackInterface.md)
 - [RmaDataTrackSearchResultInterface](docs/Model/RmaDataTrackSearchResultInterface.md)
 - [SalesDataCreditmemoCommentCreationExtensionInterface](docs/Model/SalesDataCreditmemoCommentCreationExtensionInterface.md)
 - [SalesDataCreditmemoCommentCreationInterface](docs/Model/SalesDataCreditmemoCommentCreationInterface.md)
 - [SalesDataCreditmemoCommentExtensionInterface](docs/Model/SalesDataCreditmemoCommentExtensionInterface.md)
 - [SalesDataCreditmemoCommentInterface](docs/Model/SalesDataCreditmemoCommentInterface.md)
 - [SalesDataCreditmemoCommentSearchResultInterface](docs/Model/SalesDataCreditmemoCommentSearchResultInterface.md)
 - [SalesDataCreditmemoCreationArgumentsExtensionInterface](docs/Model/SalesDataCreditmemoCreationArgumentsExtensionInterface.md)
 - [SalesDataCreditmemoCreationArgumentsInterface](docs/Model/SalesDataCreditmemoCreationArgumentsInterface.md)
 - [SalesDataCreditmemoExtensionInterface](docs/Model/SalesDataCreditmemoExtensionInterface.md)
 - [SalesDataCreditmemoInterface](docs/Model/SalesDataCreditmemoInterface.md)
 - [SalesDataCreditmemoItemCreationExtensionInterface](docs/Model/SalesDataCreditmemoItemCreationExtensionInterface.md)
 - [SalesDataCreditmemoItemCreationInterface](docs/Model/SalesDataCreditmemoItemCreationInterface.md)
 - [SalesDataCreditmemoItemExtensionInterface](docs/Model/SalesDataCreditmemoItemExtensionInterface.md)
 - [SalesDataCreditmemoItemInterface](docs/Model/SalesDataCreditmemoItemInterface.md)
 - [SalesDataCreditmemoSearchResultInterface](docs/Model/SalesDataCreditmemoSearchResultInterface.md)
 - [SalesDataInvoiceCommentCreationExtensionInterface](docs/Model/SalesDataInvoiceCommentCreationExtensionInterface.md)
 - [SalesDataInvoiceCommentCreationInterface](docs/Model/SalesDataInvoiceCommentCreationInterface.md)
 - [SalesDataInvoiceCommentExtensionInterface](docs/Model/SalesDataInvoiceCommentExtensionInterface.md)
 - [SalesDataInvoiceCommentInterface](docs/Model/SalesDataInvoiceCommentInterface.md)
 - [SalesDataInvoiceCommentSearchResultInterface](docs/Model/SalesDataInvoiceCommentSearchResultInterface.md)
 - [SalesDataInvoiceCreationArgumentsExtensionInterface](docs/Model/SalesDataInvoiceCreationArgumentsExtensionInterface.md)
 - [SalesDataInvoiceCreationArgumentsInterface](docs/Model/SalesDataInvoiceCreationArgumentsInterface.md)
 - [SalesDataInvoiceExtensionInterface](docs/Model/SalesDataInvoiceExtensionInterface.md)
 - [SalesDataInvoiceInterface](docs/Model/SalesDataInvoiceInterface.md)
 - [SalesDataInvoiceItemCreationExtensionInterface](docs/Model/SalesDataInvoiceItemCreationExtensionInterface.md)
 - [SalesDataInvoiceItemCreationInterface](docs/Model/SalesDataInvoiceItemCreationInterface.md)
 - [SalesDataInvoiceItemExtensionInterface](docs/Model/SalesDataInvoiceItemExtensionInterface.md)
 - [SalesDataInvoiceItemInterface](docs/Model/SalesDataInvoiceItemInterface.md)
 - [SalesDataInvoiceSearchResultInterface](docs/Model/SalesDataInvoiceSearchResultInterface.md)
 - [SalesDataOrderAddressExtensionInterface](docs/Model/SalesDataOrderAddressExtensionInterface.md)
 - [SalesDataOrderAddressInterface](docs/Model/SalesDataOrderAddressInterface.md)
 - [SalesDataOrderExtensionInterface](docs/Model/SalesDataOrderExtensionInterface.md)
 - [SalesDataOrderInterface](docs/Model/SalesDataOrderInterface.md)
 - [SalesDataOrderItemExtensionInterface](docs/Model/SalesDataOrderItemExtensionInterface.md)
 - [SalesDataOrderItemInterface](docs/Model/SalesDataOrderItemInterface.md)
 - [SalesDataOrderItemSearchResultInterface](docs/Model/SalesDataOrderItemSearchResultInterface.md)
 - [SalesDataOrderPaymentExtensionInterface](docs/Model/SalesDataOrderPaymentExtensionInterface.md)
 - [SalesDataOrderPaymentInterface](docs/Model/SalesDataOrderPaymentInterface.md)
 - [SalesDataOrderSearchResultInterface](docs/Model/SalesDataOrderSearchResultInterface.md)
 - [SalesDataOrderStatusHistoryExtensionInterface](docs/Model/SalesDataOrderStatusHistoryExtensionInterface.md)
 - [SalesDataOrderStatusHistoryInterface](docs/Model/SalesDataOrderStatusHistoryInterface.md)
 - [SalesDataOrderStatusHistorySearchResultInterface](docs/Model/SalesDataOrderStatusHistorySearchResultInterface.md)
 - [SalesDataShipmentCommentCreationExtensionInterface](docs/Model/SalesDataShipmentCommentCreationExtensionInterface.md)
 - [SalesDataShipmentCommentCreationInterface](docs/Model/SalesDataShipmentCommentCreationInterface.md)
 - [SalesDataShipmentCommentExtensionInterface](docs/Model/SalesDataShipmentCommentExtensionInterface.md)
 - [SalesDataShipmentCommentInterface](docs/Model/SalesDataShipmentCommentInterface.md)
 - [SalesDataShipmentCommentSearchResultInterface](docs/Model/SalesDataShipmentCommentSearchResultInterface.md)
 - [SalesDataShipmentCreationArgumentsExtensionInterface](docs/Model/SalesDataShipmentCreationArgumentsExtensionInterface.md)
 - [SalesDataShipmentCreationArgumentsInterface](docs/Model/SalesDataShipmentCreationArgumentsInterface.md)
 - [SalesDataShipmentExtensionInterface](docs/Model/SalesDataShipmentExtensionInterface.md)
 - [SalesDataShipmentInterface](docs/Model/SalesDataShipmentInterface.md)
 - [SalesDataShipmentItemCreationExtensionInterface](docs/Model/SalesDataShipmentItemCreationExtensionInterface.md)
 - [SalesDataShipmentItemCreationInterface](docs/Model/SalesDataShipmentItemCreationInterface.md)
 - [SalesDataShipmentItemExtensionInterface](docs/Model/SalesDataShipmentItemExtensionInterface.md)
 - [SalesDataShipmentItemInterface](docs/Model/SalesDataShipmentItemInterface.md)
 - [SalesDataShipmentPackageCreationExtensionInterface](docs/Model/SalesDataShipmentPackageCreationExtensionInterface.md)
 - [SalesDataShipmentPackageCreationInterface](docs/Model/SalesDataShipmentPackageCreationInterface.md)
 - [SalesDataShipmentPackageExtensionInterface](docs/Model/SalesDataShipmentPackageExtensionInterface.md)
 - [SalesDataShipmentPackageInterface](docs/Model/SalesDataShipmentPackageInterface.md)
 - [SalesDataShipmentSearchResultInterface](docs/Model/SalesDataShipmentSearchResultInterface.md)
 - [SalesDataShipmentTrackCreationExtensionInterface](docs/Model/SalesDataShipmentTrackCreationExtensionInterface.md)
 - [SalesDataShipmentTrackCreationInterface](docs/Model/SalesDataShipmentTrackCreationInterface.md)
 - [SalesDataShipmentTrackExtensionInterface](docs/Model/SalesDataShipmentTrackExtensionInterface.md)
 - [SalesDataShipmentTrackInterface](docs/Model/SalesDataShipmentTrackInterface.md)
 - [SalesDataShippingAssignmentExtensionInterface](docs/Model/SalesDataShippingAssignmentExtensionInterface.md)
 - [SalesDataShippingAssignmentInterface](docs/Model/SalesDataShippingAssignmentInterface.md)
 - [SalesDataShippingExtensionInterface](docs/Model/SalesDataShippingExtensionInterface.md)
 - [SalesDataShippingInterface](docs/Model/SalesDataShippingInterface.md)
 - [SalesDataTotalExtensionInterface](docs/Model/SalesDataTotalExtensionInterface.md)
 - [SalesDataTotalInterface](docs/Model/SalesDataTotalInterface.md)
 - [SalesDataTransactionExtensionInterface](docs/Model/SalesDataTransactionExtensionInterface.md)
 - [SalesDataTransactionInterface](docs/Model/SalesDataTransactionInterface.md)
 - [SalesDataTransactionSearchResultInterface](docs/Model/SalesDataTransactionSearchResultInterface.md)
 - [SalesRuleDataConditionExtensionInterface](docs/Model/SalesRuleDataConditionExtensionInterface.md)
 - [SalesRuleDataConditionInterface](docs/Model/SalesRuleDataConditionInterface.md)
 - [SalesRuleDataCouponExtensionInterface](docs/Model/SalesRuleDataCouponExtensionInterface.md)
 - [SalesRuleDataCouponGenerationSpecExtensionInterface](docs/Model/SalesRuleDataCouponGenerationSpecExtensionInterface.md)
 - [SalesRuleDataCouponGenerationSpecInterface](docs/Model/SalesRuleDataCouponGenerationSpecInterface.md)
 - [SalesRuleDataCouponInterface](docs/Model/SalesRuleDataCouponInterface.md)
 - [SalesRuleDataCouponMassDeleteResultInterface](docs/Model/SalesRuleDataCouponMassDeleteResultInterface.md)
 - [SalesRuleDataCouponSearchResultInterface](docs/Model/SalesRuleDataCouponSearchResultInterface.md)
 - [SalesRuleDataRuleExtensionInterface](docs/Model/SalesRuleDataRuleExtensionInterface.md)
 - [SalesRuleDataRuleInterface](docs/Model/SalesRuleDataRuleInterface.md)
 - [SalesRuleDataRuleLabelExtensionInterface](docs/Model/SalesRuleDataRuleLabelExtensionInterface.md)
 - [SalesRuleDataRuleLabelInterface](docs/Model/SalesRuleDataRuleLabelInterface.md)
 - [SalesRuleDataRuleSearchResultInterface](docs/Model/SalesRuleDataRuleSearchResultInterface.md)
 - [StoreDataGroupExtensionInterface](docs/Model/StoreDataGroupExtensionInterface.md)
 - [StoreDataGroupInterface](docs/Model/StoreDataGroupInterface.md)
 - [StoreDataStoreConfigExtensionInterface](docs/Model/StoreDataStoreConfigExtensionInterface.md)
 - [StoreDataStoreConfigInterface](docs/Model/StoreDataStoreConfigInterface.md)
 - [StoreDataStoreExtensionInterface](docs/Model/StoreDataStoreExtensionInterface.md)
 - [StoreDataStoreInterface](docs/Model/StoreDataStoreInterface.md)
 - [StoreDataWebsiteExtensionInterface](docs/Model/StoreDataWebsiteExtensionInterface.md)
 - [StoreDataWebsiteInterface](docs/Model/StoreDataWebsiteInterface.md)
 - [TaxDataGrandTotalDetailsInterface](docs/Model/TaxDataGrandTotalDetailsInterface.md)
 - [TaxDataGrandTotalRatesInterface](docs/Model/TaxDataGrandTotalRatesInterface.md)
 - [TaxDataOrderTaxDetailsAppliedTaxExtensionInterface](docs/Model/TaxDataOrderTaxDetailsAppliedTaxExtensionInterface.md)
 - [TaxDataOrderTaxDetailsAppliedTaxInterface](docs/Model/TaxDataOrderTaxDetailsAppliedTaxInterface.md)
 - [TaxDataOrderTaxDetailsItemExtensionInterface](docs/Model/TaxDataOrderTaxDetailsItemExtensionInterface.md)
 - [TaxDataOrderTaxDetailsItemInterface](docs/Model/TaxDataOrderTaxDetailsItemInterface.md)
 - [TaxDataTaxClassExtensionInterface](docs/Model/TaxDataTaxClassExtensionInterface.md)
 - [TaxDataTaxClassInterface](docs/Model/TaxDataTaxClassInterface.md)
 - [TaxDataTaxClassSearchResultsInterface](docs/Model/TaxDataTaxClassSearchResultsInterface.md)
 - [TaxDataTaxRateExtensionInterface](docs/Model/TaxDataTaxRateExtensionInterface.md)
 - [TaxDataTaxRateInterface](docs/Model/TaxDataTaxRateInterface.md)
 - [TaxDataTaxRateSearchResultsInterface](docs/Model/TaxDataTaxRateSearchResultsInterface.md)
 - [TaxDataTaxRateTitleExtensionInterface](docs/Model/TaxDataTaxRateTitleExtensionInterface.md)
 - [TaxDataTaxRateTitleInterface](docs/Model/TaxDataTaxRateTitleInterface.md)
 - [TaxDataTaxRuleExtensionInterface](docs/Model/TaxDataTaxRuleExtensionInterface.md)
 - [TaxDataTaxRuleInterface](docs/Model/TaxDataTaxRuleInterface.md)
 - [TaxDataTaxRuleSearchResultsInterface](docs/Model/TaxDataTaxRuleSearchResultsInterface.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author




