<?php
/* Copyright (C) 2020 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!class_exists('SeedObject'))
{
	/**
	 * Needed if $form->showLinkedObjectBlock() is call or for session timeout on our module page
	 */
	define('INC_FROM_DOLIBARR', true);
	require_once dirname(__FILE__).'/../config.php';
}

class doliFleetVehiculeRentalMatrix extends SeedObject
{
	/** @var string $table_element Table name in SQL */
	public $table_element = 'dolifleet_vehicule_rental_matrix';

	/** @var string $element Name of the element (tip for better integration in Dolibarr: this value should be the reflection of the class name with ucfirst() function) */
	public $element = 'dolifleet_vehicule_rental_matrix';

	public $fk_soc;

	public $fk_c_type_vh;

	public $fk_c_mark_vh;

	public $delay;

	public $amount_ht;

	public $fields = array(
		'fk_soc' => array(
			'type' => 'integer',
			'enabled' => 1,
			'visible' => 0,
			'notnull' =>1,
			'default' => 0,
			'position' => 10,
			'index' => 1,
		),

		'fk_c_type_vh' => array(
			'type' => 'sellist:c_dolifleet_vehicule_type:label:rowid::active=1',
			'label' => 'vehiculeType',
			'visible' => 1,
			'enabled' => 1,
			'position' => 20,
			'index' => 1,
		),

		'fk_c_mark_vh' => array(
			'type' => 'sellist:c_dolifleet_vehicule_mark:label:rowid::active=1',
			'label' => 'vehiculeMark',
			'visible' => 1,
			'enabled' => 1,
			'position' => 30,
			'index' => 1,
		),

		'delay' => array(
			'type' => 'integer',
			'label' => 'vehiculeDelayExploit',
			'visible' => 1,
			'enabled' => 1,
			'position' => 40,
			'index' => 1,
		),

		'amount_ht' => array(
			'type' => 'double',
			'label' => 'totalHT',
			'enabled' => 1,
			'visible' => 1,
			'position' => 50
		),

	);

	public function __construct($db)
	{
		parent::__construct($db);

		$this->init();
	}

	public function create(User &$user, $notrigger = false)
	{
		global $langs;

		// check parameters
		if (empty($this->fk_c_type_vh) || $this->fk_c_type_vh == -1) $this->errors[] = $langs->trans('ErrInvalidType');
		if (empty($this->fk_c_mark_vh) || $this->fk_c_mark_vh == -1) $this->errors[] = $langs->trans('ErrInvalidMark');
		if (empty($this->delay)) $this->errors[] = $langs->trans('ErrNoDelayForLine');
		if (empty($this->amount_ht)) $this->errors[] = $langs->trans('ErrInvalidAmount');

		if (empty($this->id))
		{
			$sql = "SELECT COUNT(rowid) as nb FROM ".MAIN_DB_PREFIX.$this->table_element;
			$sql.= " WHERE fk_soc = " . $this->fk_soc;
			$sql.= " AND fk_c_type_vh = ".$this->fk_c_type_vh;
			$sql.= " AND fk_c_mark_vh = ".$this->fk_c_mark_vh;
			$sql.= " AND delay = ".$this->delay;
			$resql = $this->db->query($sql);
			if ($resql)
			{
				$obj = $this->db->fetch_object($resql);
				if ($obj->nb > 0) $this->errors[] = $langs->trans('ErrDuplicateMatrix');
			}
		}


		if (!empty($this->errors)) return -1;

		return parent::create($user, $notrigger); // TODO: Change the autogenerated stub
	}


}
