<?php 
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';

// dol_include_once('/dolibarrmobile/class/dolimoblivraisons.class.php');
dol_include_once('/expedition/class/expedition.class.php');
dol_include_once('/commande/class/commande.class.php');
dol_include_once('/livraison/class/livraison.class.php');
dol_include_once('/core/class/html.form.class.php');

class dolimobexpeditions extends Commonobject{ 
	public $errors = array();

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}


	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."expedition";
		
		global $conf;
		if (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) && (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) > 0)){
			$filter .= " AND entity = ".dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0);
		}else{
			$filter .= " AND entity =  ".$conf->entity;
		}
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		// echo $sql;
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->entity 	= $obj->entity;
				$line->ref 	= $obj->ref;
				$line->fk_soc 	= $obj->fk_soc;
				$line->date_creation 	= $obj->date_creation;
				$line->date_delivery 	= $obj->date_delivery;
				$line->fk_statut 	= $obj->fk_statut;
				$this->rows[] 	= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}


	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'expedition WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$this->id 	= $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->entity 	= $obj->entity;
				$this->ref 	= $obj->ref;
				$this->fk_soc 	= $obj->fk_soc;
				$this->date_creation 	= $obj->date_creation;
				$this->date_delivery 	= $obj->date_delivery;
				$this->fk_statut 	= $obj->fk_statut;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

}  
class dolimoblivraisons extends Commonobject{ 
	public $errors = array();

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}
	
	

	public function listelements($userapi)
	{
		global $langs;
		$langs->loadLangs(array('orders','bills','deliveries'));
		
		// $livraisons      	= new livraisons($this->db);
		$expeditionsorig 	= new Expedition($this->db);
		$commandesorig   	= new Commande($this->db);

		$form           	= new Form($this->db);

		
		$result = [];
		$result['otherparams'][0]['permissiondata'] = 0;
		// print_r($result);die();
		if($userapi->rights->expedition->livraison->lire || $userapi->admin){
			$filter = "";
			if ($userapi->societe_id) {
			  $filter .= " AND fk_soc = '".$userapi->societe_id."'";
			}
			$sortorder = "DESC";
			$sortfield = "rowid";

			$nbrtotal = $this->fetchAll($sortorder, $sortfield, 0, 0, $filter);


			$result['otherparams'][0]['countdata'] = count($this->rows);
			$result['otherparams'][0]['permissiondata'] = 1;

			if (count($this->rows) > 0) {
				global $dolibarr_main_data_root;
				$documenturl = DOL_MAIN_URL_ROOT.'/document.php';
				$form->load_cache_types_paiements();
				$form->load_cache_conditions_paiements();
				
				for ($i=0; $i < count($this->rows) ; $i++) {
				    $item = $this->rows[$i];

				    $livraisonsorig  = new Livraison($this->db);
				    $livraisonsorig->fetch($item->rowid);

				    $result['Livraisons'][$i]['id'] = $item->rowid;
					$result['Livraisons'][$i]['ref'] = $item->ref;

					$result['Livraisons'][$i]['date'] = dol_print_date($livraisonsorig->date_delivery,'daytextshort');
					$result['Livraisons'][$i]['etat'] = html_entity_decode($livraisonsorig->getLibStatut(1), 0, 'UTF-8');
					
					$expeditionsorig->fetch($livraisonsorig->origin_id);
		            $commandesorig->fetch($expeditionsorig->origin_id);

					$result['Livraisons'][$i]['ref_commande'] = $commandesorig->ref;
					$result['Livraisons'][$i]['ref_expedition'] = $expeditionsorig->ref;

					$result['Livraisons'][$i]['ref_customer'] = $expeditionsorig->ref_customer;


					$otherdetails = [];
					$otherdetails['ref_customer'] = $expeditionsorig->ref_customer; // ref client

					$result['Livraisons'][$i]['otherdetails'] = json_encode($otherdetails);

			  }
			}
		}


		return $result;
	}


	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."livraison";
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		// echo $sql;
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->ref 	= $obj->ref;
				$line->fk_soc 	= $obj->fk_soc;
				$line->entity 	= $obj->entity;
				$line->date_creation 	= $obj->date_creation;
				$line->date_delivery 	= $obj->date_delivery;
				$line->fk_statut 	= $obj->fk_statut;
				$this->rows[] 	= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'livraison WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$this->id 	= $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->ref 	= $obj->ref;
				$this->fk_soc 	= $obj->fk_soc;
				$this->entity 	= $obj->entity;
				$this->date_creation 	= $obj->date_creation;
				$this->date_delivery 	= $obj->date_delivery;
				$this->fk_statut 	= $obj->fk_statut;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

}  
class expeditionsdet extends Commonobject{ 
	public $errors = array();

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}
	

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."expeditiondet";
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		// echo $sql;
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->fk_expedition 	= $obj->fk_expedition;
				$line->fk_origin_line 	= $obj->fk_origin_line;
				$line->fk_entrepot 	= $obj->fk_entrepot;
				$line->qty 	= $obj->qty;
				$this->rows[] 	= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'expeditiondet WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$this->id 	= $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->fk_expedition 	= $obj->fk_expedition;
				$this->fk_origin_line 	= $obj->fk_origin_line;
				$this->fk_entrepot 	= $obj->fk_entrepot;
				$this->qty 	= $obj->qty;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

} 

?>