<?php 
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';

class dolimobinterventions extends Commonobject{ 
	public $errors = array();

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}
	
	

	public function listelements($userapi)
	{
		global $langs;
		$langs->loadLangs(array('orders','bills','deliveries'));
		

		dol_include_once('/core/class/html.form.class.php');

		require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
		require_once DOL_DOCUMENT_ROOT.'/fichinter/class/fichinter.class.php';
		dol_include_once('/dolibarrmobile/class/dolimobinterventions.class.php');

		$interventions 		= new dolimobinterventions($this->db);
		$interventionsorig 	= new Fichinter($this->db);

		$form           	= new Form($this->db);

	
		$result = [];
		$result['otherparams'][0]['permissiondata'] = 0;


		if($userapi->rights->ficheinter->lire || $userapi->admin){
			$filter = "";
			if ($userapi->societe_id) {
			  $filter .= " AND fk_soc = '".$userapi->societe_id."'";
			}
			$sortorder = "DESC";
			$sortfield = "rowid";

			$nbrtotal = $interventions->fetchAll($sortorder, $sortfield, 0, 0, $filter);

			$result['otherparams'][0]['countdata'] = count($interventions->rows);
			$result['otherparams'][0]['permissiondata'] = 1;

			if (count($interventions->rows) > 0) {
				global $dolibarr_main_data_root;
				$documenturl = DOL_MAIN_URL_ROOT.'/document.php';
				$form->load_cache_types_paiements();
				$form->load_cache_conditions_paiements();
				
				// for ($i=0; $i < 87 ; $i++) {
				for ($i=0; $i < count($interventions->rows) ; $i++) {
				    $item = $interventions->rows[$i];

				    $interventionsorig  = new Fichinter($this->db);
				    $interventionsorig->fetch($item->rowid);

				    $result['Interventions'][$i]['id'] = $item->rowid;
					$result['Interventions'][$i]['ref'] = $item->ref;
					$result['Interventions'][$i]['date'] = "-*-";
					$result['Interventions'][$i]['etat'] = html_entity_decode($interventionsorig->getLibStatut(1), 0, 'UTF-8');
					
					$result['Interventions'][$i]['description'] = "-";
					if(!empty($item->description)){
						$desc = substr($item->description,0,32);
						// $descs = trim(addslashes(preg_replace('/\s\s+/', ' ', $desc)));
						$descs = preg_replace("/[^a-zA-Z0-9\s]/", "", $desc);
						$result['Interventions'][$i]['description'] = $descs."...";
					}

					$result['Interventions'][$i]['interduration'] = html_entity_decode(convertSecondToTime($item->duree), 0, 'UTF-8');


					$result['Interventions'][$i]['ref_customer'] = "--";

					$otherdetails = [];
					$otherdetails['ref_customer'] = "--"; // ref client
					$otherdetails['descriptioncomplet'] = "-";
					if(!empty($item->description))
						$otherdetails['descriptioncomplet'] = $item->description;

					$result['Interventions'][$i]['otherdetails'] = json_encode($otherdetails);
			  }
			}
		}

		return $result;
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX ."fichinter";
		
		global $conf;
		if (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) && (dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0) > 0)){
			$filter .= " AND entity = ".dolibarr_get_const($this->db,'DOLIBARRMOBILE_FIX_ENTITY',0);
		}else{
			$filter .= " AND entity =  ".$conf->entity;
		}
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		// echo $sql;
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->fk_soc 	= $obj->fk_soc;
				$line->fk_contrat 	= $obj->fk_contrat;
				$line->ref 	= $obj->ref;
				$line->fk_statut 	= $obj->fk_statut;
				$line->duree 	= $obj->duree;
				$line->description 	= $obj->description;
				$this->rows[] 	= $line;
			}
			
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}













































	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'fichinter WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);
				$this->id 	= $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->fk_soc 	= $obj->fk_soc;
				$this->fk_contrat 	= $obj->fk_contrat;
				$this->ref 	= $obj->ref;
				$this->fk_statut 	= $obj->fk_statut;
				$this->duree 	= $obj->duree;
				$this->description 	= $obj->description;
				
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

} 

?>