<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

// dol_include_once('/ged_files/class/ged_files.class.php');
 
class ged_files extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $label;

	public $element='ged_files';
	public $table_element='ged_files';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ""){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 

		// return $this->db->db->insert_id;

		$lastinid = $this->db->last_insert_id(MAIN_DB_PREFIX.'ged_files');
		return $lastinid;
	}

	public function update($id, array $data,$echo_sql=0)
	{	
		global $conf;

		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;

       	// echo "<br> sql : ".$sql."<br>";
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 


        // Actions on extra fields
		if ($resql && empty($conf->global->MAIN_EXTRAFIELDS_DISABLED)) // For avoid conflicts if trigger used
		{
			$result=$this->insertExtraFields();
			if ($result < 0)
			{
				$error++;
			}
		}


		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		global $conf;

		$extrafields = new ExtraFields($this->db);
		$object = $this;

		// fetch optionals attributes and labels
		$extralabels=$extrafields->fetch_name_optionals_label('ged_files');
		$search_array_options=$extrafields->getOptionalsFromPost('ged_files', '', 'search_');

		$sql = "SELECT ged.* ";

		// Add fields from extrafields
		foreach ($extrafields->attribute_label as $key => $val) $sql.=($extrafields->attribute_type[$key] != 'separate' ? ",ef.".$key.' as options_'.$key : '');
		$sql .= " FROM ";

		$sql .= MAIN_DB_PREFIX .get_class($this)." as ged ";

		if (is_array($extrafields->attribute_label) && count($extrafields->attribute_label)) $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."ged_files_extrafields as ef on (ged.rowid = ef.fk_object)";

		
		$sql .= " WHERE 1>0 ".$filter;
		
		// Add where from extra fields
		include DOL_DOCUMENT_ROOT.'/core/tpl/extrafields_list_search_sql.tpl.php';
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql;
		// die($sql);

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    		= $obj->rowid;
				$line->rowid 		= $obj->rowid;
				$line->label 		=  $obj->label;
				$line->fullpath 	=  $obj->fullpath;
				$line->fullname 	=  $obj->fullname;
				$line->fullnameorg 	=  $obj->fullnameorg;
				$line->date_c 		=  $obj->date_c;
				$line->date_m 		=  $obj->date_m;
				$line->user_c 		=  $obj->user_c;
				$line->user_m 		=  $obj->user_m;
				$line->confidential =  $obj->confidential;
				$line->showfor      =  $obj->showfor;
				$line->acl 	    	=  $obj->acl;
				$line->tags 	    =  $obj->tags;
				$line->categorie 	=  $obj->categorie;
				$line->description 	=  $obj->description;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			print_r($this->errors);
			die();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetch($id, $name = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 				= $this->db->fetch_object($resql);
                $this->id    		= $obj->rowid;
				$this->rowid 		= $obj->rowid;
				// $this->ref 			=  $obj->id;
				$this->label 		=  $obj->label;
				$this->fullpath 	=  $obj->fullpath;
				$this->fullname 	=  $obj->fullname;
				$this->fullnameorg 	=  $obj->fullnameorg;
				$this->date_c 		=  $obj->date_c;
				$this->date_m 		=  $obj->date_m;
				$this->user_c 		=  $obj->user_c;
				$this->user_m 		=  $obj->user_m;
				$this->confidential =  $obj->confidential;
				$this->showfor      =  $obj->showfor     ;
				$this->acl 	    	=  $obj->acl;
				$this->tags 	    =  $obj->tags;
				$this->categorie 	=  $obj->categorie;
				$this->description 	=  $obj->description;

				// fetch optionals attributes and labels
				$this->fetch_optionals();
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";

        if ($this->name) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/ged_files/img/object_ged_files.png" >&nbsp;';
            if ($withpicto != 2) $result.= $this->name;
        }

        $result .= $linkend;

        return $result;
    }








    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function load_motherof()
	{
        // phpcs:enable
		global $conf;

		$this->motherof=array();

		// Load array[child]=parent
		$sql = "SELECT fk_parent as id_parent, rowid as id_son";
		$sql.= " FROM ".MAIN_DB_PREFIX."ecm_directories";
		$sql.= " WHERE fk_parent != 0";
		$sql.= " AND entity = ".$conf->entity;

		dol_syslog(get_class($this)."::load_motherof", LOG_DEBUG);
		$resql = $this->db->query($sql);
		if ($resql)
		{
			// This assignment in condition is not a bug. It allows walking the results.
			while ($obj=$this->db->fetch_object($resql))
			{
				$this->motherof[$obj->id_son]=$obj->id_parent;
			}
			return 1;
		}
		else
		{
			dol_print_error($this->db);
			return -1;
		}
	}

	public function build_path_from_id_categ($id_categ, $protection = 0)
	{
        // phpcs:enable
		// Define fullpath
		if (! empty($this->cats[$id_categ]['id_mere']))
		{
			$this->cats[$id_categ]['fullpath'] =$this->cats[$this->cats[$id_categ]['id_mere']]['fullpath'];
			$this->cats[$id_categ]['fullpath'].='_'.$id_categ;
            $this->cats[$id_categ]['fullrelativename'] =$this->cats[$this->cats[$id_categ]['id_mere']]['fullrelativename'];
            $this->cats[$id_categ]['fullrelativename'].='/'.$this->cats[$id_categ]['label'];
			$this->cats[$id_categ]['fulllabel'] =$this->cats[$this->cats[$id_categ]['id_mere']]['fulllabel'];
			$this->cats[$id_categ]['fulllabel'].=' >> '.$this->cats[$id_categ]['label'];
		}
		else
		{
			$this->cats[$id_categ]['fullpath']='_'.$id_categ;
            $this->cats[$id_categ]['fullrelativename']=$this->cats[$id_categ]['label'];
			$this->cats[$id_categ]['fulllabel']=$this->cats[$id_categ]['label'];
		}
		// We count number of _ to have level (we use strlen that is faster than dol_strlen)
		$this->cats[$id_categ]['level']=strlen(preg_replace('/([^_])/i', '', $this->cats[$id_categ]['fullpath']));

		// Traite ces enfants
		$protection++;
		if ($protection > 20) return;	// On ne traite pas plus de 20 niveaux
		if (isset($this->cats[$id_categ]['id_children']) && is_array($this->cats[$id_categ]['id_children']))
		{
			foreach($this->cats[$id_categ]['id_children'] as $key => $val)
			{
				$this->build_path_from_id_categ($val, $protection);
			}
		}
	}

    public function get_dossiers()
    {
    	$sql = "SELECT c.rowid as rowid, c.label as label,";
    	$sql.= " c.description as description, c.cachenbofdoc,";
		$sql.= " c.fk_user_c,";
		$sql.= " c.date_c,";
		$sql.= " c.fk_parent,";
		$sql.= " u.login as login_c,";
		$sql.= " ca.rowid as rowid_fille";
		$sql.= " FROM ".MAIN_DB_PREFIX."user as u, ".MAIN_DB_PREFIX."ged_files as c";
		$sql.= " LEFT JOIN ".MAIN_DB_PREFIX."ged_files as ca";
		$sql.= " ON c.rowid = ca.fk_parent";
		$sql.= " WHERE c.fk_user_c = u.rowid ";
		$sql.= " ORDER BY c.label, c.rowid";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}

		$this->cats = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$this->cats[$obj->rowid]['id'] = $obj->rowid;
				$this->cats[$obj->rowid]['label'] = $obj->label;
				$this->cats[$obj->rowid]['fk_parent'] = $obj->fk_parent;
				$this->cats[$obj->rowid]['description'] = $obj->description;
				$this->cats[$obj->rowid]['cachenbofdoc'] = $obj->cachenbofdoc;
				$this->cats[$obj->rowid]['date_c'] = $this->db->jdate($obj->date_c);
				$this->cats[$obj->rowid]['fk_user_c'] = $obj->fk_user_c;
				// $this->cats[$obj->rowid]['login_c'] = $obj->login_c;

				if (! empty($obj->rowid_fille))
				{
					if (isset($this->cats[$obj->rowid]['id_children']) && is_array($this->cats[$obj->rowid]['id_children']))
					{
						$newelempos=count($this->cats[$obj->rowid]['id_children']);
						//print "this->cats[$i]['id_children'] est deja un tableau de $newelem elements<br>";
						$this->cats[$obj->rowid]['id_children'][$newelempos]=$obj->rowid_fille;
					}
					else
					{
						//print "this->cats[".$obj->rowid."]['id_children'] n'est pas encore un tableau<br>";
						$this->cats[$obj->rowid]['id_children']=array($obj->rowid_fille);
					}
				}
			}
		}
		else
		{
			dol_print_error($this->db);
			return -1;
		}

		// We add properties fullxxx to all elements
		foreach($this->cats as $key => $val)
		{
			if (isset($motherof[$key])) continue;
			$this->build_path_from_id_categ($key, 0);
		}

		$this->cats=dol_sort_array($this->cats, 'fulllabel', 'asc', true, false);
		$this->full_arbo_loaded=1;

		return $this->cats;
    }

    public function getAllMailTiers($selected=null){
	 	global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $name = "sendto";
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="selectalltiers" name="'.$name.'">';
	    // if ($showempty) 
    	$moreforfilter.='<option value="">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."societe";
    	$sql .= ' WHERE email != "" ';
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->email.'" data-email="'.$obj->email.'"';
	            if($obj->email == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->nom.' - '.$obj->email.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';

	    return $moreforfilter;
    }

    public function select_user($selected=[],$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'[]" multiple '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if(in_array($obj->rowid, $selected)) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function array_img($type="")
	{
		$array_img = [
			'pdf'	=> dol_buildpath('/documentsged/img/pdf.png',2),
			'doc'	=> dol_buildpath('/documentsged/img/doc.png',2),
			'docx'	=> dol_buildpath('/documentsged/img/doc.png',2),
			'ppt'	=> dol_buildpath('/documentsged/img/ppt.png',2),
			'pptx'	=> dol_buildpath('/documentsged/img/ppt.png',2),
			'xls'	=> dol_buildpath('/documentsged/img/xls.png',2),
			'xlsx'	=> dol_buildpath('/documentsged/img/xls.png',2),
			'txt'	=> dol_buildpath('/documentsged/img/txt.png',2),
			'sans'	=> dol_buildpath('/documentsged/img/sans.png',2),
		];

		if(!isset($array_img[$type]))
			$img =$array_img['sans'];
		elseif(empty($type)){
			$img =$array_img['sans'];
		}else{
			$img = $array_img[$type];
		}
		return $img;

	}

	public function fetch_thirdparty($force_thirdparty_id = 0)
	{
        
		return 1;
	}


	public function stripAccents($str) {
	    return strtr(utf8_decode($str), utf8_decode('àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ'), 'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
	}
} 


?>