<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';


dol_include_once('/documentsged/class/ged_files.class.php');


class ged_categories extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $labe;
	public $fk_parent;

	public $element='ged_categories';
	public $table_element='ged_categories';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			if($value != ''){
				$sql_column .= " , `".$column."`";
				$sql_value .= " , ".$alias.$value.$alias;
			}
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);
		// die($sql);
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		// return $this->db->db->insert_id;

		$lastinid = $this->db->last_insert_id(MAIN_DB_PREFIX.'ged_categories');
		return $lastinid;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : '"'. $val .'"';
                $val = ($val == '') ? 'NULL' : $val;
                $sql .= '`'. $key. '` = '. $val .',';
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    = $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->label 	=  $obj->label;
				$line->fk_parent 	=  $obj->fk_parent;
				$line->date_c 	=  $obj->date_c;
				$line->date_m 	=  $obj->date_m;
				$line->fk_user_c 	=  $obj->fk_user_c;
				$line->fk_user_m 	=  $obj->fk_user_m;
				$line->cachenbofdoc 	=  $obj->cachenbofdoc;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id, $name = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
                $this->id    = $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->label 	=  $obj->label;
				$this->fk_parent 	=  $obj->fk_parent;
				$this->date_c 	=  $obj->date_c;
				$this->date_m 	=  $obj->date_m;
				$this->fk_user_c 	=  $obj->fk_user_c;
				$this->fk_user_m 	=  $obj->fk_user_m;
				$this->cachenbofdoc 	=  $obj->cachenbofdoc;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

    function getNomUrl($withpicto=0, $option='', $get_params='', $notooltip=0, $save_lastsearch_value=-1)
    {
        global $langs, $conf, $user;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips

        $result='';
        $label='';
        $url='';

        // if ($user->rights->propal->lire){}

        $linkclose='';
        if (empty($notooltip))
        {
            $linkclose.= ' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip"';
        }
        $linkstart = "";
        $linkend = "";
        $result = "";

        if ($this->name) {
            $linkstart = '<a href="'.$url.'"';
            $linkstart.=$linkclose.'>';
            $linkend='</a>';

            $result .= $linkstart;
            if ($withpicto) 
                $result.= '<img height="16" src="'.DOL_URL_ROOT.'/ged_categories/img/object_ged_categories.png" >&nbsp;';
            if ($withpicto != 2) $result.= $this->name;
        }

        $result .= $linkend;

        return $result;
    }








    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut")
    {
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }


    public function getRelativePath($force = 0)
	{
		$this->get_dossiers();

		$ret='';
		$idtosearch=$this->id;
		$i=0;
		// print_r($this->cats);die();
		do {
			// Get index cursor in this->cats for id_mere
			$cursorindex=-1;
			foreach ($this->cats as $key => $val)
			{
				if ($this->cats[$key]['id'] == $idtosearch)
				{
					$cursorindex=$key;
					break;
				}
			}
			// print "c=".$idtosearch."-".$cursorindex;

			if ($cursorindex >= 0)
			{
				// Path is label sanitized (no space and no special char) and concatenated
				$ret=dol_sanitizeFileName($this->cats[$cursorindex]['label']).'/'.$ret;

				$idtosearch=$this->cats[$cursorindex]['id_mere'];
				$i++;
			}
			
		}
		while ($cursorindex >= 0 && ! empty($idtosearch) && $i < 100);	// i avoid infinite loop

		return $ret;
	}


    public function getmonth($year)
    {
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function load_motherof()
	{
        // phpcs:enable
		global $conf;

		$this->motherof=array();

		// Load array[child]=parent
		$sql = "SELECT fk_parent as id_parent, rowid as id_son";
		$sql.= " FROM ".MAIN_DB_PREFIX."ged_categories";
		$sql.= " WHERE fk_parent != 0";
		// $sql.= " AND entity = ".$conf->entity;

		dol_syslog(get_class($this)."::load_motherof", LOG_DEBUG);
		$resql = $this->db->query($sql);
		if ($resql)
		{
			// This assignment in condition is not a bug. It allows walking the results.
			while ($obj=$this->db->fetch_object($resql))
			{
				$this->motherof[$obj->id_son]=$obj->id_parent;
			}
			return 1;
		}
		else
		{
			dol_print_error($this->db);
			return -1;
		}
	}

	
    public function get_dossiers()
    {
    	if (empty($force) && ! empty($this->full_arbo_loaded))
		{
			return $this->cats;
		}

		// Init this->motherof that is array(id_son=>id_parent, ...)
		$this->load_motherof();

		// Charge tableau des categories
    	$sql = "SELECT c.rowid as rowid, c.label as label,";
    	$sql.= " c.description as description, c.cachenbofdoc,";
		$sql.= " c.fk_user_c,";
		$sql.= " c.date_c,";
		$sql.= " c.fk_parent,";
		$sql.= " u.login as login_c,";
		$sql.= " ca.rowid as rowid_fille";
		$sql.= " FROM ".MAIN_DB_PREFIX."user as u, ".MAIN_DB_PREFIX."ged_categories as c";
		$sql.= " LEFT JOIN ".MAIN_DB_PREFIX."ged_categories as ca";
		$sql.= " ON c.rowid = ca.fk_parent";
		$sql.= " WHERE c.fk_user_c = u.rowid ";
		$sql.= " ORDER BY c.label, c.rowid";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}

		$this->cats = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$this->cats[$obj->rowid]['id'] = $obj->rowid;
				$this->cats[$obj->rowid]['id_mere'] = (isset($this->motherof[$obj->rowid])?$this->motherof[$obj->rowid]:'');
				$this->cats[$obj->rowid]['label'] = $obj->label;
				$this->cats[$obj->rowid]['fk_parent'] = $obj->fk_parent;
				$this->cats[$obj->rowid]['description'] = $obj->description;
				$this->cats[$obj->rowid]['cachenbofdoc'] = $obj->cachenbofdoc;
				$this->cats[$obj->rowid]['date_c'] = $this->db->jdate($obj->date_c);
				$this->cats[$obj->rowid]['fk_user_c'] = $obj->fk_user_c;
				// $this->cats[$obj->rowid]['login_c'] = $obj->login_c;

				if (! empty($obj->rowid_fille))
				{
					if (isset($this->cats[$obj->rowid]['id_children']) && is_array($this->cats[$obj->rowid]['id_children']))
					{
						$newelempos=count($this->cats[$obj->rowid]['id_children']);
						//print "this->cats[$i]['id_children'] est deja un tableau de $newelem elements<br>";
						$this->cats[$obj->rowid]['id_children'][$newelempos]=$obj->rowid_fille;
					}
					else
					{
						//print "this->cats[".$obj->rowid."]['id_children'] n'est pas encore un tableau<br>";
						$this->cats[$obj->rowid]['id_children']=array($obj->rowid_fille);
					}
				}
			}
		}
		else
		{
			dol_print_error($this->db);
			return -1;
		}

		// We add properties fullxxx to all elements
		foreach($this->cats as $key => $val)
		{
			if (isset($motherof[$key])) continue;
			$this->build_path_from_id_categ($key, 0);
		}

		$this->cats=dol_sort_array($this->cats, 'fulllabel', 'asc', true, false);
		$this->full_arbo_loaded=1;

		return $this->cats;
    }

    public function build_path_from_id_categ($id_categ, $protection = 0)
	{
        // phpcs:enable
		// Define fullpath
		if (! empty($this->cats[$id_categ]['id_mere']))
		{
			$this->cats[$id_categ]['fullpath'] =$this->cats[$this->cats[$id_categ]['id_mere']]['fullpath'];
			$this->cats[$id_categ]['fullpath'].='_'.$id_categ;
            $this->cats[$id_categ]['fullrelativename'] =$this->cats[$this->cats[$id_categ]['id_mere']]['fullrelativename'];
            $this->cats[$id_categ]['fullrelativename'].='/'.$this->cats[$id_categ]['label'];
			$this->cats[$id_categ]['fulllabel'] =$this->cats[$this->cats[$id_categ]['id_mere']]['fulllabel'];
			$this->cats[$id_categ]['fulllabel'].=' >> '.$this->cats[$id_categ]['label'];
		}
		else
		{
			$this->cats[$id_categ]['fullpath']='_'.$id_categ;
            $this->cats[$id_categ]['fullrelativename']=$this->cats[$id_categ]['label'];
			$this->cats[$id_categ]['fulllabel']=$this->cats[$id_categ]['label'];
		}
		// We count number of _ to have level (we use strlen that is faster than dol_strlen)
		$this->cats[$id_categ]['level']=strlen(preg_replace('/([^_])/i', '', $this->cats[$id_categ]['fullpath']));

		// Traite ces enfants
		$protection++;
		if ($protection > 20) return;	// On ne traite pas plus de 20 niveaux
		if (isset($this->cats[$id_categ]['id_children']) && is_array($this->cats[$id_categ]['id_children']))
		{
			foreach($this->cats[$id_categ]['id_children'] as $key => $val)
			{
				$this->build_path_from_id_categ($val, $protection);
			}
		}
	}



	function dol_add_file_process($upload_dir, $allowoverwrite = 0, $donotupdatesession = 0, $varfiles = 'addedfile', $savingdocmask = '', $link = null, $trackid = '', $generatethumbs = 1)
	{
		global $db,$user,$conf,$langs;

		$ged_file=new ged_files($this->db);
		$extrafields = new ExtraFields($this->db);

		// fetch optionals attributes and labels
		$extralabels=$extrafields->fetch_name_optionals_label($ged_file->table_element);

		$res = 0;
		if (! empty($_FILES[$varfiles])) // For view $_FILES[$varfiles]['error']
		{
			global $maxwidthsmall, $maxheightsmall, $maxwidthmini, $maxheightmini;

			include_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';


			$result = 0;
			$nbok = 0;


			if (! preg_match('/[\\/]temp[\\/]|[\\/]thumbs|\.meta$/', $rel_dir))     // If not a tmp dir
			{
				// $filename = basename($destfile);
				
				$txt_tags = '';
				$txt_users = '';
				// $file = basename($destfile);
				
				if(GETPOST('tags')){
					$txt_tags = implode(',', GETPOST('tags'));
				}
				if(GETPOST('id_users')){
					$txt_users = implode(',', GETPOST('id_users'));
				}
				$description = GETPOST('description');
				$confidential = GETPOST('check_conf');
				
				$data_insert = [
					// 'fullpath' => $rel_dir,
					// 'fullname' => $filename,
					// 'label' => md5_file(dol_osencode($upload_dir.$filename)),
					'label' => trim(addslashes(GETPOST('titre_doc'))),
					'fullnameorg' => $TFile['name'],
					'user_c' => $user->id,
					'date_c' => date('Y-m-d'),
					'description' => addslashes($description),    // indexed content
					'tags' => $txt_tags,    
					'confidential' => $confidential,    
					'showfor' => $txt_users,    
					'categorie' => $this->rowid,    
				];
				

				$lastgedid = $ged_file->create(1,$data_insert);

			}

			// $result = addFileIntoDatabaseIndex($upload_dir, basename($destfile), $TFile['name'], 'uploaded', 0);
			if ($lastgedid < 0)
			{
				setEventMessages('FailedToAddFileIntoDatabaseIndex', '', 'warnings');
			}

			$nbok++;



			$upload_dir = $upload_dir."/".$lastgedid;
			
			dol_syslog('dol_add_file_process upload_dir='.$upload_dir.' allowoverwrite='.$allowoverwrite.' donotupdatesession='.$donotupdatesession.' savingdocmask='.$savingdocmask, LOG_DEBUG);

			if ($lastgedid && dol_mkdir($upload_dir) >= 0)
			{
			
				$TFile = $_FILES[$varfiles];

				$i = 0;
				$ext = explode('.', $TFile['name']);
				$ext = $ext[1];

				// $titredoc = GETPOST('titre_doc');
    			$titredoc = $ged_file->stripAccents(GETPOST('titre_doc'));
				if($titredoc){
					$TFile['name'] = $titredoc.'.'.$ext;
				}

				// Define $destfull (path to file including filename) and $destfile (only filename)
				$destfull=$upload_dir . "/" . $TFile['name'];
				$destfile = $TFile['name'];

				// dol_sanitizeFileName the file name and lowercase extension
				$info = pathinfo($destfull);
				$destfull = $info['dirname'].'/'.dol_sanitizeFileName($info['filename'].($info['extension']!='' ? ('.'.strtolower($info['extension'])) : ''));
				$info = pathinfo($destfile);

				$destfile = dol_sanitizeFileName($info['filename'].($info['extension']!='' ? ('.'.strtolower($info['extension'])) : ''));

				// We apply dol_string_nohtmltag also to clean file names (this remove duplicate spaces) because
				// this function is also applied when we make try to download file (by the GETPOST(filename, 'alphanohtml') call).
				$destfile = dol_string_nohtmltag($destfile);
				$destfull = dol_string_nohtmltag($destfull);

				$resupload = dol_move_uploaded_file($TFile['tmp_name'], $destfull, $allowoverwrite, 0, $TFile['error'], 0, $varfiles);





				$rel_dir = preg_replace('/^'.preg_quote(DOL_DATA_ROOT, '/').'/', '', $upload_dir);
				$rel_dir = preg_replace('/[\\/]$/', '', $rel_dir);
				$rel_dir = preg_replace('/^[\\/]/', '', $rel_dir);

				$filename = basename($destfile);
				if($lastgedid){
					$ged_file->fetch($lastgedid);
				    // Fill array 'array_options' with data from add form
				    $ret = $extrafields->setOptionalsFromPost($extralabels, $ged_file);
				    $data_update = [  
				    	'fullpath' => $rel_dir,
						'fullname' => $filename,
						// 'label' => md5_file(dol_osencode($upload_dir.$filename)),   
					];
					$result = $ged_file->update($ged_file->id,$data_update);
				}




				if (is_numeric($resupload) && $resupload > 0)   // $resupload can be 'ErrorFileAlreadyExists'
				{	
				}
				else
				{
					$langs->load("errors");
					if ($resupload < 0)	// Unknown error
					{
						setEventMessages($langs->trans("ErrorFileNotUploaded"), null, 'errors');
					}
					elseif (preg_match('/ErrorFileIsInfectedWithAVirus/', $resupload))	// Files infected by a virus
					{
						setEventMessages($langs->trans("ErrorFileIsInfectedWithAVirus"), null, 'errors');
					}
					else	// Known error
					{
						setEventMessages($langs->trans($resupload), null, 'errors');
					}
				}

				if ($nbok > 0)
				{
					$res = 1;
					setEventMessages($langs->trans("FileTransferComplete"), null, 'mesgs');
				}
			}
		} 
		else
		{
			$langs->load("errors");
			setEventMessages($langs->trans("ErrorFieldRequired", $langs->transnoentities("File")), null, 'errors');
		}

		return $res;
	}

	public function changeNbOfFiles($value,$id_cat)
	{
		// Update request
		$sql = "UPDATE ".MAIN_DB_PREFIX."ged_categories SET";
		if (preg_match('/[0-9]+/', $value)) $sql.= " cachenbofdoc = ".(int) $value;
		else $sql.= " cachenbofdoc = cachenbofdoc ".$value." 1";
		$sql.= " WHERE rowid = ".$id_cat;

		dol_syslog(get_class($this)."::changeNbOfFiles", LOG_DEBUG);
		$resql = $this->db->query($sql);
		if (! $resql)
		{
			$this->error="Error ".$this->db->lasterror();
			return -1;
		}
		else
		{
		    if (preg_match('/[0-9]+/', $value)) $this->cachenbofdoc = (int) $value;
		    elseif ($value == '+') $this->cachenbofdoc++;
		    elseif ($value == '-') $this->cachenbofdoc--;
		}

		return 1;
	}

	

	public function get_docs($dir)
	{
		global $conf;
		$nb_cache = 0;
		$sqltree = $this->get_dossiers();
		$fildir = $conf->documentsged->dir_output.'/'.$dir;
		if (file_exists($fildir))
		{
			print '<ul class="ecmjqft">';
			$files = @scandir($fildir);
			if (! empty($files))
			{
				natcasesort($files);
				if (count($files) > 0)    /* The 2 accounts for . and .. */
				{
					// echo '<ul class="ecmjqft" style="display: none;">'."\n";

					// All dirs
					foreach ($files as $file)    // $file can be '.', '..', or 'My dir' or 'My file'
					{
						if($file != '.' && $file != '..'){
							foreach($sqltree as $key => $tmpval)
							{
								$resarray = $this->tree_showpad($sqltree, $key, 1);

								// print_r('nm:'.$tmpval['fullrelativename'].'hhhhhhfilhhhhhhh'.$dir.$file.'<br>');
								// print "-- key=".$key." - ".$tmpval['fullrelativename']." vs ".(($selecteddir != '/'?$selecteddir.'/':'').$file)."<br>\n";
								if ($tmpval['fullrelativename'] == $dir.$file || $tmpval['fullrelativename'] == $dir.'/'.$file)	// We found equivalent record into database
								{
									$this->fetch($tmpval['id']);
									$user22 = new User($this->db);
									$user22->fetch($this->fk_user_c);
									$form = new Form($this->db);
									$title  = 'Créateur:'.$user22->firstname.' '.$user22->lastname.'<br>';
									$title .= 'Date de création:'.date('d/m/Y',strtotime($this->date_c)).'<br>';

									if(!$resarray[2]){
										$nb_cache = $this->cachenbofdoc;
									}
									if($resarray[2] > 0){
										$nb_cache = $this->cachenbofdoc + $resarray[2];
									}
									if(!$nb_cache || $nb_cache < 0) $nb_cache = 0;

									$title .= 'Nombre de fichiers dans les sous-répertoires:'.$nb_cache;

									print '<li class="directory collapsed">';
										print '<a href="documents.php?cat='.$tmpval['id'].'" class=\'"fmdirlia jqft ecmjqft\'">';
											print $tmpval['label'];
										print '</a>';
										// if($resarray[2] > 0){
										// 	print ' ('.$this->cachenbofdoc.')';
										// }				
											print '&nbsp;&nbsp;';
										// print '<div class="div_edit">';
											print $form->textwithpicto('', $title, 1, "info");
											print '&nbsp;&nbsp;';

											print '<a style="float:right" class="edit_cat" href ="'.dol_buildpath('/documentsged/ged_categories/card.php?id='.$tmpval['id'],2).'">';
												print '<img src="'.dol_buildpath('/documentsged/img/edit.png',2).'">';
											print '</a>';
											print '&nbsp;&nbsp;';

											
											print '<span style="float:right"> ';
											
											if($nb_cache){
												print '<b class="countfiles"><font> ('.$nb_cache.') </font></b>';
											}
											print ' &nbsp;&nbsp;</span>';
											print '</br>';
											// print '<img src="'.DOL_MAIN_U	RL_ROOT.'/theme/eldy/img/info.png" alt="" style="vertical-align: middle;" title="thghghghj">';
										// print '</div>';
										$dd = $dir.$file;
										if (file_exists($conf->documentsged->dir_output.'/'.$dd)){
										}else{
											$dd = $dir.'/'.$file;
										}
										$this->get_docs($dd);
									print '</li>';
									
								}
							}
						}

					}
				}
			}
			print '</ul>';
		}
	}

	public function tree_showpad(&$fulltree, $key, $silent = 0)
	{
		$pos=1;

		// Loop on each pos, because we will output an img for each pos
		while ($pos <= $fulltree[$key]['level'] && $fulltree[$key]['level'] > 0)
		{
			// Process for column $pos

			$atleastoneofthislevelafter=0;
			$nbofdirinsub=0;
			$nbofdocinsub=0;
			$found=0;
			//print 'x'.$key;
			foreach($fulltree as $key2 => $val2)
			{
	            //print "x".$pos." ".$key2." ".$found." ".$fulltree[$key2]['level'];
				if ($found == 1) // We are after the entry to show
				{
					if ($fulltree[$key2]['level'] > $pos)
					{
						$nbofdirinsub++;
						if (isset($fulltree[$key2]['cachenbofdoc']) && $fulltree[$key2]['cachenbofdoc'] > 0) $nbofdocinsub+=$fulltree[$key2]['cachenbofdoc'];
					}
					if ($fulltree[$key2]['level'] == $pos)
					{
						$atleastoneofthislevelafter=1;
					}
					if ($fulltree[$key2]['level'] <= $pos)
					{
						break;
					}
				}
				if ($key2 == $key)    // We found ourself, so now every lower level will be counted
				{
					$found=1;
				}
			}
			//print $atleastoneofthislevelafter;

			if (! $silent)
			{
	    		if ($atleastoneofthislevelafter)
	    		{
	    			if ($fulltree[$key]['level'] == $pos) print img_picto_common('', 'treemenu/branch.gif');
	    			else print img_picto_common('', 'treemenu/line.gif');
	    		}
	    		else
	    		{
	    			if ($fulltree[$key]['level'] == $pos) print img_picto_common('', 'treemenu/branchbottom.gif');
	    			else print img_picto_common('', 'treemenu/linebottom.gif');
	    		}
			}
			$pos++;
		}

		return array($atleastoneofthislevelafter,$nbofdirinsub,$nbofdocinsub);
	}



	public function get_docs_id($id,$arry)
	{

		global $conf;
		$sqltree = $this->get_dossiers();

		// $fildir = $conf->documentsged->dir_output.'/'.$dir;
		$this->fetchAll('','',0,0,'AND fk_parent ='.$id);
		foreach ($this->rows as $key => $value) {
			$arry = $this->get_docs_id($value->rowid,$arry);
			array_push($arry, $value->rowid);
		}

		return $arry;
	}




} 


?>