<?php
/* Copyright (C) 2017-	Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	  \file	   htdocs/customtabs/fiche.php
 *	  \ingroup	member
 *		\brief	  complement fiche 
 */

$res=@include("../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../main.inc.php");		// For "custom" directory

dol_include_once('/customtabs/core/lib/customtabs.lib.php');
dol_include_once('/customtabs/class/customtabs.class.php');

//require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
$langs->load("customtabs@customtabs");
$langs->load("admin");

// Security check
$result=restrictedArea($user, 'customtabs', $rowid, '');

$action = GETPOST("action");

$customtabs = new Customtabs($db);
$tblelement=elementarray();


$extrafields = new ExtraFields($db);

$elementtype='societe';
// Load attribute_label
$extrafields->fetch_name_optionals_label($elementtype);
if ($elementtype == 'societe') 
	$elementtypeCT ='thirdparty';

/*
 *	Actions
 */
if ($action == "transfert") {
	$extrafieldsdest = new ExtraFields($db);

	$tblcustomtabs = $customtabs->liste_array($elementtypeCT, 1);
	$tblcustomtabstransfert=array();

	// pour rcuprer la table au format pour la liste droulante
	foreach ($tblcustomtabs as $key => $value)
		$tblcustomtabstransfert[$key] = $value['libelle'];

	foreach ($extrafields->attribute_type as $key => $value) {
		if (GETPOST("customTabDest-".$key) > 0 ) {
			$customtabs->fetch(GETPOST("customTabDest-".$key));
			$elementtypeCust="cust_".$customtabs->tablename;
			// on cre l'extrafields dans le Customtabs
			$result=$extrafieldsdest->addExtraField(
							$key, $extrafields->attribute_label[$key], 
							$extrafields->attribute_type[$key], $extrafields->attribute_pos[$key],
							$extrafields->attribute_size[$key], $elementtypeCust,
							$extrafields->attribute_unique[$key], $extrafields->attribute_required[$key],
							$extrafields->attribute_default[$key], $extrafields->attribute_param[$key]
			);

			// on dsactive l'extrafields en changeant juste le nom de l'lments (prservation)
			$sql= "UPDATE ".MAIN_DB_PREFIX."extrafields";
			$sql.= " SET elementtype='oldc_".$elementtype."'";
			$sql.= " WHERE name='".$key."'";
			$sql.= " AND elementtype='".$elementtype."'";
// pour les tests on le laisse tel quel
			$resql = $db->query($sql);
		}
	}

	// transfert des datas d'extrafields  Customtabs
	// on rcupre toute les lignes d'extrafields
	$optionsArray = $extrafields->attribute_type;

	$sql = "SELECT rowid, fk_object";
	foreach ($optionsArray as $name => $type) {
		if (empty($type)
			|| $type != 'separate')
			$sql.= ", ".$name;
	}
	$sql.= " FROM ".MAIN_DB_PREFIX.$elementtype."_extrafields";

	$resql = $db->query($sql);

	if ($resql) {
		$torecup=array();
		// on rcupre les champs  transfrer sur ce customTabs
		foreach ($optionsArray as $name => $type) {
			if (GETPOST("customTabDest-".$name) > 0 )
				$torecup[$tblcustomtabs[GETPOST("customTabDest-".$name)]['tablename']][]=$name;	
		}
		if (count($torecup) > 0 ) {

			$num = $db->num_rows($resql);
			$i = 0;
			while ($i < $num) {
				$obj = $db->fetch_object($resql);
				// on boucle sur les customTabs
				foreach ($torecup as $key => $value) {

					if (count($torecup) > 0 ) {
						// on regarde si l'enreg existe dj dans le customTabs
						$sql ="SELECT rowid FROM ".MAIN_DB_PREFIX."cust_".$key."_extrafields";
						$sql.=" WHERE fk_object=".$obj->fk_object;
						$resqlcust = $db->query($sql);
						if ($resqlcust) {
							$numcust = $db->num_rows($resqlcust);
							if ($numcust > 0) {
								// on fait un update
								$objcust = $db->fetch_object($resqlcust);
								$rowidcut = $objcust->rowid;
								$sql = "UPDATE ".MAIN_DB_PREFIX."cust_".$key."_extrafields ";
								$sql.= " SET fk_object=".$obj->fk_object;
								$bToInsert = false;
								foreach ($value as $fieldscust) {
									if ($obj->$fieldscust) {
										// pour limiter la cration des lignes si vides
										if (!empty($obj->$fieldscust))
											$bToInsert = true;

										$sql.= ", ".$fieldscust." = ";
										switch ($optionsArray[$fieldscust]) {
											case "link":
											case "int":
											case "double":
#												if ($obj->$fieldscust != "")
#													$sql.= $obj->$fieldscust.", ";
#												else
#													$sql.= " null, ";
# Libre Expert 2017-10-03
												if ($obj->$fieldscust != "")
													$sql.= $obj->$fieldscust." ";
												else
													$sql.= " null ";
												break;
											case 'date' :
												if ($obj->$fieldscust != "0000-00-00" && $obj->$fieldscust != "") {
													$tmpdate=dol_mktime(
																	-1, -1, -1, 
																	substr($obj->$fieldscust, 5, 2),
																	substr($obj->$fieldscust, 8, 2),
																	substr($obj->$fieldscust, 0, 4)
													);
													$sql.=$db->idate($tmpdate);
												} else {
													$sql.= 'null';
												}
												break;

											default :
												$sql.="'".$db->escape($obj->$fieldscust)."'";
												break;
										}
									}
								}
								$sql.= " WHERE fk_object=".$obj->fk_object;
//print $sql."<br>";
								if ($bToInsert)
									$resqlcustinsert = $db->query($sql);
							} else {

								$sql = "INSERT INTO ".MAIN_DB_PREFIX."cust_".$key."_extrafields (";
								foreach($value as $fieldscust)
									$sql.= $fieldscust.", ";
								$sql.= "fk_object) VALUES (";

								$bToInsert = false;

								foreach ($value as $fieldscust) {
									// pour limiter la cration des lignes si vides
									if (!empty($obj->$fieldscust))
										$bToInsert = true;
									switch ($optionsArray[$fieldscust]) {
										case "link":
										case "int":
										case "double":
											if ($obj->$fieldscust != "")
												$sql.= $obj->$fieldscust.", ";
											else
												$sql.= " null, ";
											break;
										case 'date' :
											if ($obj->$fieldscust != "0000-00-00" && $obj->$fieldscust != "") {
												$tmpdate=dol_mktime(
																-1, -1, -1, 
																substr($obj->$fieldscust, 5, 2),
																substr($obj->$fieldscust, 8, 2),
																substr($obj->$fieldscust, 0, 4)
												);
												$sql.=$db->idate($tmpdate).", ";
											} else {
												$sql.= 'null, ';
											}
											break;

										default :
											$sql.="'".$db->escape($obj->$fieldscust)."', ";
											break;
									}
								}
								$sql.= $obj->fk_object.")"; 

								if ($bToInsert) {
									$resqlcustinsert = $db->query($sql);
//print $sql."<br>";
								}
							}
						}
					}
				}
				$i++;
			}
		}
	}
	// on recharge les extrafields (pour ceux qui on t supprim lors de l'import
	$extrafields->fetch_name_optionals_label($elementtype);
}


/*
 * View
 */

llxHeader(
				"", $langs->trans("ExtrafieldtoCustomTabs"), 
				'EN:Module_customtabs|FR:Module_customtabs|ES:M&oacute;dulo_customtabs'
);

$form=new Form($db);


// Liste des extrafields du tiers


print_fiche_titre($langs->trans("ExtrafieldtoCustomTabs"));
print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">';
print '<input type="hidden" name="action" value="transfert">';      


print '<div class="div-table-responsive">';
print '<table summary="listofattributes" class="noborder" width="100%">';

print '<tr class="liste_titre">';
print '<td align="left">'.$langs->trans("Position").'</td>';
print '<td>'.$langs->trans("Label").'</td>';
print '<td>'.$langs->trans("AttributeCode").'</td>';
print '<td>'.$langs->trans("Type").'</td>';
print '<td align="right">'.$langs->trans("Size").'</td>';
print '<td align="center">'.$langs->trans("Unique").'</td>';
print '<td>'.$langs->trans("ComputedFormula").'</td>';
print '<td align="center">'.$langs->trans("Required").'</td>';
print '<td align="center">'.$langs->trans("AlwaysEditable").'</td>';
print '<td align="right">'.$langs->trans("DestCustomTabs").'</td>';
print "</tr>\n";

// si il y a des extrafields  transfrer
if (count($extrafields->attribute_type)) {

	$tblcustomtabs = $customtabs->liste_array($elementtypeCT, 1);
	$tblcustomtabstransfert=array();
	
	// pour rcuprer la table au format pour la liste droulante
	foreach ($tblcustomtabs as $key => $value)
		$tblcustomtabstransfert[$key] = $value['libelle'];

	$tmptype2label=ExtraFields::$type2label;
	$type2label=array('');
	foreach ($tmptype2label as $key => $val)
		$type2label[$key]=$langs->trans($val);

	foreach ($extrafields->attribute_type as $key => $value) {
		print '<tr class="oddeven">';
		print "<td>".$extrafields->attribute_pos[$key]."</td>\n";
		print "<td>".$extrafields->attribute_label[$key]."</td>\n";
		print "<td>".$key."</td>\n";

		print "<td>".$type2label[$extrafields->attribute_type[$key]]."</td>\n";
		print '<td align="right">'.$extrafields->attribute_size[$key]."</td>\n";
		print '<td align="center">'.yn($extrafields->attribute_unique[$key])."</td>\n";
		print '<td>'.dol_trunc($extrafields->attribute_computed[$key], 20)."</td>\n";
		print '<td align="center">'.yn($extrafields->attribute_required[$key])."</td>\n";
		print '<td align="center">'.yn($extrafields->attribute_alwayseditable[$key])."</td>\n";
		print '<td align="right">';
		print $form->selectarray("customTabDest-".$key, $tblcustomtabstransfert, 0, 1);
		// ici la liste des customtabs associ au type
		print "</td></tr>";
	}
}
print '</table>';

/*
 * Barre d'actions
 *
 */
print '<div class="tabsAction">';
// New type
if ($user->rights->customtabs->configurer) {
	print '<input type="submit" class="button" value="'.$langs->trans("LaunchTransfert").'">';
}
print "</div></form>";

llxFooter();
$db->close();
