<?php
/* Copyright (C) 2010-2012	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2012		Regis Houssin		<regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
?>

<!-- BEGIN PHP TEMPLATE admin_extrafields_edit.tpl.php -->
<script type="text/javascript">
	jQuery(document).ready(function() {
		function init_typeoffields(type)
		{
			var size = jQuery("#size");
			var unique = jQuery("#unique");
			var required = jQuery("#required");
			if (type == 'date') { size.prop('disabled', true); }
			else if (type == 'datetime') { size.prop('disabled', true); }
			else if (type == 'double') { size.removeAttr('disabled'); }
			else if (type == 'int') { size.removeAttr('disabled'); }
			else if (type == 'text') { size.removeAttr('disabled'); unique.prop('disabled', true).removeAttr('checked'); }
			else if (type == 'varchar') { size.removeAttr('disabled'); }
			else if (type == 'boolean') { size.val('').prop('disabled', true); unique.prop('disabled', true);}
			else if (type == 'price') { size.val('').prop('disabled', true); unique.prop('disabled', true);}
			else size.val('').prop('disabled', true);
		}
		init_typeoffields(jQuery("#type").val());
	});
</script>


<form action="<?php echo $_SERVER["PHP_SELF"]; ?>?attrname=<?php echo $attrname; ?>" method="post">
<input type="hidden" name="token" value="<?php echo $_SESSION['newtoken']; ?>">
<input type="hidden" name="attrname" value="<?php echo $attrname; ?>">
<input type="hidden" name="action" value="update">
<input type="hidden" name="rowid" value="<?php echo $rowid ?>">

<?php dol_fiche_head(); ?>

<table summary="listofattributes" class="border centpercent">

<?php

$label = $extrafields->attributes[$elementtype]['label'][$attrname];
$type = $extrafields->attributes[$elementtype]['type'][$attrname];
$size = $extrafields->attributes[$elementtype]['size'][$attrname];
$default = $extrafields->attributes[$elementtype]['default'][$attrname];
$unique = $extrafields->attributes[$elementtype]['unique'][$attrname];
$required = $extrafields->attributes[$elementtype]['required'][$attrname];
$pos = $extrafields->attributes[$elementtype]['pos'][$attrname];
$alwayseditable = $extrafields->attributes[$elementtype]['alwayseditable'][$attrname];
$param = $extrafields->attributes[$elementtype]['param'][$attrname];
$perms = $extrafields->attributes[$elementtype]['perms'][$attrname];
$langfile = $extrafields->attributes[$elementtype]['langfile'][$attrname];
$list = $extrafields->attributes[$elementtype]['list'][$attrname];
$help = $extrafields->attributes[$elementtype]['help'][$attrname];
$entitycurrentorall = $extrafields->attributes[$elementtype]['entityid'][$attrname];

if ((($type == 'select') || ($type == 'checkbox') || ($type == 'radio')) && is_array($param)) {
	$param_chain = '';
	foreach ($param['options'] as $key => $value) {
		if (strlen($key))
			$param_chain .= $key.','.$value."\n";
	}
} elseif (($type== 'sellist') || ($type == 'chkbxlst') || ($type == 'link')) {
	$paramlist=array_keys($param['options']);
	$param_chain = $paramlist[0];
}
?>
<!-- Label -->
<tr>
	<td class="fieldrequired"><?php echo $langs->trans("Label"); ?></td>
	<td class="valeur">
		<input type="text" name="label" size="40" value="<?php echo $label; ?>">
	</td>
</tr>
<!-- Code -->
<tr><td class="fieldrequired"><?php echo $langs->trans("AttributeCode"); ?></td>
	<td class="valeur"><?php echo $attrname; ?></td>
</tr>
<!-- Type -->
<tr><td class="fieldrequired"><?php echo $langs->trans("Type"); ?></td><td class="valeur">
<?php print $type2label[$type]; ?>
<input type="hidden" name="type" id="type" value="<?php print $type; ?>">
</td></tr>
<!-- Size -->
<tr>
	<td class="fieldrequired"><?php echo $langs->trans("Size"); ?></td>
	<td><input id="size" type="text" name="size" size="5" value="<?php echo $size; ?>"></td>
</tr>
<!-- Position -->
<tr>
	<td><?php echo $langs->trans("Position"); ?></td>
	<td class="valeur">
		<input type="text" name="pos" size="5" value="<?php echo $pos;?>">
	</td>
</tr>

<!-- Language file -->
<tr><td class="titlefield"><?php echo $langs->trans("LanguageFile"); ?></td><td class="valeur"><input type="text" name="langfile" class="minwidth200" value="<?php echo dol_escape_htmltag($langfile); ?>"></td></tr>
<!-- Default Value (at sql setup level) -->
<tr class="extra_default_value"><td><?php echo $langs->trans("DefaultValue").' ('.$langs->trans("Database").')'; ?></td><td class="valeur"><input id="default_value" type="text" name="default_value" size="5" value="<?php echo dol_escape_htmltag($default); ?>"></td></tr>

<!--  Value (for select list / radio) -->
<?php
if (($type == 'select') || ($type == 'sellist') || ($type == 'checkbox') 
	|| ($type == 'chkbxlst') || ($type == 'radio') || ($type == 'link')) {

	print '<tr id="value_choice">';
	print '<td>';
	print $langs->trans("Value"); 
	print '</td>';
	print '<td>';
	print '<table class="nobordernopadding">';
	print '<tr><td>';

	print '<textarea name="param" id="param" cols="80" rows="'.ROWS_4.'">';
	print dol_htmlcleanlastbr($param_chain);
	print '</textarea>';
	print '</td><td>';
	print $form->textwithpicto('', $langs->trans("ExtrafieldParamHelp".$type), 1, 0);
	print '</td>';
	print '</tr></table>';
	print '</td>';
	print '</tr>';
}
?>
<!-- Unique -->
<tr>
	<td><?php echo $langs->trans("Unique"); ?></td>
	<td class="valeur"><input id="unique" type="checkbox" name="unique" <?php echo ($unique?' checked':''); ?>></td>
</tr>
<!-- Required -->
<tr>
	<td><?php echo $langs->trans("Required"); ?></td>
	<td class="valeur">
		<input id="required" type="checkbox" name="required" <?php echo ($required?' checked':''); ?>>
	</td>
</tr>
<tr class="extra_alwayseditable"><td><?php echo $langs->trans("AlwaysEditable"); ?></td><td class="valeur"><input id="alwayseditable" type="checkbox" name="alwayseditable"<?php echo ($alwayseditable ? ' checked' : ''); ?>></td></tr>
<!-- Visibility -->
<tr><td class="extra_list"><?php echo $form->textwithpicto($langs->trans("Visibility"), $langs->trans("VisibleDesc")); ?>
</td><td class="valeur"><input id="list" class="minwidth100" type="text" name="list" value="<?php echo ($list != '' ? $list : '1'); ?>"></td></tr>
<!-- Help tooltip -->
<tr class="help"><td><?php echo $form->textwithpicto($langs->trans("HelpOnTooltip"), $langs->trans("HelpOnTooltipDesc")); ?></td><td class="valeur"><input id="help" class="quatrevingtpercent" type="text" name="help" value="<?php echo dol_escape_htmltag($help); ?>"></td></tr>
<?php if ($conf->multicompany->enabled) { ?>
	<!-- Multicompany entity -->
    <tr><td><?php echo $langs->trans("AllEntities"); ?></td><td class="valeur"><input id="entitycurrentorall" type="checkbox" name="entitycurrentorall"<?php echo (empty($entitycurrentorall) ? ' checked' : ''); ?>></td></tr>
<?php } ?>
</table>

<?php dol_fiche_end(); ?>

<div align="center">
	<input type="submit" name="button" class="button" value="<?php echo $langs->trans("Save"); ?>">
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	<input type="submit" name="button" class="button" value="<?php echo $langs->trans("Cancel"); ?>">
</div>
</form>
<!-- END PHP TEMPLATE admin_extrafields_edit.tpl.php -->