<?php
/* Copyright (C) 2014-2020	Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	  \file	   htdocs/adherents/admin/adherent_extrafields.php
 *		\ingroup	member
 *		\brief	  Page to setup extra fields of group members
 */

$res=@include("../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../main.inc.php");		// For "custom" directory

dol_include_once('/customtabs/core/lib/customtabs.lib.php');
dol_include_once('/customtabs/class/customtabs.class.php');

require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

$langs->load("customtabs@customtabs");
$langs->load("admin");

$rowid	= GETPOST('rowid', 'int');

$extrafields = new ExtraFields($db);
$form = new Form($db);


$action=GETPOST('action', 'alpha');

$customtabs = new Customtabs($db);
$customtabs->fetch($rowid);

$elementtype="cust_".$customtabs->tablename;

// Security check
if (is_object($mc)) {
	$mc->addzero[]='customtabs' ;
}
$result=restrictedArea($user, 'customtabs', $rowid, '');



/*
 * Actions
 */

if ($action == 'update' && $user->rights->customtabs->configurer) {
	$customtabs = new Customtabs($db);
	$customtabs->fetch($rowid);
	$customtabs->template= GETPOST('template','none');

	$customtabs->updateTemplate($user);

	header("Location: ".$_SERVER["PHP_SELF"]."?rowid=".$rowid);
	exit;
}


/*
 * View
 */

$textobject=$langs->transnoentitiesnoconv("Members");

$help_url='EN:Module_RH|FR:Module_RH|ES:M&oacute;dulo_RH';
llxHeader('', $langs->trans("CustomtabsTemplate"), $help_url);


$head = customtabs_prepare_head($customtabs);

dol_fiche_head($head, 'template', $langs->trans("Customtabs"), -1, 'customtabs@customtabs');

dol_htmloutput_errors($mesg);

$linkback = '<a href="list.php">'.$langs->trans("BackToList").'</a>';
// customTabs additionnal element info
$morehtmlref='<div class="refidno">';	

// rendre modifiable
$morehtmlref.='<table class="nobordernopadding" width="100%">';
$morehtmlref.='<tr><td>'.$langs->trans("Label").':</td>';
$morehtmlref.='<td align="right">'.$customtabs->libelle;
$morehtmlref.='</td></tr>';

$tblelement=elementarray();
$morehtmlref.='<tr><td>'.$langs->trans("Element").':</td>';
$morehtmlref.='<td align="right">'.$tblelement[$customtabs->element];
$morehtmlref.='</td></tr>';

$morehtmlref.='<tr><td>'.$langs->trans("ModeCustomTabs").':</td>';
$morehtmlref.='<td align="right">'.getmodelib($customtabs->mode);
$morehtmlref.='</td></tr>';

$morehtmlref.='</table>';

$morehtmlref.='</div>';

$tmpTableElement = $customtabs->table_element;
$tmpElement = $customtabs->element;
$customtabs->table_element="customtabs";
$customtabs->element="customtabs";
$customtabs->ref = $customtabs->rowid;
dol_banner_tab($customtabs, 'rowid', $linkback, 1, 'rowid', 'rowid', $morehtmlref);
$customtabs->table_element =$tmpTableElement;
$customtabs->element =$tmpElement;


print '<form action="'.$_SERVER['PHP_SELF'].'" method="POST">';

print '<input type=hidden name=rowid value='.$rowid.'>';
print '<input type=hidden name=action value=update>';
print '<table summary="listofattributes" class="noborder" width="100%">';
print '<tr><th colspan=2>'.$langs->trans("Template").'</th></tr>';
print '<tr><td colspan=2 valign=top>';
print '<table class="nobordernopadding" width="100%" ><tr><td valign=top>';
print '<textarea name="template" wrap="soft" cols="80" rows="30">'.$customtabs->template.'</textarea>';
print '</td><td width=10px>';	
print '</td><td valign=top>';	
print $langs->trans("SomeHelpfullinfoAboutTemplate");
print '<br>';
print $langs->trans("SomeHelpfullinfoAboutTemplateMore");
print '<br><hr>';
print $langs->trans("AviableFields");
print '<br>';
print '<table width=100%>';
print '<tr class="liste_titre">';
print '<th>'.$langs->trans("Label").'</th>';
print '<th>'.$langs->trans("AttributeCodeLabel").'</th>';
print '<th>'.$langs->trans("AttributeCodeField").'</th>';

print '<th>'.$langs->trans("Type").'</th>';
print '<th align="right">'.$langs->trans("Size").'</th>';

print '</tr>';

// List of supported format
$tmptype2label=ExtraFields::$type2label;
//$tmptype2label=getStaticMember(get_class($extrafields),'type2label');
$type2label=array('');
foreach ($tmptype2label as $key => $val) $type2label[$key]=$langs->trans($val);

$elementtype="cust_".$customtabs->tablename;
$extrafields->fetch_name_optionals_label($elementtype);
$var=True;
foreach ($extrafields->attribute_type as $key => $value) {
	$var=!$var;
	print "<tr ".$bc[$var].">";
	print "<td>".$extrafields->attribute_label[$key]."</td>\n";
	print "<td>#LABEL-".$key."#</td>\n";
	print "<td>#FIELD-".$key."#</td>\n";
	print "<td>".$type2label[$extrafields->attribute_type[$key]]."</td>\n";
	print '<td align="right">'.$extrafields->attribute_size[$key]."</td>\n";

	print '</tr>';
}
print '</table>';

print '</td></tr></table>';	
print '</td></tr>';	

print '</table>';	

dol_fiche_end();
// Buttons
print '<div class="tabsAction">';
print '<center><input type="submit" class="button" value="'.$langs->trans("Save").'"> &nbsp; &nbsp;';
print "</div>";
print "</form>";

llxFooter();
$db->close();