<?php
/* Copyright (C) 2014-2020	Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	  \file	   htdocs/customtabs/fiche.php
 *	  \ingroup	member
 *		\brief	  complement fiche 
 */

$res=@include("../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../main.inc.php");		// For "custom" directory

dol_include_once('/customtabs/core/lib/customtabs.lib.php');
dol_include_once('/customtabs/class/customtabs.class.php');

if ($conf->multicompany->enabled) {
	dol_include_once('/multicompany/class/dao_multicompany.class.php', 'DaoMulticompany');
	$dao = new DaoMulticompany($db);
	$dao->getEntities();
}
//require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
$langs->load("customtabs@customtabs");


// Security check
$result=restrictedArea($user, 'customtabs', $rowid, '');

$elementid=GETPOST("elementid");
$action=GETPOST("action");

$modeid=GETPOST("modeid");
$fk_statut=GETPOST("fk_statut");

// Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$elementid='';
	$modeid=-1;
	$fk_statut=-1;
}

$customtabs = new Customtabs($db);
$tblelement=elementarray();

/*
 *	Actions
 */
if ($action =="refresh") {
	$custinfolist = $customtabs->liste_array();

	foreach ($custinfolist as $custinfo) {
		if ( $custinfo['fk_statut'] == 1) {
			// on supprime l'onglet si il est present ou pas
			$sql = "DELETE FROM ".MAIN_DB_PREFIX."const ";
			$sql.= " WHERE name =".$db->encrypt('MAIN_MODULE_CUSTOMTABS_TABS_'.$custinfo['rowid'], 1);

			$db->query($sql);

			if ($custinfo['fk_parent'] > 0)
				$contacttab = "sub-".$custinfo['element'];
			else {
				if ($custinfo['element']=='commande')
						$contacttab = 'order';
					else
						$contacttab = $custinfo['element'];
			}


			// on paramètre selon le type d'onglet les choix possibles
			switch($custinfo['mode']) {
				case 1 :	
					$tabinfo = $contacttab.':+customtabs_'.$custinfo['rowid'].':'.$custinfo['libelle'];
					$tabinfo.= ':"":@customtabs:/customtabs/tabs/card.php?tabsid='.$custinfo['rowid'].'&id=__ID__';

					break;
				case 2 :
					$tabinfo = $contacttab.':+customtabs_'.$custinfo['rowid'].':'.$custinfo['libelle'];
					$tabinfo.= ':"":@customtabs:/customtabs/tabs/list.php?tabsid='.$custinfo['rowid'].'&id=__ID__';
					break;
			}
			$sql = "INSERT INTO ".MAIN_DB_PREFIX."const ";
			$sql.= " ( name, type, value, note, visible, entity)";
			$sql.= " VALUES (";
			$sql.= $db->encrypt('MAIN_MODULE_CUSTOMTABS_TABS_'.$custinfo['rowid'], 1);
			$sql.= ", 'chaine'";
			$sql.= ", ".$db->encrypt($tabinfo, 1);
			$sql.= ", null";
			$sql.= ", '0'";
			$sql.= ", ".$conf->entity;
			$sql.= ")";

			$db->query($sql);

		}
	}
}


/*
 * View
 */

llxHeader('', $langs->trans("CustomTabs"), 'EN:Module_customtabs|FR:Module_customtabs|ES:M&oacute;dulo_customtabs');

$form=new Form($db);


// Liste of customtabs

print_fiche_titre($langs->trans("CustomTabsList"));
print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">';

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("Label").'</td>';
print '<td align="center">'.$langs->trans("Element").'</td>';
print '<td align="left">'.$langs->trans("TableName").'</td>';
print '<td align="center">'.$langs->trans("ModeCustomTabs").'</td>';
print '<td align="center">'.$langs->trans("FichierGED").'</td>';
print '<td align="center">'.$langs->trans("Parent").'</td>';
if ($conf->multicompany->enabled)
	print '<td align="center">'.$langs->trans("Multicompany").'</td>';

print '<td align="center">'.$langs->trans("ActiveStatut").'</td>';
print '<td align="center">';
print '<input type="image" class="liste_titre" name="button_removefilter"';
print ' src="'.img_picto($langs->trans("Search"), 'searchclear.png', '', '', 1).'"';
print ' value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'"';
print ' title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
print '</td>';
print "</tr>\n";
print '<tr class="liste_titre">';
print '<td></td>';
print '<td align="center">'.$form->selectarray("elementid", $tblelement, $elementid, 1).'</td>';
print '<td align="left"></td>';
print '<td align="center">'.$form->selectarray("modeid", modearray(), $modeid, 1).'</td>';
print '<td align="center"></td>';
print '<td align="center"></td>';
if ($conf->multicompany->enabled) {
	$tblEntity=array("0" => $langs->trans("All"));
	foreach ($dao->entities as $entites) {
		$tblEntity=array_merge($tblEntity, array($entites->id => $entites->label ));
	}
	print '<td align="center">';
	print $form->selectarray("entityid", $tblEntity, $entityid, 1);
	print '</td>';
}

print '<td align="center">'.$form->selectyesno("fk_statut", $fk_statut, 1, false, 1).'</td>';
print '<td align="center">';
print '<input type="image" class="liste_titre" name="button_search"';
print ' src="'.img_picto($langs->trans("Search"), 'search.png', '', '', 1).'"';
print ' value="'.dol_escape_htmltag($langs->trans("Search")).'"';
print ' title="'.dol_escape_htmltag($langs->trans("Search")).'">';
print '</td>';
print "</tr>\n";


$var=True;
$tblcustomtabs = $customtabs->liste_array(
				($elementid!=-1 ? $elementid :''), $modeid,
				($fk_statut=='' ? $fk_statut=-1:$fk_statut)
);
if (count($tblcustomtabs) > 0)
	foreach ($tblcustomtabs as $customtabsarray) {
		$customtabs->fetch($customtabsarray['rowid']);
		$var=!$var;
		print "<tr ".$bc[$var].">";
		print '<td><a href="card.php?rowid='.$customtabsarray['rowid'].'">';
		print img_object($langs->trans("ShowComplement"), 'list').' '.$customtabsarray['libelle'].'</a></td>';
		
		print '<td align=center>'.$tblelement[$customtabs->element].'</td>';
		print '<td align=left>llx_cust_'.$customtabs->tablename.'_extrafields</td>';
		print '<td align="center">'.getmodelib($customtabs->mode).'</td>';
		print '<td align="center">'.yn($customtabs->files).'</td>';
		print '<td align="center">'.$customtabs->parentname.'</td>';
		if ($conf->multicompany->enabled) {
			print '<td align="center">'.$tblEntity[$customtabs->entity].'</td>';
		}
		print '<td align="center">'.yn($customtabs->fk_statut).'</td>';

		print '<td align="center"></td>';
		print "</tr>";
		$i++;
	}
print "</table>";
print '</form>'."\n";


/*
 * Barre d'actions
 *
 */
print '<div class="tabsAction">';

// New type
if ($user->rights->customtabs->configurer) {
	print '<a class="butAction" href="list.php?action=refresh">'.$langs->trans("RefreshCustomTabsTabs").'</a>';
	print '<a class="butAction" href="card.php?action=create">'.$langs->trans("NewCustomtabs").'</a>';
}

print "</div>";

llxFooter();
$db->close();