<?php
/*  Copyright (C) 2019 Customizeforms Paulo Ricardo Carvalho de Oliveira	<paulorcdo@gmail.com>
 * Form based in /admin/dict.php
 
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       custom/customizeforms/card.php
 *		\brief      Page to administer fields
 */
$res=@include("../main.inc.php");// For root directory
$custom=0;

if (! $res)
{
$res=@include("../../main.inc.php");
$custom=1;
}// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formadmin.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/accounting.lib.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/bank.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/html.formproduct.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/product.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formbank.class.php';
require_once DOL_DOCUMENT_ROOT . '/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT . '/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formprojet.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formaccounting.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formactions.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent_type.class.php';

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcontract.class.php';
require_once DOL_DOCUMENT_ROOT.'/contrat/class/contrat.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formbarcode.class.php';
$formbarcode = new FormBarCode($db);
    
$adht = new AdherentType($db);
$formother=new FormOther($db);
$formproject = new FormProjets($db);  
$formbank = new FormBank($db);
$formactions = new FormActions($db);
$formcontract= new Formcontract($db);
		   
// Load translation files required by the page
if(!function_exists('loadLangs'))
			{
                
$langs->load("customizeforms@customizeforms");$langs->load("errors");$langs->load("admin");$langs->load("members");$langs->load("install");$langs->load("exports");$langs->load("banks");$langs->load("users");$langs->load("withdrawals");$langs->load("agenda");$langs->load("boxes");$langs->load("supplier_proposal");$langs->load("suppliers");$langs->load("compta");$langs->load("salaries");$langs->load("commercial");$langs->load("companies");$langs->load("donations");$langs->load("mails");$langs->load("resource");$langs->load("holiday");$langs->load("accountancy");$langs->load("hrm");$langs->load("orders");$langs->load("contracts");$langs->load("projects");$langs->load("propal");$langs->load("bills");$langs->load("interventions");$langs->load("sendings");$langs->load("deliveries");$langs->load("products");$langs->load("stocks");$langs->load("productbatch");
         }
			else
			{
           $langs->loadLangs(array("errors","admin","main","members","salaries","install","exports","banks","users","withdrawals","agenda","boxes","loan","trips","supplier_proposal","printing","sendings","ecm","dict","suppliers","compta","salaries","commercial","companies","donations", "mails","resource","holiday","accountancy","hrm","orders","contracts","projects","propal","bills","interventions","sendings","deliveries","products","other","customizeforms@customizeforms","stocks","productbatch"));
			}
 
$action=GETPOST('action','alpha')?GETPOST('action','alpha'):'view';
$confirm=GETPOST('confirm','alpha');
$id=GETPOST('id','int');
$rowid=GETPOST('rowid','alpha');
$entity=GETPOST('entity','int');
$code=GETPOST('code','alpha');
$formulario=GETPOST('form','alpha');

    $campoextra='';
    if($formulario=='NewProp-Customer'){$campoextra='propal';}
elseif($formulario=='NewOrder-Customer'){$campoextra='commande';}
elseif($formulario=='NewOrder-Supplier'){$campoextra='commande_fournisseur';}
elseif($formulario=='NewBill-Supplier'){$campoextra='facture_fourn';}
elseif($formulario=='NewAskPrice'){$campoextra='supplier_proposal';}
elseif($formulario=='NewBill-Customer'){$campoextra='facture';}
elseif($formulario=='NewThirdParty'){$campoextra='societe';}
elseif($formulario=='AddContact'){$campoextra='socpeople';}
elseif($formulario=='NewProduct-NewService'){$campoextra='product';}
elseif($formulario=='NewWarehouse'){$campoextra='';}
elseif($formulario=='NewFinancialAccount'){$campoextra='bank_account';}
elseif($formulario=='NewLeadOrProject'){$campoextra='projet';}
elseif($formulario=='NewAction'){$campoextra='actioncomm';}
elseif($formulario=='ExpenseReport-Card'){$campoextra='expensereport';}
elseif($formulario=='NewMailing'){$campoextra='';}
elseif($formulario=='NewUser'){$campoextra='user';}
elseif($formulario=='NewGroup'){$campoextra='usergroup';}
elseif($formulario=='SalaryPayment'){$campoextra='';}
elseif($formulario=='AddDonation'){$campoextra='don';}
elseif($formulario=='NewTask'){$campoextra='projet_task';}
elseif($formulario=='NewMember'){$campoextra='adherent';}
elseif($formulario=='NewMemberType'){$campoextra='adherent_type';}
elseif($formulario=='AddIntervention'){$campoextra='fichinter';}
elseif($formulario=='AddContract'){$campoextra='contrat';}



$extrafields = new ExtraFields($db);
 
$extralabels = $extrafields->fetch_name_optionals_label($campoextra);
 

 $result=restrictedArea($user,'customizeforms');
  
 $formproduct=new FormProduct($db);

$acts[0] = "activate";
$acts[1] = "disable";
$actl[0] = img_picto($langs->trans("Disabled"),'switch_off');
$actl[1] = img_picto($langs->trans("Activated"),'switch_on');

$listoffset=GETPOST('listoffset');
$listlimit=GETPOST('listlimit')>0?GETPOST('listlimit'):1000;	 
$active = 1;
 
  
$tabname=array();
$tabname[1] = MAIN_DB_PREFIX."customizeforms";
  
$tabsql=array();
$tabsql[1] = "SELECT m.rowid, m.modulo, m.submodulo, m.pagina, m.acao, m.campo_nome,m.campo_tipo,m.campo_texto,m.form_nome,m.campo_pos,m.situacao,m.valor_padrao,m.label,m.conteudo,m.tooltip,m.extra FROM ".MAIN_DB_PREFIX."customizeforms as m   ";
 
$tabfield=array();
$tabfield[1] = "campo_nome,campo_texto,situacao,valor_padrao,label,conteudo,tooltip";
  
 
$tabfieldvalue=array();
$tabfieldvalue[1] = "campo_nome,campo_texto,situacao,valor_padrao,label,conteudo,tooltip";
 
 
$tabfieldinsert=array();
$tabfieldinsert[1] = "campo_nome,campo_texto,situacao,valor_padrao,label,conteudo,tooltip";
 
   
if (GETPOST('actionadd') || GETPOST('actionmodify'))
{
    $listfield=explode(',', str_replace(' ', '',$tabfield[$id]));
 $listfieldinsert=explode(',',$tabfieldinsert[$id]);
$listfieldmodify=explode(',',$tabfieldinsert[$id]);
$listfieldvalue=explode(',',$listfieldvalue[$id]);
  
    $ok=1;
 //echo print_r($_POST['valor_padrao'])."<br>";
 
    if ($ok && GETPOST('actionmodify'))
    {
        if ($tabrowid[$id]) { $rowidcol=$tabrowid[$id]; }
        else { $rowidcol="rowid"; }
 
        $sql = "UPDATE ".$tabname[$id]." SET ";
 
        $i = 0;
        foreach ($listfieldmodify as $field)
        {
            
             
            if($field!='campo_texto' && $field!='campo_nome')
            {
          
          
            if ($field == 'price' || preg_match('/^amount/i',$field) || $field == 'taux') {
            	$_POST[$listfieldvalue[$i]] = price2num($_POST[$listfieldvalue[$i]],'MU');
            }
            else if ($field == 'entity') {
            	$_POST[$listfieldvalue[$i]] = getEntity($tabname[$id]);
            }
            if ($i>2) $sql.=",";
            $sql.= $field."=";
            if ($field== 'valor_padrao'&&$_POST['incoterm_id'])		 
            {
            	$sql.="'".(int) $db->escape($_POST['incoterm_id'])."'";
            }
            
             if ($field== 'valor_padrao'&&is_array($_POST[$listfieldmodify[$i]]))		 
            {
                $cat=$_POST[$listfieldmodify[$i]];
                $limite=count($cat);
                 $z = 0;
                  
                   if($z==0){$sql.="'";}
                foreach ($cat as $del) {
            	 $sql.= $db->escape($cat[$z]);
                 if($z<$limite-1)
                 {$sql.=",";}
               
                $z++;
                }
        
              $sql.="'";
            }

            else $sql.="'".$db->escape($_POST[$listfieldmodify[$i]])."'";
            }
            $i++;
            
        }
        $sql.= " WHERE ".$rowidcol." = '".$db->escape($rowid)."'";
        if (in_array('entity', $listfieldmodify)) $sql.= " AND entity = '".getEntity($tabname[$id])."'";
 
 
      
     
     $resql = $db->query($sql);
        if (! $resql)
        {
            setEventMessages($db->error(), null, 'errors');
        }
    }
 
}
  
$countrynotdefined=$langs->trans("ErrorSetACountryFirst").' ('.$langs->trans("SeeAbove").')';

$form = new Form($db);
$formadmin=new FormAdmin($db);
$formcompany = new FormCompany($db);

 $sql=$tabsql[$id];

    if (! preg_match('/ WHERE /',$sql)) $sql.= " WHERE form_nome='".$formulario."'";
     
    $sql.=$db->plimit($listlimit+1,$offset);
    
    
      $resql=$db->query($sql);
      if ($resql)
    {
        $obj = $db->fetch_object($resql);
          
        
        }
        
        
        
llxHeader();

$fo=explode('-',$formulario);
$titre=$langs->trans("CustomizeForm");
 $linkback='<a href="'.DOL_URL_ROOT.($custom==1?'/custom':'').'/customizeforms/list.php">'.$langs->trans("Backtolist").'</a>';
if ($id)
{
    $titre.=' - <a    href="'.DOL_URL_ROOT.($obj->modulo?"/".$obj->modulo:"").'/'.$obj->submodulo.'/'.$obj->pagina.'?action='.$obj->acao.'">'.$langs->trans($fo[0]).($fo[1]!=''?' - '.$langs->trans($fo[1]):'').'&nbsp;&nbsp;<span class=" fa fa-file-text-o" title="" ></span></a>';
  
}
 

$titlepicto='title_setup';

print load_fiche_titre($titre,$linkback,$titlepicto);

$paramurl = '&id='.urlencode($id);
 
if (GETPOST('form')) $paramurl.= '&form='.urlencode(GETPOST('form','alpha'));

  
if ($action == 'delete')
{
    print $form->formconfirm($_SERVER["PHP_SELF"].'?'.($page?'page='.$page.'&':'').'rowid='.urlencode($rowid).'&code='.urlencode($code).$paramurl, $langs->trans('DeleteLine'), $langs->trans('ConfirmDeleteLine'), 'confirm_delete','',0,1);
}

if ($action == 'confirm_delete' && $confirm == 'yes')       // delete
{
    if ($tabrowid[$id]) { $rowidcol=$tabrowid[$id]; }
    else { $rowidcol="rowid"; }

    $sql = "DELETE FROM ".$tabname[$id]." WHERE ".$rowidcol."='".$db->escape($rowid)."' AND extra =1 ";

    dol_syslog("delete", LOG_DEBUG);
    $result = $db->query($sql);
    if (! $result)
    {
        if ($db->errno() == 'DB_ERROR_CHILD_EXISTS')
        {
            setEventMessages($langs->transnoentities("ErrorRecordIsUsedByChild"), null, 'errors');
        }
        else
        {
            dol_print_error($db);
        }
    }
    else
    {
          setEventMessages($langs->trans("CustomizeCreateForms").' - '.$langs->trans("RecordsDeleted").' - '.$rowid.' - '.$langs->trans("ExtraFields"), null, 'mesgs');
        }
}

//var_dump($elementList);

/*
 * Show a dictionary
 */
if ($id)
{
    // Complete requete recherche valeurs avec critere de tri
    $sql=$tabsql[$id];

    if (! preg_match('/ WHERE /',$sql)) $sql.= " WHERE form_nome='".$formulario."' ";
     
    $sql.=$db->plimit($listlimit+1,$offset);
    // print $sql;

    if (empty($tabfield[$id]))
    {
    	dol_print_error($db, 'The table with id '.$id.' has no array tabfield defined');
    	exit;
    }
    $fieldlist=explode(',',$tabfield[$id]);

   
    

    print '<form action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&form='.$formulario.'" method="POST">';
    print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
    print '<input type="hidden" name="from" value="'.dol_escape_htmltag(GETPOST('from','alpha')).'">';

    // List of available record in database
    dol_syslog("htdocs/admin/dict", LOG_DEBUG);
    $resql=$db->query($sql);
    if ($resql)
    {
        $num = $db->num_rows($resql);
        $i = 0;

        // There is several pages
        if ($num > $listlimit || $page)
        {
            print_fleche_navigation($page, $_SERVER["PHP_SELF"], $paramurl, ($num > $listlimit), '<li class="pagination"><span>'.$langs->trans("Page").' '.($page+1).'</span></li>');
            print '<div class="clearboth"></div>';
        }
 if ($action != 'edit')
                {
	    print '<div class="div-table-responsive">';
        print '<table class="noborder" width="100%">';
 
        // Title of lines
        print '<tr class="liste_titre">';
        foreach ($fieldlist as $field => $value)
        {
        	if ($fieldlist[$field] == 'entity') continue;
 
            $showfield=1;							  	// By defaut
            
            if ($fieldlist[$field] == 'campo_nome')
		{
			 $showfield=0;	
		}
            $align="left";
            $sortable=1;
            $valuetoshow='';
            $valuetoshow=$langs->trans($fieldlist[$field]);   // try to translate
            $valuetoshow=ucfirst($valuetoshow);   // By defaut
            
            if ($fieldlist[$field]=='campo_texto')          { $valuetoshow=$langs->trans("Name"); }
            
            // Affiche nom du champ
            if ($showfield)
            {
                print "<th align=center style='font:bold arial 14px'>".$valuetoshow."</th>";
            }
        }
		 
       print getTitleFieldOfList('');
       print getTitleFieldOfList('');
        print '</tr>';
}
else
{
     print '<div class="div-table-responsive">';
        print '<table class="noborder" width="100%">';
    }
        if ($num)
        {
            // Lines with values
            
           
            while ($i < $num)
            {
                $obj = $db->fetch_object($resql);
                
               $modulo= $obj->modulo;
               $submodulo=  $obj->submodulo;
               $pagina= $obj->pagina;
               $acao=  $obj->acao;
                     $nome=  $obj->campo_nome;
                     if($obj->campo_nome=='country_id'||$obj->campo_nome=='account_country_id')
                    {
                    $campocountry_id=$obj->valor_padrao;
                    
                    }
                    // Url
                    $rowidcol=$tabrowid[$id];
                    // If rowidcol not defined
                    if (empty($rowidcol) || in_array($id, array(6,7,8,13,17,19,27))) $rowidcol='rowid';
                    $url = $_SERVER["PHP_SELF"].'?rowid='.((! empty($obj->{$rowidcol}) || $obj->{$rowidcol} == '0')?$obj->{$rowidcol}:(! empty($obj->code)?urlencode($obj->code):'')).'&code='.(! empty($obj->code)?urlencode($obj->code):'');
                    if (! empty($paramurl)) $url .= '&'.$paramurl;
                    if (! is_null($withentity)) $url .= '&entity='.$withentity;
                    $url.="&form=".$formulario."";
                    
                print '<tr class="oddeven" id="rowid-'.$obj->rowid.'">';
               
                if ($action == 'edit' && ($rowid == (! empty($obj->rowid)?$obj->rowid:$obj->code)))
                {
                    $tmpaction='edit';
                    $parameters=array('fieldlist'=>$fieldlist, 'tabname'=>$tabname[$id]);
                    $reshook=$hookmanager->executeHooks('editDictionaryFieldlist',$parameters,$obj, $tmpaction);    // Note that $action and $object may have been modified by some hooks
                    $error=$hookmanager->error; $errors=$hookmanager->errors;
             
                    // Show fields
                     
                    
                    if (empty($reshook)) {
                    	$withentity = EditaCampo($fieldlist, $obj, $tabname[$id], 'edit',$campocountry_id,$formulario);
                    }
                    
                    print '<tr><td colspan="3" align="center">';
                    print '<div name="'.(! empty($obj->rowid)?$obj->rowid:$obj->code).'"></div>';
                    print '<input type="hidden" name="page" value="'.dol_escape_htmltag($page).'">';
                    print '<input type="hidden" name="rowid" value="'.dol_escape_htmltag($rowid).'">';
                    if (! is_null($withentity))
                    	print '<input type="hidden" name="entity" value="'.$withentity.'">';
                    print '<input type="submit" class="button" name="actionmodify" value="'.$langs->trans("Modify").'">';
                    print '<input type="submit" class="button" name="actioncancel" value="'.$langs->trans("Cancel").'">';
                    
                      $podedeletar='';
                    $podedeletar=verifica($nome,$campoextra);
                     // Delete link
                     // Delete link
                   // if ($obj->extra>0)
                    {
                          if ($user->admin&&$obj->extra==1&&$podedeletar==''&&($nome!='cabecalho'&&$nome!='rodape')) print '<a class="button"  href="'.$url.'&action=delete">'.$langs->trans("Delete").'</a>';
                        //else print '<a href="#">'.img_delete().'</a>';    // Some dictionary can be edited by other profile than admin
                           }
                    print '</td>';
                }
                elseif ($action != 'edit')
                
                {
	              	$tmpaction = 'view';
                    $parameters=array('fieldlist'=>$fieldlist, 'tabname'=>$tabname[$id]);
                    $reshook=$hookmanager->executeHooks('viewDictionaryFieldlist',$parameters,$obj, $tmpaction);    // Note that $action and $object may have been modified by some hooks

                    $error=$hookmanager->error; $errors=$hookmanager->errors;

                    if (empty($reshook))
                    {
                    	$withentity=null;

                        foreach ($fieldlist as $field => $value)
                        {
                        	//var_dump($fieldlist);
                        	$showfield=1;
                        	$align="left";
                        	$valuetoshow=$obj->{$fieldlist[$field]};

                        	 
                                                          
            if ($fieldlist[$field] == 'situacao')
		{
             
    if($valuetoshow=="0") {$valuetoshow=$langs->trans("Invisivel");}
    elseif($valuetoshow=="1"){ $valuetoshow=$langs->trans("Visivel");  } 
    elseif($valuetoshow=="2") {$valuetoshow=$langs->trans("Desabilitado");   }
    elseif($valuetoshow=="3") {$valuetoshow=$langs->trans("Obrigatorio");   }
	 	 
		}
        
                                                             
      
                               if ($fieldlist[$field] == 'campo_nome')
                            {
                                  print '';
                                  $campo=$valuetoshow;
                            }
                                         
                             elseif($fieldlist[$field] == 'campo_texto')
                            {
                                $valuetoshow=$langs->trans($valuetoshow);
                                
                                $fl = explode('-',$valuetoshow);
						if (is_array($fl))
						{
                            
                             if(count($fl)==4)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1])."-".$langs->trans($fl[2])."-".$langs->trans($fl[3]);
                            }
                            
                            if(count($fl)==3)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1])."-".$langs->trans($fl[2]);
                            }
                              if(count($fl)==2)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1]);
                            }
                            
                             }
                             
                             else
                             {
                                
                               $valuetoshow= $langs->trans($valuetoshow);
                                }
                                
                                  print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.'" style="max-width:150px;" >'.$valuetoshow.($obj->extra=='1'?'<br><font size=-2 color=red>('.$langs->trans("ExtraFields").')</font>':'').'</td>';
                            }
                            
                          elseif($fieldlist[$field] == 'valor_padrao')
                                {
                                     $fieldname='valor_padrao';
                                     
                                    if($campo=='country_id')
                                    {
                                   // print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.'">'.$langs->trans($valuetoshow).'</td>';
                                     
                                      print '<td class="tdoverflowmax200">';
                                         
                                        print $form->select_country((! empty($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:(! empty($obj->country)?$obj->country:'')), $fieldname.$campo, '', 28, 'maxwidth150 maxwidthonsmartphone');
                                        
                                        print "<script> $('#select".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                        print '</td>';
            
                                     
                                    }
                                    elseif($campo=='state_id')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                                    	print $formcompany->select_state($obj->{$fieldlist[$field]},$campocountry_id,$fieldname.$campo);
         
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled');</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                     elseif($campo=='account_state_id')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                                    	print $formcompany->select_state($obj->{$fieldlist[$field]},$campocountry_id,$fieldname.$campo);
         
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled');</script>";
                                          print '</td>';
            
                                     
                                    }
                                     elseif($campo=='client')
                                    {
                            
                                    
                                    	 
          print '<td class="tdoverflowmax200"><select class="flat" id="'.$fieldname.$campo.'"  name="'.$fieldname.$campo.'" >';
            if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS)) print '<option value="2"'.($obj->{$fieldlist[$field]}==2?' selected':'').'>'.$langs->trans('Prospect').'</option>';
            if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS) && empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print '<option value="3"'.($obj->{$fieldlist[$field]}==3?' selected':'').'>'.$langs->trans('ProspectCustomer').'</option>';
            if (empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print '<option value="1"'.($obj->{$fieldlist[$field]}==1?' selected':'').'>'.$langs->trans('Customer').'</option>';
            print '<option value="0"'.($obj->{$fieldlist[$field]}==0?' selected':'').'>'.$langs->trans('NorProspectNorCustomer').'</option>';
            print '</select></td>';
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                      elseif($campo=='fournisseur')
                                    {
                            
                                    print '<td class="tdoverflowmax200">';
                                     print $form->selectarray($fieldname.$campo, array('-1'=>$langs->trans(''),'0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});         
                                    

                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                      elseif($campo=='public')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 if($formulario=='NewLeadOrProject')
                                 {
                           print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('PrivateProject'),'1'=>$langs->trans('SharedProject')),$obj->{$fieldlist[$field]});
                                    }
                                    
                                    else
                                    {
                                print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
                                        }
                               
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    elseif($campo=='no_email')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                     print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                     elseif($campo=='opp_status')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                             print $formproject->selectOpportunityStatus($fieldname.$campo, $obj->{$fieldlist[$field]});
		
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                             
        
        
                                     elseif($campo=='priv')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                     print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans("ContactPublic"),'1'=>$langs->trans("ContactPrivate")),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                        
                        
                        
                                    elseif($campo=='contcats')
                                    {
                                    print '<td class="tdoverflowmax200">';
                                    $cat=explode(',',$obj->{$fieldlist[$field]});
                                    $cate_arbo = $form->select_all_categories( Categorie::TYPE_CONTACT, null, 'parent', null, null, 1 );
                                    print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, null, null, null,
                                    null, '90%' );
                                        print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                 
                                    print '</td>';
                                    
                                    
                                    }
                                    
                                    
                                    
                                     elseif($campo=='fk_parent')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                       
                print $formproduct->selectWarehouses($obj->{$fieldlist[$field]}, $fieldname.$campo, '',1,1);
                             print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    } 
                                    elseif($campo=='birthday_alert')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    if (!empty($obj->{$fieldlist[$field]})) {
                                    $checked=' checked value="1" ';
                                    } else {
                                    $checked=' value="1" ';
                                    }
                                    $moreparam='';
                                    
                                    $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="'.$fieldname.$campo.'" '.$checked.' '.($moreparam?$moreparam:'').'>';
                                    print  $out;
                                    
                                    print '</td>';
                                    
                                    
                                    }
                                    elseif($campo=='fullday')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    if (!empty($obj->{$fieldlist[$field]})) {
                                    $checked=' checked value="1" ';
                                    } else {
                                    $checked=' value="1" ';
                                    }
                                    $moreparam='';
                                    
                                    $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="'.$fieldname.$campo.'" '.$checked.' '.($moreparam?$moreparam:'').'>';
                                    print  $out;
                                    
                                    print '</td>';
                                    
                                    
                                    }
                                    
                                    elseif($campo=='aphour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                    elseif($campo=='p2hour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                    
                                       elseif($campo=='dateohour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                       elseif($campo=='dateehour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                    
                                    
                                  elseif($campo=='p2min')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
             
                                    
                                    
                                    }
                                    elseif($campo=='apmin')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
             
                                    
                                    
                                    }
                                    
                                         
                                  elseif($campo=='dateomin')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
             
                                    
                                    
                                    }
                                    
                                     elseif($campo=='dateemin')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
             
                                    
                                    
                                    }
                                       elseif($campo=='complete')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                
                                     $formactions->form_select_status_action('formaction', $obj->{$fieldlist[$field]}, 1, $fieldname.$campo, 0, 0, 'maxwidth200');
	
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                       elseif($campo=='assignedtouser')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                       elseif($campo=='progress')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                                 	print $formother->select_percent($obj->{$fieldlist[$field]},$fieldname.$campo,0,5,0,100,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
	
                                    
                                       elseif($campo=='userid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                         elseif($campo=='typeid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                  $listetype=$adht->liste_array();
		print $form->selectarray( $fieldname.$campo, $listetype,$obj->{$fieldlist[$field]}, count($listetype)>1?1:0);
        
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                       elseif($campo=='subscription')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                   
                                   	$statutarray=array('0' => $langs->trans("No"), '1' => $langs->trans("Yes"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                               
                               
                    
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                       elseif($campo=='commercial_suivi_id')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                       elseif($campo=='commercial_signature_id')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                    
                                       elseif($campo=='contratid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                   
                                                   
                                
                          $formcontract->formSelectContract('', -1, $obj->{$fieldlist[$field]}, $fieldname.$campo, 0, 1);            
                               
                  
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
       print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                  
                                          print '</td>';
            
                                     
                                    }
                    
         
                                    
                                       elseif($campo=='vote')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                             	   	$statutarray=array('0' => $langs->trans("No"), '1' => $langs->trans("Yes"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                               
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                      
                         elseif($campo=='morphy')
                                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 
        $morphys["phy"] = $langs->trans("Physical");
		$morphys["mor"] = $langs->trans("Moral");
		 print $form->selectarray($fieldname.$campo, $morphys, $obj->{$fieldlist[$field]}, 1);
	
    
      print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
    
        
                                            print '</td>';
            
                                     
                                    }
                                    
                                     elseif($campo=='memcats')
                                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                    
                                          
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_MEMBER, '', 'parent', 64, 0, 1);
                                        
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			                     print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, '', 0, '', 0, '100%');
            
               print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
    
    
                                            print '</td>';
            
                                     
                                    }
 
                                    
                              elseif($campo=='socpeopleassigned')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
                                   print $form->selectcontacts('', $cat, $fieldname.$campo, 0, '', '', 0, 'quatrevingtpercent', false, 0, array(), false, 'multiple', 'contactid');
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
    
    elseif($campo=='taskid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                       $formproject->selectTasks(-1, $obj->{$fieldlist[$field]}, $fieldname.$campo, 24, 0, '1', 1, 0, 0, 'maxwidth500',$projectsListId);
		
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
    
      elseif($campo=='fk_user_author')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
          elseif($campo=='fk_user_validator')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
    
    
    
        elseif($campo=='admin')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('0' => $langs->trans("Yes"), '1' => $langs->trans("No"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
  
    
        elseif($campo=='gender')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('-1' => '','man' => $langs->trans("Genderman"), 'woman' => $langs->trans("Genderwoman"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
    elseif($campo=='employee')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('0' => $langs->trans("Yes"), '1' => $langs->trans("No"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
  elseif($campo=='fk_user')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
  
  
           elseif($campo=='usercats')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 
                                        
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_USER, '', 'parent', 64, 0, 1);
                                        
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, '', 0, '', 0, '100%');
			print "<script> $('select[id=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }  
   
  
                                           elseif($campo=='statut')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 if($formulario=='NewWarehouse')
                                 {
                                   $statutarray=array('1' => $langs->trans("Open"), '0' => $langs->trans("Closed"));
                                   
                                   }
                                   else
                                   {
                                     $statutarray=array('1' => $langs->trans("OnSell"), '0' => $langs->trans("NotOnSell"));
                                  
                                    }
   
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                           elseif($campo=='statut_buy')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 $statutarray=array('1' => $langs->trans("ProductStatusOnBuy"), '0' => $langs->trans("ProductStatusNotOnBuy"));
        
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
 
                                            elseif($campo=='actioncode')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                           
                    $formactions->select_type_actions($obj->{$fieldlist[$field]}, $fieldname.$campo, "systemauto", 0, -1);
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                             elseif($campo=='status_batch')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('0' => $langs->trans("ProductStatusNotOnBatch"), '1' => $langs->trans("ProductStatusOnBatch"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                             elseif($campo=='fk_barcode_type')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
 
 
			if(!function_exists('selectBarcodeType'))
			{
            print $formbarcode->select_barcode_type($obj->{$fieldlist[$field]}, $fieldname.$campo, 1);
			}
			else
			{
            print $formbarcode->selectBarcodeType($obj->{$fieldlist[$field]}, $fieldname.$campo, 1);
			}
				
				
                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                             elseif($campo=='fk_default_warehouse')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                       
                print $formproduct->selectWarehouses($obj->{$fieldlist[$field]}, $fieldname.$campo, '',1,1);
                             print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }                                    
                                    
                                             elseif($campo=='finished')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 $statutarray=array('-1' => '','1' => $langs->trans("Finished"), '0' => $langs->trans("RowMaterial"));
           
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                              elseif($campo=='duration_unit')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                     
print '      <input  name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="i"?'checked':'').'  type="radio" value="i">&nbsp;'.$langs->trans("Minute").'&nbsp;';
print '<input name="'.$fieldname.$campo.'" type="radio"  '.($obj->{$fieldlist[$field]}=="h"?'checked':'').'  value="h">&nbsp;'.$langs->trans("Hour").'&nbsp;';
print '<input name="'.$fieldname.$campo.'" '.($obj->{$fieldlist[$field]}=="d"?'checked':'').' type="radio" value="d">&nbsp;'.$langs->trans("Day").'&nbsp;<br>';
print '<input name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="w"?'checked':'').' type="radio" value="w">&nbsp;'.$langs->trans("Week").'&nbsp;';
print '<input name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="m"?'checked':'').' type="radio" value="m">&nbsp;'.$langs->trans("Month").'&nbsp;';
print '<input name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="y"?'checked':'').' type="radio" value="y">&nbsp;'.$langs->trans("Year").'&nbsp;';
print '</td>';
            
                                    print "<script> $('input[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                     
                                    }
                                    
                                       elseif($campo=='size_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"size",$obj->{$fieldlist[$field]} );
                               print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }           
                                    
                                        elseif($campo=='weight_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"weight",$obj->{$fieldlist[$field]} );
                               print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }       
                                         elseif($campo=='surface_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"surface",$obj->{$fieldlist[$field]} );
                               print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                        elseif($campo=='volume_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"volume",$obj->{$fieldlist[$field]} );
                               print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }       
                                    
                                        elseif($campo=='categories')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 if($formulario=='NewFinancialAccount')
                                 {
                                    
                                   $cate_arbo = $form->select_all_categories(Categorie::TYPE_ACCOUNT, '', 'parent', 64, 0, 1);
		 
                                    }
                                     elseif($formulario=='NewLeadOrProject')
                                 {
                                    
                                   $cate_arbo = $form->select_all_categories(Categorie::TYPE_PROJECT, '', 'parent', 64, 0, 1);
		 
                                    }
                                    else
                                    {
                                        
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_PRODUCT, '', 'parent', 64, 0, 1);
                                        }
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, '', 0, '', 0, '100%');
			print "<script> $('select[id=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }    
                                    
                                    
                                    
                                     elseif($campo=='tva_tx')
                                                            {
                                                    
                                                         print '<td class="tdoverflowmax200">';
                                     print $form->load_tva($fieldname.$campo, $obj->{$fieldlist[$field]}, $mysoc, $mysoc, 0, 0, '', false, 1);
                                        print "<script> $('select[id=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                                                  print '</td>';
                                    
                                                             
                                                            }
                                                            
                                    
                                    
                                     elseif($campo=='price_base_type')
                                                            {
                                                    
                                                         print '<td class="tdoverflowmax200">';
                                       print $form->selectPriceBaseType($object->price_base_type, $fieldname.$campo);
           
                                        print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                                                  print '</td>';
                                    
                                                             
                                                            }
                                                            
                                                                                                                        
           
            
             
             
                                           elseif($campo=='status')
                                    {
                            print '<td class="tdoverflowmax200">';
                                       print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('ActivityCeased'),'1'=>$langs->trans('InActivity')),$obj->{$fieldlist[$field]});
       
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
              
              
                                           elseif($campo=='clos')
                                    {
                            print '<td class="tdoverflowmax200">';
                                       print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('StatusAccountOpened'),'1'=>$langs->trans('StatusAccountClosed')),$obj->{$fieldlist[$field]});
       
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    elseif($campo=='assujtva_value')
                                    {
                            
                                    print '<td class="tdoverflowmax200">';
                                     print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});                          
        
       
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
              
                                     elseif($campo=='typent_id')
                                    {
                            
                                      print '<td class="tdoverflowmax200">';
                                print $form->selectarray($fieldname.$campo,$formcompany->typent_array(0), $obj->{$fieldlist[$field]}, 0, 0, 0, '', 0, 0, 0, (empty($conf->global->SOCIETE_SORT_ON_TYPEENT)?'ASC':$conf->global->SOCIETE_SORT_ON_TYPEENT));
       
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                 
                                  elseif($campo=='effectif_id')
                                    {
                            
                                      print '<td class="tdoverflowmax200">';
                               print $form->selectarray($fieldname.$campo,$formcompany->effectif_array(0), $obj->{$fieldlist[$field]});
          
       
                                     print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                 
                                    elseif ($campo == 'forme_juridique_code')
                                    {
                                            print '<td class="tdoverflowmax100">';
                                            
                                            $tmparray=getCountry($campocountry_id,'all');
	            	                       $lang_pad=$tmparray['code'];
                                           if ($lang_pad)
                                        {
                                       print $formcompany->select_juridicalstatus($obj->{$fieldlist[$field]}, $lang_pad, '',  $fieldname.$campo);
                                                      print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                                              
                                         }
                                        else
                                        {
                                            print $countrynotdefined;
                                        }
                                            
                                 
                                          print '</td>';
                                        }
            
                                    elseif ($campo == 'default_lang')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                           print $formadmin->select_language(($obj->{$fieldlist[$field]}?$obj->{$fieldlist[$field]}:''), $fieldname.$campo, 0, 0, 1, 0, 0, 'maxwidth200onsmartphone');
                                           print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                 
                                          print '</td>';
                                        }

                                    elseif ($campo == 'incoterm_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            print $form->select_incoterms($obj->{$fieldlist[$field]});
                                           print "<script> $('select#incoterm_id').prop('disabled',true).addClass('disabled')</script>";
                                   print "<script> $('input#location_incoterms').remove();</script>";
                                 
                                 
                                          print '</td>';
                                        }

                               elseif ($campo == 'custcats')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                               $cat=explode(',',$obj->{$fieldlist[$field]});
               $cate_arbo = $form->select_all_categories(Categorie::TYPE_CUSTOMER, null, 'parent', null, null, 1);
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, null, null, null, null, "90%");
			
                                                print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                                        
                                          elseif ($campo == 'suppcats')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                               $cat=explode(',',$obj->{$fieldlist[$field]});
               $cate_arbo = $form->select_all_categories(Categorie::TYPE_SUPPLIER, null, 'parent', null, null, 1);
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, null, null, null, null, "90%");
			
                                                print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                              
                                   
                                                elseif ($campo == 'multicurrency_code')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            print $form->selectMultiCurrency(($obj->{$fieldlist[$field]} ? $obj->{$fieldlist[$field]} : $conf->currency), $fieldname.$campo, 1);
			  
                                  
                                                print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
          
          
          
          
                                       elseif ($campo == 'commercial')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         $userlist = $form->select_dolusers('', '', 0, null, 0, '', '', 0, 0, 0, '', 0, '', '', 0, 1);
                                         
                                         $selected=explode(',',$obj->{$fieldlist[$field]});
        
                                              print $form->multiselectarray($fieldname.$campo, $userlist, $selected, null, null, null, null, "90%");    
                                  
			   
                                                print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
            
            
                                       elseif ($campo == 'socid')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                          	print $form->select_company($obj->{$fieldlist[$field]}, $fieldname.$campo, '(s.client = 1 OR s.client = 2 OR s.client = 3) AND status=1', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');
			   
                                                print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
             
             
                                       elseif ($campo == 'cond_reglement_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->select_conditions_paiements($obj->{$fieldlist[$field]},$fieldname.$campo);

			   
                                                print "<script> $('select#".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                                                  elseif ($campo == 'mode_reglement_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->select_types_paiements($obj->{$fieldlist[$field]},$fieldname.$campo);

			   
                                                print "<script> $('select#select".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                           
                                      elseif ($campo == 'fk_account')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->select_comptes($obj->{$fieldlist[$field]},$fieldname.$campo);

			   
                                                print "<script> $('select#select".$fieldname.$campo."').prop('disabled',true).addClass('disabled')</script>";
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                                        
                                      elseif ($campo == 'demand_reason_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->selectInputReason($obj->{$fieldlist[$field]},$fieldname.$campo,$fieldname.$campo);

			   
                                              print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                               
               
                                      elseif ($campo == 'availability_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->selectAvailabilityDelay($obj->{$fieldlist[$field]},$fieldname.$campo,$fieldname.$campo);

			   
                                              print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                                
                                      elseif ($campo == 'shipping_method_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	$form->selectShippingMethod($obj->{$fieldlist[$field]},'shipping_method_id');

			   
                                              print "<script> $('select[name=shipping_method_id]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                          print '</td>';
                                        }
                                        
                                  elseif ($campo == 'projectid')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	$formproject->select_projects(-1,$obj->{$fieldlist[$field]},$fieldname.$campo, 1, 0, 1, 1);
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                           print '</td>';
                                        }
                                         elseif ($campo == 'fk_project')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	$formproject->select_projects(-1,$obj->{$fieldlist[$field]},$fieldname.$campo, 1, 0, 1, 1);
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                           print '</td>';
                                        }
                                        
                                        elseif ($campo == 'accountid')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                          
                                             $form->select_comptes($obj->{$fieldlist[$field]},$fieldname.$campo,0,'',1);  // Affiche liste des comptes courant
                                             
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                           print '</td>';
                                        }
                                             elseif ($campo == 'paymenttype')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             	$form->select_types_paiements($obj->{$fieldlist[$field]}, $fieldname.$campo, '', 2);
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                           print '</td>';
                                        }
	                                             elseif ($campo == 'modepayment')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                              
                                                $form->select_types_paiements($obj->{$fieldlist[$field]}, $fieldname.$campo, 'CRDT', 0, 1);
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                           print '</td>';
                                        }
	
                   elseif ($campo == 'task_parent')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                              
                                        
    print $formother->selectProjectTasks($obj->{$fieldlist[$field]}, '', $fieldname.$campo, 0, 0, 1, 1, 0, '0,1', 'maxwidth500');
		
    
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                           print '</td>';
                                        }
	

    
                                   elseif ($campo == 'model')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	if($formulario=='NewProp-Customer')
                                            {
                                         require_once DOL_DOCUMENT_ROOT . '/core/modules/propale/modules_propale.php';
                                        $liste = ModelePDFPropales::liste_modeles($db);
                                            }
                                               elseif($formulario=='NewOrder-Customer')
                                            {
                                             require_once DOL_DOCUMENT_ROOT . '/core/modules/commande/modules_commande.php';
                                        $liste = ModelePDFCommandes::liste_modeles($db);
                                            }
                                             elseif($formulario=='NewAskPrice')
                                            {
                                          require_once DOL_DOCUMENT_ROOT . '/core/modules/supplier_proposal/modules_supplier_proposal.php';
                                        $liste = ModelePDFSupplierProposal::liste_modeles($db);
                                            }
                                              elseif($formulario=='NewBill-Customer')
                                            {
                                          require_once DOL_DOCUMENT_ROOT . '/core/modules/facture/modules_facture.php';
                                        $liste = ModelePDFFactures::liste_modeles($db);
                                            }
                                          
                                          print $form->selectarray($fieldname.$campo, $liste, $obj->{$fieldlist[$field]});
                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                               print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                               
                                          print '</td>';
                                        }                                       
                          
                                        elseif ($campo == 'type')
                                        {
                                        print '<td class="tdoverflowmax200">';
                                        
                                        
                                        if($formulario=='NewFinancialAccount')
                                        {
                                        
                                        print  $formbank->selectTypeOfBankAccount($obj->{$fieldlist[$field]},$fieldname.$campo);
                                        
                                        
                                        }
                                        
                                        else
                                        {
                                        
                                        
                                        $arraylist = array('0' => $langs->transnoentitiesnoconv('InvoiceStandardAsk'),'1' => $langs->transnoentitiesnoconv('InvoiceReplacementAsk'),'2' => $langs->transnoentitiesnoconv('InvoiceAvoirAsk'), '3' => $langs->transnoentitiesnoconv('InvoiceDeposit'));
                                        print $form->selectarray($fieldname.$campo, $arraylist, $obj->{$fieldlist[$field]});
                                        }
                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                        print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                      
                                        print '</td>';
                                        }
                                        
                                        
                                         elseif ($campo == 'account_currency_code')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             
                                              $selectedcode=$obj->{$fieldlist[$field]};
                                            if (! $selectedcode) $selectedcode=$conf->currency;
                                            print $form->selectCurrency($selectedcode, $fieldname.$campo);
                                             
     
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                   // print "<script> $('spam.".$fieldname.$campo."').css.maxWidth('200px')</script>";
                                          print '</td>';
                                        }
                                        
                                        
                                          elseif ($campo == 'account_country_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             
                                              $selectedcode=$obj->{$fieldlist[$field]};
                                            if (! $selectedcode) $selectedcode=$mysoc->country_code;
                                            print $form->select_country($selectedcode, $fieldname.$campo);
                                             
     
 	                                          print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('100%')</script>";
                                   // print "<script> $('spam.".$fieldname.$campo."').css.maxWidth('200px')</script>";
                                          print '</td>';
                                        }
                                         
                                        
                                          elseif ($campo == 'civility_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      print 	 $formcompany->select_civility($obj->{$fieldlist[$field]},$fieldname.$campo, 'maxwidth200');

			   
                                print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('200px');</script>";
                                          print '</td>';
                                        }
                                        
               
             
                                    else
                                    {
                                        if($obj->extra==='0')
                                        {
                                    print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150"><input disabled type="text" class="flat minwidth200" value="'.$langs->trans($valuetoshow).'" ></td>';
                                    }
                                    else
                                    {
                                        
                                        if($obj->campo_tipo==='select')
                                        {
                                           
                                        $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                     //$extrafields->attributes[$campoextra]['type'][$key]  ;
                                     
                                        print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                        $out='<select class="flat minwidth200  maxwidthonsmartphone" name="'. $fieldname.$campo.'" id="'. $fieldname.$campo.'" '.($moreparam?$moreparam:'').'>';
                                        $out.='<option value="0">&nbsp;</option>';
                                            foreach ($param['options'] as $key => $val)
                                            {
                                            if ((string) $key == '') continue;
                                            list($val, $parent) = explode('|', $val);
                                            $out.='<option value="'.$key.'"';
                                            $out.= (((string) $obj->{$fieldlist[$field]} == (string) $key)?' selected':'');
                                            $out.= (!empty($parent)?' parent="'.$parent.'"':'');
                                            $out.='>';
                                            if ($langfile && $val) $out.=$langs->trans($val);
                                            else $out.=$val;
                                            $out.='</option>';
                                            }
                                        $out.='</select>';
                                        
                                       print  $out;
                                         print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
                              
                                         }
                                         
                                          elseif($obj->campo_tipo==='link')
                                          {
                                            $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                            
                                         	$param_list=array_keys($param['options']);				// $param_list='ObjectName:classPath'
                                            $showempty=(($required && $default != '')?0:1);
                                            $out=$form->selectForForms($param_list[0], $fieldname.$campo, $obj->{$fieldlist[$field]}, $showempty,'','','minwidth200');
                                              print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                             print  $out;
                                               print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
                              
                                           }
                                           
                                          elseif($obj->campo_tipo==='sellist')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                        
                                     //$extrafields->attributes[$campoextra]['type'][$key]  ;
                                     
                                        print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                        
			$out='<select class="flat" style="max-width:200px" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" '.($moreparam?$moreparam:'').'>';
			 $out.=buscalist($param['options'],$obj->{$fieldlist[$field]});
			$out.='</select>';
                                        
                                       print  $out;
                                         print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
                              
                                         }
                                         elseif($obj->campo_tipo==='radio')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                               print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                     $out='';
			foreach ($param['options'] as $keyopt => $val)
			{
				$out.='<input disabled class="flat '.$morecss.'" type="radio" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" '.($moreparam?$moreparam:'');
				$out.=' value="'.$keyopt.'"';
				$out.=' id="'.$fieldlist[$field].'_'.$keyopt.'"';
				$out.= ($obj->{$fieldlist[$field]}==$keyopt?'checked':'');
				$out.='/><label for="'.$fieldlist[$field].'_'.$keyopt.'">'.$val.'</label><br>';
			}
                                        
                                       print  $out;
                                 
                              
                                         }
                                         elseif($obj->campo_tipo==='checkbox')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                            
                               print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                     $out='';
                               
                               $value_arr=explode(',',$obj->{$fieldlist[$field]});
			$out=$form->multiselectarray($fieldname.$campo, (empty($param['options'])?null:$param['options']), $value_arr, '', 0, '', 0, '100%');
                                          print  $out;
                                    print "<script> $('select[id=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
                              
                                         }
                                         
                                          elseif($obj->campo_tipo==='chkbxlst')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                       
                                     
                                        print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                     $value= $obj->{$fieldlist[$field]} ;
			 if (is_array($value)) {
				$value_arr = $value;
			}
			else {
				$value_arr = explode(',', $value);
			}
            
			 $data=buscalistCh($param['options'],$obj->{$fieldlist[$field]});
			 
                         $out=$form->multiselectarray($fieldname.$campo, $data, $value_arr, '', 0, '', 0, '100%');
                                          
                                        
                                       print  $out;
                                         print "<script> $('select[id=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
                              
                                         }
                                          
                                          elseif($obj->campo_tipo==='boolean')
                                        {
                                             
                                     
                                             if (!empty($obj->{$fieldlist[$field]})) {
                                                    $checked=' checked value="1" ';
                                                } else {
                                                    $checked=' value="1" ';
                                                }
            $moreparam='disabled';
                               print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                  $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" '.$checked.' '.($moreparam?$moreparam:'').'>';
			                                print  $out;
                                 
                                         }
                                                
                                          elseif($obj->campo_tipo==='password')
                                        {
                                             
                                     $moreparam='disabled'; 
  print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                         	$out='<input   type="password" class="flat '.$morecss.'" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" value="'.$obj->{$fieldlist[$field]}.'" '.($moreparam?$moreparam:'').'>';
			                                print  $out;
                                 
                                         }
                                         
                                             
                                        else
                                        {
                                         print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150"><input disabled  type="text" class="flat minwidth200" name="'.$fieldname.$campo.'"  value="'.$langs->trans($valuetoshow).'" ></td>';
                                         }
                                         
                                         
                                    }
                                    }
                                 }
                                  elseif($fieldlist[$field] == 'situacao')
                                {
                                    print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax50"><input disabled type="text" class="flat " value="'.$langs->trans($valuetoshow).'" ></td>';
                                    }
                            
                            
                            
                              
                                    
           // Show value for field
							elseif ($showfield)   print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax200"><textarea disabled type="text" class="flat "  >'.$langs->trans($valuetoshow).'</textarea></td>';
                        }
                    }

                    // Can an entry be erased or disabled ?
                    $iserasable=1;$canbedisabled=1;$canbemodified=1;	// true by default
                    if (isset($obj->code) && $id != 10)
                    {
                    	if (($obj->code == '0' || $obj->code == '' || preg_match('/unknown/i',$obj->code))) { $iserasable = 0; $canbedisabled = 0; }
                    	else if ($obj->code == 'RECEP') { $iserasable = 0; $canbedisabled = 0; }
                    	else if ($obj->code == 'EF0')   { $iserasable = 0; $canbedisabled = 0; }
                    }

                    if (isset($obj->type) && in_array($obj->type, array('system', 'systemauto'))) { $iserasable=0; }
                    if (in_array($obj->code, array('AC_OTH','AC_OTH_AUTO')) || in_array($obj->type, array('systemauto'))) { $canbedisabled=0; $canbedisabled = 0; }
                    $canbemodified=$iserasable;
                    if ($obj->code == 'RECEP') $canbemodified=1;
                    if ($tabname[$id] == MAIN_DB_PREFIX."c_actioncomm") $canbemodified=1;

                    // Url
                    $rowidcol=$tabrowid[$id];
                    // If rowidcol not defined
                    if (empty($rowidcol) || in_array($id, array(6,7,8,13,17,19,27))) $rowidcol='rowid';
                    $url = $_SERVER["PHP_SELF"].'?rowid='.((! empty($obj->{$rowidcol}) || $obj->{$rowidcol} == '0')?$obj->{$rowidcol}:(! empty($obj->code)?urlencode($obj->code):''));
                    if (! empty($paramurl)) $url .= '&'.$paramurl;
                    if (! is_null($withentity)) $url .= '&entity='.$withentity;
                     
                    $url.="&";
			 
                    // Modify link
                    if ($canbemodified) print '<td align="center"><a class="reposition" href="'.$url.'action=edit">'.img_edit().'</a></td>';
                    
                   

                    print "</tr>\n";
                }
                $i++;
            }
        }

        print '</table>';
        print '</div>';
    }
    else {
        dol_print_error($db);
    }

if($campoextra!='')
{
$extra = "SELECT m.name, m.elementtype, m.label, m.type, m.rowid FROM ".MAIN_DB_PREFIX."extrafields as m where m.elementtype='".$campoextra."' order by m.rowid";

$result=$db->query($extra);
		if ($result)
		{
            while ($obj = $db->fetch_object($result)) {
                
              if($submodulo!=''&&$pagina!=''&&$acao!='')
    
    {
                $sqlinsert = "INSERT IGNORE INTO `".MAIN_DB_PREFIX."customizeforms` (`rowid`, `modulo`, `submodulo`, `pagina`, `acao`, `campo_nome`, `campo_tipo`, `campo_texto`,`form_nome`, `campo_pos`,`situacao`,`extra`) VALUES (NULL, '".$modulo."', '".$submodulo."', '".$pagina."', '".$acao."',  '".$obj->name."', '".$obj->type."', '".$obj->label."', '".$formulario."', '0', '1', '1');";

      //  echo $sqlinsert."<br>";
                
    	 $result2=$db->query($sqlinsert);
      }   
         
if ($result2)
{
    	$num2 = $db->affected_rows($result2);
        
        if($num2>0)
        {
             setEventMessages($langs->trans("AutomaticCreation").' - '.$langs->trans("RecordCreatedSuccessfully").' - '.$obj->label.' - '.$langs->trans("ExtraFields"), null, 'mesgs');
             
             print '<script>window.location.href=window.location.href</script>';
       
           }
//        
                          
				}
        }
         
           
        }
    
}
   

    print '</form>';
}
 

print '<br>';

// End of page
llxFooter(); 
$db->close();


/**
 *	Show fields in insert/edit mode
 *
 * 	@param		array		$fieldlist		Array of fields
 * 	@param		Object		$obj			If we show a particular record, obj is filled with record fields
 *  @param		string		$tabname		Name of SQL table
 *  @param		string		$context		'add'=Output field for the "add form", 'edit'=Output field for the "edit form", 'hide'=Output field for the "add form" but we dont want it to be rendered
 *	@return		string						'' or value of entity into table
 */
function EditaCampo($fieldlist, $obj='', $tabname='', $context='',$campocountry_id,$formulario)
{
    
   //print_r($fieldlist);
   
  
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/html.formproduct.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/product.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formbank.class.php';

require_once DOL_DOCUMENT_ROOT . '/compta/bank/class/account.class.php';
 require_once DOL_DOCUMENT_ROOT.'/core/class/html.formactions.class.php';
 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent_type.class.php';

require_once DOL_DOCUMENT_ROOT."/core/class/html.formcontract.class.php";
	require_once DOL_DOCUMENT_ROOT."/contrat/class/contrat.class.php";
     



	global $conf,$langs,$db,$form;
    
    

$adht = new AdherentType($db);


$formcontract= new Formcontract($db);

$formproject = new FormProjets($db);  
	  
 $formproduct=new FormProduct($db);
$formbank = new FormBank($db);
$formactions = new FormActions($db);
$formother=new FormOther($db);
 
if(!function_exists('loadLangs'))
			{
                
$langs->load("customizeforms@customizeforms");$langs->load("errors");$langs->load("admin");$langs->load("members");$langs->load("install");$langs->load("exports");$langs->load("banks");$langs->load("users");$langs->load("withdrawals");$langs->load("agenda");$langs->load("boxes");$langs->load("supplier_proposal");$langs->load("suppliers");$langs->load("compta");$langs->load("salaries");$langs->load("commercial");$langs->load("companies");$langs->load("donations");$langs->load("mails");$langs->load("resource");$langs->load("holiday");$langs->load("accountancy");$langs->load("hrm");$langs->load("orders");$langs->load("contracts");$langs->load("projects");$langs->load("propal");$langs->load("bills");$langs->load("interventions");$langs->load("sendings");$langs->load("deliveries");$langs->load("products");$langs->load("stocks");$langs->load("productbatch");
         }
			else
			{
           $langs->loadLangs(array("errors","admin","main","members","salaries","install","exports","banks","users","withdrawals","agenda","boxes","loan","trips","supplier_proposal","printing","sendings","ecm","dict","suppliers","compta","salaries","commercial","companies","donations", "mails","resource","holiday","accountancy","hrm","orders","contracts","projects","propal","bills","interventions","sendings","deliveries","products","other","customizeforms@customizeforms","stocks","productbatch"));
			}
            

      $campoextra='';
    if($formulario=='NewProp-Customer'){$campoextra='propal';}
elseif($formulario=='NewOrder-Customer'){$campoextra='commande';}
elseif($formulario=='NewOrder-Supplier'){$campoextra='commande_fournisseur';}
elseif($formulario=='NewBill-Supplier'){$campoextra='facture_fourn';}
elseif($formulario=='NewAskPrice'){$campoextra='supplier_proposal';}
elseif($formulario=='NewBill-Customer'){$campoextra='facture';}
elseif($formulario=='NewThirdParty'){$campoextra='societe';}
elseif($formulario=='AddContact'){$campoextra='socpeople';}
elseif($formulario=='NewProduct-NewService'){$campoextra='product';}
elseif($formulario=='NewWarehouse'){$campoextra='';}
elseif($formulario=='NewFinancialAccount'){$campoextra='bank_account';}
elseif($formulario=='NewLeadOrProject'){$campoextra='projet';}
elseif($formulario=='NewAction'){$campoextra='actioncomm';}
elseif($formulario=='ExpenseReport-Card'){$campoextra='expensereport';}
elseif($formulario=='NewMailing'){$campoextra='';}
elseif($formulario=='NewUser'){$campoextra='user';}
elseif($formulario=='NewGroup'){$campoextra='usergroup';}
elseif($formulario=='SalaryPayment'){$campoextra='';}
elseif($formulario=='AddDonation'){$campoextra='don';}
elseif($formulario=='NewTask'){$campoextra='projet_task';}
elseif($formulario=='NewMember'){$campoextra='adherent';}
elseif($formulario=='NewMemberType'){$campoextra='adherent_type';}
elseif($formulario=='AddIntervention'){$campoextra='fichinter';}
elseif($formulario=='AddContract'){$campoextra='contrat';}



$extrafields = new ExtraFields($db);

// fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label($campoextra);

  $countrynotdefined=$langs->trans("ErrorSetACountryFirst").' ('.$langs->trans("SeeAbove").')';

	$formadmin = new FormAdmin($db);
	$formcompany = new FormCompany($db);
    if (! empty($conf->projet->enabled)) { $formproject = new FormProjets($db); }

	if (! empty($conf->accounting->enabled)) $formaccounting = new FormAccounting($db);

	$withentity='';

	foreach ($fieldlist as $field => $value)
	{
       
        
        if ($fieldlist[$field] == 'campo_nome')
        {
        
        $temp_nome=$obj->{$fieldlist[$field]};
        
        }
        
        
        if ($fieldlist[$field] == 'campo_texto')
        {
            $valuetoshow=$langs->trans($obj->{$fieldlist[$field]});
                $fl = explode('-',$obj->{$fieldlist[$field]});
						if (is_array($fl))
						{
                            if(count($fl)==3)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1])."-".$langs->trans($fl[2]);
                            }
                              if(count($fl)==2)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1]);
                            }
                            
                             }
            
        print '   <tr><th style="border-bottom:solid 1px #ccc; font:bold " colspan=5>'.$langs->trans("EditarCampo").' - '.$valuetoshow;
         $nomedocampo=$temp_nome;
        }
        if ($fieldlist[$field] == 'situacao')
        {
        print '<tr><td width=200 style="font:bold 14px arial" align=center>'.$langs->trans("DefinirVisibilidade").'&nbsp;&nbsp;<span class="fa fa-question-circle atoplogin classfortooltip"  title="<center><table border=1 cellspacing=0 cellpadding=5 width=100%><tr><th>'.$langs->trans("NovoValor").'<th>'.$langs->trans("Aparencia").'<tr><td>'.$langs->trans("Invisivel").'<td>&nbsp;<tr><td>'.$langs->trans("Visivel").'<td><textarea      name=teste></textarea><tr><td>'.$langs->trans("Desabilitado").'<td><textarea  disabled   ></textarea><tr><td><strong>'.$langs->trans("Obrigatorio").'</strong><td><textarea      ></textarea></table>" ></span></th>';
        }
        if ($fieldlist[$field] == 'valor_padrao')
        {
        print '<tr><td width=200 style="font:bold 14px arial" align=center>'.$langs->trans("DefinirValorPadrao").'&nbsp;&nbsp;<span class="fa fa-question-circle atoplogin classfortooltip"  title="<center>'.$langs->trans("DefinirValorPadraoAjuda").' "></span></th>';
        }       
        if ($fieldlist[$field] == 'label')
        {
        print '<tr><td width=200 style="font:bold 14px arial" align=center>'.$langs->trans("ModificarNomedoCampo").'&nbsp;&nbsp;<span class="fa fa-question-circle atoplogin classfortooltip"  title="<center><table border=1 cellspacing=0 cellpadding=5 width=100%><tr><th>'.$langs->trans("NovoValor").'<th>'.$langs->trans("Aparencia").'<tr><td>'.$langs->trans("NovoNome").' <td><label>'.$langs->trans("NovoNome").'</label><input name=teste11 class=flat ></table>" ></span></th>';
        }           
        if ($fieldlist[$field] == 'conteudo')
        {
        print '<tr><td width=200 style="font:bold 14px arial" align=center>'.$langs->trans("CriarListaAuxiliar").'&nbsp;&nbsp;<span class="fa fa-question-circle atoplogin classfortooltip"  title="<center><table border=1 cellspacing=0 cellpadding=5 width=100%><tr><th>'.$langs->trans("NovoValor").'<th>'.$langs->trans("Aparencia").'<tr> <td><textarea      name=teste>Cachoeira do Sul
       Porto Alegre</textarea><td> <select class=\'maxwidthsearch\' style=\'background-color:#ffebcc\' name=teste><option value=\'Cachoeira do Sul\'>Cachoeira do Sul</option><option value=\'Porto Alegre\'>Porto Alegre</option></select><br> <input name=teste11 class=flat > </table>" ></span></th>';
        } 
        if ($fieldlist[$field] == 'tooltip')
        {
        print '<tr><td width=200 style="font:bold 14px arial" align=center>'.$langs->trans("CriarTooltipdeAjuda").'&nbsp;&nbsp;<span class="fa fa-question-circle atoplogin classfortooltip"  title="<center><table border=1 cellspacing=0 cellpadding=5 width=100%><tr><th>'.$langs->trans("NovoValor").'<th>'.$langs->trans("Aparencia").'<tr><td width=50%><textarea style=\'width:95%;height:200px;\'><table border=1><tr> <th colspan=2>Tooltip '.$langs->trans("Aparencia").'</th></tr><tr><td>'.$langs->trans("HelpOnTooltip").'<td>'.$langs->trans("HelpOnTooltipDesc").'</table> </textarea><td><table border=1 cellspacing=0 cellpadding=5 ><tr> <th colspan=2>Tooltip '.$langs->trans("Aparencia").'</th></tr><tr><td>'.$langs->trans("HelpOnTooltip").'<td>'.$langs->trans("HelpOnTooltipDesc").' </table><br><span class=\'fa fa-question-circle atoplogin classfortooltip\'  ></span> </table>"</th>';
        }        
      
         if ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'country_id')
        {
        if (in_array('region_id',$fieldlist))
        {
        print '<td>';
        //print join(',',$fieldlist);
        print '</td>';
        continue;
        }	// For state page, we do not show the country input (we link to region, not country)
        print '<td class="tdoverflowmax150">';
        $fieldname='valor_padrao';
        print $form->select_country((! empty($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:(! empty($obj->country)?$obj->country:'')), $fieldname, '', 28, 'maxwidth150 maxwidthonsmartphone');
        print '</td>';
        
        $country=$obj->{$fieldlist[$field]};
        }
 
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'state_id')
        {
        print '<td class="tdoverflowmax150">';
        
        if ($campocountry_id)
        {
        print $formcompany->select_state($obj->{$fieldlist[$field]},$campocountry_id,'valor_padrao');
                               
         }
        else
        {
            print $countrynotdefined;
        }
        
        
        
        print '</td>';
        }
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'client')
        {
        print '<td class="tdoverflowmax150"><select class="flat" name="valor_padrao" >';
        if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS)) print '<option value="2"'.($obj->{$fieldlist[$field]}==2?' selected':'').'>'.$langs->trans('Prospect').'</option>';
        if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS) && empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print '<option value="3"'.($obj->{$fieldlist[$field]}==3?' selected':'').'>'.$langs->trans('ProspectCustomer').'</option>';
        if (empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print '<option value="1"'.($obj->{$fieldlist[$field]}==1?' selected':'').'>'.$langs->trans('Customer').'</option>';
        print '<option value="0"'.($obj->{$fieldlist[$field]}==0?' selected':'').'>'.$langs->trans('NorProspectNorCustomer').'</option>';
        print '</select></td>';
        
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'fournisseur')
        {
        print '<td class="tdoverflowmax150">';
                 print $form->selectarray('valor_padrao', array('-1'=>$langs->trans(''),'0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});     
        print '</td>';
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'opp_status')
        
        {
        
        print '<td class="tdoverflowmax200">';
        print $formproject->selectOpportunityStatus('valor_padrao', $obj->{$fieldlist[$field]});
        
        print '</td>';
        
        
        }
        
           elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'public')
        {
        print '<td class="tdoverflowmax150">';
        if($formulario=='NewLeadOrProject')
        {
        print $form->selectarray('valor_padrao',array('0'=>$langs->trans('PrivateProject'),'1'=>$langs->trans('SharedProject')),$obj->{$fieldlist[$field]});
        }
        
        else
        {
        print $form->selectarray('valor_padrao', array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});                                     }
            
                                        
   
         print '</td>';
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'status')
        {       
        print '<td class="tdoverflowmax150">';
        print $form->selectarray('valor_padrao', array('0'=>$langs->trans('ActivityCeased'),'1'=>$langs->trans('InActivity')),$obj->{$fieldlist[$field]});
        print '</td>';  
        
        }   
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'assujtva_value')
        {
        print '<td class="tdoverflowmax150">';
         print $form->selectarray('valor_padrao', array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});          print '</td>';                
       
        }      
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'typent_id')
        {
        print '<td class="tdoverflowmax150">';
        print $form->selectarray("valor_padrao",$formcompany->typent_array(0), $obj->{$fieldlist[$field]}, 0, 0, 0, '', 0, 0, 0, (empty($conf->global->SOCIETE_SORT_ON_TYPEENT)?'ASC':$conf->global->SOCIETE_SORT_ON_TYPEENT));
        print '</td>';
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'effectif_id')
        {
        print '<td class="tdoverflowmax150">';
        print $form->selectarray("valor_padrao",$formcompany->effectif_array(0), $obj->{$fieldlist[$field]});
        
        print '</td>';
        }
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'forme_juridique_code')
        {
        print '<td class="tdoverflowmax150">';
        $tmparray=getCountry($campocountry_id,'all');
        $lang_pad=$tmparray['code'];
          
        if ($lang_pad)
        {
         print $formcompany->select_juridicalstatus($obj->{$fieldlist[$field]}, $lang_pad, '',  'valor_padrao');                          
         }
        else
        {
            print $countrynotdefined;
        }   
         
        print  '</td>';
        }
        
            elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'default_lang')
            {
            print '<td class="tdoverflowmax150">';
            print $formadmin->select_language(($obj->{$fieldlist[$field]}?$obj->{$fieldlist[$field]}:''), 'valor_padrao', 0, 0, 1, 0, 0, 'maxwidth200onsmartphone');
            
            print '</td>';
            }
            elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'incoterm_id')
            {
            print '<td class="tdoverflowmax150">';
            print $form->select_incoterms($obj->{$fieldlist[$field]});
            print "<script> $('input#location_incoterms').remove();</script>";
            
            print '</td>';
			}            
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'custcats')
        {
        print '<td class="tdoverflowmax150">';
        $cat=explode(',',$obj->{$fieldlist[$field]});
        $cate_arbo = $form->select_all_categories(Categorie::TYPE_CUSTOMER, null, 'parent', null, null, 1);
        print $form->multiselectarray('valor_padrao', $cate_arbo, $cat, null, null, null, null, "90%");
        
        
        print '</td>';
        }
        
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'suppcats')
        {
        print '<td class="tdoverflowmax150">';
        $cat=explode(',',$obj->{$fieldlist[$field]});
        $cate_arbo = $form->select_all_categories(Categorie::TYPE_SUPPLIER, null, 'parent', null, null, 1);
        print $form->multiselectarray('valor_padrao', $cate_arbo, $cat, null, null, null, null, "90%");
        
        
        print '</td>';
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'multicurrency_code')
        {
        print '<td class="tdoverflowmax150">';
        print $form->selectMultiCurrency(($obj->{$fieldlist[$field]} ? $obj->{$fieldlist[$field]} : $conf->currency), 'valor_padrao', 1);
        
        print '</td>';
        }
        
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'commercial')
        {
        print '<td class="tdoverflowmax150">';
        $userlist = $form->select_dolusers('', '', 0, null, 0, '', '', 0, 0, 0, '', 0, '', '', 0, 1);
        
        $selected=explode(',',$obj->{$fieldlist[$field]});
        
        print $form->multiselectarray('valor_padrao', $userlist, $selected, null, null, null, null, "90%");    
        
        
        
        print '</td>';
        }
        
        
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'socid')
        {
        print '<td class="tdoverflowmax150">';
        print $form->select_company($obj->{$fieldlist[$field]}, 'valor_padrao', '(s.client = 1 OR s.client = 2 OR s.client = 3) AND status=1', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');
        
        print '</td>';
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'cond_reglement_id')
        {
        print '<td class="tdoverflowmax150">';
        $form->select_conditions_paiements($obj->{$fieldlist[$field]},'valor_padrao');
        
        
        print '</td>';
        }
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'mode_reglement_id')
        {
        print '<td class="tdoverflowmax150">';
        $form->select_types_paiements($obj->{$fieldlist[$field]},'valor_padrao');
        
        
        print '</td>';
        }
        
        
         elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'fk_account')
        {
        print '<td class="tdoverflowmax150">';
        $form->select_comptes($obj->{$fieldlist[$field]},'valor_padrao');
        
        
        print '</td>';
        }  
        
        
        
         elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'demand_reason_id')
        {
        print '<td class="tdoverflowmax150">';
        $form->selectInputReason($obj->{$fieldlist[$field]},'valor_padrao');
        
        
        print '</td>';
        }  
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'availability_id')
        {
        print '<td class="tdoverflowmax150">';
        $form->selectAvailabilityDelay($obj->{$fieldlist[$field]},'valor_padrao');
        
        
        print '</td>';
        }
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'shipping_method_id')
        {
        print '<td class="tdoverflowmax150">';
        $form->selectShippingMethod($obj->{$fieldlist[$field]},'valor_padrao');
        
        
        print '</td>';
        }        
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='public')
        {
        
        print '<td class="tdoverflowmax200">';
        print $form->selectarray('valor_padrao', array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
          print '</td>';
        
        
        }
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='statut')
        {
        
        print '<td class="tdoverflowmax200">';
        
       if($formulario=='NewWarehouse')
        {
        $statutarray=array('1' => $langs->trans("Opened"), '0' => $langs->trans("Closed"));
        
        }
        else
        {
        $statutarray=array('1' => $langs->trans("OnSell"), '0' => $langs->trans("NotOnSell"));
        
        }
                                    
        print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
         print '</td>';
        
        
        }
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='statut_buy')
        {
        
        print '<td class="tdoverflowmax200">';
        
        $statutarray=array('1' => $langs->trans("ProductStatusOnBuy"), '0' => $langs->trans("ProductStatusNotOnBuy"));
        
        print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
         print '</td>';
        
        
        }
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='actioncode')
        {
                                        
                                 print '<td class="tdoverflowmax200">';
                                 
                           
                    $formactions->select_type_actions($obj->{$fieldlist[$field]}, 'valor_padrao', "systemauto", 0, -1);
                               print '</td>';
            
                                     
                                    }
                                    
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='status_batch')
        {
        
        print '<td class="tdoverflowmax200">';
        
        $statutarray=array('0' => $langs->trans("ProductStatusNotOnBatch"), '1' => $langs->trans("ProductStatusOnBatch"));
        
        print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
         print '</td>';
        
        
        }
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fk_barcode_type')
        {
        
        print '<td class="tdoverflowmax200">';
        
        require_once DOL_DOCUMENT_ROOT.'/core/class/html.formbarcode.class.php';
        $formbarcode = new FormBarCode($db);
		
		if(!function_exists('selectBarcodeType'))
			{
 
		      print $formbarcode->select_barcode_type($obj->{$fieldlist[$field]}, 'valor_padrao', 1);
 	}
			else
			{
            print $formbarcode->selectBarcodeType($obj->{$fieldlist[$field]}, 'valor_padrao', 1);
 		}
			
			
           print '</td>';
        
        
        }
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fk_default_warehouse')
        {
        
        print '<td class="tdoverflowmax200">';
        
        
        print $formproduct->selectWarehouses($obj->{$fieldlist[$field]}, 'valor_padrao', '',1,0);
          print '</td>';
        
        
        }                                    
        
          elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fk_parent')
        {
        
        print '<td class="tdoverflowmax200">';
        
        
        print $formproduct->selectWarehouses($obj->{$fieldlist[$field]}, 'valor_padrao', '',1,0);
          print '</td>';
        
        
        }            
        
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='finished')
        {
        
        print '<td class="tdoverflowmax200">';
        
        $statutarray=array('-1' => '','1' => $langs->trans("Finished"), '0' => $langs->trans("RowMaterial"));
        
        print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
         print '</td>';
        
        
        }
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='duration_unit')
        {
        
        print '<td class="tdoverflowmax200">';
        
        print '      <input  name="valor_padrao"  '.($obj->{$fieldlist[$field]}=="i"?'checked':'').'  type="radio" value="i">&nbsp;'.$langs->trans("Minute").'&nbsp;';
        print '<input name="valor_padrao" type="radio"  '.($obj->{$fieldlist[$field]}=="h"?'checked':'').'  value="h">&nbsp;'.$langs->trans("Hour").'&nbsp;';
        print '<input name="valor_padrao" '.($obj->{$fieldlist[$field]}=="d"?'checked':'').' type="radio" value="d">&nbsp;'.$langs->trans("Day").'&nbsp;<br>';
        print '<input name="valor_padrao"  '.($obj->{$fieldlist[$field]}=="w"?'checked':'').' type="radio" value="w">&nbsp;'.$langs->trans("Week").'&nbsp;';
        print '<input name="valor_padrao"  '.($obj->{$fieldlist[$field]}=="m"?'checked':'').' type="radio" value="m">&nbsp;'.$langs->trans("Month").'&nbsp;';
        print '<input name="valor_padrao"  '.($obj->{$fieldlist[$field]}=="y"?'checked':'').' type="radio" value="y">&nbsp;'.$langs->trans("Year").'&nbsp;';
        print '</td>';
        
         
        }
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='size_units')
        {
        
        print '<td class="tdoverflowmax200">';
        
        
        print $formproduct->select_measuring_units('valor_padrao',"size",$obj->{$fieldlist[$field]} );
          print '</td>';
        
        
        }           
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='clos')
            
            {
            print '<td class="tdoverflowmax200">';
            print $form->selectarray('valor_padrao', array('0'=>$langs->trans('StatusAccountOpened'),'1'=>$langs->trans('StatusAccountClosed')),$obj->{$fieldlist[$field]});
            
             print '</td>';
            
            
            }
        
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='weight_units')
        {
        
        print '<td class="tdoverflowmax200">';
        
        
        print $formproduct->select_measuring_units('valor_padrao',"weight",$obj->{$fieldlist[$field]} );
         print '</td>';
        
        
        }       
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='surface_units')
        {
        
        print '<td class="tdoverflowmax200">';
        
        
        print $formproduct->select_measuring_units('valor_padrao',"surface",$obj->{$fieldlist[$field]} );
         print '</td>';
        
        
        }
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='volume_units')
        {
        
        print '<td class="tdoverflowmax200">';
        
        
        print $formproduct->select_measuring_units('valor_padrao',"volume",$obj->{$fieldlist[$field]} );
         print '</td>';
        
        
        }       
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='categories')
        {
        
        print '<td class="tdoverflowmax200">';
        
          
                                 if($formulario=='NewFinancialAccount')
                                 {
                                    
                                   $cate_arbo = $form->select_all_categories(Categorie::TYPE_ACCOUNT, '', 'parent', 64, 0, 1);
		 
                                    }
                                    elseif($formulario=='NewLeadOrProject')
                                 {
                                    
                                   $cate_arbo = $form->select_all_categories(Categorie::TYPE_PROJECT, '', 'parent', 64, 0, 1);
		 
                                    }
                                    else
                                    {
                                        
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_PRODUCT, '', 'parent', 64, 0, 1);
                                        }
                                        
         $cat=explode(',',$obj->{$fieldlist[$field]});
      
        print $form->multiselectarray('valor_padrao', $cate_arbo, $cat, '', 0, '', 0, '100%');
         print '</td>';
        
        
        }    
        
        
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='tva_tx')
        {
        
        print '<td class="tdoverflowmax200">';
        print $form->load_tva('valor_padrao', $obj->{$fieldlist[$field]}, $mysoc, $mysoc, 0, 0, '', false, 1);
             print '</td>';
        
        
        }
        
        
        
        elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='price_base_type')
        {
        
        print '<td class="tdoverflowmax200">';
        print $form->selectPriceBaseType($object->price_base_type, 'valor_padrao');
        
             print '</td>';
        
        
        }
        
                                                                  


elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fullday')

{

print '<td class="tdoverflowmax200">';
if (!empty($obj->{$fieldlist[$field]})) {
$checked=' checked value="1" ';
} else {
$checked=' value="1" ';
}
$moreparam='';

$out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="valor_padrao" '.$checked.' '.($moreparam?$moreparam:'').'>';
print  $out;

print '</td>';


}

elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='aphour')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
  

print '</td>';


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='p2hour')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
 
print '</td>';


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='dateohour')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
 
print '</td>';


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='dateehour')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
 
print '</td>';


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='p2min')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});

 print '</td>';

 


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='apmin')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
 print '</td>';

 


}

elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='dateomin')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});

 print '</td>';

 


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='dateemin')

{

print '<td class="tdoverflowmax200">';

print $form->selectarray("valor_padrao", array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});

 print '</td>';

 


}

elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='complete')
{

print '<td class="tdoverflowmax200">';


$formactions->form_select_status_action('formaction', $obj->{$fieldlist[$field]}, 1, "valor_padrao", 0, 0, 'maxwidth200');

 print '</td>';


}
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='assignedtouser')
{

print '<td class="tdoverflowmax200">';
print $form->select_dolusers($obj->{$fieldlist[$field]}, "valor_padrao",1);

 print '</td>';


}

elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='progress')
 
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                                 	print $formother->select_percent($obj->{$fieldlist[$field]},"valor_padrao",0,5,0,100,1);
		 
                                           print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                      elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='typeid')
                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                  $listetype=$adht->liste_array();
		print $form->selectarray( "valor_padrao", $listetype,$obj->{$fieldlist[$field]}, count($listetype)>1?1:0);
        
                                            print '</td>';
            
                                     
                                    }
                                      elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='contratid')
                
                                     
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                   
                                                   
                                
                          $formcontract->formSelectContract('', -1, $obj->{$fieldlist[$field]}, "valor_padrao", 0, 1);            
                               
                  
     print "<script> $('select[name=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled')</script>";
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                    
                           elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='subscription')
                                                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                   	$statutarray=array('0' => $langs->trans("No"), '1' => $langs->trans("Yes"));
		
                                    	         print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
                                                 
                                                  
	  
                                           print '</td>';
            
                                     
                                    }
                            elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='vote')
                                         
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
        
                                   $statutarray=array('0' => $langs->trans("No"), '1' => $langs->trans("Yes"));
		
                                    	         print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
                               
                                           print '</td>';
            
                                     
                                    }
                      
                      
                      
                                    
                                       elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='morphy')
                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 
        $morphys["phy"] = $langs->trans("Physical");
		$morphys["mor"] = $langs->trans("Moral");
		 print $form->selectarray("valor_padrao", $morphys, $obj->{$fieldlist[$field]}, 1);
	
    
     
        
                                            print '</td>';
            
                                     
                                    }
                                    
                                         elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='memcats')
                            
     
                                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                    
                                          
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_MEMBER, '', 'parent', 64, 0, 1);
                                        
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			                     print $form->multiselectarray('valor_padrao', $cate_arbo, $cat, '', 0, '', 0, '100%');
             
    
                                            print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='userid')
{

print '<td class="tdoverflowmax200">';
print $form->select_dolusers($obj->{$fieldlist[$field]}, "valor_padrao",1);

 print '</td>';


}


                                   
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='commercial_suivi_id')
{

print '<td class="tdoverflowmax200">';
print $form->select_dolusers($obj->{$fieldlist[$field]}, "valor_padrao",1);

 print '</td>';


}
                         
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='commercial_signature_id')
{

print '<td class="tdoverflowmax200">';
print $form->select_dolusers($obj->{$fieldlist[$field]}, "valor_padrao",1);

 print '</td>';


}
 
                                        
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='socpeopleassigned')
{

print '<td class="tdoverflowmax200">';

$cat=explode(',',$obj->{$fieldlist[$field]});
print $form->selectcontacts('', $cat, "valor_padrao", 0, '', '', 0, 'quatrevingtpercent', false, 0, array(), false, 'multiple', 'contactid');
 print '</td>';


}

elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='taskid')
{

print '<td class="tdoverflowmax200">';

$formproject->selectTasks(-1, $tid, "valor_padrao", 24, 0, '1', 1, 0, 0, 'maxwidth500',$projectsListId);

 print '</td>';


}

 
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fk_user_author')
{

print '<td class="tdoverflowmax200">';
print $form->select_dolusers($obj->{$fieldlist[$field]}, 'valor_padrao',1);
 print '</td>';


}
 
elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fk_user_validator')
{

print '<td class="tdoverflowmax200">';
print $form->select_dolusers($obj->{$fieldlist[$field]}, 'valor_padrao',1);
 print '</td>';


}
        
        
      
     elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='admin')

                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('0' => $langs->trans("Yes"), '1' => $langs->trans("No"));
		
                                    	         print $form->selectarray( 'valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
 print '</td>';
            
                                     
                                    }
  
         
     elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='gender')
 
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                  	$statutarray=array('-1' => '','man' => $langs->trans("Genderman"), 'woman' => $langs->trans("Genderwoman"));
		
                                    	         print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
                                         print '</td>';
            
                                     
                                    }     
        
             elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='employee')
  
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('0' => $langs->trans("Yes"), '1' => $langs->trans("No"));
		
                                    	         print $form->selectarray('valor_padrao', $statutarray,$obj->{$fieldlist[$field]});
                                           print '</td>';
            
                                     
                                    }
                                    
                          elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='fk_user')
 
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, 'valor_padrao',1);
	                                      print '</td>';
            
                                     
                                    }
  
  elseif($fieldlist[$field] == 'valor_padrao'&&$temp_nome=='usercats')
 
                          
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 
                                        
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_USER, '', 'parent', 64, 0, 1);
                                        
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			print $form->multiselectarray('valor_padrao', $cate_arbo, $cat, '', 0, '', 0, '100%');
			                                print '</td>';
            
                                     
                                    }
                                    
                                              
                                              elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'paymenttype')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             	$form->select_types_paiements($obj->{$fieldlist[$field]},'valor_padrao', '', 2);
 	                                     print '</td>';
                                        }
                                                elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'modepayment')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             	 
                                                  $form->select_types_paiements($obj->{$fieldlist[$field]}, 'valor_padrao', 'CRDT', 0, 1);
 	                                     print '</td>';
                                        }
                                        
                                       
                                       
                                                      elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'task_parent')
                                  
                                    {
                                            print '<td class="tdoverflowmax200">';
                                              
                                        
    print $formother->selectProjectTasks($obj->{$fieldlist[$field]}, '', 'valor_padrao', 0, 0, 1, 1, 0, '0,1', 'maxwidth500');
		
    
 	                                        print '</td>';
                                        }
                                        
                                        
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'accountid')
        {
        print '<td class="tdoverflowmax150">';
            
            $form->select_comptes($obj->{$fieldlist[$field]},'valor_padrao',0,'',1);  // Affiche liste des comptes courant
                                     
        print '</td>';
        }
        
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'projectid')
        {
        print '<td class="tdoverflowmax150">';
        
        $formproject->select_projects(-1,$obj->{$fieldlist[$field]},'valor_padrao', 0, 0, 1, 1);
        
        print '</td>';
        }                
          elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'fk_project')
        {
        print '<td class="tdoverflowmax150">';
        
        $formproject->select_projects(-1,$obj->{$fieldlist[$field]},'valor_padrao', 0, 0, 1, 1);
        
        print '</td>';
        }         
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'model')
        {
        print '<td class="tdoverflowmax150">';
        if($formulario=='NewProp-Customer')
        {
        require_once DOL_DOCUMENT_ROOT . '/core/modules/propale/modules_propale.php';
        $liste = ModelePDFPropales::liste_modeles($db);
        }
        elseif($formulario=='NewOrder-Customer')
        {
        require_once DOL_DOCUMENT_ROOT . '/core/modules/commande/modules_commande.php';
        $liste = ModelePDFCommandes::liste_modeles($db);
        }
        elseif($formulario=='NewAskPrice')
        {
        require_once DOL_DOCUMENT_ROOT . '/core/modules/supplier_proposal/modules_supplier_proposal.php';
        $liste = ModelePDFSupplierProposal::liste_modeles($db);
        }
        elseif($formulario=='NewBill-Customer')
        {
        require_once DOL_DOCUMENT_ROOT . '/core/modules/facture/modules_facture.php';
        $liste = ModelePDFFactures::liste_modeles($db);
        }
        
        elseif($formulario=='AddIntervention')
        {
         require_once DOL_DOCUMENT_ROOT . '/core/modules/fichinter/modules_fichinter.php';
        $liste=ModelePDFFicheinter::liste_modeles($db);
       }
        
        
        print $form->selectarray('valor_padrao', $liste, $obj->{$fieldlist[$field]},1);                             
        print '</td>';
        }
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'type')
        
        {
        print '<td class="tdoverflowmax150">';
        
        if($formulario=='NewFinancialAccount')
        {
            
            	print  $formbank->selectTypeOfBankAccount($obj->{$fieldlist[$field]},"valor_padrao");

            
            }
            
            else
            {
        $arraylist = array('0' => $langs->transnoentitiesnoconv('InvoiceStandardAsk'),'1' => $langs->transnoentitiesnoconv('InvoiceReplacementAsk'),'2' => $langs->transnoentitiesnoconv('InvoiceAvoirAsk'), '3' => $langs->transnoentitiesnoconv('InvoiceDeposit'));
        print $form->selectarray('valor_padrao', $arraylist, $obj->{$fieldlist[$field]});
        }
        
        
        print '</td>';
        }     
        
        
        
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'account_currency_code')
        
        {
        print '<td class="tdoverflowmax200">';
        $selectedcode=$obj->{$fieldlist[$field]};
        if (! $selectedcode) $selectedcode=$conf->currency;
        print $form->selectCurrency($selectedcode, 'valor_padrao');
        
        print '</td>';
        }
                                        
         elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'account_country_id')
        
        {
        print '<td class="tdoverflowmax200">';
        $selectedcode=$obj->{$fieldlist[$field]};
        if (! $selectedcode) $selectedcode=$mysoc->country_code;
        print $form->select_country($selectedcode, 'valor_padrao');
        
        print '</td>';
        }
            
             elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'account_state_id')
        {
        print '<td class="tdoverflowmax150">';
        
        if ($campocountry_id)
        {
        print $formcompany->select_state($obj->{$fieldlist[$field]},$campocountry_id,'valor_padrao');
                               
         }
        else
        {
            print $countrynotdefined;
        }
        
        
        
        print '</td>';
        }
        
         
                                         
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'civility_id')
        
        {
        print '<td class="tdoverflowmax150">';
        print 	 $formcompany->select_civility($obj->{$fieldlist[$field]},'valor_padrao', 'maxwidth200');
        
        print '</td>';
        }                              
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'no_email')
         
        {
        
        print '<td class="tdoverflowmax200">';
        print $form->selectarray('valor_padrao', array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
         print '</td>';
        
        
        }
        elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'priv')
         
        {
        
        print '<td class="tdoverflowmax200">';
        print $form->selectarray('valor_padrao', array('0'=>$langs->trans("ContactPublic"),'1'=>$langs->trans("ContactPrivate")),$obj->{$fieldlist[$field]});
         print '</td>';
        
        
        }
             
            
             elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'contcats')
         
        {
        
        print '<td class="tdoverflowmax200">';
             $cat=explode(',',$obj->{$fieldlist[$field]});
            $cate_arbo = $form->select_all_categories( Categorie::TYPE_CONTACT, null, 'parent', null, null, 1 );
				print $form->multiselectarray( 'valor_padrao', $cate_arbo, $cat, null, null, null,
					null, '90%' );
             print '</td>';
        
        
        }
             
             elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'birthday_alert')
         
        {
        
        print '<td class="tdoverflowmax200">';
           if (!empty($obj->{$fieldlist[$field]})) {
                $checked=' checked value="1" ';
                } else {
                $checked=' value="1" ';
                }
                $moreparam='';
                
                $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="valor_padrao" id="valor_padrao" '.$checked.' '.($moreparam?$moreparam:'').'>';
                print  $out;
         
             print '</td>';
        
        
        }      
                elseif ($fieldlist[$field] == 'valor_padrao'&&$temp_nome == 'fullday')
         
        {
        
        print '<td class="tdoverflowmax200">';
           if (!empty($obj->{$fieldlist[$field]})) {
                $checked=' checked value="1" ';
                } else {
                $checked=' value="1" ';
                }
                $moreparam='';
                
                $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="valor_padrao" id="valor_padrao" '.$checked.' '.($moreparam?$moreparam:'').'>';
                print  $out;
         
             print '</td>';
        
        
        }      
                
                
        
        
        
        
          elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='link'&&$obj->extra==='1')
            {
            $key= $obj->campo_nome;
            $param=$extrafields->attributes[$campoextra]['param'][$key];
            
            $param_list=array_keys($param['options']);				// $param_list='ObjectName:classPath'
            $showempty=(($required && $default != '')?0:1);
            $out=$form->selectForForms($param_list[0], 'valor_padrao', $obj->{$fieldlist[$field]}, $showempty,'','','minwidth200');
              print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
             print  $out;
            }
        
        
        
          elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='select'&&$obj->extra==='1')
            {
             $key= $obj->campo_nome;
                $param=$extrafields->attributes[$campoextra]['param'][$key];
         //$extrafields->attributes[$campoextra]['type'][$key]  ;
         
            print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
            $out='<select class="flat minwidth200 maxwidthonsmartphone" name="valor_padrao" id="valor_padrao">';
            $out.='<option value="0">&nbsp;</option>';
                foreach ($param['options'] as $key => $val)
                {
                if ((string) $key == '') continue;
                list($val, $parent) = explode('|', $val);
                $out.='<option value="'.$key.'"';
                $out.= (((string) $obj->{$fieldlist[$field]} == (string) $key)?' selected':'');
                $out.= (!empty($parent)?' parent="'.$parent.'"':'');
                $out.='>';
                if ($langfile && $val) $out.=$langs->trans($val);
                else $out.=$val;
                $out.='</option>';
                }
            $out.='</select>';
            
           print  $out;
            }
         elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='sellist'&&$obj->extra==='1')
         
            {
                $key= $obj->campo_nome;
                $param=$extrafields->attributes[$campoextra]['param'][$key];
                
                //$extrafields->attributes[$campoextra]['type'][$key]  ;
                
                print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                
                $out='<select class="flat minwidth200"   name="valor_padrao" id="valor_padrao" '.($moreparam?$moreparam:'').'>';
                $out.=buscalist($param['options'],$obj->{$fieldlist[$field]});
                $out.='</select>';
                
                print  $out;
             }
        
         elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='radio'&&$obj->extra==='1')
         
                {
                    $key= $obj->campo_nome;
                    $param=$extrafields->attributes[$campoextra]['param'][$key];
                    print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                    $out='';
                    foreach ($param['options'] as $keyopt => $val)
                    {
                    $out.='<input class="flat '.$morecss.'" type="radio" name="valor_padrao" id="valor_padrao" '.($moreparam?$moreparam:'');
                    $out.=' value="'.$keyopt.'"';
                    $out.=' id="'.$fieldlist[$field].'_'.$keyopt.'"';
                    $out.= ($obj->{$fieldlist[$field]}==$keyopt?'checked':'');
                    $out.='/><label for="'.$fieldlist[$field].'_'.$keyopt.'">'.$val.'</label><br>';
                }
                
                print  $out;
                                         }
          elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='checkbox'&&$obj->extra==='1')
       
                {
                    $key= $obj->campo_nome;
                    $param=$extrafields->attributes[$campoextra]['param'][$key];
                    
                    print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                    $out='';
                    
                    $value_arr=explode(',',$obj->{$fieldlist[$field]});
                    $out=$form->multiselectarray('valor_padrao', (empty($param['options'])?null:$param['options']), $value_arr, '', 0, '', 0, '100%');
                    print  $out;
                }
                
                elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='chkbxlst'&&$obj->extra==='1')
                
                {
                    $key= $obj->campo_nome;
                    $param=$extrafields->attributes[$campoextra]['param'][$key];
                    
                    
                    print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                    $value= $obj->{$fieldlist[$field]} ;
                    if (is_array($value)) {
                    $value_arr = $value;
			}
			else {
				$value_arr = explode(',', $value);
			}
                
                $data=buscalistCh($param['options'],$obj->{$fieldlist[$field]});
                
                $out=$form->multiselectarray('valor_padrao', $data, $value_arr, '', 0, '', 0, '100%');
                
                
                print  $out;
        }
          elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='html'&&$obj->extra==='1')
                                     
                            
            {
            print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
            
            require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
            $doleditor=new DolEditor('valor_padrao',$obj->{$fieldlist[$field]},'',200,'dolibarr_notes','In',false,false,! empty($conf->fckeditor->enabled),ROWS_3,'90%');
            $out=$doleditor->Create(1);
            print  $out;
            //    print "<script> $('select[id=".$fieldname.$campo."]').prop('disabled',true).addClass('disabled');</script>";
            
            }
            
             elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='boolean'&&$obj->extra==='1')
         
               
                {
                
                
                if (!empty($obj->{$fieldlist[$field]})) {
                $checked=' checked value="1" ';
                } else {
                $checked=' value="1" ';
                }
                $moreparam='';
                print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="valor_padrao" id="valor_padrao" '.$checked.' '.($moreparam?$moreparam:'').'>';
                print  $out;
                
                }
                   elseif($fieldlist[$field] == 'valor_padrao'&&$obj->campo_tipo==='password'&&$obj->extra==='1')
         
                 {
                                             
                                     $moreparam=''; 
  print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                         	$out='<input   type="text" class="flat '.$morecss.'" name="valor_padrao" id="valor_padrao" value="'.$obj->{$fieldlist[$field]}.'" '.($moreparam?$moreparam:'').'>';
			                                print  $out;
                                 
                                         }
                                         
                                         

        elseif ($fieldlist[$field] == 'campo_nome')
        {
        
        print '<input type="hidden" class="flat'.($class?' '.$class:'').'" value="'.(isset($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:'').'" name="'.$fieldlist[$field].'">';
        }
        
        elseif ($fieldlist[$field] == 'campo_texto')
        {
        
        print '<input type="hidden" class="flat'.($class?' '.$class:'').'" value="'.(isset($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:'').'" name="'.$fieldlist[$field].'">';
        
        
        }
        elseif ($fieldlist[$field] == 'tooltip')
        {
        
          print '<td>';
          if($obj->campo_nome=='cabecalho'||$obj->campo_nome=='rodape')
          {
        print $langs->trans('StatusNotApplicable');
      }
      else
      {
        
        require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
        $doleditor=new DolEditor($fieldlist[$field],$obj->{$fieldlist[$field]},'',200,'dolibarr_notes','In',false,false,! empty($conf->fckeditor->enabled),ROWS_3,'90%');
        $out=$doleditor->Create(1);
        print  $out;
        }
        print ' </td>';

        }
        
         elseif ($fieldlist[$field] == 'conteudo')
        {
        
          print '<td>';
          if($obj->campo_tipo=='select'||$obj->campo_tipo=='sellist'||$obj->campo_tipo=='radio'||$obj->campo_tipo=='boolean'||$obj->campo_tipo=='chkbxlst'||$obj->campo_tipo=='link'||$obj->campo_tipo=='checkbox'||$obj->campo_nome=='type'||$obj->campo_nome=='duration_unit'||$obj->campo_nome=='cabecalho'||$obj->campo_nome=='rodape')
          {
        print $langs->trans('StatusNotApplicable');
      }
      else
      {
        print ' <textarea   type="text"  class="centpercent" name="'.$fieldlist[$field].'"   >'.(isset($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:'').'</textarea>';
      
        }
        
        
        print ' </td>';

        }
        
        elseif ($fieldlist[$field] == 'situacao')
        {
        print '<td>';
        print '<input type="hidden" class="flat'.($class?' '.$class:'').'" value="'.(isset($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:'').'" name="'.$fieldlist[$field].'"> <select    class="flat'.($class?' '.$class:'').'"    name="'.$fieldlist[$field].'"><option '.($obj->{$fieldlist[$field]}==0?'selected':'').' value="0">'.$langs->trans("Invisivel").'</option><option '.($obj->{$fieldlist[$field]}==1?'selected':'').' value="1">'.$langs->trans("Visivel").'</option>';
        
        if($obj->campo_nome=='cabecalho'||$obj->campo_nome=='rodape')
        {
        }
        else
        {
        print '<option '.($obj->{$fieldlist[$field]}==2?'selected':'').' value="2">'.$langs->trans("Desabilitado").'</option><option '.($obj->{$fieldlist[$field]}==3?'selected':'').' value="3">'.$langs->trans("Obrigatorio").'</option>';
        
        }
        print '</select> </td>';
        }
        
         else
        {
        
                if ($fieldlist[$field]=='valor_padrao'&&($obj->campo_nome == 'cabecalho'||$obj->campo_nome == 'rodape'||$obj->campo_nome == 'signature'))
               {
               
                   
                    print '<td class="'.$classtd.' tdoverflowmax200">';
                    require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
                    $doleditor=new DolEditor($fieldlist[$field],$obj->{$fieldlist[$field]},'',200,'dolibarr_notes','In',false,false,! empty($conf->fckeditor->enabled),ROWS_3,'90%');
                    $out=$doleditor->Create(1);
                    print  $out;
                    
                     print ' </td>';
       
               }
               else
               {
               
                    print '<td class="'.$classtd.' tdoverflowmax200">';
                    print '<input    class="flat quatrevingtpercent"  name="'.$fieldlist[$field].'" value="'.(isset($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:'').'">';
               }
        print '</td>';
        }
        }

	return $withentity;
}

 function buscalist($params,$value)
{
    
  
$out='';
	global $conf,$langs,$db;
	 
    {
        if (is_array($params))
			{
				$param_list=array_keys($params);
				$InfoFieldList = explode(":", $param_list[0]);
				$parentName='';
				$parentField='';
				// 0 : tableName
				// 1 : label field name
				// 2 : key fields name (if differ of rowid)
				// 3 : key field parent (for dependent lists)
				// 4 : where clause filter on column or table extrafield, syntax field='value' or extra.field=value
				$keyList=(empty($InfoFieldList[2])?'rowid':$InfoFieldList[2].' as rowid');


				if (count($InfoFieldList) > 4 && ! empty($InfoFieldList[4]))
				{
					if (strpos($InfoFieldList[4], 'extra.') !== false)
					{
						$keyList='main.'.$InfoFieldList[2].' as rowid';
					} else {
						$keyList=$InfoFieldList[2].' as rowid';
					}
				}
				if (count($InfoFieldList) > 3 && ! empty($InfoFieldList[3]))
				{
					list($parentName, $parentField) = explode('|', $InfoFieldList[3]);
					$keyList.= ', '.$parentField;
				}

				$fields_label = explode('|',$InfoFieldList[1]);
				if (is_array($fields_label))
				{
					$keyList .=', ';
					$keyList .= implode(', ', $fields_label);
				}

				$sqlwhere='';
				$sql = 'SELECT '.$keyList;
				$sql.= ' FROM '.MAIN_DB_PREFIX .$InfoFieldList[0];
				if (!empty($InfoFieldList[4]))
				{
				    // can use curent entity filter
				    if (strpos($InfoFieldList[4], '$ENTITY$')!==false) {
				        $InfoFieldList[4]=str_replace('$ENTITY$',$conf->entity,$InfoFieldList[4]);
				    }
					// can use SELECT request
					if (strpos($InfoFieldList[4], '$SEL$')!==false) {
						$InfoFieldList[4]=str_replace('$SEL$','SELECT',$InfoFieldList[4]);
					}

					// current object id can be use into filter
					if (strpos($InfoFieldList[4], '$ID$')!==false && !empty($objectid)) {
						$InfoFieldList[4]=str_replace('$ID$',$objectid,$InfoFieldList[4]);
					} else {
						$InfoFieldList[4]=str_replace('$ID$','0',$InfoFieldList[4]);
					}
					//We have to join on extrafield table
					if (strpos($InfoFieldList[4], 'extra')!==false)
					{
						$sql.= ' as main, '.MAIN_DB_PREFIX .$InfoFieldList[0].'_extrafields as extra';
						$sqlwhere.= ' WHERE extra.fk_object=main.'.$InfoFieldList[2]. ' AND '.$InfoFieldList[4];
					}
					else
					{
						$sqlwhere.= ' WHERE '.$InfoFieldList[4];
					}
				}
				else
				{
					$sqlwhere.= ' WHERE 1=1';
				}
				// Some tables may have field, some other not. For the moment we disable it.
				if (in_array($InfoFieldList[0],array('tablewithentity')))
				{
					$sqlwhere.= ' AND entity = '.$conf->entity;
				}
				$sql.=$sqlwhere;
				//print $sql;

				$sql .= ' ORDER BY ' . implode(', ', $fields_label);

			 	$resql = $db->query($sql);
				if ($resql)
				{
					$out.='<option value="0">&nbsp;</option>';
					$num = $db->num_rows($resql);
					$i = 0;
					while ($i < $num)
					{
						$labeltoshow='';
						$obj = $db->fetch_object($resql);

						// Several field into label (eq table:code|libelle:rowid)
						$notrans = false;
						$fields_label = explode('|',$InfoFieldList[1]);
						if (is_array($fields_label))
						{
							$notrans = true;
							foreach ($fields_label as $field_toshow)
							{
								$labeltoshow.= $obj->$field_toshow.' ';
							}
						}
						else
						{
							$labeltoshow=$obj->{$InfoFieldList[1]};
						}
						$labeltoshow=dol_trunc($labeltoshow,45);

						if ($value == $obj->rowid)
						{
							foreach ($fields_label as $field_toshow)
							{
								$translabel=$langs->trans($obj->$field_toshow);
								if ($translabel!=$obj->$field_toshow) {
									$labeltoshow=dol_trunc($translabel,18).' ';
								}else {
									$labeltoshow=dol_trunc($obj->$field_toshow,18).' ';
								}
							}
							$out.='<option value="'.$obj->rowid.'" selected>'.$labeltoshow.'</option>';
						}
						else
						{
							if (! $notrans)
							{
								$translabel=$langs->trans($obj->{$InfoFieldList[1]});
								if ($translabel!=$obj->{$InfoFieldList[1]}) {
									$labeltoshow=dol_trunc($translabel,18);
								}
								else {
									$labeltoshow=dol_trunc($obj->{$InfoFieldList[1]},18);
								}
							}
							if (empty($labeltoshow)) $labeltoshow='(not defined)';
							if ($value==$obj->rowid)
							{
								$out.='<option value="'.$obj->rowid.'" selected>'.$labeltoshow.'</option>';
							}

							if (!empty($InfoFieldList[3]) && $parentField)
							{
								$parent = $parentName.':'.$obj->{$parentField};
							}

							$out.='<option value="'.$obj->rowid.'"';
							$out.= ($value==$obj->rowid?' selected':'');
							$out.= (!empty($parent)?' parent="'.$parent.'"':'');
							$out.='>'.$labeltoshow.'</option>';
						}

						$i++;
					}
					$db->free($resql);
				}
				else {
					print 'Error in request '.$sql.' '.$db->lasterror().'. Check setup of extra parameters.<br>';
				}
			}
            }
            return $out;
     }       
 
 function buscalistCh($params,$value)
{
    
  
$out='';
	global $conf,$langs,$db;
	 
    {
       if (is_array($params)) {
				$param_list = array_keys($params);
				$InfoFieldList = explode(":", $param_list[0]);
				$parentName='';
				$parentField='';
				// 0 : tableName
				// 1 : label field name
				// 2 : key fields name (if differ of rowid)
				// 3 : key field parent (for dependent lists)
				// 4 : where clause filter on column or table extrafield, syntax field='value' or extra.field=value
				$keyList = (empty($InfoFieldList[2]) ? 'rowid' : $InfoFieldList[2] . ' as rowid');

				if (count($InfoFieldList) > 3 && ! empty($InfoFieldList[3])) {
					list ( $parentName, $parentField ) = explode('|', $InfoFieldList[3]);
					$keyList .= ', ' . $parentField;
				}
				if (count($InfoFieldList) > 4 && ! empty($InfoFieldList[4])) {
					if (strpos($InfoFieldList[4], 'extra.') !== false) {
						$keyList = 'main.' . $InfoFieldList[2] . ' as rowid';
					} else {
						$keyList = $InfoFieldList[2] . ' as rowid';
					}
				}

				$fields_label = explode('|', $InfoFieldList[1]);
				if (is_array($fields_label)) {
					$keyList .= ', ';
					$keyList .= implode(', ', $fields_label);
				}

				$sqlwhere = '';
				$sql = 'SELECT ' . $keyList;
				$sql .= ' FROM ' . MAIN_DB_PREFIX . $InfoFieldList[0];
				if (! empty($InfoFieldList[4])) {

					// can use SELECT request
					if (strpos($InfoFieldList[4], '$SEL$')!==false) {
						$InfoFieldList[4]=str_replace('$SEL$','SELECT',$InfoFieldList[4]);
					}

					// current object id can be use into filter
					if (strpos($InfoFieldList[4], '$ID$')!==false && !empty($objectid)) {
						$InfoFieldList[4]=str_replace('$ID$',$objectid,$InfoFieldList[4]);
					} else {
						$InfoFieldList[4]=str_replace('$ID$','0',$InfoFieldList[4]);
					}

					// We have to join on extrafield table
					if (strpos($InfoFieldList[4], 'extra') !== false) {
						$sql .= ' as main, ' . MAIN_DB_PREFIX . $InfoFieldList[0] . '_extrafields as extra';
						$sqlwhere .= ' WHERE extra.fk_object=main.' . $InfoFieldList[2] . ' AND ' . $InfoFieldList[4];
					} else {
						$sqlwhere .= ' WHERE ' . $InfoFieldList[4];
					}
				} else {
					$sqlwhere .= ' WHERE 1=1';
				}
				// Some tables may have field, some other not. For the moment we disable it.
				if (in_array($InfoFieldList[0], array ('tablewithentity')))
				{
					$sqlwhere .= ' AND entity = ' . $conf->entity;
				}
				// $sql.=preg_replace('/^ AND /','',$sqlwhere);
				// print $sql;

				$sql .= $sqlwhere;
			 	$resql = $db->query($sql);
				if ($resql) {
					$num = $db->num_rows($resql);
					$i = 0;

					$data=array();

					while ( $i < $num ) {
						$labeltoshow = '';
						$obj = $db->fetch_object($resql);

						$notrans = false;
						// Several field into label (eq table:code|libelle:rowid)
						$fields_label = explode('|', $InfoFieldList[1]);
						if (is_array($fields_label)) {
							$notrans = true;
							foreach ( $fields_label as $field_toshow ) {
								$labeltoshow .= $obj->$field_toshow . ' ';
							}
						} else {
							$labeltoshow = $obj->{$InfoFieldList[1]};
						}
						$labeltoshow = dol_trunc($labeltoshow, 45);

						if (is_array($value_arr) && in_array($obj->rowid, $value_arr)) {
							foreach ( $fields_label as $field_toshow ) {
								$translabel = $langs->trans($obj->$field_toshow);
								if ($translabel != $obj->$field_toshow) {
									$labeltoshow = dol_trunc($translabel, 18) . ' ';
								} else {
									$labeltoshow = dol_trunc($obj->$field_toshow, 18) . ' ';
								}
							}

							$data[$obj->rowid]=$labeltoshow;
						} else {
							if (! $notrans) {
								$translabel = $langs->trans($obj->{$InfoFieldList[1]});
								if ($translabel != $obj->{$InfoFieldList[1]}) {
									$labeltoshow = dol_trunc($translabel, 18);
								} else {
									$labeltoshow = dol_trunc($obj->{$InfoFieldList[1]}, 18);
								}
							}
							if (empty($labeltoshow))
								$labeltoshow = '(not defined)';

								if (is_array($value_arr) && in_array($obj->rowid, $value_arr)) {
									$data[$obj->rowid]=$labeltoshow;
								}

								if (! empty($InfoFieldList[3]) && $parentField) {
									$parent = $parentName . ':' . $obj->{$parentField};
								}

								$data[$obj->rowid]=$labeltoshow;
						}

						$i ++;
					}
					$db->free($resql);

			 	} else {
					print 'Error in request ' . $sql . ' ' . $db->lasterror() . '. Check setup of extra parameters.<br>';
				}
			}
            }
            return $data;
     }
     
     
     function verifica($nome,$campoextra)
{
    
   
	global $conf,$langs,$db;
	 
    {
      
				$sql = 'SELECT rowid';
				$sql.= ' FROM '.MAIN_DB_PREFIX .'extrafields where `name`="'.$nome.'" and  `elementtype`="'.$campoextra.'"';
				  
                  
			 	$resql = $db->query($sql);
				if ($resql)
				{
			 	 $obj = $db->fetch_object($resql);
					 
				}
			 
	 }
           
            return $obj->rowid;
    
 }
?>