<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		admin/checkifsentemail.php
 * 	\ingroup	checkifsentemail
 * 	\brief		This file is an example module setup page
 * 				Put some comments here
 */
// Dolibarr environment
$res = @include("../../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../../main.inc.php"); // From "custom" directory
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/checkifsentemail.lib.php';
dol_include_once('/checkifsentemail/class/checkifsentemail.class.php');

$checkifsentemail  = new checkifsentemail($db);
// Translations
$langs->load("checkifsentemail@checkifsentemail");

// Access control
if (! $user->admin) {
    accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');


$status = $checkifsentemail->getStatusPropal();


if ($action == 'set_colors') {
	$statuscolrs = GETPOST('statuscolrs', 'alpha');
	if($statuscolrs){
		foreach ($statuscolrs as $key => $statut) {
			$name = $statut['name'];
			$name = str_replace(",", "-", $name);
			$value = $statut['value'];
			if ($value) {
				$res = dolibarr_set_const($db, $name, $value, 'setcol', 0, '', $conf->entity);
				if (! $res > 0)	$error ++;
			}

		}
	}
	
	if (! $error) {
		setEventMessage($langs->trans("SetupSaved"), 'mesgs');
	} else {
		setEventMessage($langs->trans("Error"), 'errors');
	}
}







/*
 * View
 */
$page_name = "checkifsentemailSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
    . $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = checkifsentemailAdminPrepareHead();
dol_fiche_head(
    $head,
    'Proposals',
    $langs->trans("checkifsentemail"),
    0,
    "checkifsentemail@checkifsentemail"
);

// Setup page goes here
$form=new Form($db);
$var=false;



// print_r($status);
print '<form id="col4-form" method="post" action="proposals.php">';
print '<input type="hidden" name="action" value="set_colors">';
print '<table class="noborder" width="100%">';
if($status){
	$i = 0;
	foreach ($status as $id => $label) {
		$name = "STATUSPROPAL_".$id;
		$valusstat = $conf->global->$name;
		if(empty($valusstat))
			$valusstat = "#FFFFFF";
		print '<tr>';
			print '<td style="width:200px;">';
				print addslashes(trim($label));
			print '</td>';
			print '<td style="">';
				print '<input type="hidden" name="statuscolrs['.$i.'][name]" value="STATUSPROPAL_'.$id.'">';
				print '<input type="color" class="inputcolor" name="statuscolrs['.$i.'][value]" value="'.$valusstat.'" style="margin:0;">';
				print '<input type="text" class="inputhexacolor" size="7" value="'.$valusstat.'">';
			print '</td>';
			// print '<td>';
			// print '<input type="submit" class="button" value="Valider">';
			// print '</td>';
		print '</tr>';
		$i++;
	}
}
print '</table>';
print '<br><div style="text-align:left;"><input type="submit" class="butAction" value="Valider"></div>';
print '</form>';



llxFooter();

$db->close();


