<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

// dol_include_once('/chartsdolibarr/class/chartsdolibarr.class.php');

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';


class charts_products extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $number;

	public $element='societe';
	public $table_element='societe';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

    













    // Statistiques
	public function products_statistiques($slctdyear)
	{
		$resultat = array();
		
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."product";
		$sql .= " WHERE YEAR(datec) = ".$slctdyear;
        $resql = $this->db->query($sql);
        $resultat['product'] = $resultat['service'] = 0;
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	if($obj->fk_product_type == 0 )
                	$resultat['product'] += 1;
            	if($obj->fk_product_type == 1 )
                	$resultat['service'] += 1;
            }
        }
        return $resultat;
    }


    // Nombre de propositions commerciales
	public function products_propals($type, $slctdyear)
	{
		$resultat = array();
		
		// $sql = "SELECT * FROM ".MAIN_DB_PREFIX."propal";
		// $sql .= " WHERE YEAR(datep) = ".$slctdyear;
		// $sql .= " AND rowid in (SELECT fk_propal FROM ".MAIN_DB_PREFIX."propaldet)";

		$sql = "SELECT propal.rowid, propal.datep, propaldet.fk_propal, propaldet.fk_product, product.rowid, product.fk_product_type";
		$sql .= " FROM ".MAIN_DB_PREFIX."propal propal";
		$sql .= " JOIN ".MAIN_DB_PREFIX."propaldet propaldet ON propaldet.fk_propal = propal.rowid";
		$sql .= " JOIN ".MAIN_DB_PREFIX."product product ON product.rowid = propaldet.fk_product";
		$sql .= " WHERE 1> 0";
		// $sql .= " AND YEAR(propal.datep) = ".$slctdyear;
		$sql .= " AND (YEAR(propal.datep) = ".$slctdyear;
		$sql .= " or YEAR(propal.datep) = ".($slctdyear-1).")";
		$sql .= " AND propal.rowid in (SELECT fk_propal FROM ".MAIN_DB_PREFIX."propaldet)";

		if($type >= 0)
			$sql .= " AND fk_product_type = ".$type;
		$sql .= " GROUP BY propal.rowid ORDER BY  propal.rowid  DESC";

		// echo $sql;
        $resql = $this->db->query($sql);
        $resultat = array();
        
        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
            	$y = date("Y",strtotime($obj->datep)) + 0;
                $resultat[$y][date("m",strtotime($obj->datep)) + 0] += 1;
            }
        }
        // print_r($resultat);
        return $resultat;
    }


    // Nombre de commandes clients
	public function products_commandes($type, $slctdyear)
	{
		$resultat = array();
		
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."commande";
		$sql .= " WHERE YEAR(date_commande) = ".$slctdyear;
		$sql .= " AND rowid in (SELECT fk_commande FROM ".MAIN_DB_PREFIX."commandedet)";

		$sql = "SELECT t1.rowid, t1.date_commande, t2.fk_commande, t2.fk_product, t3.rowid, t3.fk_product_type";
		$sql .= " FROM ".MAIN_DB_PREFIX."commande t1";
		$sql .= " JOIN ".MAIN_DB_PREFIX."commandedet t2 ON t2.fk_commande = t1.rowid";
		$sql .= " JOIN ".MAIN_DB_PREFIX."product t3 ON t3.rowid = t2.fk_product";
		$sql .= " WHERE 1> 0";
		// $sql .= " AND YEAR(t1.date_commande) = ".$slctdyear;
		$sql .= " AND (YEAR(t1.date_commande) = ".$slctdyear;
		$sql .= " or YEAR(t1.date_commande) = ".($slctdyear-1).")";
		$sql .= " AND t1.rowid in (SELECT fk_commande FROM ".MAIN_DB_PREFIX."commandedet)";

		if($type >= 0)
			$sql .= " AND fk_product_type = ".$type;
		$sql .= " GROUP BY t1.rowid ORDER BY  t1.rowid  DESC";

		// echo $sql;
        $resql = $this->db->query($sql);
        $resultat = array();

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                // $resultat[date("m",strtotime($obj->date_commande)) + 0] += 1;
                $y = date("Y",strtotime($obj->date_commande)) + 0;
                $resultat[$y][date("m",strtotime($obj->date_commande)) + 0] += 1;
            }
        }
        // print_r($resultat);
        return $resultat;
    }
    // Nombre de commandes clients
	public function products_commande_fournisseurs($type, $slctdyear)
	{
		$resultat = array();
		
		// $sql = "SELECT * FROM ".MAIN_DB_PREFIX."commande_fournisseur";
		// $sql .= " WHERE YEAR(date_commande) = ".$slctdyear;
		// $sql .= " AND rowid in (SELECT fk_commande FROM ".MAIN_DB_PREFIX."commande_fournisseurdet)";

		$sql = "SELECT t1.rowid, t1.date_commande, t1.date_creation, t2.fk_commande, t2.fk_product, t3.rowid, t3.fk_product_type";
		$sql .= " FROM ".MAIN_DB_PREFIX."commande_fournisseur t1";
		$sql .= " JOIN ".MAIN_DB_PREFIX."commande_fournisseurdet t2 ON t2.fk_commande = t1.rowid";
		$sql .= " JOIN ".MAIN_DB_PREFIX."product t3 ON t3.rowid = t2.fk_product";
		$sql .= " WHERE 1> 0";
		// $sql .= " AND YEAR(t1.date_commande) = ".$slctdyear;
		$sql .= " AND (YEAR(t1.date_creation) = ".$slctdyear;
		$sql .= " or YEAR(t1.date_creation) = ".($slctdyear-1).")";
		$sql .= " AND t1.rowid in (SELECT fk_commande FROM ".MAIN_DB_PREFIX."commande_fournisseurdet)";

		if($type >= 0)
			$sql .= " AND fk_product_type = ".$type;
		$sql .= " GROUP BY t1.rowid ORDER BY  t1.rowid  DESC";

		// echo $sql;
        $resql = $this->db->query($sql);
        $resultat = array();

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {	
				// $month = $obj->date_commande;
				// if(empty($month))
				// 	$month = $obj->date_creation;
				// if(date("Y",strtotime($month)) == $slctdyear)
				// 	$resultat[date("m",strtotime($month)) + 0] += 1;
				$y = date("Y",strtotime($obj->date_creation)) + 0;
                $resultat[$y][date("m",strtotime($obj->date_creation)) + 0] += 1;
            }
        }
        // print_r($resultat);
        return $resultat;
    }


    // Nombre de factures clients
	public function products_factures($type, $slctdyear)
	{
		$resultat = array();
		
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."facture";
		$sql .= " WHERE YEAR(datef) = ".$slctdyear;
		$sql .= " AND rowid in (SELECT fk_facture FROM ".MAIN_DB_PREFIX."facturedet)";

		$sql = "SELECT t1.rowid, t1.datef, t2.fk_facture, t2.fk_product, t3.rowid, t3.fk_product_type";
		$sql .= " FROM ".MAIN_DB_PREFIX."facture t1";
		$sql .= " JOIN ".MAIN_DB_PREFIX."facturedet t2 ON t2.fk_facture = t1.rowid";
		$sql .= " JOIN ".MAIN_DB_PREFIX."product t3 ON t3.rowid = t2.fk_product";
		$sql .= " WHERE 1> 0";
		// $sql .= " AND YEAR(t1.datef) = ".$slctdyear;
		$sql .= " AND (YEAR(t1.datef) = ".$slctdyear;
		$sql .= " or YEAR(t1.datef) = ".($slctdyear-1).")";
		$sql .= " AND t1.rowid in (SELECT fk_facture FROM ".MAIN_DB_PREFIX."facturedet)";

		if($type >= 0)
			$sql .= " AND fk_product_type = ".$type;
		$sql .= " GROUP BY t1.rowid ORDER BY  t1.rowid  DESC";

		// echo $sql;
        $resql = $this->db->query($sql);
        $resultat = array();

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                // $resultat[date("m",strtotime($obj->datef)) + 0] += 1;
                $y = date("Y",strtotime($obj->datef)) + 0;
                $resultat[$y][date("m",strtotime($obj->datef)) + 0] += 1;
            }
        }
        // print_r($resultat);
        return $resultat;
    }
    // Nombre de factures clients
	public function products_facture_fournisseurs($type, $slctdyear)
	{
		$resultat = array();
		
		// $sql = "SELECT * FROM ".MAIN_DB_PREFIX."facture_fourn";
		// $sql .= " WHERE YEAR(datef) = ".$slctdyear;
		// $sql .= " AND rowid in (SELECT fk_facture_fourn FROM ".MAIN_DB_PREFIX."facture_fourn_det)";

		$sql = "SELECT t1.rowid, t1.datef, t2.fk_facture_fourn, t2.fk_product, t3.rowid, t3.fk_product_type";
		$sql .= " FROM ".MAIN_DB_PREFIX."facture_fourn t1";
		$sql .= " JOIN ".MAIN_DB_PREFIX."facture_fourn_det t2 ON t2.fk_facture_fourn = t1.rowid";
		$sql .= " JOIN ".MAIN_DB_PREFIX."product t3 ON t3.rowid = t2.fk_product";
		$sql .= " WHERE 1> 0";
		// $sql .= " AND YEAR(t1.datef) = ".$slctdyear;
		$sql .= " AND (YEAR(t1.datef) = ".$slctdyear;
		$sql .= " or YEAR(t1.datef) = ".($slctdyear-1).")";
		$sql .= " AND t1.rowid in (SELECT fk_facture_fourn FROM ".MAIN_DB_PREFIX."facture_fourn_det)";

		if($type >= 0)
			$sql .= " AND fk_product_type = ".$type;
		$sql .= " GROUP BY t1.rowid ORDER BY  t1.rowid  DESC";

		// echo $sql;
        $resql = $this->db->query($sql);
        $resultat = array();

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                // $resultat[date("m",strtotime($obj->datef)) + 0] += 1;
                $y = date("Y",strtotime($obj->datef)) + 0;
                $resultat[$y][date("m",strtotime($obj->datef)) + 0] += 1;
            }
        }
        // print_r($resultat);
        return $resultat;
    }






	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";
		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;
        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';
        // print_r($data);die();
        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : "'". $val ."'";
                $sql .= "`". $key. "` = ". $val .",";
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // echo $sql."<br>";

        // print_r($id);
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    = $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->number 	=  $obj->number;
				$line->issuedate 	=  $obj->issuedate;
				$line->expirydate 	=  $obj->expirydate;
				$line->date_notification 	=  $obj->date_notification;
				$line->fk_type_document 	=  $obj->fk_type_document;
				$line->fk_user 	=  $obj->fk_user;
				$line->file 	=  $obj->file;
				$line->description 	=  $obj->description;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id, $name = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
                $this->id    = $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->number 	=  $obj->number;
				$this->issuedate 	=  $obj->issuedate;
				$this->expirydate 	=  $obj->expirydate;
				$this->date_notification 	=  $obj->date_notification;
				$this->fk_type_document 	=  $obj->fk_type_document;
				$this->fk_user 	=  $obj->fk_user;
				$this->file 	=  $obj->file;
				$this->description 	=  $obj->description;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}




	public function select_documents_type($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."type_document";
    	// $sql2= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function select_user($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}











    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut"){
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function getmonth($year){
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function get_type_document($id){
    	$type='';
    	$sql ='SELECT name AS type FROM ' . MAIN_DB_PREFIX.'type_document WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$type = $this->db->fetch_object($exsql)->type;
    	}
    	return '<a href="'.dol_buildpath('/type_document/card.php?id='.$id,2).'">'.$type.'</a>';
    }

    public function get_employe($id){
    	$name='';
    	$sql ='SELECT login AS name FROM ' . MAIN_DB_PREFIX.'user WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$name = $this->db->fetch_object($exsql)->name;
    	}
    	return '<a href="'.dol_buildpath('/user/card.php?id='.$id,2).'">'.$name.'</a>';
    }

    public function logo_user($id){
    	$logo="";
    	$sql ='SELECT logo  FROM ' . MAIN_DB_PREFIX.'user WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$logo = $this->db->fetch_object($exsql);
    	}
    	return $logo;
    }




    
} 
?>