<?php 
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 

// dol_include_once('/chartsdolibarr/class/chartsdolibarr.class.php');

require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

class charts_banques extends Commonobject{ 

	public $errors = array();
	public $rowid;
	public $number;

	public $element='bank';
	public $table_element='bank';
	
	public function __construct($db){ 
		$this->db = $db;
		return 1;
    }

    













	public function banques_mouvementsmois($year, $month, $bank )
	{	
		global $langs;
		$langs->loadLangs(array('banks', 'categories'));

		$resultat = array();
		
		$object = new Account($this->db);
		if ($bank > 0)
			$result=$object->fetch($bank);

		$account = $bank;

		// Chargement du tableau $credits, $debits
		$credits = array();
		$debits = array();
		$datamin = array();

		$monthnext = $month+1;
		$yearnext = $year;
		if ($monthnext > 12)
		{
			$monthnext=1;
			$yearnext++;
		}

		$sql = "SELECT date_format(b.datev,'%d')";
		$sql.= ", SUM(b.amount)";
		$sql .= " FROM ".MAIN_DB_PREFIX."bank as b";
		$sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
		$sql.= " WHERE b.fk_account = ba.rowid";
		$sql.= " AND ba.entity IN (".getEntity('bank_account').")";
		$sql.= " AND b.datev >= '".$year."-".$month."-01 00:00:00'";
		$sql.= " AND b.datev < '".$yearnext."-".$monthnext."-01 00:00:00'";
		$sql.= " AND b.amount > 0";

		if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";
		$sql.= " GROUP BY date_format(b.datev,'%d')";

		$resql = $this->db->query($sql);
		if ($resql)
		{
			$num = $this->db->num_rows($resql);
			$i = 0;
			while ($i < $num)
			{
				$row = $this->db->fetch_row($resql);
				$credits[$row[0]] = $row[1];
				$i++;
			}
			$this->db->free($resql);
		}
		else
		{
			dol_print_error($this->db);
		}

		$monthnext = $month+1;
		$yearnext = $year;
		if ($monthnext > 12)
		{
			$monthnext=1;
			$yearnext++;
		}

		$sql = "SELECT date_format(b.datev,'%d')";
		$sql.= ", SUM(b.amount)";
		$sql .= " FROM ".MAIN_DB_PREFIX."bank as b";
		$sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
		$sql.= " WHERE b.fk_account = ba.rowid";
		$sql.= " AND ba.entity IN (".getEntity('bank_account').")";
		$sql.= " AND b.datev >= '".$year."-".$month."-01 00:00:00'";
		$sql.= " AND b.datev < '".$yearnext."-".$monthnext."-01 00:00:00'";
		$sql.= " AND b.amount < 0";
		if ($bank > 0 ) $sql.= " AND b.fk_account IN (".$account.")";
		$sql .= " GROUP BY date_format(b.datev,'%d')";


		// echo $sql;
		$resql = $this->db->query($sql);
		if ($resql)
		{
			while ($row = $this->db->fetch_row($resql))
			{
				$debits[$row[0]] = abs($row[1]);
			}
			$this->db->free($resql);
		}
		else
		{
			dol_print_error($this->db);
		}


		// Chargement de labels et data_xxx pour tableau 4 Mouvements
		$labels = array();
		$data_credit = array();
		$data_debit = array();


		$datamin = array();

		$subtotal = 0;
		$day = dol_mktime(12,0,0,$month,1,$year);
		$textdate = strftime("%Y%m%d",$day);
		$xyear = substr($textdate,0,4);
		$xday = substr($textdate,6,2);
		$xmonth = substr($textdate,4,2);

		// echo "xmonth : ".$xmonth."<br>";
		// echo "month : ".$month."<br>";
	
		$i = 0;
		while ($xmonth == $month)
		// for ($i = 0 ; $i < 31 ; $i++)
		{
			$data_credit[$i] = isset($credits[substr("0".($i+1),-2)]) ? $credits[substr("0".($i+1),-2)] : 0;
			$data_debit[$i] = isset($debits[substr("0".($i+1),-2)]) ? $debits[substr("0".($i+1),-2)] : 0;
			$labels[$i] = sprintf("%02d",$i+1);
			$datamin[$i] = $object->min_desired;




			$day += 86400;
			$textdate = strftime("%Y%m%d",$day);
			$xyear = substr($textdate,0,4);
			$xday = substr($textdate,6,2);
			$xmonth = substr($textdate,4,2);

			$i++;
		}

		// Fabrication tableau 4a
		$file= $conf->bank->dir_temp."/movement".$account."-".$year.$month.".png";
		$fileurl=DOL_URL_ROOT.'/viewimage.php?modulepart=banque_temp&file='."/movement".$account."-".$year.$month.".png";
		$title=$langs->transnoentities("BankMovements").' - '.$langs->transnoentities("Month").': '.$month.' '.$langs->transnoentities("Year").': '.$year;
		$graph_datas=array();
		// print_r($data_credit);
		foreach($data_credit as $i => $val)
		{
			$graph_datas[$i]=array($labels[$i],$data_credit[$i],$data_debit[$i]);
		}


		$resultat['title'] = $title;
		$resultat['graph_datas'] = $graph_datas;
		// print_r($resultat);

		return $resultat;
    }

    public function banques_soldemois($year, $month, $bank )
	{		
		global $langs;
		$langs->loadLangs(array('banks', 'categories'));

		$resultat = array();

		$object = new Account($this->db);
		if ($bank > 0)
			$result=$object->fetch($bank);

		// Loading table $amounts
		$amounts = array();

		$monthnext = $month+1;
		$yearnext = $year;
		if ($monthnext > 12)
		{
			$monthnext=1;
			$yearnext++;
		}

		$account = $bank;

		$sql = "SELECT date_format(b.datev,'%Y%m%d')";
		$sql.= ", SUM(b.amount)";
		$sql.= " FROM ".MAIN_DB_PREFIX."bank as b";
		$sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
		$sql.= " WHERE b.fk_account = ba.rowid";
		$sql.= " AND ba.entity IN (".getEntity('bank_account').")";
		$sql.= " AND b.datev >= '".$year."-".$month."-01 00:00:00'";
		$sql.= " AND b.datev < '".$yearnext."-".$monthnext."-01 00:00:00'";
		if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";
		$sql.= " GROUP BY date_format(b.datev,'%Y%m%d')";

		$resql = $this->db->query($sql);
		if ($resql)
		{
			$num = $this->db->num_rows($resql);
			$i = 0;
			while ($i < $num)
			{
				$row = $this->db->fetch_row($resql);
				$amounts[$row[0]] = $row[1];
				$i++;
			}
			$this->db->free($resql);
		}
		else
		{
			dol_print_error($this->db);
		}

		// Calculation of $solde before the start of the graph
		$solde = 0;

		$sql = "SELECT SUM(b.amount)";
		$sql.= " FROM ".MAIN_DB_PREFIX."bank as b";
		$sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
		$sql.= " WHERE b.fk_account = ba.rowid";
		$sql.= " AND ba.entity IN (".getEntity('bank_account').")";
		$sql.= " AND b.datev < '".$year."-".sprintf("%02s",$month)."-01'";
		if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";

		$resql = $this->db->query($sql);
		if ($resql)
		{
			$row = $this->db->fetch_row($resql);
			$solde = $row[0];
			$this->db->free($resql);
		}
		else
		{
			dol_print_error($this->db);
		}

		// Chargement de labels et datas pour tableau 1
		$labels = array();
		$datas = array();
		$datamin = array();

		$subtotal = 0;
		$day = dol_mktime(12,0,0,$month,1,$year);
		$textdate = strftime("%Y%m%d",$day);
		$xyear = substr($textdate,0,4);
		$xday = substr($textdate,6,2);
		$xmonth = substr($textdate,4,2);

		$i = 0;
		while ($xmonth == $month)
		{
			$subtotal = $subtotal + (isset($amounts[$textdate]) ? $amounts[$textdate] : 0);
			if ($day > time())
			{
				// $datas[$i] = ''; // Valeur speciale permettant de ne pas tracer le graph
			}
			else
			{
				$datas[$i] = $solde + $subtotal;
			}
			$datamin[$i] = $object->min_desired;
			$dataall[$i] = $object->min_allowed;
			//$labels[$i] = strftime("%d",$day);
			$labels[$i] = $xday;

			$day += 86400;
			$textdate = strftime("%Y%m%d",$day);
			$xyear = substr($textdate,0,4);
			$xday = substr($textdate,6,2);
			$xmonth = substr($textdate,4,2);

			$i++;
		}
		// If we are the first of month, only $datas[0] is defined to an int value, others are defined to ""
		// and this may make graph lib report a warning.
		//$datas[0]=100; KO
		//$datas[0]=100; $datas[1]=90; OK
		//var_dump($datas);
		//exit;

		// Fabrication tableau 1
		$file= $conf->bank->dir_temp."/balance".$account."-".$year.$month.".png";
		$fileurl=DOL_URL_ROOT.'/viewimage.php?modulepart=banque_temp&file='."/balance".$account."-".$year.$month.".png";
		$title=$langs->transnoentities("Balance").' - '.$langs->transnoentities("Month").': '.$month.' '.$langs->transnoentities("Year").': '.$year;
		$graph_datas=array();
		// print_r($datas);
		foreach($datas as $i => $val)
		{
			$graph_datas[$i]=array(isset($labels[$i])?$labels[$i]:'',$datas[$i]);
			if ($object->min_desired) array_push($graph_datas[$i],$datamin[$i]);
			if ($object->min_allowed) array_push($graph_datas[$i],$dataall[$i]);
		}

		$resultat['title'] = $title;
		$resultat['graph_datas'] = $graph_datas;
		// print_r($resultat);

		return $resultat;
    }





	public function banques_mouvementsannee($year, $month, $bank )
	{	
		global $langs;
		$langs->loadLangs(array('banks', 'categories'));

		$resultat = array();
		
		$object = new Account($this->db);
		if ($bank > 0)
			$result=$object->fetch($bank);

		$account = $bank;
		// Chargement du tableau $credits, $debits
		$credits = array();
	    $debits = array();
	    $sql = "SELECT date_format(b.datev,'%m')";
	    $sql.= ", SUM(b.amount)";
	    $sql.= " FROM ".MAIN_DB_PREFIX."bank as b";
	    $sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
	    $sql.= " WHERE b.fk_account = ba.rowid";
	    $sql.= " AND ba.entity IN (".getEntity('bank_account').")";
	    $sql.= " AND b.datev >= '".$year."-01-01 00:00:00'";
	    $sql.= " AND b.datev <= '".$year."-12-31 23:59:59'";
	    $sql.= " AND b.amount > 0";
	    if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";
	    $sql .= " GROUP BY date_format(b.datev,'%m');";

	    $resql = $this->db->query($sql);
	    if ($resql)
	    {
	      $num = $this->db->num_rows($resql);
	      $i = 0;
	      while ($i < $num)
	      {
	        $row = $this->db->fetch_row($resql);
	        $credits[$row[0]] = $row[1];
	        $i++;
	      }
	      $this->db->free($resql);
	    }
	    else
	    {
	      dol_print_error($this->db);
	    }
	    $sql = "SELECT date_format(b.datev,'%m')";
	    $sql.= ", SUM(b.amount)";
	    $sql.= " FROM ".MAIN_DB_PREFIX."bank as b";
	    $sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
	    $sql.= " WHERE b.fk_account = ba.rowid";
	    $sql.= " AND ba.entity IN (".getEntity('bank_account').")";
	    $sql.= " AND b.datev >= '".$year."-01-01 00:00:00'";
	    $sql.= " AND b.datev <= '".$year."-12-31 23:59:59'";
	    $sql.= " AND b.amount < 0";
	    if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";
	    $sql .= " GROUP BY date_format(b.datev,'%m')";

	    $resql = $this->db->query($sql);
	    if ($resql)
	    {
	      while ($row = $this->db->fetch_row($resql))
	      {
	        $debits[$row[0]] = abs($row[1]);
	      }
	      $this->db->free($resql);
	    }
	    else
	    {
	      dol_print_error($this->db);
	    }


	    // Chargement de labels et data_xxx pour tableau 4 Mouvements
	    $labels = array();
	    $data_credit = array();
	    $data_debit = array();
	    for ($i = 0 ; $i < 12 ; $i++)
	    {
	      $data_credit[$i] = isset($credits[substr("0".($i+1),-2)]) ? $credits[substr("0".($i+1),-2)] : 0;
	      $data_debit[$i] = isset($debits[substr("0".($i+1),-2)]) ? $debits[substr("0".($i+1),-2)] : 0;
	      $labels[$i] = dol_print_date(dol_mktime(12,0,0,$i+1,1,2000),"%b");
	      $datamin[$i] = $object->min_desired;
	    }

	    // Fabrication tableau 4b
	    $file= $conf->bank->dir_temp."/movement".$account."-".$year.".png";
	    $fileurl=DOL_URL_ROOT.'/viewimage.php?modulepart=banque_temp&file='."/movement".$account."-".$year.".png";
	    $title=$langs->transnoentities("BankMovements").' - '.$langs->transnoentities("Year").': '.$year;
	    $graph_datas=array();
	    foreach($data_credit as $i => $val)
	    {
	      $graph_datas[$i]=array($labels[$i],$data_credit[$i],$data_debit[$i]);
	    }


		$resultat['title'] = $title;
		$resultat['graph_datas'] = $graph_datas;
		// print_r($resultat);

		return $resultat;
    }
	
    public function banques_soldeannee($year, $month, $bank )
	{
		global $langs;
		$langs->loadLangs(array('banks', 'categories'));

		$resultat = array();

		$object = new Account($this->db);
		if ($bank > 0)
			$result=$object->fetch($bank);

		$account = $bank;
		$datetime = dol_now();

		$amounts = array();
		$sql = "SELECT date_format(b.datev,'%Y%m%d')";
		$sql.= ", SUM(b.amount)";
		$sql.= " FROM ".MAIN_DB_PREFIX."bank as b";
		$sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
		$sql.= " WHERE b.fk_account = ba.rowid";
		$sql.= " AND ba.entity IN (".getEntity('bank_account').")";
		$sql.= " AND b.datev >= '".$year."-01-01 00:00:00'";
		$sql.= " AND b.datev <= '".$year."-12-31 23:59:59'";
		if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";
		$sql .= " GROUP BY date_format(b.datev,'%Y%m%d')";

		$resql = $this->db->query($sql);
		if ($resql)
		{
			$num = $this->db->num_rows($resql);
			$i = 0;
			while ($i < $num)
			{
				$row = $this->db->fetch_row($resql);
				$amounts[$row[0]] = $row[1];
				$i++;
			}
			$this->db->free($resql);
		}
		else
		{
			dol_print_error($this->db);
		}

		// Calculation of $solde before the start of the graph
		$solde = 0;

		$sql = "SELECT SUM(b.amount)";
		$sql.= " FROM ".MAIN_DB_PREFIX."bank as b";
		$sql.= ", ".MAIN_DB_PREFIX."bank_account as ba";
		$sql.= " WHERE b.fk_account = ba.rowid";
		$sql.= " AND ba.entity IN (".getEntity('bank_account').")";
		$sql.= " AND b.datev < '".$year."-01-01'";
		if ($bank > 0) $sql.= " AND b.fk_account IN (".$account.")";

		// echo $sql;
		$resql = $this->db->query($sql);
		if ($resql)
		{
			$row = $this->db->fetch_row($resql);
			$solde = $row[0];
			$this->db->free($resql);
		}
		else
		{
			dol_print_error($this->db);
		}

		// Chargement de labels et datas pour tableau 2
		$labels = array();
		$datas = array();
		$datamin = array();
		$dataall = array();

		$subtotal = 0;
		$now = time();
		$day = dol_mktime(12,0,0,1,1,$year);
		$textdate = strftime("%Y%m%d",$day);
		$xyear = substr($textdate,0,4);
		$xday = substr($textdate,6,2);

		$i = 0;
		while ($xyear == $year && $day <= $datetime)
		{
			$subtotal = $subtotal + (isset($amounts[$textdate]) ? $amounts[$textdate] : 0);
			if ($day > $now)
			{
				$datas[$i] = ''; // Valeur speciale permettant de ne pas tracer le graph
			}
			else
			{
				$datas[$i] = $solde + $subtotal;
			}
			$datamin[$i] = $object->min_desired;
			$dataall[$i] = $object->min_allowed;
			// if ($xday == '15')
			// {
				$labels[$i] = dol_print_date($day,"%b");
			// }
			$day += 86400;
			$textdate = strftime("%Y%m%d",$day);
			$xyear = substr($textdate,0,4);
			$xday = substr($textdate,6,2);
			$i++;
		}

		// Fabrication tableau 2
		$file= $conf->bank->dir_temp."/balance".$account."-".$year.".png";
		$fileurl=DOL_URL_ROOT.'/viewimage.php?modulepart=banque_temp&file='."/balance".$account."-".$year.".png";
		$title=$langs->transnoentities("Balance").' - '.$langs->transnoentities("Year").': '.$year;
		$graph_datas=array();
		foreach($datas as $i => $val)
		{	
			// if(isset($labels[$i])){
				
			// }
			$graph_datas[$i]=array(isset($labels[$i])?$labels[$i]:'',$datas[$i]);
			if ($object->min_desired) array_push($graph_datas[$i],$datamin[$i]);
			if ($object->min_allowed) array_push($graph_datas[$i],$dataall[$i]);
		}


		$mois = $langs->trans("MonthShort01");
		$soldanne = array();
		foreach ($graph_datas as $key => $data) {
			
			$data0 = (!empty($data[0])) ? $data[0] : $mois;
			$val1 = (isset($data[1])) ? $data[1] : 0;
			if(!isset($soldanne[$data0]) || (isset($soldanne[$data0]) && $val1 > $soldanne[$data0]) )
				$soldanne[$data0] = $val1;

			if(!empty($data[0]))
				$mois = $data[0];
		}

		// print_r($soldanne);
		$resultat['title'] = $title;
		$resultat['graph_datas'] = $soldanne;
		// print_r($resultat);

		return $resultat;
    }









	public function create($echo_sql=0,$insert)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ( ";
		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return 0;
		} 
		return $this->db->db->insert_id;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;
        $sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';
        // print_r($data);die();
        if (count($data) && is_array($data))
            foreach ($data as $key => $val) {
                $val = is_numeric($val) ? $val : "'". $val ."'";
                $sql .= "`". $key. "` = ". $val .",";
            }

        $sql  = substr($sql, 0, -1);
        $sql .= ' WHERE rowid = ' . $id;
        // echo $sql."<br>";

        // print_r($id);
        // die($sql);

        $resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 

		return 1;
	}

    
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// die($sql);
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    = $obj->rowid;
				$line->rowid 	= $obj->rowid;
				$line->number 	=  $obj->number;
				$line->issuedate 	=  $obj->issuedate;
				$line->expirydate 	=  $obj->expirydate;
				$line->date_notification 	=  $obj->date_notification;
				$line->fk_type_document 	=  $obj->fk_type_document;
				$line->fk_user 	=  $obj->fk_user;
				$line->file 	=  $obj->file;
				$line->description 	=  $obj->description;
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	public function fetch($id, $name = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
                $this->id    = $obj->rowid;
				$this->rowid 	= $obj->rowid;
				$this->number 	=  $obj->number;
				$this->issuedate 	=  $obj->issuedate;
				$this->expirydate 	=  $obj->expirydate;
				$this->date_notification 	=  $obj->date_notification;
				$this->fk_type_document 	=  $obj->fk_type_document;
				$this->fk_user 	=  $obj->fk_user;
				$this->file 	=  $obj->file;
				$this->description 	=  $obj->description;
                // ....
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			return -1;
		}
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;

	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}




	public function select_documents_type($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX."type_document";
    	// $sql2= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function select_user($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql= "SELECT * FROM ".MAIN_DB_PREFIX."user";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			
			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->lastname.' '.$obj->firstname.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}



    public function getcountrows(){
        $tot = 0;
        $sql = "SELECT COUNT(rowid) as tot FROM ".MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);

        if($resql){
            while ($obj = $this->db->fetch_object($resql)) 
            {
                $tot = $obj->tot;
            }
        }
        return $tot;
    }

    public function getdateformat($date,$time=true){
        $d = explode(' ', $date);
        $date = explode('-', $d[0]);
        $d2 = explode(':', $d[1]);
        $result = $date[2]."/".$date[1]."/".$date[0];
        if ($time) {
            $result .= " ".$d2[0].":".$d2[1];
        }
        return $result;
    }

    public function getYears($debut="debut"){
        $sql = 'SELECT YEAR('.$debut.') as years FROM ' . MAIN_DB_PREFIX.get_class($this);
        $resql = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function getmonth($year){
        $sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
        $resql  = $this->db->query($sql);
        $years = array();
        if ($resql) {
            $num = $this->db->num_rows($resql);
            while ($obj = $this->db->fetch_object($resql)) {
                $years[$obj->years] = $obj->years;
            }
            $this->db->free($resql);
        }

        return $years;
    }

    public function get_type_document($id){
    	$type='';
    	$sql ='SELECT name AS type FROM ' . MAIN_DB_PREFIX.'type_document WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$type = $this->db->fetch_object($exsql)->type;
    	}
    	return '<a href="'.dol_buildpath('/type_document/card.php?id='.$id,2).'">'.$type.'</a>';
    }

    public function get_employe($id){
    	$name='';
    	$sql ='SELECT login AS name FROM ' . MAIN_DB_PREFIX.'user WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$name = $this->db->fetch_object($exsql)->name;
    	}
    	return '<a href="'.dol_buildpath('/user/card.php?id='.$id,2).'">'.$name.'</a>';
    }

    public function logo_user($id){
    	$logo="";
    	$sql ='SELECT logo  FROM ' . MAIN_DB_PREFIX.'user WHERE rowid = '.$id;
    	$exsql=$this->db->query($sql);
    	if($exsql){
    		$logo = $this->db->fetch_object($exsql);
    	}
    	return $logo;
    }

  


    
} 
?>