<?php
/*  Copyright (C) 2019 categorizeall Paulo Ricardo Carvalho de Oliveira	<paulorcdo@gmail.com>
 * Form based in /admin/dict.php
 
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       custom/categorizeall/card.php
 *		\brief      Page to administer fields
 */
$res=@include("../main.inc.php");// For root directory
$custom=0;

if (! $res)
{
$res=@include("../../main.inc.php");
$custom=1;
}// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formadmin.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/accounting.lib.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/bank.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/html.formproduct.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/product.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formbank.class.php';
require_once DOL_DOCUMENT_ROOT . '/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT . '/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formprojet.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.formaccounting.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formactions.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent.class.php';
require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent_type.class.php';

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcontract.class.php';
require_once DOL_DOCUMENT_ROOT.'/contrat/class/contrat.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formbarcode.class.php';
$formbarcode = new FormBarCode($db);
    
$adht = new AdherentType($db);
$formother=new FormOther($db);
$formproject = new FormProjets($db);  
$formbank = new FormBank($db);
$formactions = new FormActions($db);
$formcontract= new Formcontract($db);
		   
           
            
// Load translation files required by the page
if(!function_exists('loadLangs'))
			{
                
$langs->load("categorizeall@categorizeall");$langs->load("errors");$langs->load("admin");$langs->load("members");$langs->load("install");$langs->load("exports");$langs->load("banks");$langs->load("users");$langs->load("withdrawals");$langs->load("agenda");$langs->load("boxes");$langs->load("supplier_proposal");$langs->load("suppliers");$langs->load("compta");$langs->load("salaries");$langs->load("commercial");$langs->load("companies");$langs->load("donations");$langs->load("mails");$langs->load("resource");$langs->load("holiday");$langs->load("accountancy");$langs->load("hrm");$langs->load("orders");$langs->load("contracts");$langs->load("projects");$langs->load("propal");$langs->load("bills");$langs->load("interventions");$langs->load("sendings");$langs->load("deliveries");$langs->load("products");$langs->load("stocks");$langs->load("productbatch");$langs->load("categories");
         }
			else
			{
           $langs->loadLangs(array("errors","admin","main","members","salaries","install","exports","banks","users","categories","withdrawals","agenda","boxes","loan","trips","supplier_proposal","printing","sendings","ecm","dict","suppliers","compta","salaries","commercial","companies","donations", "mails","resource","holiday","accountancy","hrm","orders","contracts","projects","propal","bills","interventions","sendings","deliveries","products","other","categorizeall@categorizeall","stocks","productbatch"));
			}
 
$action=GETPOST('action','alpha')?GETPOST('action','alpha'):'view';
$confirm=GETPOST('confirm','alpha');
$id=GETPOST('id','int');
$rowid=GETPOST('rowid','alpha');
$entity=GETPOST('entity','int');
$code=GETPOST('code','alpha');
$formulario=GETPOST('form','alpha');
$tipocat=$db->escape(GETPOST('tipocat'));
 
    $campoextra='';
  

 
if($formulario=='ThirdParty'){$campoextra='societe';$nome='nom';$vinculo='fk_soc';$campoextra2=($tipocat==1?'fournisseur':$campoextra);}
elseif($formulario=='Contact'){$campoextra='socpeople';$campoextra2='contact';$vinculo='fk_socpeople';$tipocategoria=4;}
elseif($formulario=='Product-Service'){$campoextra='product'; $nome='label'; $vinculo='fk_product';$campoextra2=$campoextra;$tipocategoria=0;}
elseif($formulario=='FinancialAccount'){$campoextra='bank_account';$campoextra2='account';$vinculo='fk_account';$tipocategoria=5;}
elseif($formulario=='LeadOrProject'){$campoextra='projet';$vinculo='fk_project';$campoextra2='project';$tipocategoria=6;}
elseif($formulario=='User'){$campoextra='user';$campoextra2=$campoextra;$vinculo='fk_user';$tipocategoria=7;}
elseif($formulario=='Member'){$campoextra='adherent';$campoextra2='member';$vinculo='fk_member';$tipocategoria=3;}




$countrynotdefined=$langs->trans("ErrorSetACountryFirst").' ('.$langs->trans("SeeAbove").')';

$form = new Form($db);
$formadmin=new FormAdmin($db);
$formcompany = new FormCompany($db);


$extrafields = new ExtraFields($db);
 
$extralabels = $extrafields->fetch_name_optionals_label($campoextra);
 

 $result=restrictedArea($user,'categorizeall');
  
 $formproduct=new FormProduct($db);

$acts[0] = "activate";
$acts[1] = "disable";
$actl[0] = img_picto($langs->trans("Disabled"),'switch_off');
$actl[1] = img_picto($langs->trans("Activated"),'switch_on');

$listoffset=GETPOST('listoffset');
$listlimit=GETPOST('listlimit')>0?GETPOST('listlimit'):1000000;	 
$active = 1;
 
  
$tabname=array();
$tabname[1] =MAIN_DB_PREFIX."categorizeall";
  
$tabsql=array();
$tabsql[1] = "SELECT * FROM ".MAIN_DB_PREFIX."categorizeall_regras as m ";


 
$tabfield=array();
$tabfield[1] = "campo_nome,campo_texto,situacao,valor_padrao,label,conteudo,tooltip";
  
 
$tabfieldvalue=array();
$tabfieldvalue[1] = "campo_nome,campo_texto,situacao,valor_padrao,label,conteudo,tooltip";
 
 
$tabfieldinsert=array();
$tabfieldinsert[1] = "regra_nome,regra_tipo,regra_texto,form_nome,situacao,quant,ids,idcat";
 
 
$paramurl = '&id='.urlencode($id);
 
if (GETPOST('form')) $paramurl.= '&form='.urlencode(GETPOST('form','alpha'));

 
 
 $sql=$tabsql[$id];
 

    if (! preg_match('/ WHERE /',$sql)) $sql.= " WHERE form_nome='".$formulario."'";
     
              if ($action == 'edit')
         {
           $sql.= " and `rowid`=".$rowid;
           
           }
    $sql.=$db->plimit($listlimit+1,$offset);
     
      $resql=$db->query($sql);
      if ($resql)
    {
        $obj = $db->fetch_object($resql);
          if($obj->json)
          {
        $obj->json=stripslashes($obj->json);
        }
        }
        
        

llxHeader();

$fo=explode('-',$formulario);
$titre='<img align=midlle width=40 src="./img/object_categorizeall.png">'.$langs->trans("CategorizeAll")." / ".$langs->trans("Categorias")." / ".($formulario=='Product-Service'?$langs->trans('Product').'-'.$langs->trans('Service'):$langs->trans($formulario));
 $linkback='<a href="'.DOL_URL_ROOT.($custom==1?'/custom':'').'/categorizeall/list.php">'.$langs->trans("Backtolist").'</a>';
 
 

$titlepicto='';

print load_fiche_titre($titre,$linkback,$titlepicto);

  if (GETPOST('actionremodify'))
{


 
$total_categorizaveis=$db->escape(GETPOST('total_categorizaveis'));
$lista_categorizaveis=$db->escape(GETPOST('lista_categorizaveis'));
$rowid=$db->escape(GETPOST('rowid'));
$campo=$db->escape(GETPOST('campo'));
$tipocat=$db->escape(GETPOST('tipocat'));
$nomecat=$db->escape(GETPOST('nomecat'));
$textocat=$db->escape(GETPOST('textocat'));
$color=$db->escape(GETPOST('color'));
$idcat=$db->escape(GETPOST('idcat'));

$db->query('SET foreign_key_checks = 0');

$sqldelcat = "DELETE FROM `".MAIN_DB_PREFIX."categorie_".$campoextra2."`  WHERE `fk_categorie`=".$idcat;
 

$resql = $db->query($sqldelcat);

 $db->query('SET foreign_key_checks = 1');

    
     if (! $resql)
    {
       if ($db->errno() != '')
        {
            setEventMessages($db->errno(), null, 'errors');
        }
    }
    else
    {
        
              
        
        $listanova=explode(',',$lista_categorizaveis);
        $quantidade=count($listanova);
        
        for ($i = 0; $i < $quantidade; $i++) {
            
        
 $sqlinsert2 = "INSERT INTO `".MAIN_DB_PREFIX."categorie_".$campoextra2."` (`fk_categorie`, `".$vinculo."`) VALUES ('".$idcat."', '".$listanova[$i]."');";

     $resultinsert2 = $db->query($sqlinsert2);
            
       //f echo $sqlinsert2."<br>";
        
        }
    
     if (! $resultinsert2)
    {
        if ($db->errno() != '')
        {
            setEventMessages($db->errno(), null, 'errors');
        }
    }
    else
    {
         $sqlupdate="UPDATE `".MAIN_DB_PREFIX."categorizeall_regras` SET situacao=2, modif='".$db->idate(dol_now())."', quant='".$quantidade."', ids='".urldecode($lista_categorizaveis)."', cor='".$color."', regra_tipo='".$tipocat."'   WHERE rowid=".$rowid;
         
     $sqlupdate2="UPDATE `".MAIN_DB_PREFIX."categorie`  set color='".$color."', type='".$tipocat."'   WHERE rowid=".$idcat;
      $resultupdate2 = $db->query($sqlupdate2);
      
//echo $sqlupdate;

    dol_syslog("delete", LOG_DEBUG);
    $resultupdate = $db->query($sqlupdate);
    if (! $resultupdate)
    {
        if ($db->errno() != '')
        {
            setEventMessages($db->errno(), null, 'errors');
        }
         
    }
    else
    {
        setEventMessages($langs->trans("CategorizeAll").' - '.$langs->trans("RecordsInserted"), null, 'mesgs');
      }
    }
}        
   print '<script>setTimeout(function(){ window.location.href="'.$_SERVER["PHP_SELF"].'?id='.urlencode($id).'&rowid='.urlencode($rowid). '&form='.urlencode(GETPOST('form','alpha')).'";}, 1000);</script>';  
      
       
        
        
}
 
   
 
  if (GETPOST('actionmodify'))
{


 
$total_categorizaveis=$db->escape(GETPOST('total_categorizaveis'));
$lista_categorizaveis=$db->escape(GETPOST('lista_categorizaveis'));
$rowid=$db->escape(GETPOST('rowid'));
$campo=$db->escape(GETPOST('campo'));
$tipocat=$db->escape(GETPOST('tipocat'));
$nomecat=$db->escape(GETPOST('nomecat'));
$textocat=$db->escape(GETPOST('textocat'));
$color=$db->escape(GETPOST('color'));

 $sqlinsert = "INSERT INTO `".MAIN_DB_PREFIX."categorie` (`rowid`, `entity`, `fk_parent`, `label`,  `type`, `description`,  `color`,`visible`) VALUES (NULL, '1', '0', '".$nomecat."', '".$tipocat."','[CategorizeAll] ".urldecode($textocat)."','".$color."','0');";
 
     $resultinsert = $db->query($sqlinsert);
    
     if (! $resultinsert)
    {
       if ($db->errno() != '')
        {
            setEventMessages($db->errno(), null, 'errors');
             
        }
    }
    else
    {
        
             
    $insertedrowid=$db->last_insert_id(MAIN_DB_PREFIX.'categorie');
        
        $listanova=explode(',',$lista_categorizaveis);
        $quantidade=count($listanova);
        
        for ($i = 0; $i < $quantidade; $i++) {
            
        
 $sqlinsert2 = "INSERT INTO `".MAIN_DB_PREFIX."categorie_".$campoextra2."` (`fk_categorie`, `".$vinculo."`) VALUES ('".$insertedrowid."', '".$listanova[$i]."');";

     $resultinsert2 = $db->query($sqlinsert2);
            
        //   echo $sqlinsert2."<br>";
        
        }
    
     if (! $resultinsert2)
    {
        if ($db->errno() != '')
        {
            setEventMessages($db->errno(), null, 'errors');
        }
    }
    else
    {
         $sqlupdate="UPDATE `".MAIN_DB_PREFIX."categorizeall_regras` SET situacao=2, modif='".$db->idate(dol_now())."', quant='".$quantidade."', idcat='".$insertedrowid."', ids='".urldecode($lista_categorizaveis)."', cor='".$color."', regra_tipo='".$tipocat."'  WHERE rowid=".$rowid;
      
//echo $sqlupdate;

    dol_syslog("delete", LOG_DEBUG);
    $resultupdate = $db->query($sqlupdate);
    if (! $resultupdate)
    {
        if ($db->errno() != '')
        {
            setEventMessages($db->errno(), null, 'errors');
        }
         
    }
    else
    {
        setEventMessages($langs->trans("categorizeAll").' - '.$langs->trans("RecordsInserted"), null, 'mesgs');
      }
    }
}        
  //print '<script>setTimeout(function(){ window.location.href="'.$_SERVER["PHP_SELF"].'?id='.urlencode($id).'&rowid='.urlencode($rowid). '&form='.urlencode(GETPOST('form','alpha')).'";}, 1000);</script>';  
      
       
        
        
}



if ($action == 'delete')
{
    print $form->formconfirm($_SERVER["PHP_SELF"].'?'.($page?'page='.$page.'&':'').'rowid='.urlencode($rowid).'&code='.urlencode($code).$paramurl, $langs->trans('DeleteLine'), $langs->trans('ConfirmDeleteLine'), 'confirm_delete','',0,1);
}

if ($action == 'confirm_delete' && $confirm == 'yes')       // delete
{
    if ($tabrowid[$id]) { $rowidcol=$tabrowid[$id]; }
    else { $rowidcol="rowid"; }
    
      
$sql = 'SELECT idcat FROM `'.MAIN_DB_PREFIX.'categorizeall_regras` where `rowid`="'.$db->escape($rowid).'"';
 
$resql = $db->query($sql);
if ($resql)
{
$obj = $db->fetch_object($resql);
}
 
if($obj->idcat>0)
{
$db->query('SET foreign_key_checks = 0');


$sqldelcat2 = "DELETE FROM ".MAIN_DB_PREFIX."categorie_".$campoextra."  WHERE `fk_categorie`=".$obj->idcat;
$resql = $db->query($sqldelcat2);

$sqldelcat = "DELETE FROM ".MAIN_DB_PREFIX."categorie WHERE `rowid`=".$obj->idcat;
$resql = $db->query($sqldelcat);
 
 
$db->query('SET foreign_key_checks = 1');
}    
 
    $sql = "DELETE FROM ".MAIN_DB_PREFIX."categorizeall_regras WHERE ".$rowidcol."='".$db->escape($rowid)."'";
 

    dol_syslog("delete", LOG_DEBUG);
    $result = $db->query($sql);
    if (! $result)
    {
        if ($db->errno() == 'DB_ERROR_CHILD_EXISTS')
        {
            setEventMessages($langs->transnoentities("ErrorRecordIsUsedByChild"), null, 'errors');
        }
        else
        {
            dol_print_error($db);
        }
    }
    else
    {
          setEventMessages($langs->trans("CategorizeAll").' - '.$langs->trans("RecordsDeleted"), null, 'mesgs');
        }
        
       print '<script>setTimeout(function(){ window.location.href="'.$_SERVER["PHP_SELF"].'?id='.urlencode($id).'&rowid='.urlencode($rowid). '&form='.urlencode(GETPOST('form','alpha')).'";}, 1000);</script>';  
      
       
}

//var_dump($elementList);



/*
 * Show a dictionary
 */
if ($id)
{
     $anopassado=date("Y-m-d",strtotime("-1 year"));
 $hoje=date("Y-m-d",strtotime("+1 day"));
 
 
   

    // Complete requete recherche valeurs avec critere de tri
    $sql=$tabsql[$id];

    if (! preg_match('/ WHERE /',$sql)) $sql.= " WHERE form_nome='".$formulario."'  order by situacao asc,  regra_nome asc, rowid asc";
     
    $sql.=$db->plimit($listlimit+1,$offset);
   //  print $sql;

    if (empty($tabfield[$id]))
    {
    	dol_print_error($db, 'The table with id '.$id.' has no array tabfield defined');
    	exit;
    }
    $fieldlist=explode(',',$tabfield[$id]);

   
    

    print '<form action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&form='.$formulario.'" method="POST">';
    print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
    print '<input type="hidden" name="from" value="'.dol_escape_htmltag(GETPOST('from','alpha')).'">';

    // List of available record in database
    dol_syslog("htdocs/admin/dict", LOG_DEBUG);
    $resql=$db->query($sql);
    if ($resql)
    {
        $num = $db->num_rows($resql);
        $i = 0;
$cats=0;
$cris=0;
  
        
        // There is several pages
        if ($num > $listlimit || $page)
        {
            print_fleche_navigation($page, $_SERVER["PHP_SELF"], $paramurl, ($num > $listlimit), '<li class="pagination"><span>'.$langs->trans("Page").' '.($page+1).'</span></li>');
            print '<div class="clearboth"></div>';
        }
 
                      print '<label style="display:block; width: 91%;" for=rules><h3><span style="padding-top:0px;font-size:20px;" class="fa fa-info-circle classfortooltip" title="<center><h3>'.$langs->trans("ComoFazer").' </h3></center>'.($action != 'edit'?$langs->trans("ComoFazerListadeCategoriaspasso1"):$langs->trans("ComoFazerListadeCategoriaspasso2")).'" ></span>&nbsp;&nbsp;'. ($action== 'edit'?$langs->trans('Passo2'):$langs->trans('Passo1')).'<p>';
                      
                       if ($action != 'edit')
         {
                      
                      print '<input style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px;" type="button" class="button" onclick=novacategoria(); value="'.$langs->trans("NovaCategoria").'"><input style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px; " type="button" id=cris class="button" onclick=listacategorias(1); value="'.$langs->trans("ListadeCriterios").'"> <input style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px; " id=cats type="button" class="button" onclick=listacategorias(2); value="'.$langs->trans("ListadeCategorias").'"> </h3   >';
          }

                       print '</label></h3><hr> <h4><span id=titulo></span></h4></span><div id="listacategorias"  class="div-table-responsive"  " > ';
                        
        print ' <table class="noborder responsive" width="100%">';
        
         if ($action == 'edit')
         {
              
               
       print '<tr class="liste_titre"><th align=center nowrap >'.$langs->trans("Id").'<th align=center >'.$langs->trans("Detalhes");
                    	$withentity = EditaCampo($fieldlist, $obj, $tabname[$id], 'edit',$campocountry_id,$formulario);
          }
          else
          {
         print '<tr class="liste_titre"><th align=center >'.$langs->trans("Categoria").'<th align=center >'.$langs->trans("Itens").'<th align=center >'.$langs->trans("Criterios").'<th align=center >'.$langs->trans("Situacao").'<th align=center >'.$langs->trans("Atualizacao").'<th align=center >'.$langs->trans("Acoes");
        }
        
        if($num==0)
        {
             print '<tr ><td  colspan=6 align=center >'.$langs->trans("Select2NotFound");
            
            }
        
           $listajson= ' var arraylistajson = {'; 
         if ($num)
        {
            // Lines with values
                
       
           
            while ($i < $num)
            {
                $obj = $db->fetch_object($resql);
                
                  if($obj->situacao==2)
                 {$cats++;}
                 else
                 {$cris++;}
                 
               
                
                
                  $url = $_SERVER["PHP_SELF"].'?rowid='.$obj->rowid;
                    if (! empty($paramurl)) $url .= '&'.$paramurl;
                    if (! is_null($withentity)) $url .= '&entity='.$withentity;
                  
                    $url.="&";
                     
			 if ($action == 'edit' && ($rowid == (! empty($obj->rowid)?$obj->rowid:$obj->code)))
                {
                   
                    print '<tr><td colspan="3" align="center">';
                    print '<div name="'.(! empty($obj->rowid)?$obj->rowid:$obj->code).'"></div>';
                    print '<input type="hidden" name="page" value="'.dol_escape_htmltag($page).'">';
                    print '<input type="hidden" name="rowid" value="'.dol_escape_htmltag($rowid).'">';
                    if (! is_null($withentity))
                    	print '<input type="hidden" name="entity" value="'.$withentity.'">';
                        if($obj->situacao==1)
                        {
                    print '<input type="submit" style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px; "  class="button" name="actionmodify" value="'.$langs->trans("NovaCategoria").'">';
                     }
                        else
                        {
                            print '<input type="hidden"  name="idcat" value="'.$obj->idcat.'">';
                    print '<input type="submit" style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px; "   class="button" name="actionremodify" value="'.$langs->trans("AtualizarCategoria").'">';
                     }
                     print '<input type="hidden"  name="campo" value="'.$campoextra.'">';
                       print '<input type="hidden"  name="nomecat" value="'.$obj->regra_nome.'">';
                     print '<input type="hidden"  name="textocat" value="'.$obj->regra_texto.'">';
                     
                   
                    print '<input type="submit" style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px; "  class="button" name="actioncancel" value="'.$langs->trans("Cancel").'">';
                    
                    
                    print '</td>';
                }
                
                 elseif ($action != 'edit')
                
                {
                    // Modify link
                //fa-pencil-square
              if($obj->regra_tipo==1&&$obj->form_nome=='ThirdParty')
              {
                $ttipo=$langs->trans("TipoCatFornecedor");
                }
                elseif($obj->regra_tipo==2&&$obj->form_nome=='ThirdParty')
               
                 {
                $ttipo=$langs->trans("TipoCatCliente");
                }
              else
              {
                $ttipo='';
                }
              
               print '<tr class="oddeven '.($obj->situacao==2?'categoria':'criterio').' " id="rowid-'.$obj->rowid.'" ><td align=left style="font-size:16px;width:20%" ><a  href="'.$url.'action=edit" >'.($obj->situacao==2?'<span    style="font-size:26px;text-shadow:1px 1px 1px #111; color:#'.$obj->cor.'"  class=\'fa fa-tags classfortooltip  \' title="'.$langs->trans("CategoriaCriada").' '.$ttipo.'"  ></span>&nbsp;&nbsp;':'').$obj->regra_nome.'</b></a><td style="width:3%"  align=center >'.$obj->quant.'<td align=left   style="font-size:12px;width:40%" >'.urldecode($obj->regra_texto).'<td align=center >'.($obj->situacao==2?$langs->trans("CategoriaCriada"):$langs->trans("CriteriosDefinidos")).'<td align=center style="font-size:10px;width:3%" >'.$obj->modif.'<td align="right">';
              
                 if($obj->situacao==1)
                 {
                   
                print ' <a class="reposition"  href="javascript://" onclick=inserejson('.$obj->rowid.',1);><span   style="font:bold 16px"   class=\'fa fa-pencil classfortooltip  \'  title=\''.$langs->trans("CliqueParaEditar").'\'></span></a>&nbsp;&nbsp;&nbsp;';
                 
                 }
                  else
                  {
                    $arr=json_decode(stripslashes($obj->json),true);
                    for ($x = 0; $x <  count($arr)-3; $x++) {
        
                  if($arr[$x]["operador"]=="5")
                  {
                        $ini=$arr[$x]["dadosvalorpadrao"][0][2];
                        $fim=$arr[$x]["dadosvalorpadrao"][0][3];
                         
                         
                        }
                        
                   }
                    
                    
                    $l2="";
                    
$separaini=explode('-',$ini);
$date_startmonth=$separaini[1];
$date_startday=$separaini[2];
$date_startyear=$separaini[0];
$separafim=explode('-',$fim);
$date_endmonth=$separafim[1];
$date_endday=$separafim[2];
$date_endyear =$separafim[0];


if($obj->form_nome=='ThirdParty'&&$obj->regra_tipo==2){$linkform='/societe/list.php?leftmenu=thirdparties&search_categ_cus=';$l2='/compta/stats/casoc.php?leftmenu=report&sortfield=amount_ht&sortorder=desc&search_categ=';$l3='&date_startyear='.$date_startyear.'&date_startmonth='.$date_startmonth.'&date_startday='.$date_startday.'&date_endyear='.$date_endyear.'&date_endmonth='.$date_endmonth.'&date_endday='.$date_endday; }
else if($obj->form_nome=='ThirdParty'&&$obj->regra_tipo==1){$linkform='/societe/list.php?leftmenu=thirdparties&search_categ_sup=';$l2='/compta/stats/casoc.php?leftmenu=report&sortfield=amount_ht&sortorder=desc&search_categ=';$l3='&date_startyear='.$date_startyear.'&date_startmonth='.$date_startmonth.'&date_startday='.$date_startday.'&date_endyear='.$date_endyear.'&date_endmonth='.$date_endmonth.'&date_endday='.$date_endday; }
elseif($obj->form_nome=='Contact'){$linkform='/contact/list.php?leftmenu=thirdparties&search_categ=';}
elseif($obj->form_nome=='Product-Service'){$linkform='/product/list.php?leftmenu=product&search_categ=';$l2='/compta/stats/cabyprodserv.php?leftmenu=report&modecompta=CREANCES-DETTES&search_categ=';$l3='&date_startyear='.$date_startyear.'&date_startmonth='.$date_startmonth.'&date_startday='.$date_startday.'&date_endyear='.$date_endyear.'&date_endmonth='.$date_endmonth.'&date_endday='.$date_endday; }
elseif($obj->form_nome=='FinancialAccount'){$linkform='/compta/bank/list.php?mainmenu=bank&leftmenu=&search_categ=';}
elseif($obj->form_nome=='LeadOrProject'){$linkform='/projet/list.php?leftmenu=projets&search_categ=';}
elseif($obj->form_nome=='User'){$linkform='/user/list.php?leftmenu=users&search_categ=';}
elseif($obj->form_nome=='Member'){$linkform='/adherents/list.php?leftmenu=members&search_categ=';}

      if($obj->regra_tipo==1)
      {
        $l2='';
        }
      
                    if($l2!='')
                    {
                  print ' <a href="'.DOL_URL_ROOT.$l2.$obj->idcat.$l3.'" > <span    style="font-size:18px;color:#000078"  class=\'fa fa-usd classfortooltip \'  title=\''.$langs->trans("CliqueParaVerRelatorioVendas").'\' ></a> &nbsp; ';
                 
           }
                  
                 print ' <a href="'.DOL_URL_ROOT.$linkform.$obj->idcat.'"> <span    style="font-size:18px;color:#000078"  class=\'fa fa-file-o classfortooltip \'  title=\''.$langs->trans("CliqueParaVerLista").'\' ></a> &nbsp; ';   
                      
                     print ' <a href="'.DOL_URL_ROOT.'/categories/viewcat.php?id='.$obj->idcat.'"> <span    style="font-size:18px;"  class=\'fa fa-search classfortooltip \'  title=\''.$langs->trans("CliqueParaVerCategoriaCriada").'\' ></a> &nbsp; ';
                    }
                 
                    
             print ' <a  href="'.$url.'action=edit" ><span    style="font-size:18px"  class=\'fa fa-tags classfortooltip  \'  title=\''.$langs->trans("CliqueParaCriarCategoria").'\'></span></a>&nbsp;&nbsp;<a class="reposition"  href="'.$url.'&action=delete" ><span   style="font-size:18px"   class=\'fa fa-times-circle classfortooltip \'  title=\''.$langs->trans("CliqueParaExcluir").'\'></span></a></td>';
                
                 
                $listajson.='"'.$obj->rowid.'":'.stripslashes($obj->json).''.(($i < $num-1)?",":"");
                
                }
                

                
                
                
                $i++;
        }
 }
         $listajson.='};';
         
         print '</table></div>';
         
         
         
        print '  <script>';
          print '$("#cris").val($("#cris").val()+" ('.$cris.')");
          ';
         print '$("#cats").val($("#cats").val()+" ('.$cats.')");
         ';       
        print $listajson;
        
        print $propal_soc;
        print $commandesoc;
        print $facturesoc;
        print   $facture_prod;
        print $propal_prod;
        print   $commande_prod;
          
          print '
          
          var arraynovaregra = [];
          
          function listacategorias(num)
          {
          if (num==1)
          {
          $("#titulo").html("'.$langs->trans("ListadeCriterios").'");
 
          $("#editacategoria").hide();
          $("#listacategorias").show();
          $("tr.categoria").hide();
          $("tr.criterio").show();
           $("#titulo").show();
          
          }
          if (num==2)
          {
          $("#editacategoria").hide();
          $("#listacategorias").show();
            $("tr.criterio").hide();
           $("tr.categoria").show();
                     $("#titulo").html("'.$langs->trans("ListadeCategorias").'");
   $("#titulo").show();
          
          }
          
           
 
          }
          listacategorias(2);
          function crialabel(id,array)
          {
         
newArray=nestedToArray(array);
 tab="<table style=\'font-size:10px\' cellpadding=1  cellspacing=0 border=1 width=100% > <tr><th>'.$langs->trans("situacao").'<th>'.$langs->trans("Total").'<th>'.$langs->trans("C").'<th>'.$langs->trans("B").'<th>'.$langs->trans("A").'</th>";
          

for (i = 0; i < newArray.length; i++) {
novamedia=(newArray[i]["soma"]/newArray[i]["quant"]);
mmede=(novamedia-newArray[i]["desvio"]);
lsmmede=(mmede>newArray[i]["min"]?parseInt(mmede):parseInt(newArray[i]["min"]*1.1));
mmade=(novamedia*1+newArray[i]["desvio"]*1);
 
tmmede="0 - "+lsmmede;
tmedia=parseInt(lsmmede+1)+" - "+parseInt(mmade);
tmmade=parseInt(mmade+1)+" - "+ parseInt(newArray[i]["soma"]*1.01);

tab+="<tr><td>"+newArray[i]["sit"]+"("+parseInt(newArray[i]["quant"])+")<td align=right>"+parseInt(newArray[i]["soma"])+"<td align=right>"+ (newArray[i]["quant"]<2||newArray[i]["max"]==newArray[i]["min"]?"-":tmmede)+"<td align=right>"+ (newArray[i]["quant"]<2||newArray[i]["max"]==newArray[i]["min"]?"-":tmedia)+"<td align=right>"+(newArray[i]["quant"]<2||newArray[i]["max"]==newArray[i]["min"]?"-":tmmade);
}
 tab+="</table>";
$("#"+id+"").prop("title",tab) ;
 
          }
          
           function novacategoria()
          {
          $("#nomecat").prop("disabled", false);  
          arraynovaregra=[];
          $(listaregras).empty();
          $("#nomecat").val("");
          $("#edita").val(0);
          $("#listacategorias").hide();
          $("#editacategoria").show();
 $("#titulo").hide();
          }
          
           function nestedToArray(nested) {
    let arrayOfObjects = [];

    for (const prop in nested) {
        if (nested.hasOwnProperty(prop)) {
            arrayOfObjects.push(nested[prop]);
          } 
    }
    return arrayOfObjects;
}

function inserejson(ejson,tipo)
{

novacategoria();
var newArray = Array();
 
$("#nomecat").val(arraylistajson[ejson]["nomecat"]);
 
$("#edita").val(ejson);
 
 

delete arraylistajson[ejson]["nomecat"];
delete arraylistajson[ejson]["form"];
delete arraylistajson[ejson]["edita"];

newArray=nestedToArray(arraylistajson[ejson]);
for (i = 0; i < newArray.length; i++) {
arraynovaregra.push(newArray[i]);
}
crialista();
}
          
          
          
           function buscajson(arra) {
            
           return "{\"form\":\"'.$formulario.'\",\"nomecat\":\""+$("#nomecat").val()+"\",\"edita\":\""+$("#edita").val()+"\","+criajson(arra)+"}";
           
           }
       
  var dumped_text = "";
          
 function criajson(arr,level) {
  var dumped_text = "";
  if(!level) level = 0;

  
 
    for(var item in arr) {
      var value = arr[item];

      if(typeof(value) == "object") { //If it is an array,
        dumped_text +=  "\"" + encodeURIComponent(item) + "\":";
        dumped_text +="{"+criajson(value,level)+"},";
      } else {
        dumped_text += "\"" + encodeURIComponent(item) + "\":\"" + encodeURIComponent(value) + "\",";
      }
      
       
    }
   dumped_text=dumped_text.substring(0, dumped_text.length - 1);
    
  return dumped_text;
}


 
function removeDumplicateValue(myArray){ 
      var newArray = [];
    
      $.each(myArray.reverse(), function(key, value) {
        var exists = false;
        $.each(newArray, function(k, val2) {
          if(value.nome == val2.nome){ exists = true }; 
        });
        if(exists == false && value.nome != "") { newArray.push(value); }
      });
   
      return newArray.reverse();
    }
    
    function remover(myArray,campo){ 
      var newArray = [];
       
for (i = 0; i < arraynovaregra.length; i++) {

if(arraynovaregra[i]["nome"] == campo)
{

}
else
{
newArray.push(arraynovaregra[i]);
}

}
     
     arraynovaregra=newArray;
     crialista();
     
    }
    
      function dump(arr,level) {
  var dumped_text = "";
  if(!level) level = 0;

  //The padding given at the beginning of the line.
  var level_padding = "";
  for(var j=0;j<level+1;j++) level_padding += "    ";

  if(typeof(arr) == "object") { //Array/Hashes/Objects
    for(var item in arr) {
      var value = arr[item];

      if(typeof(value) == "object") { //If it is an array,
        dumped_text += level_padding + "\'" + item + "\' ...\n";
        dumped_text += dump(value,level+1);
      } else {
        dumped_text += level_padding + "\'" + item + "\' => \"" + value + "\"\n";
      }
    }
  } else { //Stings/Chars/Numbers etc.
    dumped_text = "===>"+arr+"<===("+typeof(arr)+")";
  }
  return dumped_text;
}

      function transferFailed(evt) {
  alert("Um erro ocorreu durante a transferência do arquivo.");
}

    function envia()
    {
     
      if($("#nomecat").val()=="")
      {
      alert("'.$langs->trans("InformeoNomedaCategoria").'");
      $("#nomecat").focus();
      return false;
      }
      
       if(arraynovaregra.length<1)
      {
      alert("'.$langs->trans("InformeoCriteriodaCategoria").'");
      $("#nomecat").focus();
      return false;
      }
       
 var data = "data="+JSON.stringify(buscajson(arraynovaregra));
  
//alert(data);
 

var xhr = new XMLHttpRequest();
xhr.addEventListener("error", transferFailed, false);
xhr.open("POST", "insere.php", !0);
xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
xhr.send(data);
xhr.onreadystatechange = function () {
    if (xhr.readyState === 4 && xhr.status === 200) {
    
     //alert(xhr.responseText);
            if(xhr.responseText<=0)
        {
        alert("'.$langs->trans("Erro").'");
        }
       
    else
    {
        if(xhr.responseText==91)
        {
        alert("'.$langs->trans("RegraAtualizadaErro").'");
        }
        else if(xhr.responseText==99)
        {
        alert("'.$langs->trans("NomeExiste").'");
        return false;
        
        }
        else if(xhr.responseText==92)
        {
        alert("'.$langs->trans("RegraInseridaErro").'");
        }
        else if(xhr.responseText==11)
        {
        alert("'.$langs->trans("RegraAtualizadaSucesso").'");
        }
       else  if(xhr.responseText==12)
        {
        alert("'.$langs->trans("RegraInseridaSucesso").'");
        }
        window.location.href=window.location.href
    }


    

    }
} 
    
    }

function insere(i,c1,c2,c3,c4,c5)
{
var  arrayregras = [];

arrayregras.id = i;
arrayregras.tipo = c1;
arrayregras.label = c2;
arrayregras.nome = c3;
arrayregras.banco = c5;
arrayregras.extra = c4;
nomeoperador="sel_ope_valor_padrao"+c3;
arrayregras.operador = $("[name=\'"+nomeoperador+"\']").val()


   
var op = [];
$.each($("#"+nomeoperador+" option:selected"), function(){            
op.push($(this).text());
 });
   
    
     
 arrayregras.textooperador = op.join(", ");
if(c3=="contcats"||c3=="custcats"||c3=="suppcats"||c3=="commercial"||c3=="categories"||c3=="usercats"||c3=="memcats"||c3=="socpeopleassigned"||(c4==1&&c1=="checkbox")||(c4==1&&c1=="chkbxlst"))
{
nomevalorpadrao="valor_padrao"+c3+"[]";
}
else
{
nomevalorpadrao="valor_padrao"+c3;
}

    
       
 
 if(c1=="input"||c1=="textarea"||c1=="text"||c1=="html" ||c1=="date"||c1=="datetime"|| c1=="varchar"|| c1=="phone"|| c1=="mail"|| c1=="url" ||c1=="int"||c1=="double"||c1=="price" ||c1=="boolean")
 
 {  
 
          //  alert(c1); 
        if(c3=="re"||c3=="birthday"||c3=="tms"||c3=="datec"||c3=="projectstart"||c3=="projectend"||c3=="birth"||c3=="dateemployment"||c3=="dateemploymentend"||c1=="date"||c1=="int"||c1=="double"||c1=="price"||c1=="datetime"||c3=="desiredstock"||c3=="seuil_stock_alerte"||c3=="duration_value"||c3=="weight"||c3=="size"||c3=="sizewidth"||c3=="sizeheight"||c3=="surface"||c3=="volume"||c3=="price"||c3=="price_min"||c3=="capital"||c3=="solde"||c3=="account_min_allowed"||c3=="opp_percent"||c3=="opp_amount"||c3=="budget_amount"||c3=="thm"||c3=="tjm"||c3=="salary"||c3=="weeklyhours"||c3=="remise_client"||c3=="remise_supplier"||c3=="outstanding_limit"||c3=="propal_count"||c3=="propal_sum"||c3=="commande_count"||c3=="commande_sum"||c3=="facture_count"||c3=="facture_sum"||c3=="propal-supplier_count"||c3=="propal-supplier_sum"||c3=="commande-supplier_count"||c3=="commande-supplier_sum"||c3=="facture-fourn_count"||c3=="facture-fourn_sum" )
        
        {
       
           if($("[name=\'"+nomeoperador+"\']").val()==7)
           {
           arrayregras.textovalorpadrao ="'.rawurlencode($langs->trans("Mes")).' "+($("[name=\'"+nomevalorpadrao+"_1"+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"_1"+"\']").val());
             arrayregras.dadosvalorpadrao = $("[name=\'"+nomevalorpadrao+"\']").val();
             
            ca="novcam_"+nomevalorpadrao;
            ca_1="novcam_"+nomevalorpadrao+"_1";
             
            var arraydados = [];
            
    arraydados.push($("[name=\'"+nomevalorpadrao+"_1"+"\']").val());
    
              
            campos=0;
            for (i = 0; i < arraycampos.length; i++) {
            if(arraycampos[i]["campo"] == ca)
            {
            campos=arraycampos[i]["id"];
            }
            
            }
            
            for (z = 1; z <= campos; z++) {
            
            arrayregras.textovalorpadrao+="<font color=red> '.rawurlencode($langs->trans("ou")).' </font>"+"'.rawurlencode($langs->trans("Mes")).' "+($("[name=\'"+ca_1+z+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+ca_1+z+"\']").val());
            
            arraydados.push($("[name=\'"+ca_1+z+"\']").val());
    
            }
            
      arrayregras.dadosvalorpadrao = arraydados;
          
            
           }
           else if(c3=="propal_count"||c3=="propal_sum"||c3=="commande_count"||c3=="commande_sum"||c3=="facture_count"||c3=="facture_sum"||c3=="propal-supplier_count"||c3=="propal-supplier_sum"||c3=="commande-supplier_count"||c3=="commande-supplier_sum"||c3=="facture-fourn_count"||c3=="facture-fourn_sum" )
           {
           
           
            if($("[name=\'"+nomevalorpadrao+"_1"+"\']").val()==""||$("[name=\'"+nomevalorpadrao+"_2"+"\']").val()==""||$("[name=\'"+nomevalorpadrao+"_3"+"\']").val()==""||$("[name=\'"+nomevalorpadrao+"_4"+"\']").val()=="")
            {
            alert("'.$langs->trans("NoIntervalo").' '.$langs->trans("vazio").'!");
            return false;
            }
           
           
            arrayregras.textovalorpadrao ="<b>"+$("[name=\'"+nomevalorpadrao+"_6"+"\'] option:selected" ).text()+ " '.rawurlencode($langs->trans("entre")).' "+($("[name=\'"+nomevalorpadrao+"_1"+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"_1"+"\']").val())+" '.rawurlencode($langs->trans("e")).' "+($("[name=\'"+nomevalorpadrao+"_2"+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"_2"+"\']").val()) +"</b> ( '.rawurlencode($langs->trans("entre")).' "+ $("[name=\'"+nomevalorpadrao+"_3"+"\']").val() +"  '.rawurlencode($langs->trans("e")).' "+ $("[name=\'"+nomevalorpadrao+"_4"+"\']").val()+" '.rawurlencode($langs->trans("situacao")).' "+  $("[name=\'"+nomevalorpadrao+"_5"+"\'] option:selected" ).text()
            
             arrayregras.dadosvalorpadrao = $("[name=\'"+nomevalorpadrao+"\']").val();
             
            ca="novcam_"+nomevalorpadrao;
            ca_1="novcam_"+nomevalorpadrao+"_1";
            ca_2="novcam_"+nomevalorpadrao+"_2";
            ca_3="novcam_"+nomevalorpadrao+"_3";
            ca_4="novcam_"+nomevalorpadrao+"_4";
             ca_5="novcam_"+nomevalorpadrao+"_5";
              ca_6="novcam_"+nomevalorpadrao+"_6";
            var arraydados = [];
            
    arraydados.push([$("[name=\'"+nomevalorpadrao+"_1"+"\']").val(),$("[name=\'"+nomevalorpadrao+"_2"+"\']").val(),$("[name=\'"+nomevalorpadrao+"_3"+"\']").val(),$("[name=\'"+nomevalorpadrao+"_4"+"\']").val(),$("[name=\'"+nomevalorpadrao+"_5"+"\']").val(),$("[name=\'"+nomevalorpadrao+"_6"+"\']").val()]);
    
              
            campos=0;
            for (i = 0; i < arraycampos.length; i++) {
            if(arraycampos[i]["campo"] == ca)
            {
            campos=arraycampos[i]["id"];
            }
            
            }
            
            for (z = 1; z <= campos; z++) {
            
                 if($("[name=\'"+ca_1+z+"\']").val()==""||$("[name=\'"+ca_2+z+"\']").val()==""||$("[name=\'"+ca_3+z+"\']").val()==""||$("[name=\'"+ca_4+z+"\']").val()=="")
            {
            alert("'.$langs->trans("NoIntervalo").' '.$langs->trans("vazio").'!");
            return false;
            }
            
            arrayregras.textovalorpadrao+="<font color=red> '.rawurlencode($langs->trans("ou")).'</font>  '.rawurlencode($langs->trans("situacao")).' "+ $("[name=\'"+ca_5+z+"\'] option:selected").text()
            
            
          
            
            arraydados.push([$("[name=\'"+ca_1+z+"\']").val(),$("[name=\'"+ca_2+z+"\']").val(),$("[name=\'"+ca_3+z+"\']").val(),$("[name=\'"+ca_4+z+"\']").val(),$("[name=\'"+ca_5+z+"\']").val(),$("[name=\'"+ca_6+z+"\']").val()]);
    
            }
            arrayregras.textovalorpadrao+=")";
            
                  if($("[name=\'"+nomeoperador+"\']").val()==10||$("[name=\'"+nomeoperador+"\']").val()==11)
           {
           arrayregras.textovalorpadrao="";
           }
           
      arrayregras.dadosvalorpadrao = arraydados;
          
            
            }
        else
            {
            
            if($("[name=\'"+nomevalorpadrao+"_1"+"\']").val()==""||$("[name=\'"+nomevalorpadrao+"_2"+"\']").val()=="")
            {
            alert("'.$langs->trans("NoIntervalo").' '.$langs->trans("vazio").'!");
            return false;
            }
            
            arrayregras.textovalorpadrao ="'.rawurlencode($langs->trans("entre")).' "+($("[name=\'"+nomevalorpadrao+"_1"+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"_1"+"\']").val())+"  '.rawurlencode($langs->trans("e")).' "+($("[name=\'"+nomevalorpadrao+"_2"+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"_2"+"\']").val());
            
             arrayregras.dadosvalorpadrao = $("[name=\'"+nomevalorpadrao+"\']").val();
             
            ca="novcam_"+nomevalorpadrao;
            ca_1="novcam_"+nomevalorpadrao+"_1";
            ca_2="novcam_"+nomevalorpadrao+"_2";
            var arraydados = [];
            
    arraydados.push([$("[name=\'"+nomevalorpadrao+"_1"+"\']").val(),$("[name=\'"+nomevalorpadrao+"_2"+"\']").val()]);
    
              
            campos=0;
            for (i = 0; i < arraycampos.length; i++) {
            if(arraycampos[i]["campo"] == ca)
            {
            campos=arraycampos[i]["id"];
            }
            
            }
            
            for (z = 1; z <= campos; z++) {
            
               if($("[name=\'"+ca_1+z+"\']").val()==""||$("[name=\'"+ca_2+z+"\']").val()=="")
            {
            alert("'.$langs->trans("NoIntervalo").' '.$langs->trans("vazio").'!");
            return false;
            }
            
            arrayregras.textovalorpadrao+="<font color=red> '.rawurlencode($langs->trans("ou")).' </font>"+"'.rawurlencode($langs->trans("entre")).' "+($("[name=\'"+ca_1+z+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+ca_1+z+"\']").val())+" '.rawurlencode($langs->trans("e")).' "+($("[name=\'"+ca_2+z+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+ca_2+z+"\']").val());
            
            
          
            
            arraydados.push([$("[name=\'"+ca_1+z+"\']").val(),$("[name=\'"+ca_2+z+"\']").val()]);
    
            }
            
      arrayregras.dadosvalorpadrao = arraydados;
          
            
            }
        }
        else
        {
        
       
       
     var arraydados = [];
          arrayregras.textovalorpadrao =($("[name=\'"+nomevalorpadrao+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"\']").val().replace(/"/g, "") );
          arraydados.push($("[name=\'"+nomevalorpadrao+"\']").val().replace(/"/g, ""));
 
        ca="novcam_"+nomevalorpadrao;
        campos=0;
            for (i = 0; i < arraycampos.length; i++) {
                    if(arraycampos[i]["campo"] == ca)
                    {
                    campos=arraycampos[i]["id"];
                    }
            
           }
              
           for (z = 1; z <= campos; z++) {
                   
            arrayregras.textovalorpadrao+="<font color=red> '.rawurlencode($langs->trans("ou")).'</font>"+($("[name=\'"+ca+z+"\']").val()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+ca+z+"\']").val());
            arraydados.push($("[name=\'"+ca+z+"\']").val());
      
           }
           
arrayregras.dadosvalorpadrao = arraydados;
 
 }
 
  
 if( c3=="duration_unit")
      {
       
       arrayregras.dadosvalorpadrao =  $("[name=\'"+nomevalorpadrao+"\']:checked").val();   
        
        arrayregras.textovalorpadrao=( arrayregras.dadosvalorpadrao=="i"?"'.rawurlencode($langs->trans("Minuto")).'":arrayregras.dadosvalorpadrao=="h"?"'.rawurlencode($langs->trans("Hora")).'":arrayregras.dadosvalorpadrao=="d"?"'.rawurlencode($langs->trans("Dia")).'":arrayregras.dadosvalorpadrao=="w"?"'.rawurlencode($langs->trans("Semana")).'":arrayregras.dadosvalorpadrao=="m"?"'.rawurlencode($langs->trans("Mes")).'":arrayregras.dadosvalorpadrao=="y"?"'.rawurlencode($langs->trans("Ano")).'":"");
    
       
       }
 }
 else
 {

       

        if(  c1=="radio" )
      {
       
       arrayregras.dadosvalorpadrao =  ($("[name=\'"+nomevalorpadrao+"\']:checked").val()==""?"":$("[name=\'"+nomevalorpadrao+"\']:checked").val());  
        
       
      arrayregras.textovalorpadrao =($("[name=\'"+nomevalorpadrao+"\']:checked + label").text()==""?"'.rawurlencode($langs->trans("vazio")).'":$("[name=\'"+nomevalorpadrao+"\']:checked + label").text());   
      
          //  alert(dump(arrayregras));
       }
       else
       {
       
       arrayregras.dadosvalorpadrao = ($("[name=\'"+nomevalorpadrao+"\']").val()==""?"":$("[name=\'"+nomevalorpadrao+"\']").val());
       
      
      
      var nvp = [];
       ct=0;
      $.each($("[name=\'"+nomevalorpadrao+"\'] option:selected"), function(){
     
      nvp.push(($(this).text()==""||!$(this).val()||($(this).val()==-1&&(nomevalorpadrao=="valor_padraofinished"||nomevalorpadrao=="valor_padraoopp_status"||nomevalorpadrao=="valor_padraogender"||nomevalorpadrao=="valor_padraomorphy"))||($(this).val()==0&&(nomevalorpadrao!="valor_padraotva_tx"&&nomevalorpadrao!="valor_padraofournisseur"&&nomevalorpadrao!="valor_padraofk_product_type"&&nomevalorpadrao!="valor_padraopublic"&&nomevalorpadrao!="valor_padraoadmin"&&nomevalorpadrao!="valor_padraoemployee"&&nomevalorpadrao!="valor_padraoclos"&&nomevalorpadrao!="valor_padraotype"&&nomevalorpadrao!="valor_padraovolume_units"&&nomevalorpadrao!="valor_padraoweight_units"&&nomevalorpadrao!="valor_padraosize_units"&&nomevalorpadrao!="valor_padraosurface_units"&&nomevalorpadrao!="valor_padraostatut"&&nomevalorpadrao!="valor_padraostatut_buy"&&nomevalorpadrao!="valor_padraostatus_batch"&&nomevalorpadrao!="valor_padraofinished"&&nomevalorpadrao!="valor_padraopriv"&&nomevalorpadrao!="valor_padraoclient"&&nomevalorpadrao!="valor_padraono_email"&&nomevalorpadrao!="valor_padraostatus"))||$(this).text()==" &nbsp;"?"'.rawurlencode($langs->trans("vazio")).'":encodeURIComponent($(this).text())));
      ct++;
       });
       if(ct==0) 
       {
       arrayregras.textovalorpadrao ="'.rawurlencode($langs->trans("vazio")).'";
       }
       else
       {
      arrayregras.textovalorpadrao =nvp.join(" <font color=red> '.rawurlencode($langs->trans("ou")).' </font>");
      }
      }
}       
arraynovaregra.push(arrayregras);
 
arraynovaregra=removeDumplicateValue(arraynovaregra);
 
 crialista();

}
  
var arraycampos = [];


  function insereid(ca){
jaexiste=0;  
for (i = 0; i < arraycampos.length; i++) {
if(arraycampos[i]["campo"] == ca)
{
jaexiste=1;
}
}
   
  if(jaexiste==0)
  {
var arraync = [];
arraync.campo = ca;
arraync.id = 1;
arraycampos.push(arraync);
}
else
{
for (i = 0; i < arraycampos.length; i++) {
if(arraycampos[i]["campo"] == ca)
{
arraycampos[i]["id"]=arraycampos[i]["id"]+1;
}

}
     
}
     }
    
    
function buscaid(ca){
   
ret=""; 
for (i = 0; i < arraycampos.length; i++) {
if(arraycampos[i]["campo"] == ca)
{
ret= arraycampos[i]["id"];
}

}
     
   return ret;  
    }
    
    
    

  function zeraid(ca){
  
 //alert(dump(arraycampos));
 can="novcam_"+ca;
for (i = 0; i < arraycampos.length; i++) {
if(arraycampos[i]["campo"] == can)
{
arraycampos[i]["id"]=0;
}

}

 //alert(dump(arraycampos));
}

function chama(th)
{
    var v = th.value;
        if (v.match(/^\d{4}$/) !== null) {
            th.value = v + \'-\';
        } else if (v.match(/^\d{4}-\d{2}$/) !== null) {
            th.value = v+\'-\';
           
        }
        
        else if (v.match(/^\d{4}-\d{2}-\d{2}$/) !== null) {
            
           x=th.value.split("-");
           if(x[0]<1900||x[0]>2500){alert("Verifique o ano!")};
          if(x[1]<1||x[1]>12){alert("Verifique o mês!")};
          if(x[2]<1||x[2]>31){alert("Verifique o dia!")};
          th.focus();
       
           
        }
       
        
         
}
function chamanum(th)
{
    var v = th.value;
         var regex_cell =/^(-?\d+\.\d+)$|^(-?\d+)$/gm;
   
          if(!regex_cell.test(v))
          {alert("Verifique o número!")
          th.select();
          th.focus()};
       
        
         
}
function alteracampo2(spam,extra,tipo)
{
if ($("[name=\'sel_ope_"+spam+"\']").val()==10||$("[name=\'sel_ope_"+spam+"\']").val()==11)
{
$("#bir_"+spam).hide();
}
else
{
$("#bir_"+spam).show();
}
 
}

function alteracampo(spam,extra,tipo)
{

novospam="bir_"+spam;
var objTo = document.getElementById(novospam);
if ($("[name=\'sel_ope_"+spam+"\']").val()==7)
{

objTo.innerHTML="'.$langs->trans("Mes").' <select  name=\'"+spam+"_1\'   id=\'"+spam+"_1\'  ><option value=\'01\'>01</option><option value=\'02\'>02</option><option value=\'03\'>03</option><option value=\'04\'>04</option><option value=\'05\'>05</option><option value=\'06\'>06</option><option value=\'07\'>07</option><option value=\'08\'>08</option><option value=\'09\'>09</option><option value=\'10\'>10</option><option value=\'11\'>11</option><option value=\'12\'>12</option></select>&nbsp;<span id=\'novcam_"+spam+"\'></span><span   onclick=inserecampo(\"novcam_"+spam+"\",1,"+extra+",\""+tipo+"\",\"data\"); class=\'fa fa-plus-circle classfortooltip  \'  title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'>";

}
else
{
 objTo.innerHTML ="'.$langs->trans("Entre").'<input type=text placeholder=\'yyyy-mm-dd\' maxlength=10 onkeyup=chama(this); style=\'width:60px;font-size:10px;\' id=\'"+spam+"_1\' name=\'"+spam+"_1\' value=\'\'     />'.$langs->trans("e").'  <input  type=text placeholder=\'yyyy-mm-dd\' maxlength=10 onkeyup=chama(this); style=\'width:60px;font-size:10px;\' id=\'"+spam+"_2\' name=\'"+spam+"_2\' value=\'\'     />&nbsp;<span id=\'novcam_"+spam+"\'></span><span  onclick=inserecampo(\"novcam_"+spam+"\",0,"+extra+",\""+tipo+"\",\"data\");  class=\'fa fa-plus-circle classfortooltip  \'  title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'>";
}
 zeraid(spam)
}

function aplica(id) {
 
$("#"+id+"").datepicker({dateFormat:\'yy-mm-dd\'});
$("#"+id+"").datepicker(\'show\');
 
};


function inserecampo(spam,id,extra,tipo,modo)
{
  insereid(spam);
 

    var objTo = document.getElementById(spam);


 if(modo=="data"||modo=="numero")
     
  {
        var nomenovo1=spam+"_1"+buscaid(spam);
        var nomenovo2=spam+"_2"+buscaid(spam);
        var nomeori1=spam.substr(7,spam.length-1)+"_1";
        var nomeori2=spam.substr(7,spam.length-1)+"_2";
                
        if(id==1)
        {
        
        
        objTo.innerHTML +="'.$langs->trans("ou").'<br>'.$langs->trans("Mes").'<select  name=\'"+nomenovo1+"\'   id=\'"+nomenovo1+"\' ><option value=\'01\'>01</option><option value=\'02\'>02</option><option value=\'03\'>03</option><option value=\'04\'>04</option><option value=\'05\'>05</option><option value=\'06\'>06</option><option value=\'07\'>07</option><option value=\'08\'>08</option><option value=\'09\'>09</option><option value=\'10\'>10</option><option value=\'11\'>11</option><option value=\'12\'>12</option></select> ";
        $("[name=\'"+nomenovo1+"\']").val($("[name=\'"+nomeori1+"\']").val());
        }
        
        else if(id==3)
        {
         var nomenovo3=spam+"_3"+buscaid(spam);
        var nomenovo4=spam+"_4"+buscaid(spam);
        var nomenovo5=spam+"_5"+buscaid(spam);
        var nomenovo6=spam+"_6"+buscaid(spam);
         var nomeori3=spam.substr(7,spam.length-1)+"_3";
        var nomeori4=spam.substr(7,spam.length-1)+"_4";
       var nomeori5=spam.substr(7,spam.length-1)+"_5";
         var nomeori6=spam.substr(7,spam.length-1)+"_6";
        
        
          objTo.innerHTML +="'.$langs->trans("ou").'<select style=\'display:none;\' id="+nomenovo6+" name="+nomenovo6+"  ><option value=\'0\'>Quantidade</option><option value=\'1\'>Valores</option></select><br> <input type=text "+(id==0?"placeholder=\'yyyy-mm-dd\'":"")+"  "+(id==0?"maxlength=10":"maxlength=50")+"  "+(id==0?"onkeyup=chama(this);":"onchange=chamanum(this);")+"  style=\'width:60px;font-size:10px;;display:none;\' id="+nomenovo1+" name="+nomenovo1+" value=\'\'     />   <input  type=text "+(id==0?"placeholder=\'yyyy-mm-dd\'":"")+" maxlength=10 "+(id==0?"onkeyup=chama(this);":"onchange=chamanum(this);")+"  style=\'width:60px;font-size:10px;;display:none;\' id="+nomenovo2+" name="+nomenovo2+" value=\'\'     /> <input type=text "+(id==0?"placeholder=\'yyyy-mm-dd\'":"")+"  "+(id==0?"maxlength=10":"maxlength=50")+"  "+(id==0?"onkeyup=chama(this);":"onchange=chamanum(this);")+"  style=\'width:60px;font-size:10px;;display:none;\' id="+nomenovo3+" name="+nomenovo3+" value=\'\'     /> <input  type=text "+(id==0?"placeholder=\'yyyy-mm-dd\'":"")+" maxlength=10 "+(id==0?"onkeyup=chama(this);":"onchange=chamanum(this);")+"  style=\'width:60px;font-size:10px;;display:none;\' id="+nomenovo4+" name="+nomenovo4+" value=\'\'     />'.$langs->trans("Situacao").': <select   id="+nomenovo5+" name="+nomenovo5+"    ><option value=\'0\'>'.$langs->trans("Rascunho").'</option><option value=\'1\'>'.$langs->trans("Validado").'</option><option value=\'2\'>'.$langs->trans("Assinado").'</option><option value=\'4\'>'.$langs->trans("Faturado").'</option><option value=\'3\'>'.$langs->trans("Recusado").'</option></select>";
          
          numids=buscaid(spam);
        
          for (i = 1; i < numids+1; i++) {
 
          $("[name=\'novcam_"+nomeori1+i+"\']").val($("[name=\'"+nomeori1+"\']").val());$("[name=\'novcam_"+nomeori1+i+"\']").prop("disabled", true);  
          $("[name=\'novcam_"+nomeori2+i+"\']").val($("[name=\'"+nomeori2+"\']").val());$("[name=\'novcam_"+nomeori2+i+"\']").prop("disabled", true);  
          $("[name=\'novcam_"+nomeori3+i+"\']").val($("[name=\'"+nomeori3+"\']").val());$("[name=\'novcam_"+nomeori3+i+"\']").prop("disabled", true);  
          $("[name=\'novcam_"+nomeori4+i+"\']").val($("[name=\'"+nomeori4+"\']").val());$("[name=\'novcam_"+nomeori4+i+"\']").prop("disabled", true);  
           
          $("[name=\'novcam_"+nomeori6+i+"\']").val($("[name=\'"+nomeori6+"\']").val());$("[name=\'novcam_"+nomeori6+i+"\']").prop("disabled", true);  
          
           
        }
          
        }
        else
        {
 
          sta="'.$langs->trans("ou").'<br>'.$langs->trans("Entre").'<input type=text "+(id==0?"placeholder=\'yyyy-mm-dd\'":"")+"  "+(id==0?"onfocus=aplica(this.id); maxlength=10":"maxlength=50")+"    style=\'width:60px;font-size:10px;\' id="+nomenovo1+" name="+nomenovo1+" value=\'\'     />'.$langs->trans("e").'  <input  type=text "+(id==0?"onfocus=aplica(this.id); placeholder=\'yyyy-mm-dd\'":"")+" maxlength=10      style=\'width:60px;font-size:10px;\' id="+nomenovo2+" name="+nomenovo2+" value=\'\'     />";
      
       
       objTo.innerHTML +=sta;
       
         numids=buscaid(spam);
        
          for (i = 1; i < numids+1; i++) {
 
          $("[name=\'novcam_"+nomeori1+i+"\']").val($("[name=\'"+nomeori1+"\']").val()) ;  
          $("[name=\'novcam_"+nomeori2+i+"\']").val($("[name=\'"+nomeori2+"\']").val()) ;  
  
        }
        
                
          }
              
  } 
   
  
  else  if(modo=="texto")
  {
  
    objTo.innerHTML =objTo.innerHTML+"'.$langs->trans("ou").'<br><input type=text  name="+spam+buscaid(spam)+" value=\'\' />";
  }
  
   

}

function crialista()
{



$(listaregras).empty();

for (i = 0; i < arraynovaregra.length; i++) {
 
var lista = document.createElement("li");
 lista.style.cssText = " font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px;width:94%; margin-top:2px;margin-left:4px;list-style-type: none;  float:left;";
    lista.innerHTML = "<a href=\'javascript://\'    ><span  style=\'float:left;margin-right:5px;\'  onclick=remover(arraynovaregra,arraynovaregra["+i+"][\'nome\']); class=\'fa fa-times-circle classfortooltip \'  title=\''.$langs->trans("CliqueParaExcluir").'\'></span></a> '.$langs->trans("Se").'<b> "+decodeURIComponent(arraynovaregra[i]["label"].replace(/\+/g, " "))+"</b> <font color=blue>"+arraynovaregra[i]["textooperador"]+"</font> "+decodeURIComponent(arraynovaregra[i]["textovalorpadrao"].replace(/\+/g, " "));
     listaregras.appendChild(lista);
  
}

}
         
         </script>
         
        
         ';
 if ($action != 'edit'||!$action)
                
                {      
    print ' <div id=editacategoria style="display:none"><label for=rules><h3>'.$langs->trans("NovaCategoria").'<h4><span style="padding-top:0px;font-size:20px;" class="fa fa-info-circle classfortooltip" title="<center><h3>'.$langs->trans("Dicas").'</h3></center>'.$langs->trans("DetalhesDicas").'" ></span>&nbsp;&nbsp'. $langs->trans('NomedaNovaCategoria').': <input id=nomecat name=nomecat class=minwidth500 style="border:solid 1px #ccc;font-weight:bold; font-size:24px;font-type:tahoma;"><input id=edita name=edita type=hidden></h5></label> </h3><div id="wrapper"     ><h4  style="margin-bottom:0px"> '.$langs->trans("CriteriosDisponiveis").': </h4><div   id="quadro"   style="min-width: 350px;scrollbar-face-color: blue; scrollbar-arrow-color: blue;margin:3px;width: 60%;height:320px; border: 1px solid #ccc; overflow: auto;float:left;" >
   
    ';
        print '<table  class="noborder" width="100%"><tr><td style="width:100px" >'.$langs->trans("Campo").'<td>'.$langs->trans("Operacao").'<td>'.$langs->trans("Valores").'<td>'.$langs->trans("InserirCriterio").'';
 
        // Title of lines
   }
}
else
{
   
       
        
     print '<div id="wrapper"     style="width: 800px; border: 1px solid black; overflow: auto;" ><div   style="float:left;width: 500px; ">';
        print '<table class="noborder" width="100%">';
    }
    
    $sql3="SELECT m.rowid, m.modulo, m.submodulo, m.pagina, m.acao, m.campo_nome,m.campo_tipo,m.campo_texto,m.campo_banco,m.form_nome,m.campo_pos,m.situacao,m.valor_padrao,m.label,m.conteudo,m.tooltip,m.extra FROM ".MAIN_DB_PREFIX."categorizeall as m    WHERE form_nome='".$formulario."' ";

$resql3=$db->query($sql3);
 
        $num3 = $db->num_rows($resql3);
        $i3 = 0;


        if ($num3)
        {
            // Lines with values
            
           
            while ($i3 < $num3)
            {
                $obj = $db->fetch_object($resql3);
                
               $modulo= $obj->modulo;
               $submodulo=  $obj->submodulo;
               $pagina= $obj->pagina;
               $acao=  $obj->acao;
                     $nome=  $obj->campo_nome;
                     if($obj->campo_nome=='country_id'||$obj->campo_nome=='account_country_id')
                    {
                    $campocountry_id=$obj->valor_padrao;
                    
                    }
                    // Url
                    $rowidcol=$tabrowid[$id];
                    // If rowidcol not defined
                    if (empty($rowidcol) || in_array($id, array(6,7,8,13,17,19,27))) $rowidcol='rowid';
                    $url = $_SERVER["PHP_SELF"].'?rowid='.((! empty($obj->{$rowidcol}) || $obj->{$rowidcol} == '0')?$obj->{$rowidcol}:(! empty($obj->code)?urlencode($obj->code):'')).'&code='.(! empty($obj->code)?urlencode($obj->code):'');
                    if (! empty($paramurl)) $url .= '&'.$paramurl;
                    if (! is_null($withentity)) $url .= '&entity='.$withentity;
                    $url.="&form=".$formulario."";
                    
                print '<tr class="oddeven" id="rowid-'.$obj->rowid.'">';
               
                
                if ($action != 'edit')
                
                {
	              	$tmpaction = 'view';
                    $parameters=array('fieldlist'=>$fieldlist, 'tabname'=>$tabname[$id]);
                    $reshook=$hookmanager->executeHooks('viewDictionaryFieldlist',$parameters,$obj, $tmpaction);    // Note that $action and $object may have been modified by some hooks

                    $error=$hookmanager->error; $errors=$hookmanager->errors;

                    if (empty($reshook))
                    {
                    	$withentity=null;

                        foreach ($fieldlist as $field => $value)
                        {
                        	//var_dump($fieldlist);
                        	$showfield=1;
                        	$align="left";
                        	$valuetoshow=$obj->{$fieldlist[$field]};

                        	 
                                                          
            if ($fieldlist[$field] == 'situacao')
		{
             
    if($valuetoshow=="0") {$valuetoshow=$langs->trans("Invisivel");}
    elseif($valuetoshow=="1"){ $valuetoshow=$langs->trans("Visivel");  } 
    elseif($valuetoshow=="2") {$valuetoshow=$langs->trans("Desabilitado");   }
    elseif($valuetoshow=="3") {$valuetoshow=$langs->trans("Obrigatorio");   }
	 	 
		}
        
                                                             
      
                               if ($fieldlist[$field] == 'campo_nome')
                            {
                                  print '';
                                  $campo=$valuetoshow;
                            }
                                         
                             elseif($fieldlist[$field] == 'campo_texto')
                            {
                                $valuetoshow=$langs->trans($valuetoshow);
                                
                                $fl = explode('-',$valuetoshow);
						if (is_array($fl))
						{
                            
                             if(count($fl)==4)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1])."-".$langs->trans($fl[2])."-".$langs->trans($fl[3]);
                            }
                            
                            if(count($fl)==3)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1])."-".$langs->trans($fl[2]);
                            }
                              if(count($fl)==2)
                            {
                            $valuetoshow=$langs->trans($fl[0])."-".$langs->trans($fl[1]);
                            }
                            $campolabel=$valuetoshow;
                             }
                             
                             else
                             {
                                
                               $valuetoshow= $langs->trans($valuetoshow);
                                }
                                
                                  print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.'" style="max-width:100px;" >'.$valuetoshow.($obj->extra=='1'?'<br><font size=-2 color=red>('.$langs->trans("ExtraFields").')</font>':'').'</td>';
                            }
                            
                          elseif($fieldlist[$field] == 'valor_padrao')
                                {
                                     $fieldname='valor_padrao';
                                     
                                       print '<td style="padding:10px"  class="tdoverflowmax200">';
                                         
                                          
                                               if($obj->campo_tipo==='select'||$obj->campo_tipo=='link' ||$obj->campo_nome==='birthday_alert'||$obj->campo_tipo=='boolean'||$obj->campo_tipo=='sellist' ||$obj->campo_tipo=='radio' )
                                        {
                                             	$statutarray=array( '1' => $langs->trans("Igual"), '2' => $langs->trans("Diferente"));
                                                 print $form->selectarray('sel_ope_'.$fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                              
		                                }
                                        else 
                                        { 
                                            
                                             if($obj->campo_tipo==='int'||$obj->campo_tipo==='double'||$obj->campo_tipo==='price')
                                         {
                                 print '<select id="sel_ope_'.$fieldname.$campo.'" class="flat " onchange=alteracampo("'.$fieldname.$campo.'",'.$obj->extra.',"'.$obj->campo_tipo.'"); name="sel_ope_'.$fieldname.$campo.'"  ><option value="5">'.$langs->trans("NoIntervalo").'</option><option value="6">'.$langs->trans("ForaDoIntervalo").'</option></select>';
                                           
     
                                            }
                                             elseif($obj->campo_nome==='birthday'||$obj->campo_nome==='projectstart'||$obj->campo_nome==='projectend'||$obj->campo_nome==='birth'||$obj->campo_nome==='dateemployment'||$obj->campo_nome==='dateemploymentend'||$obj->campo_tipo=='date'||$obj->campo_tipo=='datetime'||$obj->campo_nome==='re'||$obj->campo_nome==='tms'||$obj->campo_nome==='datec')
                                         {
                                 print '<select id="sel_ope_'.$fieldname.$campo.'" class="flat " onchange=alteracampo("'.$fieldname.$campo.'",'.$obj->extra.',"'.$obj->campo_tipo.'"); name="sel_ope_'.$fieldname.$campo.'"  ><option value="8">'.$langs->trans("NoIntervalo").'</option><option value="9">'.$langs->trans("ForaDoIntervalo").'</option><option value="7">'.$langs->trans("MesEspecifico").'</option></select>';
                                           
     
                                            }
                                              elseif($campo=='desiredstock'||$campo=='seuil_stock_alerte'||$campo=='duration_value'||$campo=='weight'||$campo=='size'||$campo=='sizewidth'||$campo=='sizeheight'||$campo=='surface'||$campo=='volume'||$campo=='price'||$campo=='price_min'||$campo=='capital'||$campo=='solde'||$campo=='account_min_allowed'||$campo=='opp_percent'||$campo=='opp_amount'||$campo=='budget_amount'||$campo=='thm'||$campo=='tjm'||$campo=='salary'||$campo=='weeklyhours'||$campo=='remise_client'||$campo=='remise_supplier'||$campo=='outstanding_limit')
                                             {
                                 print '<select id="sel_ope_'.$fieldname.$campo.'" class="flat "   name="sel_ope_'.$fieldname.$campo.'"  ><option value="5">'.$langs->trans("NoIntervalo").'</option><option value="6">'.$langs->trans("ForaDoIntervalo").'</option> </select>';
                                           
     
                                            }
                                            
                                             elseif($campo=='propal_count'||$campo=='propal_sum'||$campo=='commande_count'||$campo=='commande_sum'||$campo=='facture_count'||$campo=='facture_sum'||$campo=='propal-supplier_count'||$campo=='propal-supplier_sum'||$campo=='commande-supplier_count'||$campo=='commande-supplier_sum'||$campo=='facture-fourn_count'||$campo=='facture-fourn_sum')
                                             {
                                 print '<select onchange=alteracampo2("'.$fieldname.$campo.'",'.$obj->extra.',"'.$obj->campo_tipo.'"); id="sel_ope_'.$fieldname.$campo.'" class="flat "   name="sel_ope_'.$fieldname.$campo.'"  ><option value="5">'.$langs->trans("NoIntervalo").'</option><option value="6">'.$langs->trans("ForaDoIntervalo").'</option><option value="10">'.$langs->trans("SemRegistro").'</option> <option value="11">'.$langs->trans("ComRegistro").'</option>  </select>';
                                           
     
                                            }
                                            
                                         else
                                         {
                                             	$statutarray=array('3' => $langs->trans("Contem"), '4' => $langs->trans("NaoContem"));
                                                 print $form->selectarray('sel_ope_'.$fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                              
		                                }
                                        }
                                        
                                 
                                        print '</td>';
                                     
                                    if($campo=='country_id')
                                    {
                                      
                                      print '<td class="tdoverflowmax200">';
                                         
                                        print $form->select_country($obj->{$fieldlist[$field]}, $fieldname.$campo, '', 28, 'maxwidth150 maxwidthonsmartphone');
                                        
                                            print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                        print '</td>';
            
                                     
                                    }
 
                                    elseif($campo=='state_id')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                                    	print $formcompany->select_state($obj->{$fieldlist[$field]},$campocountry_id,$fieldname.$campo);
         
                                         print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
            
                                     
                                    }
                                    elseif($campo=='mode_reglement_supplier_id')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                         
                                    
                                    	$form->form_modes_reglement('',$obj->{$fieldlist[$field]},$fieldname.$campo, 'DBIT', 1, 1);
	   print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
            
                                     
                                    }
                                    elseif($campo=='cond_reglement_supplier_id')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                         
                                    	$form->form_conditions_reglement('',$obj->{$fieldlist[$field]},$fieldname.$campo,-1,1);
	
                                      print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                             
                                          print '</td>';
            
                                     
                                    }
                                    
                                     elseif($campo=='fk_product_type')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                           
                              print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans("Product"),'1'=>$langs->trans("Service")),$obj->{$fieldlist[$field]});
                   print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                             
                                          print '</td>';
            
                                     
                                    }
                                     elseif($campo=='account_state_id')
                                    {
                            print '<td class="tdoverflowmax200"  >';
                                    	print $formcompany->select_state($obj->{$fieldlist[$field]},$campocountry_id,$fieldname.$campo);
         
                                         print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
            
                                     
                                    }
                                     elseif($campo=='client')
                                    {
                            
                                    
                                    	 
          print '<td class="tdoverflowmax200"><select class="flat" id="'.$fieldname.$campo.'"  name="'.$fieldname.$campo.'" >';
            if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS)) print '<option value="2"'.($obj->{$fieldlist[$field]}==2?' selected':'').'>'.$langs->trans('Prospect').'</option>';
            if (empty($conf->global->SOCIETE_DISABLE_PROSPECTS) && empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print '<option value="3"'.($obj->{$fieldlist[$field]}==3?' selected':'').'>'.$langs->trans('ProspectCustomer').'</option>';
            if (empty($conf->global->SOCIETE_DISABLE_CUSTOMERS)) print '<option value="1"'.($obj->{$fieldlist[$field]}==1?' selected':'').'>'.$langs->trans('Customer').'</option>';
            print '<option value="0"'.($obj->{$fieldlist[$field]}==0?' selected':'').'>'.$langs->trans('NorProspectNorCustomer').'</option>';
            print '</select></td>';
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                      elseif($campo=='fournisseur')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                    	 
   print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
                             
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                      elseif($campo=='public')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 if($formulario=='NewLeadOrProject')
                                 {
                           print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('PrivateProject'),'1'=>$langs->trans('SharedProject')),$obj->{$fieldlist[$field]});
                                    }
                                    
                                    else
                                    {
                                print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
                                        }
                               
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                    elseif($campo=='no_email')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                     print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('No'),'1'=>$langs->trans('Yes')),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                     elseif($campo=='opp_status')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                             print $formproject->selectOpportunityStatus($fieldname.$campo, $obj->{$fieldlist[$field]});
		
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                             
        
        
                                     elseif($campo=='priv')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                     print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans("ContactPublic"),'1'=>$langs->trans("ContactPrivate")),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                        
                        
                        
                                    elseif($campo=='contcats')
                                    {
                                    print '<td class="tdoverflowmax200">';
                                    $cat=explode(',',$obj->{$fieldlist[$field]});
                                    $cate_arbo = $form->select_all_categories( Categorie::TYPE_CONTACT, null, 'parent', null, null, 1 );
                                    print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, null, null, null,
                                    null, '90%' );
                                        
                                 
                                    print '</td>';
                                    
                                    
                                    }
                                    
                                    
                                    
                                     elseif($campo=='fk_parent')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                       
                print $formproduct->selectWarehouses($obj->{$fieldlist[$field]}, $fieldname.$campo, '',1,1);
                             
                                          print '</td>';
            
                                     
                                    } 
                                    elseif($campo=='birthday_alert')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    if (!empty($obj->{$fieldlist[$field]})) {
                                    $checked=' checked value="1" ';
                                    } else {
                                    $checked=' value="1" ';
                                    }
                                    $moreparam='';
                                    
                                    $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="'.$fieldname.$campo.'" '.$checked.' '.($moreparam?$moreparam:'').'>';
                                    print  $out;
                                    
                                    print '</td>';
                                    
                                    
                                    }
                                     elseif($campo=='birthday'||$campo=='re'||$campo=='projectstart'||$campo=='projectend'||$campo=='birth'||$campo=='dateemployment'||$campo=='dateemploymentend'||$campo=='tms'||$campo=='datec')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    
                                   print '<span id="bir_'. $fieldname.$campo.'">'.$langs->trans("Entre").' <input type="text"  placeholder=\'yyyy-mm-dd\' maxlength=10 onkeyup=chama(this);   style=\'width:60px;font-size:10px;\'   name="'.$fieldname.$campo.'_1"   id="'.$fieldname.$campo.'_1" >'.$langs->trans("e").' <input type="text"  placeholder=\'yyyy-mm-dd\' maxlength=10 onkeyup=chama(this);   style=\'width:60px;font-size:10px;\'    name="'.$fieldname.$campo.'_2"   id="'.$fieldname.$campo.'_2"  >&nbsp;<span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",0,'.$obj->extra.',"'.$obj->campo_tipo.'","data");  class=\'fa fa-plus-circle classfortooltip  \'  style=\'display:block;\'  title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'></span>';
                                    
                                                 
                                    
  print '<script>$(document).ready(function() {
    $("#'.$fieldname.$campo.'_1'.'").datepicker({
        dateFormat: "yy-mm-dd"
    }).focus(function() {
        $("#'.$fieldname.$campo.'_1'.'").datepicker("show");
    }).focus();
    
    $("#'.$fieldname.$campo.'_2'.'").datepicker({
        dateFormat: "yy-mm-dd"
    }).focus(function() {
        $("#'.$fieldname.$campo.'_2'.'").datepicker("show");
    }).focus();
});
</script>
            ';
                                    print '</td>';
                                     
                                    
                                    }
         
 

        elseif($campo=='desiredstock'||$campo=='seuil_stock_alerte'||$campo=='duration_value'||$campo=='weight'||$campo=='size'||$campo=='sizewidth'||$campo=='sizeheight'||$campo=='surface'||$campo=='volume'||$campo=='price'||$campo=='price_min'||$campo=='capital'||$campo=='solde'||$campo=='account_min_allowed'||$campo=='opp_percent'||$campo=='opp_amount'||$campo=='budget_amount'||$campo=='thm'||$campo=='tjm'||$campo=='salary'||$campo=='weeklyhours'||$campo=='remise_client'||$campo=='remise_supplier'||$campo=='outstanding_limit' )
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    
                                   print '<span id="bir_'. $fieldname.$campo.'">'.$langs->trans("Entre").' <input type="text"   maxlength=20 onchange=chamanum(this);   style=\'width:60px;font-size:10px;\'   name="'.$fieldname.$campo.'_1"   id="'.$fieldname.$campo.'_1" >'.$langs->trans("e").' <input type="text"    maxlength=20 onchange=chamanum(this);   style=\'width:60px;font-size:10px;\'    name="'.$fieldname.$campo.'_2"   id="'.$fieldname.$campo.'_2"  >&nbsp;<span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",2,'.$obj->extra.',"'.$obj->campo_tipo.'","numero");  class=\'fa fa-plus-circle classfortooltip  \'  style=\'display:block;\'   title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'></span>';
                                    
                                  
                                    print '</td>';
                                     
                                    
                                    }
                                      
                                    
        elseif($campo=='propal_count'||$campo=='propal_sum'||$campo=='commande_count'||$campo=='commande_sum'||$campo=='facture_count'||$campo=='facture_sum'||$campo=='propal-supplier_count'||$campo=='propal-supplier_sum'||$campo=='commande-supplier_count'||$campo=='commande-supplier_sum'||$campo=='facture-fourn_count'||$campo=='facture-fourn_sum')
                                    
                     
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    
                                    
                                      
                                   print ($campo=='propal_count'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/comm/propal/list.php?sortfield=p.total_ht&sortorder=desc&begin=&viewstatut=&contextpage=proposallist&leftmenu=propals" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':'').($campo=='commande_count'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/commande/list.php?sortfield=c.total_ht&sortorder=desc&begin=&contextpage=orderlist&search_project_ref=&leftmenu=orders" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':''). ($campo=='facture_count'&&$formulario=='ThirdParty'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/compta/stats/casoc.php?sortfield=amount_ttc&sortorder=desc&leftmenu=report" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':'').($campo=='facture_count'&&$formulario=='Product-Service'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/compta/stats/cabyprodserv.php?sortfield=amount_ttc&modecompta=CREANCES-DETTES&sortorder=desc&leftmenu=report" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':'').($campo=='propal-supplier_count'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/supplier_proposal/list.php?sortfield=sp.total_ht&sortorder=desc&leftmenu=supplier_proposals" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':'').($campo=='commande-supplier_count'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/fourn/commande/list.php?sortfield=cf.total_ht&sortorder=desc&leftmenu=orders_suppliers" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':'').($campo=='facture-fourn_count'?'&nbsp;<a target=_blank  href="'.DOL_URL_ROOT.'/fourn/facture/list.php?sortfield=f.total&sortorder=desc&leftmenu=suppliers_bills" ><span style=\'color:blue\'  class=\'fa fa-info-circle classfortooltip\' title=\''.$langs->trans("CliqueParaVerListaRange").'\'   ></a>':'').'&nbsp;<span id="bir_'. $fieldname.$campo.'">'.$langs->trans("TipoCampo").': <select  name="'.$fieldname.$campo.'_6" id="'.$fieldname.$campo.'_6"  ><option value=\'0\'>'.$langs->trans("Quantidades").'</option><option value=\'1\' selected>'.$langs->trans("Valores").'</option></select><br>'.$langs->trans("Entre").': <input type="text"   maxlength=20 onchange=chamanum(this);   style=\'width:60px;font-size:10px;\'   name="'.$fieldname.$campo.'_1"   id="'.$fieldname.$campo.'_1" >'.$langs->trans("e").'<input type="text"    maxlength=20 onchange=chamanum(this);   style=\'width:60px;font-size:10px;\'    name="'.$fieldname.$campo.'_2"   id="'.$fieldname.$campo.'_2"  >';
                                    
        
                                    
                                   
                                   
                                    print ' <br>'.$langs->trans("Periodo").': <input type="text"  placeholder=\'yyyy-mm-dd\' maxlength=10    style=\'width:60px;font-size:10px;\'   name="'.$fieldname.$campo.'_3"   id="'.$fieldname.$campo.'_3" >'.$langs->trans("e").' <input type="text"  placeholder=\'yyyy-mm-dd\' maxlength=10    style=\'width:60px;font-size:10px;\'    name="'.$fieldname.$campo.'_4"   id="'.$fieldname.$campo.'_4"  ><hr>'.$langs->trans("Situacao").':<select  name="'.$fieldname.$campo.'_5" id="'.$fieldname.$campo.'_5"  ><option value=\'0\'>'.$langs->trans("Rascunho").'</option><option value=\'1\'>'.$langs->trans("Validado").'</option><option value=\'2\'>'.$langs->trans("Assinado").'</option><option value=\'4\'>'.$langs->trans("Faturado").'</option><option value=\'3\'>'.$langs->trans("Recusado").'</option></select>&nbsp;<span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",3,'.$obj->extra.',"'.$obj->campo_tipo.'","numero");  class=\'fa fa-plus-circle classfortooltip  \'  style=\'display:block;\'   title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'></span>';
                                    
                                    
  print '<script>$(document).ready(function() {
    $("#'.$fieldname.$campo.'_3'.'").datepicker({
        dateFormat: "yy-mm-dd"
    }).focus(function() {
        $("#'.$fieldname.$campo.'_3'.'").datepicker("show");
    }).focus();
    
    $("#'.$fieldname.$campo.'_4'.'").datepicker({
        dateFormat: "yy-mm-dd"
    }).focus(function() {
        $("#'.$fieldname.$campo.'_4'.'").datepicker("show");
    }).focus();
});



</script>';
                                    
                                  
                                    print '</td>';
                                     
                                    
                                    }
                                    elseif($campo=='fullday')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                    if (!empty($obj->{$fieldlist[$field]})) {
                                    $checked=' checked value="1" ';
                                    } else {
                                    $checked=' value="1" ';
                                    }
                                    $moreparam='';
                                    
                                    $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="'.$fieldname.$campo.'" '.$checked.' '.($moreparam?$moreparam:'').'>';
                                    print  $out;
                                    
                                    print '</td>';
                                    
                                    
                                    }
                                    
                                    elseif($campo=='aphour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                    elseif($campo=='p2hour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                    
                                       elseif($campo=='dateohour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                       elseif($campo=='dateehour')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    
                                    
                                    }
                                    
                                    
                                  elseif($campo=='p2min')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
             
                                    
                                    
                                    }
                                    elseif($campo=='apmin')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
             
                                    
                                    
                                    }
                                    
                                         
                                  elseif($campo=='dateomin')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
             
                                    
                                    
                                    }
                                    
                                     elseif($campo=='dateemin')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                     
                     print $form->selectarray($fieldname.$campo, array('-1'=>'','00'=>'00','01'=>'01','02'=>'02','03'=>'03','04'=>'04','05'=>'05','06'=>'06','07'=>'07','08'=>'08','09'=>'09','10'=>'10','11'=>'11','12'=>'12','13'=>'13','14'=>'14','15'=>'15','16'=>'16','17'=>'17','18'=>'18','19'=>'19','20'=>'20','21'=>'21','22'=>'22','23'=>'23','24'=>'24','25'=>'25','26'=>'26','27'=>'27','28'=>'28','29'=>'29','30'=>'30','31'=>'31','32'=>'32','33'=>'33','34'=>'34','35'=>'35','36'=>'36','37'=>'37','38'=>'38','39'=>'39','40'=>'40','41'=>'41','42'=>'42','43'=>'43','44'=>'44','45'=>'45','46'=>'46','47'=>'47','48'=>'48','49'=>'49','50'=>'50','51'=>'51','52'=>'52','53'=>'53','54'=>'54','55'=>'55','56'=>'56','57'=>'57','58'=>'58','59'=>'59'),$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
             
                                    
                                    
                                    }
                                       elseif($campo=='complete')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                
                                     $formactions->form_select_status_action('formaction', $obj->{$fieldlist[$field]}, 1, $fieldname.$campo, 0, 0, 'maxwidth200');
	
     
                                          print '</td>';
            
                                     
                                    }
                                       elseif($campo=='assignedtouser')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     
                                          print '</td>';
            
                                     
                                    }
                                    
                                       elseif($campo=='progress')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                                 	print $formother->select_percent($obj->{$fieldlist[$field]},$fieldname.$campo,0,5,0,100,1);
		 
     
                                          print '</td>';
            
                                     
                                    }
                                    
	
                                    
                                       elseif($campo=='userid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     
                                          print '</td>';
            
                                     
                                    }
                                    
                                         elseif($campo=='typeid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                  $listetype=$adht->liste_array();
		print $form->selectarray( $fieldname.$campo, $listetype,$obj->{$fieldlist[$field]}, count($listetype)>1?1:0);
        
     
                                          print '</td>';
            
                                     
                                    }
                                    
                                       elseif($campo=='subscription')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                   
                                   	$statutarray=array('0' => $langs->trans("No"), '1' => $langs->trans("Yes"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                               
                               
                    
     
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                       elseif($campo=='commercial_suivi_id')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     
                                          print '</td>';
            
                                     
                                    }
                                    
                                       elseif($campo=='commercial_signature_id')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
     
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                    
                                       elseif($campo=='contratid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                   
                                                   
                                
                          $formcontract->formSelectContract('', -1, $obj->{$fieldlist[$field]}, $fieldname.$campo, 0, 1);            
                               
                  
     
       print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                  
                                          print '</td>';
            
                                     
                                    }
                    
         
                                    
                                       elseif($campo=='vote')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                             	   	$statutarray=array('0' => $langs->trans("No"), '1' => $langs->trans("Yes"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                               
     
                                          print '</td>';
            
                                     
                                    }
                                      
                         elseif($campo=='morphy')
                                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 
        $morphys["phy"] = $langs->trans("Physical");
		$morphys["mor"] = $langs->trans("Moral");
		 print $form->selectarray($fieldname.$campo, $morphys, $obj->{$fieldlist[$field]}, 1);
	
    
      
    
        
                                            print '</td>';
            
                                     
                                    }
                                    
                                     elseif($campo=='memcats')
                                
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                    
                                          
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_MEMBER, '', 'parent', 64, 0, 1);
                                        
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			                     print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, '', 0, '', 0, '100%');
            
               
    
    
                                            print '</td>';
            
                                     
                                    }
 
                                    
                              elseif($campo=='socpeopleassigned')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
                                   print $form->selectcontacts('', $cat, $fieldname.$campo, 0, '', '', 0, 'quatrevingtpercent', false, 0, array(), false, 'multiple', 'contactid');
     
                                          print '</td>';
            
                                     
                                    }
    
    elseif($campo=='taskid')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                       $formproject->selectTasks(-1, $obj->{$fieldlist[$field]}, $fieldname.$campo, 24, 0, '1', 1, 0, 0, 'maxwidth500',$projectsListId);
		
     
                                          print '</td>';
            
                                     
                                    }
    
      elseif($campo=='fk_user_author')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		     print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
     
                                          print '</td>';
            
                                     
                                    }
          elseif($campo=='fk_user_validator')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		     print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
     
                                          print '</td>';
            
                                     
                                    }
    
    
    
        elseif($campo=='admin')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('1' => $langs->trans("Yes"), '0' => $langs->trans("No"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
  
    
        elseif($campo=='gender')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('-1' => '','man' => $langs->trans("Genderman"), 'woman' => $langs->trans("Genderwoman"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
    elseif($campo=='employee')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('1' => $langs->trans("Yes"), '0' => $langs->trans("No"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
  elseif($campo=='fk_user')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 print $form->select_dolusers($obj->{$fieldlist[$field]}, $fieldname.$campo,1);
		 
         print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
            
                                     
                                    }
  
  
           elseif($campo=='usercats')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 
                                        
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_USER, '', 'parent', 64, 0, 1);
                                        
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, '', 0, '', 0, '100%');
			 
                                          print '</td>';
            
                                     
                                    }  
   
  
                                           elseif($campo=='statut')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 if($formulario=='NewWarehouse')
                                 {
                                   $statutarray=array('1' => $langs->trans("Open"), '0' => $langs->trans("Closed"));
                                   
                                   }
                                   else
                                   {
                                     $statutarray=array('1' => $langs->trans("OnSell"), '0' => $langs->trans("NotOnSell"));
                                  
                                    }
   
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                           elseif($campo=='statut_buy')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 $statutarray=array('1' => $langs->trans("ProductStatusOnBuy"), '0' => $langs->trans("ProductStatusNotOnBuy"));
        
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
 
                                            elseif($campo=='actioncode')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                           
                    $formactions->select_type_actions($obj->{$fieldlist[$field]}, $fieldname.$campo, "systemauto", 0, -1);
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                    
                                    
                                             elseif($campo=='status_batch')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                               	$statutarray=array('0' => $langs->trans("ProductStatusNotOnBatch"), '1' => $langs->trans("ProductStatusOnBatch"));
		
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                             elseif($campo=='fk_barcode_type')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
 
 
			if(!function_exists('selectBarcodeType'))
			{
            print $formbarcode->select_barcode_type($obj->{$fieldlist[$field]}, $fieldname.$campo, 1);
			}
			else
			{
            print $formbarcode->selectBarcodeType($obj->{$fieldlist[$field]}, $fieldname.$campo, 1);
			}
				
				 print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                          
                                          print '</td>';
            
                                     
                                    }
                                             elseif($campo=='fk_default_warehouse')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                       
                print $formproduct->selectWarehouses($obj->{$fieldlist[$field]}, $fieldname.$campo, '',0,0);
                              print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
            
                                     
                                    }                                    
                                    
                                             elseif($campo=='finished')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 $statutarray=array('-1' => '','1' => $langs->trans("Finished"), '0' => $langs->trans("RowMaterial"));
           
                                    	         print $form->selectarray($fieldname.$campo, $statutarray,$obj->{$fieldlist[$field]});
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                              elseif($campo=='duration_unit')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                     
print '      <input  name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="i"?'checked':'').'  type="radio" value="i">&nbsp;'.$langs->trans("Minute").'&nbsp;';
print '<input name="'.$fieldname.$campo.'" type="radio"  '.($obj->{$fieldlist[$field]}=="h"?'checked':'').'  value="h">&nbsp;'.$langs->trans("Hour").'&nbsp;';
print '<input name="'.$fieldname.$campo.'" '.($obj->{$fieldlist[$field]}=="d"?'checked':'').' type="radio" value="d">&nbsp;'.$langs->trans("Day").'&nbsp;<br>';
print '<input name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="w"?'checked':'').' type="radio" value="w">&nbsp;'.$langs->trans("Week").'&nbsp;';
print '<input name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="m"?'checked':'').' type="radio" value="m">&nbsp;'.$langs->trans("Month").'&nbsp;';
print '<input name="'.$fieldname.$campo.'"  '.($obj->{$fieldlist[$field]}=="y"?'checked':'').' type="radio" value="y">&nbsp;'.$langs->trans("Year").'&nbsp;';
print '</td>';
            
                                     
                                     
                                    }
                                    
                                       elseif($campo=='size_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"size",$obj->{$fieldlist[$field]} );
                               
                                          print '</td>';
            
                                     
                                    }           
                                    
                                        elseif($campo=='weight_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"weight",$obj->{$fieldlist[$field]} );
                               
                                          print '</td>';
            
                                     
                                    }       
                                         elseif($campo=='surface_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"surface",$obj->{$fieldlist[$field]} );
                               
                                          print '</td>';
            
                                     
                                    }
                                    
                                        elseif($campo=='volume_units')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                
                           
					     print $formproduct->select_measuring_units($fieldname.$campo,"volume",$obj->{$fieldlist[$field]} );
                               
                                          print '</td>';
            
                                     
                                    }       
                                    
                                        elseif($campo=='categories')
                                    {
                            
                                 print '<td class="tdoverflowmax200">';
                                 
                                 if($formulario=='FinancialAccount')
                                 {
                                    
                                   $cate_arbo = $form->select_all_categories(Categorie::TYPE_ACCOUNT, '', 'parent', 64, 0, 1);
		 
                                    }
                                     elseif($formulario=='LeadOrProject')
                                 {
                                    
                                   $cate_arbo = $form->select_all_categories(Categorie::TYPE_PROJECT, '', 'parent', 64, 0, 1);
		 
                                    }
                                    else
                                    {
                                        
                                    $cate_arbo = $form->select_all_categories(Categorie::TYPE_PRODUCT, '', 'parent', 64, 0, 1);
                                        }
                                 
                                     $cat=explode(',',$obj->{$fieldlist[$field]});
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, '', 0, '', 0, '100%');
			 
                                          print '</td>';
            
                                     
                                    }    
                                    
                                    
                                    
                                     elseif($campo=='tva_tx')
                                                            {
                                                    
                                                         print '<td class="tdoverflowmax200">';
                                     print $form->load_tva($fieldname.$campo, $obj->{$fieldlist[$field]}, $mysoc, $mysoc, 0, 0, '', false, 1);
                                         
                                                                  print '</td>';
                                    
                                                             
                                                            }
                                                            
                                    
                                    
                                     elseif($campo=='price_base_type')
                                                            {
                                                    
                                                         print '<td class="tdoverflowmax200">';
                                       print $form->selectPriceBaseType($object->price_base_type, $fieldname.$campo);
           
                                        
                                                                  print '</td>';
                                    
                                                             
                                                            }
                                                            
                                                                                                                        
           
            
             
             
                                           elseif($campo=='status')
                                    {
                            print '<td class="tdoverflowmax200">';
                                       print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('ActivityCeased'),'1'=>$langs->trans('InActivity')),$obj->{$fieldlist[$field]});
       
                                     
                                          print '</td>';
            
                                     
                                    }
              
              
                                           elseif($campo=='clos')
                                    {
                            print '<td class="tdoverflowmax200">';
                                       print $form->selectarray($fieldname.$campo, array('0'=>$langs->trans('StatusAccountOpened'),'1'=>$langs->trans('StatusAccountClosed')),$obj->{$fieldlist[$field]});
       
                                     
                                          print '</td>';
            
                                     
                                    }
                                    
                                    elseif($campo=='assujtva_value')
                                    {
                            
                                    print '<td class="tdoverflowmax200">';
                               		print $form->selectyesno($fieldname.$campo,(! empty($obj->{$fieldlist[$field]})?$obj->{$fieldlist[$field]}:''));
	
       
                                     
                                          print '</td>';
            
                                     
                                    }
              
                                     elseif($campo=='typent_id')
                                    {
                            
                                      print '<td class="tdoverflowmax200">';
                                print $form->selectarray($fieldname.$campo,$formcompany->typent_array(0), $obj->{$fieldlist[$field]}, 0, 0, 0, '', 0, 0, 0, (empty($conf->global->SOCIETE_SORT_ON_TYPEENT)?'ASC':$conf->global->SOCIETE_SORT_ON_TYPEENT));
       
                                     
                                          print '</td>';
            
                                     
                                    }
                                 
                                  elseif($campo=='effectif_id')
                                    {
                            
                                      print '<td class="tdoverflowmax200">';
                               print $form->selectarray($fieldname.$campo,$formcompany->effectif_array(0), $obj->{$fieldlist[$field]});
          
       
                                     
                                          print '</td>';
            
                                     
                                    }
                                 
                                    elseif ($campo == 'forme_juridique_code')
                                    {
                                            print '<td class="tdoverflowmax100">';
                                            
                            
                                       print $formcompany->select_juridicalstatus($obj->{$fieldlist[$field]}, 0, '',  $fieldname.$campo);
                                                          print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                           
                                            
                                 
                                          print '</td>';
                                        }
            
                                    elseif ($campo == 'default_lang')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                           print $formadmin->select_language(($obj->{$fieldlist[$field]}?$obj->{$fieldlist[$field]}:''), $fieldname.$campo, 0, 0, 1, 0, 0, 'maxwidth200onsmartphone');
                                               print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                 
                                          print '</td>';
                                        }

                                    elseif ($campo == 'incoterm_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            print $form->select_incoterms($obj->{$fieldlist[$field]},'','',$fieldname.$campo);
                                  
                                        print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                          
                                          print '</td>';
                                        }

                               elseif ($campo == 'custcats')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                               $cat=explode(',',$obj->{$fieldlist[$field]});
               $cate_arbo = $form->select_all_categories(Categorie::TYPE_CUSTOMER, null, 'parent', null, null, 1);
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, null, null, null, null, "90%");
			
                                                
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                                        
                                          elseif ($campo == 'suppcats')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                               $cat=explode(',',$obj->{$fieldlist[$field]});
               $cate_arbo = $form->select_all_categories(Categorie::TYPE_SUPPLIER, null, 'parent', null, null, 1);
			print $form->multiselectarray($fieldname.$campo, $cate_arbo, $cat, null, null, null, null, "90%");
			
                                                
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                              
                                   
                                                elseif ($campo == 'multicurrency_code')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            print $form->select_currency($obj->{$fieldlist[$field]}, $fieldname.$campo, 0);
			  
                                      print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
                                        }
          
          
          
          
                                       elseif ($campo == 'commercial')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         $userlist = $form->select_dolusers('', '', 0, null, 0, '', '', 0, 0, 0, '', 0, '', '', 0, 1);
                                         
                                         $selected=explode(',',$obj->{$fieldlist[$field]});
        
                                              print $form->multiselectarray($fieldname.$campo, $userlist, $selected, null, null, null, null, "90%");    
                                  
			     print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                                       print '</td>';
                                        }
            
            
                                       elseif ($campo == 'socid')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                          	print $form->select_company($obj->{$fieldlist[$field]}, $fieldname.$campo, '(s.client = 1 OR s.client = 2 OR s.client = 3) AND status=1', 'SelectThirdParty', 0, 0, null, 0, 'minwidth300');
			   
                                                
                                    print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
                                        }
             
             
                                       elseif ($campo == 'cond_reglement_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->select_conditions_paiements($obj->{$fieldlist[$field]},$fieldname.$campo);

			   
                                                
                                    print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                                                  elseif ($campo == 'mode_reglement_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->select_types_paiements($obj->{$fieldlist[$field]},$fieldname.$campo);

			   
                                     print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                           
                                      elseif ($campo == 'fk_account')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->select_comptes($obj->{$fieldlist[$field]},$fieldname.$campo);

			   
                                      print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                                        
                                      elseif ($campo == 'demand_reason_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->selectInputReason($obj->{$fieldlist[$field]},$fieldname.$campo,$fieldname.$campo);

			   
                                              
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                               
               
                                      elseif ($campo == 'availability_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      	$form->selectAvailabilityDelay($obj->{$fieldlist[$field]},$fieldname.$campo,$fieldname.$campo);

			   
                                              
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                                
                                      elseif ($campo == 'shipping_method_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	$form->selectShippingMethod($obj->{$fieldlist[$field]},'shipping_method_id');

			   
                                   print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                          print '</td>';
                                        }
                                        
                                  elseif ($campo == 'projectid')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	$formproject->select_projects(-1,$obj->{$fieldlist[$field]},$fieldname.$campo, 1, 0, 1, 1);
 	                                          
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                           print '</td>';
                                        }
                                         elseif ($campo == 'fk_project')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	$formproject->select_projects(-1,$obj->{$fieldlist[$field]},$fieldname.$campo, 1, 0, 1, 1);
 	                                          
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                           print '</td>';
                                        }
                                        
                                        elseif ($campo == 'accountid')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                          
                                             $form->select_comptes($obj->{$fieldlist[$field]},$fieldname.$campo,0,'',1);  // Affiche liste des comptes courant
                                             
 	                                          
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                           print '</td>';
                                        }
                                             elseif ($campo == 'paymenttype')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             	$form->select_types_paiements($obj->{$fieldlist[$field]}, $fieldname.$campo, '', 2);
 	                                          
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                           print '</td>';
                                        }
	                                             elseif ($campo == 'modepayment')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                              
                                                $form->select_types_paiements($obj->{$fieldlist[$field]}, $fieldname.$campo, 'CRDT', 0, 1);
 	                                          
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                           print '</td>';
                                        }
	
                   elseif ($campo == 'task_parent')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                              
                                        
    print $formother->selectProjectTasks($obj->{$fieldlist[$field]}, '', $fieldname.$campo, 0, 0, 1, 1, 0, '0,1', 'maxwidth500');
		
    
 	                                          
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                           print '</td>';
                                        }
	

    
                                   elseif ($campo == 'model')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                         
                                        	if($formulario=='NewProp-Customer')
                                            {
                                         require_once DOL_DOCUMENT_ROOT . '/core/modules/propale/modules_propale.php';
                                        $liste = ModelePDFPropales::liste_modeles($db);
                                            }
                                               elseif($formulario=='NewOrder-Customer')
                                            {
                                             require_once DOL_DOCUMENT_ROOT . '/core/modules/commande/modules_commande.php';
                                        $liste = ModelePDFCommandes::liste_modeles($db);
                                            }
                                             elseif($formulario=='NewAskPrice')
                                            {
                                          require_once DOL_DOCUMENT_ROOT . '/core/modules/supplier_proposal/modules_supplier_proposal.php';
                                        $liste = ModelePDFSupplierProposal::liste_modeles($db);
                                            }
                                              elseif($formulario=='NewBill-Customer')
                                            {
                                          require_once DOL_DOCUMENT_ROOT . '/core/modules/facture/modules_facture.php';
                                        $liste = ModelePDFFactures::liste_modeles($db);
                                            }
                                          
                                          print $form->selectarray($fieldname.$campo, $liste, $obj->{$fieldlist[$field]});
                                          
                               print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                               
                                          print '</td>';
                                        }                                       
                          
                                        elseif ($campo == 'type')
                                        {
                                        print '<td class="tdoverflowmax200">';
                                        
                                        
                                        if($formulario=='FinancialAccount')
                                        {
                                        
                                        print  $formbank->selectTypeOfBankAccount($obj->{$fieldlist[$field]},$fieldname.$campo);
                                        
                                        
                                        }
                                        
                                        else
                                        {
                                        
                                        
                                        $arraylist = array('0' => $langs->transnoentitiesnoconv('InvoiceStandardAsk'),'1' => $langs->transnoentitiesnoconv('InvoiceReplacementAsk'),'2' => $langs->transnoentitiesnoconv('InvoiceAvoirAsk'), '3' => $langs->transnoentitiesnoconv('InvoiceDeposit'));
                                        print $form->selectarray($fieldname.$campo, $arraylist, $obj->{$fieldlist[$field]});
                                        }
                                          
                                        print "<script> $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                      
                                        print '</td>';
                                        }
                                        
                                        
                                         elseif ($campo == 'account_currency_code')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             
                                              $selectedcode=$obj->{$fieldlist[$field]};
                                            if (! $selectedcode) $selectedcode=$conf->currency;
                                            print $form->selectCurrency($selectedcode, $fieldname.$campo);
                                             
     
 	                                          
                                  print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                          print '</td>';
                                        }
                                        
                                        
                                          elseif ($campo == 'account_country_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                             
                                              $selectedcode=$obj->{$fieldlist[$field]};
                                            if (! $selectedcode) $selectedcode=$mysoc->country_code;
                                            print $form->select_country($selectedcode, $fieldname.$campo);
                                             
    

 	                                          
                                 print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                                   
                                          print '</td>';
                                        }
                                         
                                        
                                          elseif ($campo == 'civility_id')
                                    {
                                            print '<td class="tdoverflowmax200">';
                                            
                                      print 	 $formcompany->select_civility($obj->{$fieldlist[$field]},$fieldname.$campo, 'maxwidth200');

			   
                              
                                 print "<script> $('select[name=".$fieldname.$campo."]').width('200px');</script>";
                                          print '</td>';
                                        }
                                        
               
             
                                    else
                                    {
                                        if($obj->extra==='0')
                                        {
                                    print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150"><input   type="text" class="flat "   name="'. $fieldname.$campo.'"   value=\'\'    ><span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",0,'.$obj->extra.',"'.$obj->campo_tipo.'","texto");  class=\'fa fa-plus-circle classfortooltip \'  title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'></td>';
                                    }
                                    else
                                    {
                                        
                                        
                                         
                  $podedeletar=verifica($nome,$campoextra,$obj->rowid);
                   
                                        
                                        if($obj->campo_tipo==='select')
                                        {
                                           
                                        $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                     
                                        print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                        $out='<select class="flat minwidth200  maxwidthonsmartphone" name="'. $fieldname.$campo.'" id="'. $fieldname.$campo.'" '.($moreparam?$moreparam:'').'>';
                                        $out.='<option value="0">&nbsp;</option>';
                                            foreach ($param['options'] as $key => $val)
                                            {
                                            if ((string) $key == '') continue;
                                            list($val, $parent) = explode('|', $val);
                                            $out.='<option value="'.$key.'"';
                                            $out.= (((string) $obj->{$fieldlist[$field]} == (string) $key)?' selected':'');
                                            $out.= (!empty($parent)?' parent="'.$parent.'"':'');
                                            $out.='>';
                                            if ($langfile && $val) $out.=$langs->trans($val);
                                            else $out.=$val;
                                            $out.='</option>';
                                            }
                                        $out.='</select>';
                                        
                                       print  $out;
                                            print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                         }
                                         
                                          elseif($obj->campo_tipo==='link')
                                          {
                                            $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                            
                                         	$param_list=array_keys($param['options']);				// $param_list='ObjectName:classPath'
                                            $showempty=(($required && $default != '')?0:1);
                                            $out=$form->selectForForms($param_list[0], $fieldname.$campo, $obj->{$fieldlist[$field]}, $showempty,'','','minwidth200');
                                              print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                             print  $out;
                                               print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                           }
                                           
                                          elseif($obj->campo_tipo==='sellist')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                        
                                     //$extrafields->attributes[$campoextra]['type'][$key]  ;
                                     
                                        print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                        
			$out='<select class="flat" style="max-width:200px" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" '.($moreparam?$moreparam:'').'>';
			 $out.=buscalist($param['options'],$obj->{$fieldlist[$field]});
			$out.='</select>';
                                        
                                       print  $out;
                                           print "<script>$('select[name=".$fieldname.$campo."]').val([]); $('select[name=".$fieldname.$campo."]').width('95%')</script>";
                             
                                         }
                                         elseif($obj->campo_tipo==='radio')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                               print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                     $out='';
			foreach ($param['options'] as $keyopt => $val)
			{
				$out.='<input   class="flat '.$morecss.'" type="radio" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" '.($moreparam?$moreparam:'');
				$out.=' value="'.$keyopt.'"';
				$out.=' id="'.$fieldlist[$field].'_'.$keyopt.'"';
				$out.= ($obj->{$fieldlist[$field]}==$keyopt?'checked':'');
				$out.='/><label for="'.$fieldlist[$field].'_'.$keyopt.'">'.$val.'</label><br>';
			}
                                        
                                       print  $out;
                                 
                              
                                         }
                                         elseif($obj->campo_tipo==='checkbox')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                            
                               print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                     $out='';
                               
                               $value_arr=explode(',',$obj->{$fieldlist[$field]});
			$out=$form->multiselectarray($fieldname.$campo, (empty($param['options'])?null:$param['options']), $value_arr, '', 0, '', 0, '100%');
                                          print  $out;
                                   
                              
                                         }
                                         
                                          elseif($obj->campo_tipo==='chkbxlst')
                                        {
                                           $key= $obj->campo_nome;
                                            $param=$extrafields->attributes[$campoextra]['param'][$key];
                                       
                                     
                                        print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                     $value= $obj->{$fieldlist[$field]} ;
			 if (is_array($value)) {
				$value_arr = $value;
			}
			else {
				$value_arr = explode(',', $value);
			}
            
			 $data=buscalistCh($param['options'],$obj->{$fieldlist[$field]});
			 
                         $out=$form->multiselectarray($fieldname.$campo, $data, $value_arr, '', 0, '', 0, '100%');
                                          
                                        
                                       print  $out;
                                     
                                         }
                                          
                                          elseif($obj->campo_tipo==='boolean')
                                        {
                                             
                                     
                                             if (!empty($obj->{$fieldlist[$field]})) {
                                                    $checked=' checked value="1" ';
                                                } else {
                                                    $checked=' value="1" ';
                                                }
            $moreparam='';
                               print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                  $out='<input type="checkbox" class="flat '.$morecss.' maxwidthonsmartphone" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" '.$checked.' '.($moreparam?$moreparam:'').'>';
			                                print  $out;
                                 
                                         }
                                                
                                          elseif($obj->campo_tipo==='password')
                                        {
                                             
                                     $moreparam=''; 
  print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150">';
                                         	$out='<input   type="password" class="flat '.$morecss.'" name="'.$fieldname.$campo.'" id="'.$fieldname.$campo.'" value="'.$obj->{$fieldlist[$field]}.'" '.($moreparam?$moreparam:'').'><span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",0,'.$obj->extra.',"'.$obj->campo_tipo.'","texto");  class=\'fa fa-plus-circle classfortooltip \'   title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'>';
			                                print  $out;
                                 
                                         }
                                         
                                            elseif($obj->campo_tipo==='date'||$obj->campo_tipo==='datetime')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                   
                                     // $form1=$form->select_date('',"novcam_".$fieldname.$campo."_1",0,0,1);
                                   print '<span id="bir_'. $fieldname.$campo.'">'.$langs->trans("Entre").' <input type="text"  placeholder=\'yyyy-mm-dd\' maxlength=10 onkeyup=chama(this);   style=\'width:60px;font-size:10px;\'   name="'.$fieldname.$campo.'_1"   id="'.$fieldname.$campo.'_1" >'.$langs->trans("e").' <input type="text"  placeholder=\'yyyy-mm-dd\' maxlength=10 onkeyup=chama(this);   style=\'width:60px;font-size:10px;\'    name="'.$fieldname.$campo.'_2"   id="'.$fieldname.$campo.'_2"  >&nbsp;<span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",0,'.$obj->extra.',"'.$obj->campo_tipo.'","data");  class=\'fa fa-plus-circle classfortooltip  \' style=\'display:block;\' title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'></span>';
                                    
  
  print '<script>$(document).ready(function() {
    $("#'.$fieldname.$campo.'_1'.'").datepicker({
        dateFormat: "yy-mm-dd"
    }).focus(function() {
        $("#'.$fieldname.$campo.'_1'.'").datepicker("show");
    }).focus();
    
    $("#'.$fieldname.$campo.'_2'.'").datepicker({
        dateFormat: "yy-mm-dd"
    }).focus(function() {
        $("#'.$fieldname.$campo.'_2'.'").datepicker("show");
    }).focus();
});



</script>';

                                    print '</td>';
                                     
                                    
                                    }
                                         elseif($obj->campo_tipo==='int'||$obj->campo_tipo==='double'||$obj->campo_tipo==='price')
                                    
                                    {
                                    
                                    print '<td class="tdoverflowmax200">';
                                   
                                    print '<span id="bir_'. $fieldname.$campo.'">'.$langs->trans("Entre").' <input type="text"   maxlength=20 onchange=chamanum(this);   style=\'width:60px;font-size:10px;\'   name="'.$fieldname.$campo.'_1"   id="'.$fieldname.$campo.'_1" >'.$langs->trans("e").' <input type="text"    maxlength=20 onchange=chamanum(this);   style=\'width:60px;font-size:10px;\'    name="'.$fieldname.$campo.'_2"   id="'.$fieldname.$campo.'_2"  >&nbsp;<span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",2,'.$obj->extra.',"'.$obj->campo_tipo.'","numero");  class=\'fa fa-plus-circle classfortooltip  \'  style=\'display:block;\'   title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'></span>';
                                   
                                  
                                    print '</td>';
                                     
                                    
                                    } 
                                        else
                                        {
                                         print '<!-- '.$fieldlist[$field].' --><td align="'.$align.'" class="'.$class.' tdoverflowmax150"><input  type="text" class="flat" name="'.$fieldname.$campo.'"  value="'.$langs->trans($valuetoshow).'" ><span id="novcam_'. $fieldname.$campo.'"></span><span   onclick=inserecampo("novcam_'. $fieldname.$campo.'",0,'.$obj->extra.',"'.$obj->campo_tipo.'","texto");  class=\'fa fa-plus-circle classfortooltip \'  title=\''.$langs->trans("CliqueParaInserirInsiraosCampos").'\'> </td>';
                                         }
                                         
                                         
                                    }
                                    }
                                 }
                                  
                            
                            
                            
                               
                        }
                    }

                    // Can an entry be erased or disabled ?
                    $iserasable=1;$canbedisabled=1;$canbemodified=1;	// true by default
                    if (isset($obj->code) && $id != 10)
                    {
                    	if (($obj->code == '0' || $obj->code == '' || preg_match('/unknown/i',$obj->code))) { $iserasable = 0; $canbedisabled = 0; }
                    	else if ($obj->code == 'RECEP') { $iserasable = 0; $canbedisabled = 0; }
                    	else if ($obj->code == 'EF0')   { $iserasable = 0; $canbedisabled = 0; }
                    }

                    if (isset($obj->type) && in_array($obj->type, array('system', 'systemauto'))) { $iserasable=0; }
                    if (in_array($obj->code, array('AC_OTH','AC_OTH_AUTO')) || in_array($obj->type, array('systemauto'))) { $canbedisabled=0; $canbedisabled = 0; }
                    $canbemodified=$iserasable;
                    if ($obj->code == 'RECEP') $canbemodified=1;
                    if ($tabname[$id] == MAIN_DB_PREFIX."c_actioncomm") $canbemodified=1;

                    // Url
                    $rowidcol=$tabrowid[$id];
                    // If rowidcol not defined
                    if (empty($rowidcol) || in_array($id, array(6,7,8,13,17,19,27))) $rowidcol='rowid';
                    $url = $_SERVER["PHP_SELF"].'?rowid='.((! empty($obj->{$rowidcol}) || $obj->{$rowidcol} == '0')?$obj->{$rowidcol}:(! empty($obj->code)?urlencode($obj->code):''));
                    if (! empty($paramurl)) $url .= '&'.$paramurl;
                    if (! is_null($withentity)) $url .= '&entity='.$withentity;
                     
                    $url.="&";
			 
                    // Modify link
                     
                       
                      if ($canbemodified) print '<td align="center"><a class="reposition" href="javascript://" onclick=\'insere('.$i.',"'.$obj->campo_tipo.'","'.urlencode($campolabel).'","'.$campo.'","'.$obj->extra.'","'.$obj->campo_banco.'");  \' ><span style="font-size:32px" class="fa fa-arrow-circle-right atoplogin classfortooltip"  title="'.$langs->trans("CliqueParaInserirCriterio").'"></span></a></td>';
                      
                      if($obj->campo_tipo=='select'||$obj->campo_tipo=='link')
                      {
                       print  "<script> $('select[name=".$fieldname.$campo."]').attr('multiple','multiple'); </script>";
                         print "<script> $('select[name=".$fieldname.$campo."]').height('100%')</script>";
                          print "<script> $('select[name=".$fieldname.$campo."]').css('overflow-y','scroll');</script>";
                          
                        
                         
                         
}
                    print "</tr>\n";
                }
                $i3++;
            }
        }

        print '</table>';
        print '</div>';
        if ($action != 'edit'||!$action)
                
                {
                    
             print '<label for=rules><h4  style="margin-bottom:0px;margin-top:0px">'.$langs->trans("RegrasDefinidasdeCategorias").':</label> </h4><div    style=" height:305px; background-color:#fff; border: 1px solid #ccc; overflow: auto; "  ><span  width=100%    name=regras><ul style="margin:0px;padding:0" id=listaregras></ul></span></div> <h4></h4></div><br><center><input class="button" style="font:normal 12px arial; border:1px solid grey; padding:5px; border-radius:10px; margin-top:2px; " type=button onclick=envia() value="'.$langs->trans("EnviarRegrasdeCategorias").'"> ';
             }
    }
    else {
        dol_print_error($db);
    }
 
if($campoextra!='')
{
$extra = "SELECT m.name, m.elementtype, m.label, m.type, m.rowid FROM ".MAIN_DB_PREFIX."extrafields as m where m.elementtype='".$campoextra."' order by m.rowid";

$result=$db->query($extra);
		if ($result)
		{
            while ($obj = $db->fetch_object($result)) {
                
              if($submodulo!=''&&$pagina!=''&&$acao!='')
    
    {
                $sqlinsert = "INSERT  INTO `".MAIN_DB_PREFIX."categorizeall` (`rowid`, `modulo`, `submodulo`, `pagina`, `acao`, `campo_nome`, `campo_banco`, `campo_tipo`, `campo_texto`,`form_nome`, `campo_pos`,`situacao`,`extra`) VALUES (NULL, '".$modulo."', '".$submodulo."', '".$pagina."', '".$acao."',  '".$obj->name."','".$obj->name."', '".$obj->type."', '".$obj->label."', '".$formulario."', '0', '1', '1');";

     
     // echo $sqlinsert."<br>";
                
    	 $result2=$db->query($sqlinsert);
      }   
         
if ($result2)
{
    	$num2 = $db->affected_rows($result2);
        
        if($num2>0)
        {
             setEventMessages($langs->trans("AutomaticCreation").' - '.$langs->trans("RecordCreatedSuccessfully").' - '.$obj->label.' - '.$langs->trans("ExtraFields"), null, 'mesgs');
             
         	 print '<script>setTimeout(function(){ window.location.href=window.location.href}, 1000);</script>';  
       
           }
//        
                          
				}
        }
         
           
        }
    
}
   

    print '</form></div>';
 
 

 function buscalist($params,$value)
{
    
  
$out='';
	global $conf,$langs,$db;
	 
    {
        if (is_array($params))
			{
				$param_list=array_keys($params);
				$InfoFieldList = explode(":", $param_list[0]);
				$parentName='';
				$parentField='';
				// 0 : tableName
				// 1 : label field name
				// 2 : key fields name (if differ of rowid)
				// 3 : key field parent (for dependent lists)
				// 4 : where clause filter on column or table extrafield, syntax field='value' or extra.field=value
				$keyList=(empty($InfoFieldList[2])?'rowid':$InfoFieldList[2].' as rowid');


				if (count($InfoFieldList) > 4 && ! empty($InfoFieldList[4]))
				{
					if (strpos($InfoFieldList[4], 'extra.') !== false)
					{
						$keyList='main.'.$InfoFieldList[2].' as rowid';
					} else {
						$keyList=$InfoFieldList[2].' as rowid';
					}
				}
				if (count($InfoFieldList) > 3 && ! empty($InfoFieldList[3]))
				{
					list($parentName, $parentField) = explode('|', $InfoFieldList[3]);
					$keyList.= ', '.$parentField;
				}

				$fields_label = explode('|',$InfoFieldList[1]);
				if (is_array($fields_label))
				{
					$keyList .=', ';
					$keyList .= implode(', ', $fields_label);
				}

				$sqlwhere='';
				$sql = 'SELECT '.$keyList;
				$sql.= ' FROM '.MAIN_DB_PREFIX .$InfoFieldList[0];
				if (!empty($InfoFieldList[4]))
				{
				    // can use curent entity filter
				    if (strpos($InfoFieldList[4], '$ENTITY$')!==false) {
				        $InfoFieldList[4]=str_replace('$ENTITY$',$conf->entity,$InfoFieldList[4]);
				    }
					// can use SELECT request
					if (strpos($InfoFieldList[4], '$SEL$')!==false) {
						$InfoFieldList[4]=str_replace('$SEL$','SELECT',$InfoFieldList[4]);
					}

					// current object id can be use into filter
					if (strpos($InfoFieldList[4], '$ID$')!==false && !empty($objectid)) {
						$InfoFieldList[4]=str_replace('$ID$',$objectid,$InfoFieldList[4]);
					} else {
						$InfoFieldList[4]=str_replace('$ID$','0',$InfoFieldList[4]);
					}
					//We have to join on extrafield table
					if (strpos($InfoFieldList[4], 'extra')!==false)
					{
						$sql.= ' as main, '.MAIN_DB_PREFIX .$InfoFieldList[0].'_extrafields as extra';
						$sqlwhere.= ' WHERE extra.fk_object=main.'.$InfoFieldList[2]. ' AND '.$InfoFieldList[4];
					}
					else
					{
						$sqlwhere.= ' WHERE '.$InfoFieldList[4];
					}
				}
				else
				{
					$sqlwhere.= ' WHERE 1=1';
				}
				// Some tables may have field, some other not. For the moment we disable it.
				if (in_array($InfoFieldList[0],array('tablewithentity')))
				{
					$sqlwhere.= ' AND entity = '.$conf->entity;
				}
				$sql.=$sqlwhere;
				//print $sql;

				$sql .= ' ORDER BY ' . implode(', ', $fields_label);

			 	$resql = $db->query($sql);
				if ($resql)
				{
					$out.='<option value="0">&nbsp;</option>';
					$num = $db->num_rows($resql);
					$i = 0;
					while ($i < $num)
					{
						$labeltoshow='';
						$obj = $db->fetch_object($resql);

						// Several field into label (eq table:code|libelle:rowid)
						$notrans = false;
						$fields_label = explode('|',$InfoFieldList[1]);
						if (is_array($fields_label))
						{
							$notrans = true;
							foreach ($fields_label as $field_toshow)
							{
								$labeltoshow.= $obj->$field_toshow.' ';
							}
						}
						else
						{
							$labeltoshow=$obj->{$InfoFieldList[1]};
						}
						$labeltoshow=dol_trunc($labeltoshow,45);

						if ($value == $obj->rowid)
						{
							foreach ($fields_label as $field_toshow)
							{
								$translabel=$langs->trans($obj->$field_toshow);
								if ($translabel!=$obj->$field_toshow) {
									$labeltoshow=dol_trunc($translabel,18).' ';
								}else {
									$labeltoshow=dol_trunc($obj->$field_toshow,18).' ';
								}
							}
							$out.='<option value="'.$obj->rowid.'" selected>'.$labeltoshow.'</option>';
						}
						else
						{
							if (! $notrans)
							{
								$translabel=$langs->trans($obj->{$InfoFieldList[1]});
								if ($translabel!=$obj->{$InfoFieldList[1]}) {
									$labeltoshow=dol_trunc($translabel,18);
								}
								else {
									$labeltoshow=dol_trunc($obj->{$InfoFieldList[1]},18);
								}
							}
							if (empty($labeltoshow)) $labeltoshow='(not defined)';
							if ($value==$obj->rowid)
							{
								$out.='<option value="'.$obj->rowid.'" selected>'.$labeltoshow.'</option>';
							}

							if (!empty($InfoFieldList[3]) && $parentField)
							{
								$parent = $parentName.':'.$obj->{$parentField};
							}

							$out.='<option value="'.$obj->rowid.'"';
							$out.= ($value==$obj->rowid?' selected':'');
							$out.= (!empty($parent)?' parent="'.$parent.'"':'');
							$out.='>'.$labeltoshow.'</option>';
						}

						$i++;
					}
					$db->free($resql);
				}
				else {
					print 'Error in request '.$sql.' '.$db->lasterror().'. Check setup of extra parameters.<br>';
				}
			}
            }
            return $out;
     }       
 
 function buscalistCh($params,$value)
{
    
  
$out='';
	global $conf,$langs,$db;
	 
    {
       if (is_array($params)) {
				$param_list = array_keys($params);
				$InfoFieldList = explode(":", $param_list[0]);
				$parentName='';
				$parentField='';
				// 0 : tableName
				// 1 : label field name
				// 2 : key fields name (if differ of rowid)
				// 3 : key field parent (for dependent lists)
				// 4 : where clause filter on column or table extrafield, syntax field='value' or extra.field=value
				$keyList = (empty($InfoFieldList[2]) ? 'rowid' : $InfoFieldList[2] . ' as rowid');

				if (count($InfoFieldList) > 3 && ! empty($InfoFieldList[3])) {
					list ( $parentName, $parentField ) = explode('|', $InfoFieldList[3]);
					$keyList .= ', ' . $parentField;
				}
				if (count($InfoFieldList) > 4 && ! empty($InfoFieldList[4])) {
					if (strpos($InfoFieldList[4], 'extra.') !== false) {
						$keyList = 'main.' . $InfoFieldList[2] . ' as rowid';
					} else {
						$keyList = $InfoFieldList[2] . ' as rowid';
					}
				}

				$fields_label = explode('|', $InfoFieldList[1]);
				if (is_array($fields_label)) {
					$keyList .= ', ';
					$keyList .= implode(', ', $fields_label);
				}

				$sqlwhere = '';
				$sql = 'SELECT ' . $keyList;
				$sql .= ' FROM ' . MAIN_DB_PREFIX . $InfoFieldList[0];
				if (! empty($InfoFieldList[4])) {

					// can use SELECT request
					if (strpos($InfoFieldList[4], '$SEL$')!==false) {
						$InfoFieldList[4]=str_replace('$SEL$','SELECT',$InfoFieldList[4]);
					}

					// current object id can be use into filter
					if (strpos($InfoFieldList[4], '$ID$')!==false && !empty($objectid)) {
						$InfoFieldList[4]=str_replace('$ID$',$objectid,$InfoFieldList[4]);
					} else {
						$InfoFieldList[4]=str_replace('$ID$','0',$InfoFieldList[4]);
					}

					// We have to join on extrafield table
					if (strpos($InfoFieldList[4], 'extra') !== false) {
						$sql .= ' as main, ' . MAIN_DB_PREFIX . $InfoFieldList[0] . '_extrafields as extra';
						$sqlwhere .= ' WHERE extra.fk_object=main.' . $InfoFieldList[2] . ' AND ' . $InfoFieldList[4];
					} else {
						$sqlwhere .= ' WHERE ' . $InfoFieldList[4];
					}
				} else {
					$sqlwhere .= ' WHERE 1=1';
				}
				// Some tables may have field, some other not. For the moment we disable it.
				if (in_array($InfoFieldList[0], array ('tablewithentity')))
				{
					$sqlwhere .= ' AND entity = ' . $conf->entity;
				}
				// $sql.=preg_replace('/^ AND /','',$sqlwhere);
				// print $sql;

				$sql .= $sqlwhere;
			 	$resql = $db->query($sql);
				if ($resql) {
					$num = $db->num_rows($resql);
					$i = 0;

					$data=array();

					while ( $i < $num ) {
						$labeltoshow = '';
						$obj = $db->fetch_object($resql);

						$notrans = false;
						// Several field into label (eq table:code|libelle:rowid)
						$fields_label = explode('|', $InfoFieldList[1]);
						if (is_array($fields_label)) {
							$notrans = true;
							foreach ( $fields_label as $field_toshow ) {
								$labeltoshow .= $obj->$field_toshow . ' ';
							}
						} else {
							$labeltoshow = $obj->{$InfoFieldList[1]};
						}
						$labeltoshow = dol_trunc($labeltoshow, 45);

						if (is_array($value_arr) && in_array($obj->rowid, $value_arr)) {
							foreach ( $fields_label as $field_toshow ) {
								$translabel = $langs->trans($obj->$field_toshow);
								if ($translabel != $obj->$field_toshow) {
									$labeltoshow = dol_trunc($translabel, 18) . ' ';
								} else {
									$labeltoshow = dol_trunc($obj->$field_toshow, 18) . ' ';
								}
							}

							$data[$obj->rowid]=$labeltoshow;
						} else {
							if (! $notrans) {
								$translabel = $langs->trans($obj->{$InfoFieldList[1]});
								if ($translabel != $obj->{$InfoFieldList[1]}) {
									$labeltoshow = dol_trunc($translabel, 18);
								} else {
									$labeltoshow = dol_trunc($obj->{$InfoFieldList[1]}, 18);
								}
							}
							if (empty($labeltoshow))
								$labeltoshow = '(not defined)';

								if (is_array($value_arr) && in_array($obj->rowid, $value_arr)) {
									$data[$obj->rowid]=$labeltoshow;
								}

								if (! empty($InfoFieldList[3]) && $parentField) {
									$parent = $parentName . ':' . $obj->{$parentField};
								}

								$data[$obj->rowid]=$labeltoshow;
						}

						$i ++;
					}
					$db->free($resql);

			 	} else {
					print 'Error in request ' . $sql . ' ' . $db->lasterror() . '. Check setup of extra parameters.<br>';
				}
			}
            }
            return $data;
     }
     
  function EditaCampo($fieldlist, $obj='', $tabname='', $context='',$campocountry_id,$formulario)
{
    
   //print_r($fieldlist);
    

	global $conf,$langs,$db,$form;
    
    

$adht = new AdherentType($db);


$formcontract= new Formcontract($db);

$formproject = new FormProjets($db);  
	  
 $formproduct=new FormProduct($db);
$formbank = new FormBank($db);
$formactions = new FormActions($db);
$formother=new FormOther($db);
 
if(!function_exists('loadLangs'))
			{
                
$langs->load("categorizeall@categorizeall");$langs->load("errors");$langs->load("admin");$langs->load("members");$langs->load("install");$langs->load("exports");$langs->load("banks");$langs->load("users");$langs->load("withdrawals");$langs->load("agenda");$langs->load("boxes");$langs->load("supplier_proposal");$langs->load("suppliers");$langs->load("compta");$langs->load("salaries");$langs->load("commercial");$langs->load("companies");$langs->load("donations");$langs->load("mails");$langs->load("resource");$langs->load("holiday");$langs->load("accountancy");$langs->load("hrm");$langs->load("orders");$langs->load("contracts");$langs->load("projects");$langs->load("propal");$langs->load("bills");$langs->load("interventions");$langs->load("sendings");$langs->load("deliveries");$langs->load("products");$langs->load("stocks");$langs->load("productbatch");$langs->load("categories");
         }
			else
			{
           $langs->loadLangs(array("errors","admin","main","members","salaries","install","exports","banks","users","categories","withdrawals","agenda","boxes","loan","trips","supplier_proposal","printing","sendings","ecm","dict","suppliers","compta","salaries","commercial","companies","donations", "mails","resource","holiday","accountancy","hrm","orders","contracts","projects","propal","bills","interventions","sendings","deliveries","products","other","categorizeall@categorizeall","stocks","productbatch"));
			}

      $campoextra='';
   
  
if($formulario=='ThirdParty'){$campoextra='societe';$nome='nom';$vinculo='fk_soc';$cat=$campoextra;$campoextra2=($tipocat==1?'fournisseur':$campoextra);$tipocategoria=$tipocat;}
elseif($formulario=='Contact'){$campoextra='socpeople';$nome='lastname';$campoextra2='contact';$nome2='firstname'; $vinculo='fk_socpeople';$cat='contact';$tipocategoria=4;}
elseif($formulario=='Product-Service'){$campoextra='product'; $nome='label'; $vinculo='fk_product';$cat=$campoextra;$campoextra2=$campoextra;$tipocategoria=0;}
elseif($formulario=='FinancialAccount'){$campoextra='bank_account';$nome='label'; $cat='account'; $vinculo='fk_account';$tipocategoria=5;}
elseif($formulario=='LeadOrProject'){$campoextra='projet';   $nome='title';$campoextra2='project'; $vinculo='fk_project';$cat='project';$tipocategoria=6; }
elseif($formulario=='User'){$campoextra='user';  $nome='login'; $vinculo='fk_user';$cat='project';$tipocategoria=7; $campoextra2=$campoextra; }
elseif($formulario=='Member'){$campoextra='adherent';  $nome='lastname';$nome2='firstname'; $vinculo='fk_member';$campoextra2='member'; $cat='member';$tipocategoria=3; }




$extrafields = new ExtraFields($db);

// fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label($campoextra);

  $countrynotdefined=$langs->trans("ErrorSetACountryFirst").' ('.$langs->trans("SeeAbove").')';

	$formadmin = new FormAdmin($db);
	$formcompany = new FormCompany($db);
    if (! empty($conf->projet->enabled)) { $formproject = new FormProjets($db); }

	if (! empty($conf->accounting->enabled)) $formaccounting = new FormAccounting($db);

	$withentity='';


      $crialistajson=json_decode($obj->json,true);
                
                
                
                
       //echo print_r($crialistajson);
       
        $textoquery="";
       
echo '<tr><td nowrap>'.$langs->trans("NomedaCategoria").'<td style="font-weight:bold; font-size:22px;">'.$crialistajson['nomecat'] ;
echo '<tr><td  >'.$langs->trans("Criterios").'<td>' ;

 
for ($i = 0; $i <  count($crialistajson)-3; $i++) {
echo   $langs->trans("Se")." <b>".urldecode($crialistajson[$i]["label"])."</b> <font color=blue>".urldecode($crialistajson[$i]["textooperador"])."</font> ".urldecode($crialistajson[$i]["textovalorpadrao"])."<br>";


if($crialistajson[$i]["operador"]==="1"){$opera="=";$pre="'";$pos="'";}
elseif($crialistajson[$i]["operador"]==="2"){$opera="!=";$pre="'";$pos="'";}
elseif($crialistajson[$i]["operador"]==="3"){$opera="LIKE";$pre=" '%";$pos="%'";}
elseif($crialistajson[$i]["operador"]==="4"){$opera="NOT LIKE";$pre=" '%";$pos="%'";}
elseif($crialistajson[$i]["operador"]==="5"){$opera="BETWEEN";$pre=" ";$pos="";}
elseif($crialistajson[$i]["operador"]==="6"){$opera="NOT BETWEEN";$pre=" ";$pos=" ";}
elseif($crialistajson[$i]["operador"]==="7"){$opera="=";$pre="'";$pos="'";}
elseif($crialistajson[$i]["operador"]==="8"){$opera="BETWEEN";$pre=" '";$pos="'";}
elseif($crialistajson[$i]["operador"]==="9"){$opera="NOT BETWEEN";$pre=" '";$pos="'";}
 elseif($crialistajson[$i]["operador"]==="10"){$opera="NOT EXISTS";$pre=" '";$pos="'";}
 elseif($crialistajson[$i]["operador"]==="11"){$opera="EXISTS";$pre=" '";$pos="'";}
  

    if(is_array($crialistajson[$i]["dadosvalorpadrao"]))
    {
    $textoquery.=" and (";
    
    for ($x = 0; $x <  count($crialistajson[$i]["dadosvalorpadrao"]); $x++) {
        
        
            if(is_array($crialistajson[$i]["dadosvalorpadrao"][$x]))
        {
              if($crialistajson[$i]["extra"]=='1'){
                            
              if($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="3")
                    {
                        $opera="=";$pre="'";$pos="'";   
                    }
                    elseif($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="4")
                    {
                        $opera="!=";$pre="'";$pos="'";   
                    }
                    
                    
             $nova = '(SELECT 1 FROM '.MAIN_DB_PREFIX .$campoextra.'_extrafields where `'.$crialistajson[$i]["banco"].'` '.$opera.$pre.$crialistajson[$i]["dadosvalorpadrao"][$x][0].$pos.' and '. $pre.$crialistajson[$i]["dadosvalorpadrao"][$x][1].$pos.' and `fk_object`=ca.rowid)' ;
             }
                else
                {
                    if($crialistajson[$i]["banco"]=='propal_count'||$crialistajson[$i]["banco"]=='propal_sum'||$crialistajson[$i]["banco"]=='commande_count'||$crialistajson[$i]["banco"]=='commande_sum'||$crialistajson[$i]["banco"]=='facture_count'||$crialistajson[$i]["banco"]=='facture_sum'||$crialistajson[$i]["banco"]=='propal-supplier_count'||$crialistajson[$i]["banco"]=='propal-supplier_sum'||$crialistajson[$i]["banco"]=='commande-supplier_count'||$crialistajson[$i]["banco"]=='commande-supplier_sum'||$crialistajson[$i]["banco"]=='facture-fourn_count'||$crialistajson[$i]["banco"]=='facture-fourn_sum'){
                        
 $separa=explode('_',$crialistajson[$i]["banco"]);
 if($campoextra=='societe')
 {
 
     if($crialistajson[$i]["dadosvalorpadrao"][$x][5]=='0')
        {
        $camporef='rowid';
        $operaref='count';
        }
        else
        {
        $camporef='total_ttc';
        $operaref='sum';
        }
        
        if($separa[0]=='commande')
        {
        $data='date_creation';
        $total='total_ttc';
        $tabela='commande';
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=-1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=4;}
        }
        elseif($separa[0]=='propal')
        {
        $data='datec';
        $total='total';
        $tabela='propal';
        $camporef='total';
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=3;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=4;}
        }
        elseif($separa[0]=='propal-supplier')
        {
        $data='datec';
        $total='total';
        $tabela='supplier_proposal';
        $camporef='total';
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=3;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=4;}
        } 
        elseif($separa[0]=='facture')
        {
        $data='datec';
        $total='total';
        $tabela='facture';
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=3;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=2;}
        }
        elseif($separa[0]=='commande-supplier')
        {
          $data='date_creation';
        $total='total';
        $tabela='commande_fournisseur';
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=6;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=3;}
        }
        elseif($separa[0]=='facture-fourn')
        {
        $data='datec';
        $total='total';
        $tabela='facture_fourn';  
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=6;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=2;}
        }
    
}
if($campoextra=='product')
 {
  if($crialistajson[$i]["dadosvalorpadrao"][$x][5]=='0')
        {
        $camporef='qty';
        $operaref='sum';
        }
        else
        {
        $camporef='total_ttc';
        $operaref='sum';
        }
            
    
        if($separa[0]=='commande')
        {
        $data='date_creation';
 
        $total='total_ht';
        $tabela='commandedet';
        $tabela2='commande';
         $fk=$tabela2;
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=-1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=4;}
        }
        elseif($separa[0]=='propal')
        {
        $data='datec';
        $total='total_ht';
        $tabela='propaldet';
        $tabela2='propal';
        $fk=$tabela2;
        
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=3;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=4;}
        }
        elseif($separa[0]=='propal-supplier')
        {
        $data='datec';
        $total='total';
        $tabela='supplier_proposaldet';
         $tabela2='supplier_proposal';
         $fk=$tabela2;
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=3;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=4;}
        } 
        elseif($separa[0]=='facture')
        {
        $data='datec';
        $total='total';
       
         $tabela='facturedet';
        $tabela2='facture';
         $fk=$tabela2;
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=3;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=2;}
        }
        elseif($separa[0]=='commande-supplier')
        {
         $data='date_creation';
        $total='total';
        $tabela='commande_fournisseurdet';
        
        $tabela2='commande_fournisseur';
        $fk='commande';
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=2;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=6;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=3;}
        }
        elseif($separa[0]=='facture-fourn')
        {
        $data='datec';
        $total='total';
        $tabela='facture_fourn_det';
        $tabela2='facture_fourn';
       $fk=$tabela2;
         
        if($crialistajson[$i]["dadosvalorpadrao"][$x][4]==0){$situa=0;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==1){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==2){$situa=1;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==3){$situa=6;}
        elseif($crialistajson[$i]["dadosvalorpadrao"][$x][4]==4){$situa=2;}
        }
    
}
 if($campoextra=='societe')
 {
             $nova = '((SELECT '.$operaref.'('.$camporef.') FROM '.MAIN_DB_PREFIX.$tabela.' as t where `t`.`'.$vinculo.'`=ca.rowid and `t`.`fk_statut`='.$situa.' and `t`.`'.$data.'` between "'.$crialistajson[$i]["dadosvalorpadrao"][$x][2].'" AND "'.$crialistajson[$i]["dadosvalorpadrao"][$x][3].'") '.$opera.$pre.$crialistajson[$i]["dadosvalorpadrao"][$x][0].$pos.' and '. $pre.$crialistajson[$i]["dadosvalorpadrao"][$x][1].$pos.')' ;
  }
  else
  {
       $nova = '((SELECT '.$operaref.'(l.'.$camporef.') FROM '.MAIN_DB_PREFIX.$tabela.' as l, '.MAIN_DB_PREFIX.$tabela2.' as pp  where `l`.`'.$vinculo.'`=ca.rowid and l.fk_'.$fk.'=pp.rowid  and `pp`.`fk_statut`='.$situa.' and `pp`.`'.$data.'` between "'.$crialistajson[$i]["dadosvalorpadrao"][$x][2].'" AND "'.$crialistajson[$i]["dadosvalorpadrao"][$x][3].'") '.$opera.$pre.$crialistajson[$i]["dadosvalorpadrao"][$x][0].$pos.' and '. $pre.$crialistajson[$i]["dadosvalorpadrao"][$x][1].$pos.')' ;
       
       
       
     
    }
  
             
             }
                    else
                    {
                    if($crialistajson[$i]["dadosvalorpadrao"][$x][0]=='')
                    {
                          $nova = "(`".$crialistajson[$i]["banco"]."` ".($opera=='BETWEEN'?'=':'!=')."'' or ".$crialistajson[$i]["banco"].($opera=='BETWEEN'?" is null ":" is not null ").")";
                     } 
                        else 
                    {
                    $nova = "(`".$crialistajson[$i]["banco"]."` ". $opera." ".$pre. $crialistajson[$i]["dadosvalorpadrao"][$x][0].$pos."  and ". $pre.$crialistajson[$i]["dadosvalorpadrao"][$x][1].$pos.")";
                    }
                    
                    }
                    }
                     if($crialistajson[$i]["operador"]==="10"||$crialistajson[$i]["operador"]==="11")
                     {
                        $nova = $opera.' (SELECT 1 FROM '.MAIN_DB_PREFIX.$tabela.'   where  `'.$vinculo.'`=`ca`.`rowid`)' ;
                        }
                     
               $textoquery.=($x==0?"":" or ").$nova;
              
            }
     else
     {
         if($crialistajson[$i]["extra"]=='1'){
            
              if($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="3")
                    {
                        $opera="=";$pre="'";$pos="'";   
                    }
                    elseif($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="4")
                    {
                        $opera="!=";$pre="'";$pos="'";   
                    }
                    
                $nova = '(SELECT 1 FROM '.MAIN_DB_PREFIX .$campoextra.'_extrafields where `'.$crialistajson[$i]["banco"].'` '.$opera.$pre.$crialistajson[$i]["dadosvalorpadrao"][$x].$pos.' and `fk_object`=ca.rowid)' ;
                }
                elseif($crialistajson[$i]["banco"]=='custcats'||$crialistajson[$i]["banco"]=='suppcats'||$crialistajson[$i]["banco"]=='contcats'||$crialistajson[$i]["banco"]=='categories'||$crialistajson[$i]["banco"]=='usercats'||$crialistajson[$i]["banco"]=='memcats'){
                   if($crialistajson[$i]["banco"]==='custcats')
                       {
                       $texto='  client>0  and ';
                       }
                       elseif($crialistajson[$i]["banco"]==='suppcats')
                       {
                       $texto=' fournisseur>0  and ';
                       }
                       else {$texto='';}
                   
          
                $invopera="=";
                $nova= $texto.($opera=='='?'  EXISTS':' NOT EXISTS').'(SELECT 1 FROM '.MAIN_DB_PREFIX.'categorie_'.$cat.'  where `fk_categorie`'.$invopera.$pre.$crialistajson[$i]["dadosvalorpadrao"][$x].$pos.' and `'.$vinculo.'`=`ca`.`rowid`)' ;
                }
                  elseif($crialistajson[$i]["banco"]=='commercial'){
                  
                $nova = '(SELECT 1 FROM '.MAIN_DB_PREFIX.'societe_commerciaux where `fk_user`'.$opera.$pre.$crialistajson[$i]["dadosvalorpadrao"][$x].$pos.' and `fk_soc`=`ca`.`rowid`)' ;
                }
                   elseif($crialistajson[$i]["operador"]==="7"){
                  
                  
                  $nova ="(MONTH(`".$crialistajson[$i]["banco"]."`)".$opera."".$pre.($crialistajson[$i]["dadosvalorpadrao"][$x]*1).$pos.")";
                }
                else
                {
                    if($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="3")
                    {
                        $opera="=";$pre="'";$pos="'";   
                    }
                    elseif($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="4")
                    {
                        $opera="!=";$pre="'";$pos="'";   
                    }
                    
                     
                  $nova ="(`".$crialistajson[$i]["banco"]."` ".$opera."".$pre. $crialistajson[$i]["dadosvalorpadrao"][$x].$pos.($crialistajson[$i]["dadosvalorpadrao"][$x]==''?" or ".$crialistajson[$i]["banco"].($opera=='='?" is null ":" is not null "):"").")";
                    }
           $textoquery.=($x==0?"":" or ").$nova;
        }

    }
    $textoquery.=")";
    
    }
    
    else 
    {
        
        
  if($crialistajson[$i]["extra"]=='1'){
    
    
              if($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="3")
                    {
                        $opera="=";$pre="'";$pos="'";   
                    }
                    elseif($crialistajson[$i]["dadosvalorpadrao"][$x]==''&&$crialistajson[$i]["operador"]==="4")
                    {
                        $opera="!=";$pre="'";$pos="'";   
                    }
                    
                $nova = '(SELECT 1 FROM '.MAIN_DB_PREFIX .$campoextra.'_extrafields where `'.$crialistajson[$i]["banco"].'` '.$opera.$pre.$crialistajson[$i]["dadosvalorpadrao"].$pos.' and `fk_object`=ca.rowid)' ;
                }
                else 
                {
                 if($crialistajson[$i]["dadosvalorpadrao"]==''&&($crialistajson[$i]["banco"]=='custcats'||$crialistajson[$i]["banco"]=='suppcats'||$crialistajson[$i]["banco"]=='contcats'||$crialistajson[$i]["banco"]=='categories'||$crialistajson[$i]["banco"]=='usercats'||$crialistajson[$i]["banco"]=='memcats')){
                        
                       if($crialistajson[$i]["banco"]==='custcats')
                       {
                       $texto='  client>0  and ';
                       }
                       elseif($crialistajson[$i]["banco"]==='suppcats')
                       {
                       $texto=' fournisseur>0  and ';
                       }
                       else {$texto='';}
                   
                $nova= $texto.($opera=='='?' NOT EXISTS':' EXISTS').'(SELECT 1 FROM '.MAIN_DB_PREFIX.'categorie_'.($crialistajson[$i]["banco"]=='suppcats'?'fournisseur':$campoextra2).'  where  `'.$vinculo.'`=`ca`.`rowid`)' ;
                }
                 else
                 {
                 $nova = "(`".$crialistajson[$i]["banco"]."` ".$opera." '".$crialistajson[$i]["dadosvalorpadrao"]."'".($crialistajson[$i]["dadosvalorpadrao"]==''?" or ".$crialistajson[$i]["banco"].($opera=='='?" is null ":" is not null "):"").")";
                 
                 }
                    
                    }
                    
$textoquery.=" and ". $nova;

}
}
  
// 
//   echo "<tr><td>Query<td>" ; 
//
// 
 $query = "select distinct ca.rowid, ca.".$nome."  as nome ".($nome2?', '.$nome2.' as nome2':'')." from `".MAIN_DB_PREFIX.$campoextra."` as ca ".$pretexto."  where 1=1  ".$textoquery.' order by nome asc' ;
//
// 
//     
 //echo $query;
 
 
if($obj->form_nome=='ThirdParty'&&$obj->regra_tipo==2){$linkform='/societe/card.php?socid='; }
else if($obj->form_nome=='ThirdParty'&&$obj->regra_tipo==1){$linkform='/societe/card.php?socid=';  }
elseif($obj->form_nome=='Contact'){$linkform='/contact/card.php?id=';}
elseif($obj->form_nome=='Product-Service'){$linkform='/product/card.php?id=';  }
elseif($obj->form_nome=='FinancialAccount'){$linkform='/compta/bank/card.php?id=';}
elseif($obj->form_nome=='LeadOrProject'){$linkform='/projet/card.php?id=';}
elseif($obj->form_nome=='User'){$linkform='/user/card.php?id=';}
elseif($obj->form_nome=='Member'){$linkform='/adherents/card.php?rowid=';}

 
                  
                    
 
  echo '<tr><td>'.$langs->trans("Resultado").'<td>';
  
  $lista="";
    $lista2="";
	$resql4 = $db->query($query);
                $num4 = $db->num_rows($resql4);
                
          
        $z = 0;
				if ($resql4)
				{
                    for($z=0; $z <$num4; $z++)
				{
			 	 $obj7 = $db->fetch_object($resql4);
				$lista.=$obj7->rowid.($z<$num4-1?", ":"");
                $lista2.='<a   href="'.DOL_URL_ROOT.$linkform.$obj7->rowid.'"> <li style="font: 12px arial; border: 1px solid grey; padding: 5px; border-radius: 10px; width: 94%; margin-top: 2px; margin-left: 4px; list-style-type: none; float: left;">'.($obj7->nome2?$obj7->nome2.' ':'').$obj7->nome.'</li></a>';
                
                
				}
                }
                
               
                
                
                

      echo '<div    style=" height:'.($num4>5?150:$num4>10?200:$num4>15?300:100).'px; width:400px; background-color:#fff; border: 2px solid #ccc; overflow: auto; "  ><span  width=95%    name=listacategorizaveis><ul style="margin:0px;padding:0" id=listaregras>'.$lista2.'</ul></span></div>';
 
			   print '<br>'.$langs->trans("QuantidadeDeItens").': '.$num4.' <input type="hidden" name="total_categorizaveis" value="'.$num4.'">'.($num4<1?'<font color=red><b><br><br>('.$langs->trans("VerifiqueOsCriterios").'</font>)':'');
               print '<br><br><b>'.$langs->trans("QuantidadeDeItensCategorizados").': '.$obj->quant;
               
      print '<br><input type="hidden" name="lista_categorizaveis" value="'.$lista.'">';
      if($campoextra=='societe')
      {
           echo "<tr><td>".$langs->trans("Tipo")."<td><select  name='tipocat'   id='tipocat'   ><option ".($obj->regra_tipo==2||$obj->regra_tipo==''?'selected':'')." value=2>".$langs->trans("TipoCatCliente")."</option><option ".($obj->regra_tipo==1?'selected':'')." value=1>".$langs->trans("TipoCatFornecedor")."</option> </select>" ;
       }
       else
       
      {
           echo "<input type=hidden name='tipocat'   id='tipocat' value='".$tipocategoria."'   >" ;
       }
       
       
       print '<tr>';
print '<td>'.$langs->trans("Color").'</td>';
print '<td >';
print $formother->selectColor($obj->cor, 'color');
print '</td></tr>';
}






    function verifica($nome,$campoextra,$rowid)
{
    
   
	global $conf,$langs,$db;
	 
    {
      
				$sql = 'SELECT rowid';
				$sql.= ' FROM '.MAIN_DB_PREFIX .'extrafields where `name`="'.$nome.'" and  `elementtype`="'.$campoextra.'"';
				  
                  
			 	$resql = $db->query($sql);
				if ($resql)
				{
			 	 $obj = $db->fetch_object($resql);
					 
				}
			 
	 }
           
            if($obj->rowid=="")
            {
               
    $sql = "DELETE FROM ".MAIN_DB_PREFIX."categorizeall WHERE rowid='".$rowid."'";
    $resqld = $db->query($sql);
 	 print '<script>setTimeout(function(){ window.location.href="'.$_SERVER["PHP_SELF"].'?id='.urlencode($id).'&rowid='.urlencode($rowid). '&form='.urlencode(GETPOST('form','alpha')).'";}, 1000);</script>';  
 
                }
             
    
 }
 
  
print '<br></form>';

// End of page
llxFooter(); 
$db->close();

 
?>