<?php
/*  Copyright (C) 2019 categorizeall Paulo Ricardo Carvalho de Oliveira	<paulorcdo@gmail.com>
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * \file admin/about.php
 * \ingroup categorizeall
 * \brief Module about page
 */

// Load Dolibarr environment
if (false === (@include '../../main.inc.php')) {  // From htdocs directory
    require '../../../main.inc.php'; // From "custom" directory
}

require_once '../core/modules/modCategorizeAll.class.php';
require_once '../lib/admin.lib.php';

global $db, $langs, $user;

$langs->load("categorizeall@categorizeall");
$langs->load("admin");
$langs->load("help");

// only readable by admin
if (! $user->admin) {
    accessforbidden();
}

$module = new modcategorizeall($db);

/*
 * View
 */

// Little folder on the html page
llxHeader();
/// Navigation in the modules
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">';
$linkback .= $langs->trans("BackToModuleList") . '</a>';
// Folder icon title
print_fiche_titre("CategorizeAll", $linkback, 'setup');

$head = PrepareHead();

dol_fiche_head(
    $head,
    'about',
    $langs->trans("CategorizeAll"),
    0,
    'categorizeall@categorizeall'
);

echo '<img width=280 src="../img/logotipocategorizeall.png" ><h3>', $langs->trans("Module468224Name"), '</h3>',
     '<em>', $langs->trans("Version"), ' ',
 $langs->trans($module->version), '</em><br>',
     '<em>&copy;2019 Paulo OLiveira<br></em>',
 '<a href="mailto:paulorcdo@gmail.com">paulorcdo@gmail.com</a>',
 
     '
 
<h3>FUNCTIONS</h3>
<p>CategorizeAll allows the management of categories in Dolibarr. Create and apply categories (tags) to all items with just a few clicks. For customers and products, you can also categorize quantities and values for budgets, orders, and invoices. Centralizes access to Reports and Category Lists.

<h3>EASY TO CREATE NEW CATEGORIES</h3>

<p>To create categories in Dolibarr, you must register each category and go to each record to link the category. With the CategorizeAll module just a few clicks to create the category and link across all items.

<p>CategorizeAll presents all table fields that have categories (Third Party, Products, Contacts, Financial Accounts, Projects, Users and Members) and allows to use as selection criteria in the search of the items.

<h3>JUST 2 STEPS - SET SELECTION CRITERIA AND CREATE CATEGORY</h3>

<p>The possibilities for creating categories are endless, as the criteria are the fields of the Dolibarr database:
<p>In the text fields it allows searching by word or phrase through the Contain / Not Contain operations;
<p>In the selection and checkbox fields, the system options are available to perform the search through Equal / Different operations;
<p>In the value and date fields, the value and date range fields are available for searching through the Interval / Out of Interval operations;
<p>In the budget, order, and invoice fields, you provide the types (values ​​or quantities), value and quantity range fields, date range fields, and situations (draft, validated, signed, paid, and canceled) to perform the search via of operations In Range / Out of Range / With records in table / No records in table;

<p>* CategorizeAll allows recursive use of categories, ie a new category can use other existing categories as criteria.
<p>Prerequisites
<p>Dolibarr ≥ 5.0.3
  
<p>License
<p>Copyright (C) 2019 Paulo Oliveira - paulorcdo@gmail.com

<p>GPLv3 any later version.
 
';

dol_fiche_end();
llxFooter();
