<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class advance_supplier extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

   public $transaction_date;
  public $amount;
  public $due_date;
  public $check_num ;
  public $payment_id ;
  public $bank_id ;
  public $supplier_id ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

  public $table_element = 'advance_supplier';

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/tresorie/advance_supplier/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        if ($setRef != "") {
        	$result = $link."<div class='icon-empty_folder mainvmenu'></div>  ".$setRef.$linkend;
        }else{
        	$result = "-";
        }
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->transaction_date= $this->transaction_date ? $this->db->escape($this->transaction_date): null;
	  $this->amount = $this->amount ? $this->db->escape($this->amount): null;
	  $this->due_date = $this->due_date ? $this->db->escape($this->due_date): null;
	  $this->payment_id = $this->payment_id ? $this->db->escape($this->payment_id): null;
	  $this->check_num = $this->check_num ? $this->db->escape($this->check_num): null;
	  $this->supplier_id = $this->supplier_id ? $this->db->escape($this->supplier_id): null;
	  $this->bank_id	= $this->bank_id ? $this->db->escape($this->bank_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'advance_supplier' . ' (transaction_date,amount,due_date,check_num,supplier_id,';
	$sql .= 'payment_id,bank_id,created_by,created_at) ';
	$sql .= 'VALUES ("'.$this->transaction_date.'", '.$this->amount.',"'.$this->due_date.'",'. $this->check_num.', '. $this->supplier_id.', ';
	$sql .=	 $this->payment_id.', '.$this->bank_id.', '.$this->created_by.',"'.$this->created_at.'")';
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error advance_supplier ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'advance_supplier';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid ;
			  $this->transaction_date 			= $this->db->jdate($obj->transaction_date); ;
			  $this->amount 			= $obj->amount ;
			  $this->due_date 			= $obj->due_date ;
			  $this->payment_id 			= $obj->payment_id ;
			  $this->check_num 	= $obj->check_num ;
			  $this->supplier_id 	= $obj->supplier_id ;
			  $this->bank_id	= $obj->bank_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'advance_supplier';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->transaction_date 			= $this->db->jdate($obj->transaction_date); ;
				  $line->amount 			= $obj->amount ;
				  $line->due_date 			= $obj->due_date ;
				  $line->payment_id 			= $obj->payment_id ;
				  $line->check_num 	= $obj->check_num ;
				  $line->supplier_id 	= $obj->supplier_id ;
				  $line->bank_id	= $obj->bank_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'advance_supplier' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now  = $now->format('Y-m-d');
			$sql .= '`updated_at` = "'. $now.'"' ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'advance_supplier' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getPayment($id)
    {
    	$sql = 'SELECT libelle FROM ' . MAIN_DB_PREFIX . 'c_paiement WHERE id='.$id;
    	$resql = $this->db->query($sql);
    	//die($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->libelle;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

    public function load_state_board()
	{
		global $conf, $user;

		$this->nb=array();

		$sql = "SELECT count(s.rowid) as nb";
		$sql.= " FROM ".MAIN_DB_PREFIX. $this->table_element ." as s";

		$resql=$this->db->query($sql);
		
		if ($resql) {
			while ($obj=$this->db->fetch_object($resql)) {
				$this->nb["advancesuppliers"]=$obj->nb;
			}
            $this->db->free($resql);
			return 1;
		}
		else {
			dol_print_error($this->db);
			$this->error=$this->db->error();
			return -1;
		}
	}

	public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('advance_supplier');
    	$object->url 	= dol_buildpath('/btp/tresorie/advance_supplier/index.php',1);

    	return $object;
    }

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
    public function load_board()
    {
        global $conf, $user, $langs;

		dol_include_once('/btp/tresorie/invoice_location_expenses/class/invoice_location_expenses.class.php');
		dol_include_once('/btp/tresorie/invoice_reception/class/invoice_reception.class.php');

		$invoiceLocationExpenses = new invoice_location_expenses($this->db);
        $invoiceReception 		 = new invoice_reception($this->db);

        return array($this->getStatData(), $invoiceLocationExpenses->getStatData(), $invoiceReception->getStatData());
    }
}
?>