<?php
/* Copyright (C) 2016 Yassine Belkaid  y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    btp/interim/.class.php
 * \ingroup btp
 * \brief   This file is interim CRUD class file
 *
 */

dol_include_once('/btp/db/nxdb.class.php');

/**
 * Class btp
 *
 * Contract Management class
 */
class InterimBail extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see btp::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'td_interim_bail';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'td_interim_bail';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_createdby;
	public $fk_tender;
	public $amount;
	public $date_bail;
	public $date_withdrawal;
	public $num;
	public $observation;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		  = $db;
		$this->now 		  = new \DateTime("now");
		$this->now 		  = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_tender 	= $this->fk_tender ?: null;
		$this->fk_createdby = $this->fk_createdby ?: null;
		$this->amount		= $this->amount ?: null;
		$this->date_bail	= $this->date_bail ?: null;
		$this->num			= $this->num ?: null;
		$this->observation	= $this->observation ?: null;
		$this->created_at  	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_tender, fk_createdby, amount, date_bail, date_withdrawal,num, observation, created_at, updated_at) VALUES (';
		$sql .= $this->fk_tender.', '.$this->fk_createdby.', '. $this->db->escape($this->amount) .', "'.$this->date_bail.'", "'.$this->date_withdrawal.'", "'. $this->db->escape($this->num) .'", "'. $this->db->escape($this->observation) .'", "'.$this->created_at.'", "'.$this->updated_at .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error interim bail ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id = null, $td_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (null !== $id) {
			$sql .= ' WHERE rowid = ' . $id;
		} else {
			$sql .= ' WHERE fk_tender = '. $td_id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	= $this->db->fetch_object($resql);
				$this->id 		  	= $obj->rowid;
				$this->fk_tender 	= $obj->fk_tender;
				$this->fk_createdby = $obj->fk_createdby;
				$this->amount 	  	= $obj->amount;
				$this->num 		  	= $obj->num;
				$this->observation 	= nl2br($obj->observation);
				$this->date_bail 	  = $this->db->jdate($obj->date_bail);
				$this->date_withdrawal= $this->db->jdate($obj->date_withdrawal);
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($td_id = false, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element . ' WHERE fk_tender ='. (int) $td_id;
		else
			$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;

		if (!empty($filter)) {
			$sql .= substr($filter, 4);
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  	= $obj->rowid;
				$line->fk_tender 	= $obj->fk_tender;
				$line->fk_createdby = $obj->fk_createdby;
				$line->amount 	  	= $obj->amount;
				$line->num 		  	= $obj->num;
				$line->observation 	= nl2br($obj->observation);
				$line->date_bail 	  = $this->db->jdate($obj->date_bail);
				$line->date_withdrawal= $this->db->jdate($obj->date_withdrawal);
				$line->updated_at 	  = $this->db->jdate($obj->updated_at);
				$line->created_at 	  = $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, $td_id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || !$td_id)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $this->db->escape($val) ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id . ' AND fk_tender ='. (int) $td_id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id, $td_id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int)$id .' AND fk_tender ='. (int)$td_id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

    public function statusLevel($statut)
	{
		global $langs;

		switch ($statut) {
			case 1:
				return $langs->trans('Approved').' '.img_picto($langs->trans('Approved'), 'statut6');
				break;
			
			case 0:
				return $langs->trans('NotApproved').' '.img_picto($langs->trans('NotApproved'),'statut5');
				break;
		}
    }

    public function getStatData($tender_id = false)
    {
    	global $langs;
    	$this->fetchAll($tender_id, 'desc', 'rowid', 0, 0, '', ($tender_id ? false : true));
    	$countAmount = 0;

    	foreach ($this->lines as $key => $obj)
    		$countAmount += $obj->amount;

    	$object 		= new stdClass();
    	$object->number = count($this->lines);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('InterimBails');
    	$object->url 	= (int)$tender_id ? dol_buildpath('/btp/tender/interimbail/index.php?td=',1).$tender_id : '';

    	return $object;
    }
}
