<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       tools/index.php
 * \ingroup    list
 * \brief      List of tools
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/settings/type_entrees/class/type_entrees.class.php');
dol_include_once('/core/class/html.form.class.php');

$form 		= new Form($db);
$type_entrees 	  = new type_entrees($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      			= GETPOST('search_ref');
$search_dsg      	= GETPOST('search_dsg');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_dsg      	= "";

}
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_dsg) && $search_dsg != -1) ? " AND designation = '".$db->escape($search_dsg)."'\n" : "";

$gettype_entrees=$type_entrees->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($gettype_entrees) && $action == "xsl" ) {
$filename="liste_types_entres.xls";
      dol_include_once('/btp/settings/type_entrees/tpl/type_entrees_exl.php');
 die();
 
}
if ($id > 0) {
	llxHeader('', $langs->trans('tool'));
    print_fiche_titre($langs->trans('details_type_Entrees'));
	dol_fiche_head('', 'tools', $langs->trans("typeEntrees"), 0, '');

	$type_entrees->fetch($id);
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Reference").'</td>';
	print '<td colspan="2">'. $type_entrees->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Designation").'</td>';
	print '<td colspan="2">'. $type_entrees->designation .'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete') {
	    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeleteT"),$langs->trans("ConfirmDeleteT"),"confirm_delete", '', 0, 1);
    }
}
else {

 // Both test are required to be compatible with all browsers


llxHeader('', $langs->trans('listTypeEntrees'));
print_fiche_titre($langs->trans('listTypeEntrees'));
	$card="card.php";
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('ajoutetype_entrees').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_dsg" value="'. $search_dsg .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Reference"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Designation"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_dsg" value="'.$search_dsg.'">';
	print '</td>';
	
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($type_entrees->rows)) {
			foreach($type_entrees->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$dsg 		        = $line->designation;
				print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $type_entrees->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			// designation
			print '<td align="center">'. $dsg .'</td>';
			print '<td align="center"></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';
	
}	
print '</table>';
	print '</form>';
llxFooter();

$db->close();


?>
