<?php
dol_include_once('/btp/db/nxdb.class.php');

class type_entrees extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */

	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'type_entrees';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'type_entrees';
	public $errors = array();
	public $fk_createdby;
	public $designation;
	public $rows = array();
	public $now;
    public $rowid;

	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create()
	{
		global $conf;
		
 		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->designation	= $this->designation ? $this->db->escape($this->designation): null;
		$this->fk_createdby = $this->fk_createdby ? $this->db->escape($this->fk_createdby): null;
		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . '(entity,designation,created_by,created_at,updated_at) VALUES (';
		$sql .= ''.$conf->entity.',"'.$this->designation.'", '.$this->fk_createdby.',"'.$this->now.'","'.$this->now.'")';
		$this->db->begin();
		$resql = $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			
			return -1;
		} else {
			$this->db->commit();
		return $this->getLasInsrtedId();
		}
	}
public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element;
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 					 = $this->db->fetch_object($resql);
				$this->rowid 				 = $obj->rowid;
				$this->id 				 = $obj->rowid;
				$this->tool_type_id		 = $obj->tool_type_id;
				$this->designation	 = $obj->designation;
				
			}
			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			echo 	$sql;
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->designation;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/settings/type_entrees/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }
	
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE  rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql.=',updated_at="'.$this->now.'"';
		$sql .= ' WHERE  rowid = ' . $id;

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	////////////////////////////////////////////////search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $id = '')
	{
		global $conf;
		
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element;
		$sql .= ' WHERE entity ='.$conf->entity.' ';
		
		if (!empty($filter)) {
		$sql .= $filter;
		}

	if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		$this->rows = array();
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
 
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 		 = $obj->rowid;
				$line->designation 	 = $obj->designation;
				$this->rows[] 		 = $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
public function getNames()
	    {
	    	$this->fetchAll();
	    	$names = array();

	    	if (count($this->rows))
	    	foreach ($this->rows as $key => $line) {
				$names[$line->rowid] = $line->designation;    		
	    	}

	    	return $names;
	    }
    public function getName($id)
    {
    	$sql = 'SELECT designation FROM ' . MAIN_DB_PREFIX . $this->table_element.' WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->designation;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

   public function getNomUrlID($withpicto = 0,  $id = null, $ref = null,$mid=null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->designation;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/market/entrees/index.php?id_type='. $id .'&mid='.$mid,2).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	/**
     * Load indicators for dashboard (this->nbtodo and this->nbtodolate)
     *
     * @param	User	$user   Objet user
     * @return WorkboardResponse|int <0 if KO, WorkboardResponse if OK
     */
   
}
