<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of stakeholders
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/settings/stakeholder_types/class/StakeHolderType.class.php');
dol_include_once('/btp/settings/stakeholders/class/StakeHolder.class.php');

$stakeholder 	  = new StakeHolder($db);
$form= new Form($db);
$var = false;
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      			= GETPOST('search_ref');
$search_user      			= GETPOST('search_user');
$search_nom      	= GETPOST('search_nom');
$search_tel      	= GETPOST('search_tel');
$search_fax      	= GETPOST('search_fax');
$search_type      	= GETPOST('search_type');
$id 	  = GETPOST('id','int');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_nom      	= "";
	$search_tel     		= "";
	$search_fax     		= "";
	$search_user     		= "";
	$search_type     		= "";
}

$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_nom) && $search_nom != -1) ? " AND name = '".$db->escape($search_nom)."'\n" : "";
$filter .= (!empty($search_user) && $search_user != -1) ? " AND fk_user = '".$db->escape($search_user)."'\n" : "";
$filter .= (!empty($search_tel) && $search_tel != -1) ? " AND  tel= '".$db->escape($search_tel)."'\n" : "";
$filter .= (!empty($search_fax) && $search_fax != -1) ? " AND fax = '".$db->escape($search_fax)."'\n" : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND fk_type = ".$db->escape($search_type)."\n" : "";
$getstakeholder=$stakeholder->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getstakeholder) && $action == "xsl" ) {
$filename="liste_types_prenantes.xls";
      dol_include_once('/btp/settings/stakeholders/tpl/stakeholders_exl.php');
 die();
 
}
if ($id > 0 ) {
	llxHeader('', $langs->trans('stakeholder'));
 	print_fiche_titre($langs->trans('detai_pre'));
	dol_fiche_head('', 'stakeholder', $langs->trans("stakeholder"), 0, ''); 

	$stakeholder->fetch($id);
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Reference").'</td>';
	print '<td colspan="2">'. $stakeholder->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Name").'</td>';
	print '<td colspan="2">'. $stakeholder->name.'</td></tr>';
	//utilisateur	
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("User").'</td>';
    $users = new User($db);
    $users->fetch($stakeholder->fk_user);   
	print '<td colspan="2">'; 
	$nom=$users->lastname.'  '.$users->firstname;
	print $users->getNomUrl(1,$stakeholder->fk_user,$nom) .'</td></tr>';
	//Type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Type").'</td>';
	 $type= new StakeHolderType($db);
        $type->fetch($stakeholder->fk_type);
	print '<td colspan="2">'.$type->getNomUrl(1,$stakeholder->fk_user,$type->name)  .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Tel").'</td>';
	print '<td colspan="2">'. $stakeholder->tel .'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Fax").'</td>';
	print '<td colspan="2">'. $stakeholder->fax .'</td></tr>';
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./card.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';

	print '</div>';	
}
else {
llxHeader('', $langs->trans('listprenante'));
	  print_fiche_titre($langs->trans('listprenante'));
	$card="card.php";
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Dpre').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_nom" value="'. $search_nom .'" type="hidden" />';
print '<input name="search_user" value="'. $search_user .'" type="hidden" />';
print '<input name="search_tel" value="'. $search_tel .'" type="hidden" />';
print '<input name="search_fax" value="'. $search_fax .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';   
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Reference"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Name"),$_SERVER["PHP_SELF"],"name", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Utilisateur"),$_SERVER["PHP_SELF"],"fk_user", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Type"), $_SERVER["PHP_SELF"], 'fk_type', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Tele"),$_SERVER["PHP_SELF"], 'tel', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Fax"),$_SERVER["PHP_SELF"], 'fax', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	// name
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_nom" value="'.$search_nom.'">';
	print '</td>';
	// utilisateur
	print '<td class="liste_titre" colspan="1" align="center">'.$form->select_dolusers($search_user,"search_user",1).'</td>';
	// type
	print '<td class="liste_titre" colspan="1" align="center">';
	$type=new StakeHolderType($db);
	$type->fetchAll();
        print '<select name="search_type"      id="nomer"/>';
        print '<option></option>';
        if (count($type->rows)) {
      $select="";
        foreach($type->rows as $line) {
        	if($search_type){
        		if($line->rowid==$search_type){
				$select="selected='selected'";
        		}
        	}
       print '<option  value="'.$line->rowid.'" '.$select.'>'.$line->name.'</option>';
       $select="";
        }
    }
    print '</select>';
	print '</td>';
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_tel" value="'.$search_tel.'">';
	print '</td>';
print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_fax" value="'.$search_fax.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
		print '</td>';
	print "</tr>\n";
	// Lines
	if (count($stakeholder->rows)) {
		foreach($stakeholder->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$name 		        = $line->name;

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $stakeholder->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			print '<td align="center">'. $name .'</td>';
			$fser = new User($db);
			$fser->fetch($line->fk_user);
               $name=$fser->lastname.' '.$fser->firstname;
			print '<td align="center">'.$fser->getNomUrl(1,$line->fk_user,$name).'</td>';
			$tpe= new StakeHolderType($db);
       		 $tpe->fetch($line->fk_type);
			print '<td align="center">'. $type->getNomUrl(1,$line->fk_type, $tpe->name) .'</td>';
	     	print '<td align="center">'. $line->tel .'</td>';
		    print '<td align="center">'. $line->fax .'</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
	print '</table>';
	print '</form>';


}

print '</table>';
	print '</form>';
llxFooter();

$db->close();


?>
