<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       stakeholder/index.php
 *		\ingroup    list
 *		\brief      Gestion des prenantes
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/settings/stakeholders/class/StakeHolder.class.php');
dol_include_once('/btp/settings/stakeholder_types/class/StakeHolderType.class.php');
// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$error 	= false;
if ($action == 'update' && $request_method === 'POST') {
    $stakeholde_id = (int) GETPOST('stakeholder_id', 'int');

    if (!$stakeholde_id || $stakeholde_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $stakeholder = new StakeHolder($db);
    $stakeholder->fetch($stakeholde_id);
        $canedit = true ; 
    // If this is the requestor or has read/write rights
    if ($canedit) {
        $name   = trim(GETPOST('name'));
		// Update
        $data = array(
            'name'             => $name,
            'tel'=>GETPOST('tele'),
            'fax'=>GETPOST('faxe'),
            'fk_type'=>(int)GETPOST('type'),
            'fk_user'=>(int)GETPOST('util'),);
       $vider="";
       $vider.=(GETPOST('util')!=-1)?"":"erreur";
       $vider.=(GETPOST('type')!=0)?"":"erreur";
       $vider.=(!empty(GETPOST('tele')))?"":"erreur";
       $vider.=(!empty(GETPOST('faxe')))?"":"erreur";
        $vider.=(!empty(GETPOST('name')))?"":"erreur";
         if($vider==""){
            $getMarcheID = $stakeholder->update($stakeholde_id, $data);
  
        }else
        {
            $getMarcheID=-1;
        }
       
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$stakeholde_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $stakeholde_id .'&action=edit&error=SQL_Create&msg='.$stakeholder->error);
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$stakeholder  = new StakeHolder($db);
	 $canedit = true;
	if ($canedit) {
        $stakeholder->fetch($id);
		$stakeholder->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
	header('Location: index.php');
		exit;
	}
	else {
        header('Location: index.php?leftmenu=stakeholders');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$stakeholder     = new StakeHolder($db);
if ($action == 'create' && $request_method === 'POST') {
    $stakeholder = new StakeHolder($db);
    $name     = trim(GETPOST('name'));
    $tel         =trim(GETPOST('tel'));
    $fax        =trim(GETPOST('fax'));
    $type        =(int) GETPOST('type');

        // Vars
        $stakeholder->name      =$name;
        $stakeholder->fk_user   =(int) trim(GETPOST('util'));
        $stakeholder->tel       = $tel;
        $stakeholder->fk_type   = $type;
        $stakeholder->fax       = $fax;
        $vid="";
        $vid.=($stakeholder->fk_user!=-1)?"":"erreur";
        $vid.=($stakeholder->fk_type!=0)?"":"erreur";
        $vid.=(!empty($stakeholder->fax))?"":"erreur";
        $vid.=(!empty($stakeholder->tel))?"":"erreur";
        $vid.=(!empty($stakeholder->name))?"":"erreur";
            if($vid==""){
           $getMarcheID = $stakeholder->create();
        }else {
            $getMarcheID=-1;
        }
 if ($getMarcheID > 0) {
        header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
      exit(); 
        }
}
llxHeader(array(), $langs->trans('listevents'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire 
        print_fiche_titre($langs->trans('Createpre'));
        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // Name
        print '<tr><td class="fieldrequired">'.$langs->trans("Name").'</td><td class="fieldrequired">';
        print '<input type=text name="name" required="required">';  print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("User").'</td><td class="fieldrequired">';
        print $form->select_dolusers('',"util",1);

        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td class="fieldrequired">';
        $type= new StakeHolderType($db);
        $type->fetchAll();
        print '<select name="type" required="required"     id="nomer"/>';
        print '<option></option>';
        if (count($type->rows)) {
        foreach($type->rows as $line) {
       print '<option  value="'.$line->rowid.'">'.$line->name.'</option>';
        }
    }
   print '</select>';  print '</td></tr>';
          print '<tr><td class="fieldrequired">'.$langs->trans("Tel").'</td><td class="fieldrequired">';
        print '<input type="text" name="tel" required="required">';  print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Fax").'</td><td class="fieldrequired">';
        print '<input type="text" name="fax" required="required">';  print '</td></tr>';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createpre") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('detai_pre'));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage
        if ($id > 0) {
            $stakeholder->fetch($id);
			 // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

                if ($action == 'delete') {
                       print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletepre"),$langs->trans("ConfirmDeletepre"),"confirm_delete", '', 1, 1);
                           print_fiche_titre($langs->trans('detai_pre'));

print '<table class="border" width="100%">';
    // Ref
print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
print '<td colspan="2">'. $stakeholder->rowid .'</td></tr>';
    //Nom
print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Name").'</td>';
print '<td colspan="2">'. $stakeholder->name .'</td></tr>';
print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("User").'</td>';
$users = new User($db);
$users->fetch($stakeholder->fk_user);
$nom=$users->lastname.'  '.$users->firstname;
print '<td colspan="2">'; 
print   $users->getNomUrl(1,$stakeholder->fk_user,$nom).'</td></tr>';
    // type
print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Type").'</td>';
     $type= new StakeHolderType($db);
        $type->fetch($stakeholder->fk_type);
       
    print '<td colspan="2">'. $type->getNomUrl(1,$stakeholder->fk_type, $type->name).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Tel").'</td>';
    print '<td colspan="2">'. $stakeholder->tel .'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Fax").'</td>';
    print '<td colspan="2">'. $stakeholder->fax.'</td></tr>';

    print '</table>';

    print '<br>';
                }

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }
                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];

                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="stakeholder_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    // Name
                    print '<tr><td class="fieldrequired">'.$langs->trans("Nom").'</td><td>';
                  
                   
         print '<input name="name"  type=text  required="required" value="'.$stakeholder->name.'"></td></tr>';
                 
                   print '<tr><td class="fieldrequired">'.$langs->trans("Utilisateur").'</td><td>';
              
             print $form->select_dolusers($stakeholder->fk_user,"util",1);
             print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>'; 
        $type= new StakeHolderType($db);
        $type->fetchAll();
        print '<select name="type" required="required"     id="nomer"/>';
        print '<option></option>';
        if (count($type->rows)) {
      $sel="";
        foreach($type->rows as $line) {
            if($line->rowid==$stakeholder->fk_type){
                $sel="selected='selected'";
            }
       print '<option  value="'.$line->rowid.'" '. $sel.'>'.$line->name.'</option>';
      $sel="";
        }
    }
   print '</select></td></tr>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("Tel").'</td><td>';
                  
                   
         print '<input name="tele" required="required"  type="text" value="'.$stakeholder->tel.'"></td></tr>';
                    print '<tr><td class="fieldrequired">'.$langs->trans("Fax").'</td><td>';
                  
                   
         print '<input name="faxe" required="required" type="text" value="'.$stakeholder->fax.'"></td></tr>';
                print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';

                    // If draft
            	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}
//////////////////////////////////////confirmation de suppression
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
    $error=0;
    $stakeholder  = new StakeHolder($db);
    $canedit = true;
    if ($canedit) {
        $stakeholder->fetch($id);
        $stakeholder->delete();
    }
    else {
        $error = $langs->trans('ErrorCantDelete');
    }

    if (!$error) {
         header('Location: index.php');
        exit;
    }
    else {
        
        header('Location: index.php?leftmenu=pointage');
        exit;
    }
}













// End of page
llxFooter();llxFooter();

$db->close();


?>