<?php
/* Copyright (C) 2005		Rodolphe Quiedeville 	<rodolphe@quiedeville.org>
 * Copyright (C) 2004-2013	Laurent Destailleur  	<eldy@users.sourceforge.net>
 * Copyright (C) 2005-2010	Regis Houssin        	<regis.houssin@capnetworks.com>
 * Copyright (C) 2010     	François Legastelois 	<flegastelois@teclib.com>
 * Copyright (C) 2014-2015	charlie BENKE			<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file       /rh/pointage/listtime.php
 *	\ingroup    pointage
 *	\brief      List  
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
require_once DOL_DOCUMENT_ROOT.'/projet/class/task.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/project.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
dol_include_once('/btp/rh/pointage/class/pointage.class.php');
dol_include_once('/btp/nc_under_modules/management/core/lib/management.lib.php');

// load css theme.css ici 
$langs->load('btp@btp');

$langs->load('management@management');
$action=GETPOST('action');
$mode=GETPOST("mode");
$id=GETPOST('id','int');

$periodyear=GETPOST('periodyear','int');
if (!$periodyear)
	$periodyear=date('Y');
$periodproject=GETPOST('periodproject','int');
$periodmonth=GETPOST('periodmonth','int');
if (!$periodmonth)
	$periodmonth=date('m');

$perioduser=GETPOST('perioduser','int');
if (!$perioduser)
	$perioduser=$user->id;
	
// récupération du nombre de jour dans le mois
$time = mktime(0, 0, 0, $periodmonth+1, 1, $periodyear); // premier jour du mois suivant
$time--; // Recule d'une seconde
$nbdaymonth=date('d', $time); // on récupère le dernier jour

$projectid='';
$projectid=isset($_GET["id"])?$_GET["id"]:$_POST["projectid"];

// Security check
$socid=0;
if ($user->societe_id > 0) $socid=$user->societe_id;
// $result = restrictedArea($user, 'projet', $projectid);

if (! $user->rights->projet->lire) { 
	$message = "Accès refusé.<br>";
	$message .= "Vous n'avez pas la permission de gérer les projets";
	accessforbidden($message,1,1,1); 
}

$form=new Form($db);
$formother = new FormOther($db);
$pointage= new pointage($db);
$user_array=new User($db);
$project = new Project($db);


/*
 * Actions
 */

if ($action == 'addtime')
{
	// on boucle sur les lignes de taches 
	$result=setsheetLines($j, 0, $user_array, $level, $projectsrole, $tasksrole, $perioduser);
	if($result)
	setEventMessage($langs->trans("RecordSaved"));
	
	$action ="";
	// Redirect to avoid submit twice on back
	//header('Location: '.$_SERVER["PHP_SELF"].'?id='.$projectid.($mode?'&mode='.$mode:''));
	//exit;
}

/*
 * View
 */


$title=$langs->trans("TimeSpentPeriod");

llxHeader("",$title,"");
// print_barre_liste($title, $page, $_SERVER["PHP_SELF"], "", $sortfield, $sortorder, "", $num,"","object");
print_fiche_titre($langs->trans("TimeSpentPeriod"));
dol_htmloutput_mesg($mesg);
// 

print '<form name="selectperiod" method="POST" action="'.$_SERVER["PHP_SELF"].'?id='.$project->id.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="selectperiod">';

print '<table  width="100%">';
print '<tr >';
print '<td>'.$langs->trans("PeriodAAAAMM").'</td>';
print '<td>'.$formother->selectyear($periodyear,'periodyear').$formother->select_month($periodmonth,'periodmonth').'</td>';
print '<td><div id="lblBlurWeekEnd">'.$langs->trans("ShowHideWeekend").'</div></td>';
print "</tr>\n";
print '<tr >';
print '<td>'.$langs->trans("UserToDisplay").'</td>';
$showempty=0;
// attention le dernier paramétre n'est dispo que sur la 3.7 et le patch fournis
print '<td>';
print $form->select_users($perioduser,"perioduser",0);
print '</td>';
print '<td>';
print $langs->trans("Projet")."     <select name='periodproject' >";
if($periodproject ==0)
print '<option value="0" ></option>';
else
print '<option value="0" selected></option>';
  foreach ($project->liste_array() as $key => $line) {
  	     if($key==$periodproject){
  		print '<option value="'.$key.'" selected>'.$line.'</option>';
  	}else{

		print '<option value="'.$key.'">'.$line.'</option>';
  }	
  }
print '</td>';
print '<td ><input id="select_search" type=submit name="select" value="'.$langs->trans("Select").'" class="button"></td>';
print "</tr>\n";
print "</table>";
print '</form>';
print '<br>';

print '<form name="addtime" method="GET" action="'.$_SERVER["PHP_SELF"].'?id='.$project->id.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="addtime">';
print '<input type="hidden" name="mode" value="'.$mode.'">';

print '<input type="hidden" name="periodyear" value="'.$periodyear.'">';
print '<input type="hidden" name="periodmonth" value="'.$periodmonth.'">';
print '<input type="hidden" name="perioduser" value="'.$perioduser.'">';
print '<input type="hidden" name="periodproject" value="'.$periodproject.'">';

print '<div style="overflow: auto; width: 100%;" class="table_temps">';
print '<table class="noborder" width="100%" >';
print '<tr class="liste_titre nc_filtrage_tr">';
print '<td>'.$langs->trans("Noms").'</td>';
print '<td align="center">'.$langs->trans("Qualification").'</td>';

print '<td colspan="32" align="center">'.$langs->trans("TimeSpent").'&nbsp;<input type=submit name=save></td>';


print "</tr>\n";
timesheetLines($j, 0, $user_array, $level, $projectsrole, $tasksrole, $mine, $perioduser);

print "</table>";
print '</div>';
print '</form>';
print '<div style="float: right; margin-top: 8px;">';
print '<a href="./addpointage.php?periodmonths=0" class="butAction">'.$langs->trans('consulte').'</a>';
		print '</div>';
// pour activer ou non le week-end
?>
<script language="javascript">
$(document).ready(function() {
	$(".weekendtohide").toggle();
	$("#lblBlurWeekEnd").click(function() {
		$(".weekendtohide").toggle();
		$(".weekendtoshow").toggle();
	});
	$('select[name="periodproject"]').select2();
});
</script>
<script language="javascript">
$(window).on('load',function(){
var side = ($("#id-container .side-nav").width() + 3);
var all = $("#id-container").width();
console.log(all-side);
$("#id-right").css({
    width : (all-side)+'px',
    opacity: 1
});
});
</script>
<style type="text/css">
	.table_temps td input[type=text]{
		padding: 4px 0px;
	}
	td.user_list, td.user_job {
	    background: #f1f1f1;
	}
	td.titre_td, td.empty_td_list {
	    background: #f9f9f9;
	}
	body div.table_temps>table.noborder{
		font-size: 11px !important;
	}
	.table_temps td:not(.titre_td){white-space: nowrap;}
	.table_temps button[disabled], html input[disabled]{text-align: center;}
	table tr td input{text-align: center;}
	#id-container .side-nav {
	    float: left !important;
	}
	#id-container {
	    display: block !important;
	}
	#id-right {
	    display: block !important;
	    opacity : 0;
	    float: left !important;
	}
</style>
<?php
llxFooter();

$db->close();


/**
 * Output a task line
 *
 * @param	string	   	&$inc			?
 * @param   string		$parent			?
 * @param   Object		$lines			?
 * @param   int			&$level			?
 * @param   string		&$projectsrole	?
 * @param   string		&$tasksrole		?
 * @param   int			$mytask			0 or 1 to enable only if task is a task i am affected to
 * @return  $inc
 */
function timesheetLines(&$inc, $lines, &$level, &$projectsrole, &$tasksrole, $mytask=0, $perioduser='')
{
	global $user, $bc, $langs;
	global $form, $formother, $pointage, $taskstatic;
	global $periodyear, $periodmonth, $nbdaymonth,$pointage,$perioduser,$periodproject ;
     global $lines, $project;
     global $numlines,$user_array;
    $user_array->fetch($perioduser);
    $project->fetch($periodproject);
	$lastprojectid=0;
	$var=true;
	$array=['','J','HS','AV'];
    
    $numlines=count($array);
    
	for ($i = 0 ; $i <$numlines ; $i++)
	{      
	   
	               if(empty($array[$i])){
	            print '<td align="left" width="125px" class="user_list">'.$user_array->getNomUrl($perioduser).'<p style="margin-left:30px;margin: 0;"></p>
	               </td><td align="center" class="user_job">'.$user_array->job.'</td><td>'.$array[$i].'</td>';
	                }else{
	                	    if($array[$i]=='HS'){
	                	print '<tr>
						<td colspan="2" class="titre_td">';
						print $langs->trans("Projet")."   <select name='periodprojectselected' class='maxwidth200' >";
						if($periodproject ==0)
						print '<option value="0" selected ></option>';
						else
						print '<option value="0" ></option>';
						  foreach ($project->liste_array() as $key => $line) {
						  	     if($key==$periodproject){
						  		print '<option value="'.$key.'" selected>'.$line.'</option>';
						  	}else{

								print '<option value="'.$key.'">'.$line.'</option>';
						  }	
						  }
						  /*.$project->title.*/print'</td></td><td>'.$array[$i].'</td>';}
					else{

	    print '<tr>
						<td colspan="2" class="empty_td_list"></td><td>'.$array[$i].'</td>';
	                }
}
	    for ($day=1;$day <= $nbdaymonth ;$day++)
				{ 


					$curday=mktime(0, 0, 0, $periodmonth, $day, $periodyear);
					$bgcolor="";
					if (date('N', $curday) == 6 || date('N', $curday) == 7)
					{
						print '<td width=1px class=weekendtoshow bgcolor=grey ></td>';
						$bgcolor=" class=weekendtohide bgcolor=grey ";}
					if(empty($array[$i])){
				
					print '<td '.$bgcolor.' align=center>';
					print substr($langs->trans(date('l', $curday)),0,1)." ".$day.'</td>';}
					else{

				print '<td '.$bgcolor.' align=center >';
				// le nom du champs c'est à la fois le jour et l'id de l'utilisateur
				print '<input  type=text id="inputday" name="'.$array[$i].'-'.$day.'-'.$perioduser.'"';

				$val=$pointage->getVal($periodmonth,$periodyear,$perioduser,$array[$i],$day,$periodproject);
				print ' value="'.$val.'"';
				
				print ' size=2 style="font-size:0.9em !important">';
				print '</td>';

					}

   }


PRINT'</tr>';



}

			print "</tr>\n";
			

	return $inc;
}
            
/**
 * Output a task line
 *
 * @param	string	   	&$inc			?
 * @param   string		$parent			?
 * @param   Object		$lines			?
 * @param   int			&$level			?
 * @param   string		&$projectsrole	?
 * @param   string		&$tasksrole		?
 * @param   int			$mytask			0 or 1 to enable only if task is a task i am affected to
 * @return  $inc
 */
function setsheetLines(&$inc, $parent, $lines, &$level, &$projectsrole, &$tasksrole, $perioduser)
{
	global $db, $bc, $langs, $user;
	global $form, $projectstatic, $taskstatic,$pointage;
	global $periodyear, $periodmonth, $nbdaymonth,$periodproject;
/*echo '<pre>';
print_r($lines); die();
echo '</pre>';*/
	$lastprojectid=0;
	$var=true;
    $ar=['J','HS','AV'];
	$numline=count($ar);
	$fk_project = GETPOST('periodprojectselected','int');
	$test = $pointage->getProjetId($periodmonth,$periodyear,$perioduser,$fk_project);
	if($test && $fk_project!=$periodproject){
		setEventMessage($langs->trans("projetExict"), 'errors');
	return 0;
	}
	$sqltoinsert = "";
	$arrtoinsert = 0;
	$sqli = "INSERT INTO `".MAIN_DB_PREFIX."btp_pointage` (`fk_user`, `type`, `val`, `jour`, `month_point`, `year_point`, `created_by`, `fk_project`, `created_at`, `updated_at`) VALUES ";
	for ($i = 0 ; $i < $numline ; $i++)
	{

			for ($day=1;$day <= $nbdaymonth;$day++)
			{
				$durationsuppr 	= 0;
				$curday 	 	= mktime(0, 0, 0, $periodmonth, $day, $periodyear);
				// dans le doute on supprime les enregs si ils existent
				// on supprime les lignes du mois
			     $getPointageId = $pointage->getID($periodmonth,$periodyear,$perioduser,$ar[$i],$day,$periodproject);
			    
		        $valeur=GETPOST($ar[$i].'-'.$day.'-'.$perioduser);
				      if($getPointageId)
				      {
				      	$data = array(
                        'val'=>$valeur,
                        'fk_project'=>$fk_project);
                         $pointage->update($getPointageId, $data);
				      }else{
			      	      	if($valeur){
			      	      		if($arrtoinsert > 100){
			      	      			$sqltoinsert = trim($sqltoinsert,",");
			      	      			$sql8 = $sqli.$sqltoinsert;
			      	      			// echo $sql8."<br>";
									$resql = $db->query($sql8);
									if (!$resql) {
										$errors[] = 'Error : ' . $db->lasterror();
										print_r($errors);
										die();
									}
			      	      			$sqltoinsert = "";
	                            }
	                            else{
	                                $sqltoinsert .= "('".$perioduser."', '".$ar[$i]."', '".$valeur."', '".$day."', '".$periodmonth."', '".$periodyear."', '".$user->id."', '".$fk_project."', '".date('Y-m-d')."', '".date('Y-m-d')."'),";
	                                $arrtoinsert++;
	                            }

								// $pointage->year_point=$periodyear;
								// $pointage->created_by=$user->id;
								// $pointage->month_point=$periodmonth;
								// $pointage->fk_user=$perioduser;
								// $pointage->jour=$day;
								// $pointage->val=$valeur;
								// $pointage->type=$ar[$i];
								// $pointage->fk_project=$fk_project;

								// $getpoinID = $pointage->create();
					        }
				        }
                           
           }
          
				
	}

	if(!empty($sqltoinsert)){
		$sqltoinsert = trim($sqltoinsert,",");
        $sql8 = $sqli.$sqltoinsert;
        // echo $sql8."<br>";
		$resql = $db->query($sql8);
		if (!$resql) {
			$errors[] = 'Error : ' . $db->lasterror();
			print_r($errors);
			die();
		}
    }

 	$periodproject = $fk_project;
			
		
	
	return 1;
}
?>

