<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       integration/index.php
 * \ingroup    list
 * \brief      List of integrations
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/rh/integration/class/integration.class.php');
dol_include_once('/btp/lib/tools.lib.php');


$integration 	  = new Integration($db);
$var = false;
$form= new Form($db);
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      			= GETPOST('search_ref');
$search_coefficient      	= GETPOST('search_coefficient');

$id 	  = GETPOST('id','int');
if (GETPOST('search_datec')) {
     $search_datec  = Tools::convertDateTo(GETPOST('search_datec'), 'sql');}
  if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      			= "";
	$search_coefficient  	= "";
	$search_datec    		= "";
}
$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_coefficient) && $search_coefficient!= -1) ? " AND  coefficient= '".$db->escape((float)$search_coefficient)."'\n" : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '".$db->escape($search_datec)."'\n" : "";
$getresults=$integration->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getresults)  && $action == "xsl" ) {
$filename="integration.xls";
    dol_include_once('/btp/rh/integration/tpl/integration_xsl.php');
 die();
 
}
$morecss = array();
$morejs  = array("/btp/js/btp.js");

if ($id > 0) {
	llxHeader(array(), $langs->trans('ListOfinteg'),'','','','',$morejs,$morecss,0,0);

	print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

	print_fiche_titre($langs->trans('detai_integ'));
	dol_fiche_head('', 'ListOfinteg', $langs->trans("ListOfinteg"), 0, '');

	$integration->fetch($id);
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Reference").'</td>';
	print '<td colspan="2">'. $integration->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Coefficient").'</td>';
	// coefficient
	print '<td colspan="2">'.$integration->coefficient.'</td></tr>';   
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'.dol_print_date($integration->datec,'day').'</td></tr>';   	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./card.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';

	print '</div>';	
}
else {
	llxHeader(array(), $langs->trans('ListOfinteg'),'','','','',$morejs,$morecss,0,0);
	
	print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

	print_fiche_titre($langs->trans('ListOfinteg'));

	$card="card.php";
print '<div style="float: right; margin-bottom: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('add_integration').'</a>';
		print '</div>';
		print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_coefficient" value="'. $search_coefficient .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	;
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Reference"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Coefficient"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Date"),$_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder);
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';

print '<td class="liste_titre" align="left" width="50">';    

print '<input class="flat" type="number" min="0" size="14" name="search_coefficient" value="'.$search_coefficient.'">';

print '</td>';
 
 
print '<td class="liste_titre" colspan="1" align="center">';
	print '<input type="text" class="datepicker" autocomplete="off"  name="search_datec" id="sdate" value="'.dol_print_date($search_datec,'day') .'" "  />';
	print '</td>'; 
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($integration->rows)) {
		//$createdBy = new User($db);
		foreach($integration->rows as $line) {
			$var = !$var;
			$rowid 				= $line->rowid;
			$datec=				$line->datec;
			$coefficient= 		$line->coefficient;
			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $integration->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			print '<td align="center">'.$coefficient.'</td>';
		    print '<td align="center">'.dol_print_date($datec,'day').'</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
	print '</table>';
	print '</form>';
	
		


}	
print '</table>';
print '</form>';

llxFooter();

$db->close();


?>