<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des integrations
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/rh/integration/class/integration.class.php');
dol_include_once('/btp/lib/tools.lib.php');


// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

$langs->load('btp');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();
$now 	= new DateTime('now');
$error 	= false;
$form=new Form($db);
if ($action == 'update' && $request_method === 'POST') {
    $integration_id = (int) GETPOST('integration_id', 'int');

    if (!$integration_id || $integration_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }
    $integration = new Integration($db);
    $integration->fetch($integration_id);
    $canedit = true ; 
    // If this is the requestor or has read/write rights 
    if ($canedit) {
         $datep=trim(GETPOST('datead'));
        // Update
        
        $date_in = Tools::convertDateTo($datep, 'sql');
        $cof=trim(GETPOST('coefficient'));
		// Update
	      if (!$date_in || !$cof || !$integration_id){
    header('Location: ./card.php?id='. $integration_id .'&action=edit&error=SQL_Create&msg=Veuillez renseigner tous les champs');
        exit();
          }   
        $data = array(
          'coefficient'=>$cof,
          'datec'=>$date_in,);
        $getMarcheID = $integration->update($integration_id, $data);
        if ($getMarcheID > 0) {
        header('Location: ./index.php?id='.$integration_id);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
            header('Location: ./card.php?id='. $integration_id .'&action=edit&error=SQL_Create&msg=Veuillez renseigner tous les champs');
            exit;
        }
    }
}
// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;
	$integration  = new Integration($db);
	 $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $integration->fetch($id);
		$integration->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}
	if (!$error) {
		header('Location: index.php');
		exit;
	}
	else {
        header('Location: index.php?leftmenu=integration');
        exit;
	}
}

/*
 * View
 */

$form           = new Form($db);
$integration     = new Integration($db);
$morecss = array();
$morejs  = array("/btp/js/btp.js");
//insertion 
if ($action == 'create' && $request_method === 'GET') {


    $coff=(float) GETPOST("coefficient");
    $integration = new Integration($db);
    $datep=GETPOST("ad_date");
    $integration->fk_createdby  = $user->id;
    $integration->coefficient   =$coff; 
    $integration->datec         =Tools::convertDateTo($datep, 'sql');

     if (!$datep || !$coff){
     header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
      exit;}  // Vars
  $getMarcheID = $integration->create();
   if ($getMarcheID > 0) {
        header('Location: index.php?id='.$getMarcheID);
            exit;
        } else {
            // Otherwise we display the request form with the SQL error message
  header('Location: card.php?action=request&error=SQL_Create&msg="Veuillez renseigner tous les champs"');
     exit(); 
        }
}
llxHeader(array(), $langs->trans('ListOfinteg'),'','','','',$morejs,$morecss,0,0);
if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
        // Formulaire
        print_fiche_titre($langs->trans('add_integration'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="GET" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        // coefficient
        print '<tr><td class="fieldrequired">'.$langs->trans("Coefficient").'</td><td class="fieldrequired">';
             print '<input type="number" min="0" name="coefficient"   required="required">';
        
        print '</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Date").'</td><td class="fieldrequired">';
         print '<input type="text" class="datepicker" autocomplete="off"  id="datel" name="ad_date" value="" href="javascript:;" required="required">';
        print '</td></tr>';
        print '</tbody>';
        print '</table>';
        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("add_integration") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
}
else {
    print_fiche_titre($langs->trans('detai_integ'));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage 
        if ($id > 0) {
            $integration->fetch($id);
            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }
            // On vérifie si l'utilisateur à le droit de lire cette demande
                if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDeletesup"),$langs->trans("ConfirmDeletesup"),"confirm_delete", '', 0, 1);
                        print_fiche_titre($langs->trans('detai_integ'));
                
                        print '<table class="border" width="100%">';
                // Ref
                print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Refe").'</td>';
                print '<td colspan="2">'. $integration->rowid .'</td></tr>';
                  //Nom
                print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Coefficient").'</td>';
                // coefficient
                print '<td colspan="2">'.$integration->coefficient.'</td></tr>';   
                 print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td>';
                print '<td colspan="2">'.dol_print_date($integration->datec,'day').'</td></tr>';   
                 print '</table>';
                }
                  // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                if ($action == 'edit') {
                    $edit = true;
                    $id=$_GET['id'];
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" id="h" name="integration_id" value='.$id.' />'."\n";
                    print '<table class="border" width="100%">';
                    print '<tbody>';
                    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("coefficient").'</td><td>';
                    print '<input name="coefficient"  type="number" min="0" value="'.$integration->coefficient.'" required="required"></td></tr>';
                    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td><td>';
                    print '<input type="text" class="datepicker" autocomplete="off"  name="datead" id="sdate" value="'.dol_print_date($integration->datec,'day') .'" name="sdate" required="required" />';
                    print '</tbody>';
                    print '</table>';                 
                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';
                    // Boutons d'actions
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    // If draft
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }
    }

}

// End of page
llxFooter();llxFooter();
$db->close();

?>