<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/rh/advance_user/class/AdvanceUser.class.php');
dol_include_once('/btp/lib/tools.lib.php');

$advance_user 	  = new AdvanceUser($db);
$var = false;
$form= new Form($db);
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$action  = GETPOST('action', 'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "";
$search_ref      	= GETPOST('search_ref');
$search_advancefor  = GETPOST('search_advancefor');
$search_advanceby   = GETPOST('search_advanceby');
$id 	  = GETPOST('id','int');
if (GETPOST('search_datec')) {
    $search_datec  = Tools::convertDateTo(GETPOST('search_datec'), 'sql');
}
$search_amount     = GETPOST('search_amount');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref      		= "";
	$search_advanceby    	= "";
	$search_advancefor      = "";
	$search_datec    		= "";
	$search_amount     		= "";

}

$filter='';
$filter .= (!empty($search_ref) && $search_ref != -1) ? " and  rowid = ". $db->escape((int)$search_ref) ."\n" : "";
$filter .= (!empty($search_advancefor) && $search_advancefor!= -1) ? " AND  advancefor_id= ".$db->escape((int)$search_advancefor)."\n" : "";
$filter .= (!empty($search_advanceby) && $search_advanceby != -1) ? " and  advanceby_id = ". $db->escape((int)$search_advanceby) ."\n" : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '".$db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_amount) && $search_amount != -1) ? " and  amount = '". $db->escape((float)$search_amount) ."'\n" : "";
$getresults=$advance_user->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter, $id);
if (!empty($getresults)  && $action == "xsl" ) {
$filename="Liste_avances_utilisateurs.xls";
      dol_include_once('/btp/rh/advance_user/tpl/advanceuser_xsl.php');
 die();
 
}
$morecss = array();
$morejs  = array("/btp/js/btp.js");
llxHeader(array(), $langs->trans('ListeofAdvanceuser'),'','','','',$morejs,$morecss,0,0);

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

if ($id > 0) {
dol_fiche_head('', 'ListeofAdvanceuser', $langs->trans("ListeofAdvanceuser"), 0, '');
	$advance_user->fetch($id);
	print_fiche_titre($langs->trans('det_adv_user'));
	
	print '<table class="border" width="100%">';
	// Ref
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Reference").'</td>';
	print '<td colspan="2">'. $advance_user->rowid .'</td></tr>';
	//Nom
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("advance_for").'</td>';
	$use_u   = new User($db);
    $use_u->fetch($advance_user->advancefor_id);     
     $nom=$use_u->lastname.'  '.$use_u->firstname;
	print '<td colspan="2">'.$use_u->getNomUrl(1,$advance_user->advancefor_id,$nom).'</td></tr>';
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("made_by").'</td>';
		  $user_ad   = new User($db);
          $user_ad ->fetch($advance_user->advanceby_id);     
          $nom=$user_ad->lastname;
          $nom.='   '.$user_ad->firstname;
        print '<td colspan="2">'.$user_ad->getNomUrl(1,$advance_user->advanceby_id,$nom).'</td></tr>';
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'.dol_print_date($advance_user->datec,'day').'</td></tr>';   
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Amount").'</td>';
	print '<td colspan="2">'.$advance_user->amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';     
  
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '<a href="./card.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';

	print '</div>';
}
else {
	print_fiche_titre($langs->trans('ListeofAdvanceuser'));
     
	$card="card.php";
	print '<div style="float: right; margin-bottom: 6px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('dAdvance').'</a>';
		print '</div>';
		print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_ref" value="'. $search_ref .'" type="hidden" />';
print '<input name="search_advancefor" value="'. $search_advancefor .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_advanceby" value="'. $search_advanceby .'" type="hidden" />';
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
print '<input name="search_amount" value="'. $search_amount .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	;
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Reference"),$_SERVER["PHP_SELF"], "rowid", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("advance_for"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("made_by"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Date"),$_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amount"), $_SERVER["PHP_SELF"], '', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder);
	print "</tr>\n";
	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'">';
	print '</td>';
	print '<td class="liste_titre" align="left" width="50">';    
    print $form->select_users($search_advancefor,"search_advancefor",1);
	print '</td>';	
	// Fournisseur
	print '<td class="liste_titre" align="left" width="50">';   
 	print $form->select_users($search_advanceby,"search_advanceby",1);
	print '</td>';
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input type="text" class="datepicker" autocomplete="off"  name="search_datec" id="sdate" value="'.dol_print_date($search_datec,'day') .'" "  />';
	print '</td>'; 
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" step="0.01" min="0" size="14" name="search_amount" value="'.$search_amount.'">';
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";
	// Lines
	if (count($advance_user->rows)) {
		//$createdBy = new User($db);
		foreach($advance_user->rows as $line) {
			$var = !$var;
			$rowid 	 = $line->rowid;
			$sales   = $line->fk_sale;
			$prd     =$line->fk_product;
			$datec   =	$line->datec;
			$amount  = $line->amount;

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="125px">';
				print $advance_user->getNomUrl(1,  $line->rowid, $rowid);
			print '</td>';
			$user_u   = new User($db);
      		$user_u->fetch($line->advancefor_id);  
     		$name= $user_u->lastname.' '.$user_u->firstname;  
			print '<td align="center">'.$user_u->getNomUrl(1,$line->advancefor_id,$name).'</td>';
			$users  = new User($db);
       		$users->fetch($line->advanceby_id);
       		$nom= $users->lastname.' '.$users->firstname;     
			print '<td align="center">'.$users->getNomUrl(1,$line->advanceby_id,$nom) .'</td>';
			print '<td align="center">'.dol_print_date($datec,'day').'</td>';
			print '<td align="center">'.$amount.' '.$langs->getCurrencySymbol($conf->currency).'</td>';
			print '<td><div style="float: right; margin-top: 8px;">';
			print '</div></td>';
			print '</tr>'."\n";
		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}
	print '</table>';
	print '</form>';

		
}
print '</table>';
	print '</form>';































llxFooter();

$db->close();


?>