<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/po_documentmanagement/index.php
 * \ingroup    po_documentmanagement
 * \brief      List of po_documentmanagement
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/btp/nc_under_modules/marches/po_documentmanagement/class/po_documentmanagement.class.php');
dol_include_once('/btp/nc_under_modules/marches/purchaseorder/class/purchaseorder.class.php');
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$poid 	 = GETPOST('poid', 'int');
$id 	 = GETPOST('id', 'int');
$type 	 = GETPOST('type', 'int');
$type 	 = $type ?: '';
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$poid && $request_method !== 'POST')
	die('ID bon de commande n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new PODocumentManagement($db);
$purchaseorder = new PurchaseOrder($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    $doc_date = trim($_POST['doc_date']);
	    $type_id  = trim($_POST['type_id']);
	    $poid 	  = trim(GETPOST('poid', 'int'));
    	$ref	  = trim($_POST['ref']);
    	$observes = trim($_POST['observes']);

	    if (!$poid || !$doc_date || $type_id == -1 || !$ref) {	
			header('Location: ./card.php?action=add&poid='.$poid);
		    die();
	    }

    	if (isset($doc_date) && !empty($doc_date)) {
	        list($etd, $etm, $ety) = explode("/", $doc_date);
	        $doc_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $object->fk_created_by 	= $user->id;
	    $object->fk_po  		= $poid;
	    $object->ref 			= $ref;
	    $object->doc_date 		= $doc_date;
	    $object->type_id 		= $type_id;
	    $object->observes 		= $observes;

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./list.php?id='. $getId .'&poid='.$poid.'&type='.$type_id);
		    die();
		} else {
			header('Location: ./index.php?poid='.$poid);
		    die();
		}
    }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['poid'] > 0 && $request_method === 'POST') {

	 if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    $id   	  = trim(GETPOST('id', 'int'));
	    $poid 	  = trim(GETPOST('poid', 'int'));
    	$doc_date = trim($_POST['doc_date']);
	    $type_id  = trim($_POST['type_id']);
    	$ref	  = trim($_POST['ref']);
    	$observes = trim($_POST['observes']);

	    if (!$poid || !$id || !$doc_date || $type_id == -1 || !$ref) {
			header('Location: ./index.php?poid='.$poid);
		    die();
	    }

    	if (isset($doc_date) && !empty($doc_date)) {
	        list($etd, $etm, $ety) = explode("/", $doc_date);
	        $doc_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
	    	'ref' 	 	=> $ref,
	    	'doc_date' 	=> $doc_date,
	    	'type_id'	=> $type_id,
	    	'observes'	=> $observes
	    );

		$object->update($id, $data);
		header('Location: ./list.php?id='. $id .'&poid='.$poid.'&type='.$type_id);
	    die();
	}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->btp->delete) {
	$error = 0;
	$poid = GETPOST('poid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$poid || !$id)
		return;

	$db->begin();

	$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=marches&poid='.$poid);
	exit;
}

$form = new Form($db);
$document_dirs = $object->getDocumentTypesDir();

llxHeader(array(), $langs->trans('MarketDocuments'),'','','','',array('/btp/nc_under_modules/marches/js/marches.js'),array(),0,0);
$purchaseorder->fetch($poid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreate');
    } else {
		$head  = purchaseorder_prepare_head($purchaseorder);
		dol_fiche_head($head, 'documentmanagement', $langs->trans("DocumentManagementDetail"), 0, '');

    	$module_name = (in_array($type, array(99, 10, 11, 12)) ? 'technical_file' : $document_dirs[($type-1)]);
		$headBtm = purchaseorder_documents_prepare_head($purchaseorder);
    	dol_fiche_head($headBtm, $module_name, $langs->trans("DocumentTypes"), 0, '');

    	/*
    	$headBtm2 = marche_documents2_prepare_head($purchaseorder);
    	dol_fiche_head($headBtm2, $module_name, $langs->trans("DocumentTypes"), 0, '');*/

		echo $purchaseorder->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="poid" value="'. $poid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Label").'</td><td>';
        print '<input type="text" name="ref" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Date").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  value="" name="doc_date" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
        if ($type) {
        	if ($type == 99) {
        		$technicalFileTypes = $object->getTechnicalDocumentTypes();
		        print $form->selectarray('type_id', $technicalFileTypes, (GETPOST('type_id') ? GETPOST('type_id') : $type), 1, 0, 0, 'required="required"');
        	} else {
        		print $object->getDocumentTypeById($type);
		        print '<input type="hidden" value="'. $type .'" name="type_id" />';
        	}
        } else {
	        print $form->selectarray('type_id', $object->getDocumentTypes(), (GETPOST('type_id') ? GETPOST('type_id') : $type), 1, 0, 0, 'required="required"');
        }
        print '</td></tr>';

        print '<tr><td valign="top">'.$langs->trans("Remarks").'</td><td>';
        print '<textarea rows="6" cols="60" name="observes"></textarea></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("Create") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $poid > 0) {
		
		$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->btp->delete) {
                    print $form->formconfirm("./card.php?poid=".$poid."&id=".$id, $langs->trans("TitleDeleteDocument"), $langs->trans("ConfirmDeleteDocument"), "confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				$object->fetch($id);
				$head  = purchaseorder_prepare_head($purchaseorder);
				dol_fiche_head($head, 'documentmanagement', $langs->trans("DocumentManagementDetail"), 0, '');

    			$module_name = (in_array($type, array(99, 10, 11, 12)) ? 'technical_file' : $document_dirs[($type-1)]);
				$headBtm = purchaseorder_documents_prepare_head($purchaseorder);
		    	dol_fiche_head($headBtm, $module_name, $langs->trans("DocumentTypes"), 0, '');

		    	/*$headBtm2 = marche_documents2_prepare_head($purchaseorder);
    			dol_fiche_head($headBtm2, $module_name, $langs->trans("DocumentTypes"), 0, '');*/

				echo $purchaseorder->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="poid" value="'. $poid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$ref	  = $object->ref ?: '';
				$doc_date = $object->doc_date ? dol_print_date($object->doc_date, 'day'): '';
				$observes = $object->observes ?: '';
				$type_id  = $object->type_id ?: -1;

		        print '<table class="border" width="100%">';
		        print '<tbody>';

			    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Label").'</td><td>';
		        print '<input type="text" class="" value="'. $ref .'" name="ref" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Date").'</td><td>';
		        print '<input type="text" class="datepicker" autocomplete="off"  value="'. $doc_date .'" name="doc_date" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
		        print $form->selectarray('type_id', $object->getDocumentTypes(), (GETPOST('type_id') ? GETPOST('type_id') : $type_id), 1, 0, 0, 'required="required"');
		        print '</td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("Remarks").'</td><td>';
		        print '<textarea rows="6" cols="60" name="observes">'. nl2br($observes) .'</textarea></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    if ($user->rights->btp->delete)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete&poid='. $poid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
