<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/managementpackingslip/index.php
 * \ingroup    managementpackingslip
 * \brief      List of managementpackingslip
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/nc_under_modules/marches/managementpackingslip/class/managementpackingslip.class.php');
dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new ManagementPackingSlip($db);
$marche = new Marches($db);

if ($action == 'pdf' && $mid) {
	$title = $langs->trans('PackingSlip');
	dol_include_once('/btp/nc_under_modules/marches/pdf/pdf-no-header.lib.php');
	$pdf->SetFont('dejavusans', '', 12, '', true);

	// Add a page
	$pdf->AddPage();

	// set text shadow effect
	$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));
	$timezone = new DateTimeZone("GMT");
	$today 	  = new DateTime();
	$today->setTimeZone($timezone);
	$html = '';
	dol_include_once('/btp/nc_under_modules/marches/managementpackingslip/tpl/packingslip.php');

	// Print text using writeHTMLCell()
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

	// ---------------------------------------------------------

	// Close and output PDF document
	$pdf->Output('packing_slip_'. $id .'_'. $mid .'_'. $today->format('YmdHis') .'.pdf', 'I');
	die();
}

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    $action='request';
	// If no right to create a request
    if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    // $date_at	= '';
	    $mid 		= trim(GETPOST('mid', 'int'));
	    $number 	= trim(GETPOST('number'));
	    $subject 	= trim(GETPOST('subject'));
	    $observation= trim(GETPOST('observation'));

	    if (!$mid || !$number || empty($subject))
			return;

		/*if (isset($_POST['date_at']) && !empty($_POST['date_at'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['date_at']);
	        $date_at = $ety.'-'.$etm.'-'.$etd;
	    }*/

	    $object->fk_created_by	= $user->id;
	    $object->fk_marche  	= $mid;
	    $object->number 		= $number;
	    $object->subject 	 	= $subject;
	    $object->observation 	= $observation;
	    // $object->date_at 		= $date_at;

		$getPackingSlip = $object->create();

		if ($getPackingSlip) {
		    header('Location: ./index.php?id='. $getPackingSlip .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
    	$id 		= trim(GETPOST('id', 'int'));
    	$mid 		= trim(GETPOST('mid', 'int'));
	    $number 	= trim(GETPOST('number'));
	    $subject 	= trim(GETPOST('subject'));
	    $observation= trim(GETPOST('observation'));

	    if (!$mid || !$number || empty($subject))
			return;

	    $data = array(
	    	'number' 	 => $number,
	    	'subject' 	 => $subject,
	    	'observation'=> $observation
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid);
	    die();
	}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->btp->delete) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete((int) $id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}
	
	header('Location: ./index.php?leftmenu=marches&mid='.$mid);
    exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('ListOfmanagementpackingslip'),'','','','',array(),array(),0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[] = $langs->trans('CantCreate');
    } else {
    	$title = $langs->trans('AddPackingSlip');
		print_fiche_titre($title,'','');
	 	$marche->fetch($mid);
		$head = marches_prepare_head($marche);
		dol_fiche_head($head, 'managementpackingslip', $langs->trans('AddPackingSlip'), 0, '.');
		echo $marche->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        /*print '<tr><td class="fieldrequired" width="400px">'.$langs->trans("Date").'</td><td>';
        print '<input type="date" class="datepicker" autocomplete="off"  value="" name="date_at" required="required" />';*/
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("Number").'</td><td>';
        print '<input type="number" class="" value="" name="number" /></td></tr>';

        print '<tr><td valign="top">'.$langs->trans("Subject").'</td><td>';
        print ' <textarea cols="49" rows="6" name="subject"></textarea>';
        print '</td></tr>';

        print '<tr><td valign="top">'.$langs->trans("Observation").'</td><td>';
        print ' <textarea cols="49" rows="6" name="observation"></textarea>';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreatePackingSlip") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $mid > 0) {
		$title = $langs->trans('ModifyPackingSlip');
		print_fiche_titre($title,'','');
		$object->fetch($id);
		$marche->fetch($mid);
		$head  = marches_prepare_head($marche);
		$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

		if ($canedit) {
			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'managementpackingslip', $langs->trans('ModifyPackingSlip'), 0, '');
				echo $marche->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$number 	 = $object->number ?: 0;
				$subject 	 = $object->subject ? nl2br($object->subject) : '';
				$observation = $object->observation ? nl2br($object->observation) : '';

		        print '<table class="border" width="100%">';
		        print '<tbody>';

			   	print '<tr><td>'.$langs->trans("Number").'</td><td>';
		        print '<input type="number" class="" value="'. $number .'" name="number" /></td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("Subject").'</td><td>';
		        print ' <textarea cols="49" rows="6" name="subject">'. $subject .'</textarea>';
		        print '</td></tr>';

		        print '<tr><td valign="top">'.$langs->trans("Observation").'</td><td>';
		        print ' <textarea cols="49" rows="6" name="observation">'. $observation .'</textarea>';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
