<?php
/* Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *	\file       marches/lib/marches.lib.php
 *	\brief      Ensemble de fonctions de base pour les adherents
 */

function marches_cadre_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/marche/index.php?id=1&tasktab=1',1);
    $head[$h][1] = $langs->trans("Task").'1';
    $head[$h][2] = 'task_1';
    $h++;

    $head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/marche/index.php?id=2&tasktab=2',1);
    $head[$h][1] = $langs->trans("Task").'2';
    $head[$h][2] = 'task_2';
    $h++;

    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         marches
 *  @return array           		head
 */
function marches_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/marche/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("MarketFile");
    $head[$h][2] = 'marche';
    $h++;

    $head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/notifications/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('NotificationsPhase');
	$head[$h][2] = 'notifications';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/executions/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('ExecutionPhase');
	$head[$h][2] = 'execution';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('MarketDocuments');
	$head[$h][2] = 'documentmanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/recap/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("RecapMarket");
	$head[$h][2] = 'recap';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/managementpackingslip/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans("ManagementPackingSlip");
	$head[$h][2] = 'managementpackingslip';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

function phase_notification_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/bails/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('Bails');
	$head[$h][2] = 'bails';
	$h++;
	
	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/certificates/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('Certificates');
	$head[$h][2] = 'certificates';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

function phase_execution_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/executions/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('ExecutionFile');
	$head[$h][2] = 'executions';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/delaymanagement/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('DelayManagement');
	$head[$h][2] = 'delaymanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/paymentmanagement/index.php?mid='.$object->id,1);
	$head[$h][1] = $langs->trans('PaymentManagement');
	$head[$h][2] = 'paymentmanagement';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function appeloffre_prepare_head($object)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("AODetail");
	$head[$h][2] = 'appeloffre';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/competitors/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("Competitors");
	$head[$h][2] = 'competitors';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/monitorings/index.php?ao='.$object->id,1);
	$head[$h][1] = $langs->trans("Monitoring");
	$head[$h][2] = 'monitoring';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/approval/index.php?ao='.$object->id,1);
	$head[$h][1] = $langs->trans("Approval");
	$head[$h][2] = 'approval';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/provisionalbail/index.php?ao='.$object->id,1);
	$head[$h][1] = $langs->trans("ProvisionalBail");
	$head[$h][2] = 'provisionalbail';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h,'appeloffre');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'appeloffre','remove');
	
	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function monitoring_prepare_head($object, $monitoring)
{
	global $langs, $conf, $user;
	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("AODetail");
	$head[$h][2] = 'appeloffre';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/competitors/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("Competitors");
	$head[$h][2] = 'competitors';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/monitorings/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("Monitoring");
	$head[$h][2] = 'monitoring';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/approval/index.php?id='.$object->id,1);
	$head[$h][1] = $langs->trans("Approval");
	$head[$h][2] = 'approval';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/monitorings/document.php?ao='.$monitoring->id,1);
	$head[$h][1] = $langs->trans("Document");
	$head[$h][2] = 'monitoringsdocs';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h,'appeloffre');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function marche_documents_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=1',1);
	$head[$h][1] = $langs->trans("PvImplantation");
	$head[$h][2] = 'pv_implantation';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=2',1);
	$head[$h][1] = $langs->trans("TechnicalMemory");
	$head[$h][2] = 'technical_memory';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=3',1);
	$head[$h][1] = $langs->trans("OS");
	$head[$h][2] = 'os';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=4',1);
	$head[$h][1] = $langs->trans("PvSiteMonitoring");
	$head[$h][2] = 'pv_site_monitoring';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=5',1);
	$head[$h][1] = $langs->trans("ReportEndWork");
	$head[$h][2] = 'report_end_work';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=6',1);
	$head[$h][1] = $langs->trans("DailyReport");
	$head[$h][2] = 'daily_report';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=7',1);
	$head[$h][1] = $langs->trans("CasingCertificates");
	$head[$h][2] = 'casing_certificates';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=8',1);
	$head[$h][1] = $langs->trans("CertificateOfOrigin");
	$head[$h][2] = 'certificate_of_origin';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=9',1);
	$head[$h][1] = $langs->trans("PurchaseInvoices");
	$head[$h][2] = 'purchase_invoices';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=99',1);
	$head[$h][1] = $langs->trans("TechnicalFile");
	$head[$h][2] = 'technical_file';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'marche');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function marche_documents2_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=9',1);
	$head[$h][1] = $langs->trans("PurchaseInvoices");
	$head[$h][2] = 'purchase_invoices';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/documentmanagement/list.php?mid='.$object->id.'&type=99',1);
	$head[$h][1] = $langs->trans("TechnicalFile");
	$head[$h][2] = 'technical_file';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'marche');

	return $head;
}

/**
 *  Return array head with list of tabs to view object informations
 *
 *  @param	Object	$object         marches
 *  @return array           		head
 */
function purchaseorder_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

    $head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/purchaseorder/index.php?id='.$object->id,1);
    $head[$h][1] = $langs->trans("PurchaseOrderFile");
    $head[$h][2] = 'purchaseorder';
    $h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_paymentmanagement/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans('ExecutionPhase');
	$head[$h][2] = 'po_paymentmanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans('BCDocuments');
	$head[$h][2] = 'po_documentmanagement';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_recap/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans("RecapBC");
	$head[$h][2] = 'po_recap';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_managementpackingslip/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans("ManagementPackingSlipBC");
	$head[$h][2] = 'po_managementpackingslip';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

function purchaseorder_execution_prepare_head($object)
{
	global $langs, $conf, $user;

	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_paymentmanagement/index.php?poid='.$object->id,1);
	$head[$h][1] = $langs->trans('PaymentManagement');
	$head[$h][2] = 'po_paymentmanagement';
	$h++;

    // Show more tabs from modules
    // Entries must be declared in modules descriptor with line
    // $this->tabs = array('entity:+tabname:Title:@mymodule:/mymodule/mypage.php?id=__ID__');   to add new tab
    // $this->tabs = array('entity:-tabname);   												to remove a tab
    complete_head_from_modules($conf,$langs,$object,$head,$h,'marches');

	complete_head_from_modules($conf,$langs,$object,$head,$h,'marches','remove');

	return $head;
}

/**
 * Prepare array with list of tabs
 *
 * @param   Object	$object		Object related to tabs
 * @return  array				Array of tabs to show
 */
function purchaseorder_documents_prepare_head($object)
{
	global $langs, $conf, $user;
	$h 	  = 0;
	$head = array();

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=1',1);
	$head[$h][1] = $langs->trans("PvImplantation");
	$head[$h][2] = 'pv_implantation';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=2',1);
	$head[$h][1] = $langs->trans("TechnicalMemory");
	$head[$h][2] = 'technical_memory';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=3',1);
	$head[$h][1] = $langs->trans("OS");
	$head[$h][2] = 'os';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=4',1);
	$head[$h][1] = $langs->trans("PvSiteMonitoring");
	$head[$h][2] = 'pv_site_monitoring';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=5',1);
	$head[$h][1] = $langs->trans("ReportEndWork");
	$head[$h][2] = 'report_end_work';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=6',1);
	$head[$h][1] = $langs->trans("DailyReport");
	$head[$h][2] = 'daily_report';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=7',1);
	$head[$h][1] = $langs->trans("CasingCertificates");
	$head[$h][2] = 'casing_certificates';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=8',1);
	$head[$h][1] = $langs->trans("CertificateOfOrigin");
	$head[$h][2] = 'certificate_of_origin';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=9',1);
	$head[$h][1] = $langs->trans("PurchaseInvoices");
	$head[$h][2] = 'purchase_invoices';
	$h++;

	$head[$h][0] = dol_buildpath('/btp/nc_under_modules/marches/po_documentmanagement/list.php?poid='.$object->id.'&type=99',1);
	$head[$h][1] = $langs->trans("TechnicalFile");
	$head[$h][2] = 'technical_file';
	$h++;

	complete_head_from_modules($conf,$langs,$object,$head,$h, 'marche');

	return $head;
}
