<?php
/* 
 * Copyright (C) 2016 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 */
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formsocialcontrib.class.php';

class FormSocialContribChild extends FormSocialContrib
{
	/**
     *	Return list of social contributions.
     * 	Use mysoc->country_id or mysoc->country_code so they must be defined.
     *
     *	@param	string	$selected       Preselected type
     *	@param  string	$htmlname       Name of field in form
     * 	@param	int		$useempty		Set to 1 if we want an empty value
     * 	@param	int		$maxlen			Max length of text in combo box
     * 	@param	int		$help			Add or not the admin help picto
     * 	@return	void
     */
    function select_type_socialcontrib($selected='',$htmlname='actioncode', $useempty=0, $maxlen=40, $help=1, $morecss = 'minwidth30...')
    {
        global $db,$langs,$user,$mysoc;

        if (empty($mysoc->country_id) && empty($mysoc->country_code))
        {
            dol_print_error('','Call to select_type_socialcontrib with mysoc country not yet defined');
            exit;
        }

        if (! empty($mysoc->country_id))
        {
            $sql = "SELECT c.id, c.libelle as type";
            $sql.= " FROM ".MAIN_DB_PREFIX."c_chargesociales as c";
            $sql.= " WHERE c.active = 1";
            $sql.= " AND c.fk_pays = ".$mysoc->country_id;
            $sql.= " ORDER BY c.libelle ASC";
        }
        else
        {
            $sql = "SELECT c.id, c.libelle as type";
            $sql.= " FROM ".MAIN_DB_PREFIX."c_chargesociales as c, ".MAIN_DB_PREFIX."c_country as co";
            $sql.= " WHERE c.active = 1 AND c.fk_pays = co.rowid";
            $sql.= " AND co.code = '".$mysoc->country_code."'";
            $sql.= " ORDER BY c.libelle ASC";
        }

        dol_syslog("Form::select_type_socialcontrib", LOG_DEBUG);
        $resql=$db->query($sql);
        if ($resql)
        {
            $num = $db->num_rows($resql);
            if ($num)
            {
                print '<select class="flat" id="'.$htmlname.'" name="'.$htmlname.'">';
                $i = 0;

                if ($useempty) print '<option value="0">&nbsp;</option>';
                while ($i < $num)
                {
                    $obj = $db->fetch_object($resql);
                    print '<option value="'.$obj->id.'"';
                    if ($obj->id == $selected) print ' selected';
                    print '>'.dol_trunc($obj->type,$maxlen);
                    $i++;
                }
                print '</select>';
                if ($user->admin && $help) print info_admin($langs->trans("YouCanChangeValuesForThisListFromDictionarySetup"),1);
            }
            else
            {
                print $langs->trans("ErrorNoSocialContributionForSellerCountry",$mysoc->country_code);
            }
        }
        else
        {
            dol_print_error($db,$db->lasterror());
        }
    }
}