<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches//bails/index.php
 * \ingroup    list
 * \brief      List of bails related to given mid
 */
$res=0;
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../../main.inc.php")) $res=@include("../../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/nc_under_modules/marches/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/btp/nc_under_modules/marches/lib/marches.lib.php');
dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/nc_under_modules/marches/marche/class/marche.class.php');
dol_include_once('/btp/nc_under_modules/marches/bails/class/bail.class.php');
dol_include_once('/btp/nc_under_modules/marches/provisionalbail/class/provisionalbail.class.php');

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page 	   = GETPOST("page",'int');
$page 	   = is_numeric($page) ? $page : 0;
$page 	   = $page == -1 ? 0 : $page;
$filter    = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset  = $conf->liste_limit * $page;
$pageprev= $page - 1;
$pagenext= $page + 1;
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$mid)
	die('ID marché n\'existe pas!');

$object = new Bails($db);
$marche = new Marches($db);
$account= new Account($db);
$form   = new FormChild($db);

if ($mid > 0) {
	$object->fetch($id);
		
	if (!$object->id)
		$object->fetch(0, $mid);
    $param 		= '&mid='. $mid;
	$upload_dir = $conf->marches->dir_output.'/bails/'.$object->id;
	$modulepart = 'marches';

	$filearray = array();
	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}

	dol_include_once('/btp/nc_under_modules/marches/core/tpl/document_actions_pre_headers.tpl.php');
}

/**
 * Actions
 */

// None

/**
 * View
 */

llxHeader(array(), $langs->trans('Bails'));

// Récupération de l'ID de l'utilisateur
$getBails = $object->fetchAll($mid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, '');

// Si erreur SQL
if ($getBails == '-1') {
    print_fiche_titre($langs->trans('DefinitiveBail'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

if (($id > 0 || $mid > 0) && $getBails > 0) {
	$title = $langs->trans("BailsDetail");
	print_fiche_titre($title,'','');
	
	
	$object->fetch($id);
		
	if (!$object->id)
		$object->fetch(0, $mid);

	$marche->fetch($mid);
	$title = $langs->trans("DefinitiveBail");
	$head  = marches_prepare_head($marche);
	dol_fiche_head($head, 'notifications', $langs->trans('NotificationsPhase'), 0, '');

	$head_btm = phase_notification_prepare_head($marche);
	dol_fiche_head($head_btm, 'bails', $title, 0, '');
	echo $marche->getMarketHeader();

	$user->fetch($object->fk_created_by);
	$account->fetch($object->fk_bank);

	$amount 	= $object->amount ? number_format($object->amount,  2, ",", " ") : '';
	$ref	  	= $object->ref ? $object->ref : '';
	$bail_date	= $object->bail_date ? dol_print_date($object->bail_date, 'day') : '';
	$sig_date	= $object->sig_date ? dol_print_date($object->sig_date, 'day') : '';
	$deposit_date= $object->deposit_date ? dol_print_date($object->deposit_date, 'day') : '';
	$def = $langs->trans("Definit");

	$provisionalbail = new ProvisionalBail($db);
	$provisionalbail->fetch(null, $marche->fk_appel_offre);
	$recovered  = ($provisionalbail->id ? $langs->trans('Yes') : $langs->trans('No'));

	print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td><td>'. $user->getNomUrl(1) .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailNum").' '. $def .'</td><td>'. $ref .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("BailDate").' '. $def.'</td><td>' . $bail_date .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailAmount").' '. $def.'</td><td>' . $amount.' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
        print '<tr><td class="">'.$langs->trans("SigDate").'</td><td>' . $sig_date .'</td></tr>';
        print '<tr><td class="">'.$langs->trans("DepositDate").'</td><td>' . $deposit_date .'</td></tr>';
        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>'. $account->getNomUrl(1) . ($account->number ? " &nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )" : "") .'</td></tr>';
     	print '</tbody>';
	print '</table><br />';

	print '<table class="border" width="100%">';
        print '<tbody>';
        print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ProvAmount").'</td><td>' . number_format($object->amount,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
       	print '<tr><td class="fieldrequired">'.$langs->trans("ProvDate").'</td><td>' . dol_print_date($object->adate, 'day') .'</td></tr>';
       	print '<tr><td>'.$langs->trans("Recovered").'</td><td>'. $recovered .'</td></tr>';
     	print '</tbody>';
	print '</table>';

	if ($user->id && $user->rights->btp->write_all) {
		print '<div class="tabsAction">';
        // Boutons d'actions
		print '<a href="./card.php?action=edit&mid='. $mid .'&id='. $object->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        print '</div>';
	}

	$modulepart = 'marches';
    $permission = $user->rights->btp->write;
    $param 		= '&mid='. $mid;
    $relativepathwithnofile = '/bails/'.$object->id.'/';

    dol_include_once('/btp/nc_under_modules/marches/core/tpl/document_actions_post_headers.tpl.php');
}

if ($user->id && $user->rights->btp->write && $getBails <= 0) {
	$title = $langs->trans('CreateBail');
	print_fiche_titre($title,'','');

	$marche->fetch($mid);
	$title = $langs->trans("Bails");
	$head  = marches_prepare_head($marche);
	dol_fiche_head($head, 'notifications', $langs->trans('NotificationsPhase'), 0, '');

	$head_btm = phase_notification_prepare_head($marche);
	dol_fiche_head($head_btm, 'bails', $title, 0, '');

	echo $marche->getMarketHeader();
	
	print '<br>';
	print '<div style="text-align: center; margin-top: 8px;">';
	print '<a href="./card.php?action=add&mid='. $mid .'" class="butAction">'.$langs->trans('AddBail').'</a>';
	print '</div>';
}

llxFooter();

$db->close();

?>