<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class gestion_location extends Commonobject{

	public $error;	
	public $errors = array();
	public $rowid;
	public $date;
	public $id_engin;
	public $inter_exter;
	public $id_fornisseur;
	public $unite;
	public $qty;
	public $prix;
	public $id_chantier;

	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/nc_under_modules/gestion_location/card.php?id='. $id,2) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	public function create()
	{
		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "gestion_location ( ";
		//$sql .= "date,";
		$sql .= "id_engin,";
		$sql .= "inter_exter,";
		$sql .= "id_fornisseur";
		// $sql .= "unite,";
		// $sql .= "qty,";
		// $sql .= "prix,";
		// $sql .= "id_chantier";
		$sql .= ") VALUES ( ";
		//$sql .= " '".$this->date."', ";
		$sql .= " ".$this->id_engin.", ";
		$sql .= " '".$this->inter_exter."', ";
		$sql .= " ".$this->id_fornisseur." ";
		// $sql .= " '".$this->unite."', ";
		// $sql .= " ".$this->qty.", ";
		// $sql .= " ".$this->prix.", ";
		// $sql .= " ".$this->id_chantier." ";
		$sql .= ")";

		$this->db->begin();
		$resql = $this->db->query($sql);
		echo $sql."<br>";
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_location ' . $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'gestion_location WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
				$this->rowid 	= $obj->rowid;
				$this->date 	= $obj->date;
				$this->id_engin 	= $obj->id_engin;
				$this->inter_exter 	= $obj->inter_exter;
				$this->id_fornisseur 	= $obj->id_fornisseur;
				$this->unite 	= $obj->unite;
				$this->qty 	= $obj->qty;
				$this->prix 	= $obj->prix;
				$this->id_chantier 	= $obj->id_chantier;

				$this->db->free($resql);
				return 1 ;
			}else {
				return 0;
			}

		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "gestion_location";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		//echo $sql."<br>";
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->rowid 	= $obj->rowid;
				$line->date 	= $obj->date;
				$line->id_engin 	= $obj->id_engin;
				$line->inter_exter 	= $obj->inter_exter;
				$line->id_fornisseur 	= $obj->id_fornisseur;
				$line->unite 	= $obj->unite;
				$line->qty 	= $obj->qty;
				$line->prix 	= $obj->prix;
				$line->id_chantier 	= $obj->id_chantier;

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'gestion_location' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		//echo $sql."<br>";

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_location ' . $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'gestion_location' .' WHERE rowid = ' . $this->rowid;
		//echo $sql."<br>";
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_location ' . $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$table="gestion_location"){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.$table;
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function get_label($rowid)
	{
		$sql = "SELECT label FROM ".MAIN_DB_PREFIX."gestion_location WHERE rowid=".$rowid;

		$resql = $this->db->query($sql);
		$label ;

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$label = $obj->label;
			}
			$this->db->free($resql);
			return $label;
		}
	}
	public function get_fournisseur($rowid)
	{
		$sql = "SELECT nom FROM ".MAIN_DB_PREFIX."societe WHERE rowid=".$rowid;

		$resql = $this->db->query($sql);
		$label ;
		//echo $sql;

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$label = $obj->nom;
			}
			$this->db->free($resql);
			return $label;
		}
	}

}


 
class gestion_location_input extends Commonobject{ 

	public $error;
	public $errors = array();
	public $rowid;
	public $id_list;
	public $date_l; 
	public $unite; 
	public $qty; 
	public $prix; 
	public $id_chantier; 

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.DOL_URL_ROOT.'/'.get_class($this).'/card.php?id='. $id .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	public function create($insert,$echo_sql=0)
	{
		$sql  = "INSERT INTO " . MAIN_DB_PREFIX ."".get_class($this)." ( ";

		foreach ($insert as $column => $value) {
			$alias = (is_numeric($value)) ? "" : "'";
			$sql_column .= " , `".$column."`";
			$sql_value .= " , ".$alias.$value.$alias;
		}

		$sql .= substr($sql_column, 2)." ) VALUES ( ".substr($sql_value, 2)." )";

		$this->db->begin();
		$resql = $this->db->query($sql);

		if ($echo_sql)
			echo "<br>".$sql."<br>";

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function update($id, array $data,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		if($echo_sql)
			echo "<br>".$sql."<br>";

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0,$filter='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if(empty($filter)){
			$filter = ' rowid = ' . $this->rowid;
		}

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE '.$filter;
		
		if ($echo_sql) {
			echo "<br>".$sql."<br>";
		}

		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function get_item($item,$rowid,$filter='')
	{
		if(empty($filter)){
			$filter = " and rowid=".$rowid;
		}
		$sql = "SELECT ".$item." as 'item' FROM ".MAIN_DB_PREFIX.get_class($this)." WHERE 1>0 ".$filter;

		$resql = $this->db->query($sql);
		$item ;
		//echo $sql."<br>";

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$item = $obj->item;
			}
			$this->db->free($resql);
			return $item;
		}
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX.get_class($this);

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 	= $obj->rowid;
				$line->id_list 	= $obj->id_list;
				$line->date_l 	= $obj->date_l;
				$line->unite 	= $obj->unite;
				$line->qty 		= $obj->qty;
				$line->prix 	= $obj->prix;
				$line->id_chantier 	= $obj->id_chantier;
				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	} 
	
}


?>