<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class list_gasoil_lubrifiant extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */

	public $errors = array();
	public $rowid;
	public $id_engin;

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $id_engin  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/nc_under_modules/gestion_gasoil_lubrifiant/card.php?id='. $id,2) .'" title="'.dol_escape_htmltag($id_engin, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($id_engin, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{


		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "list_gasoil_lubrifiant ( ";
		$sql .= "id_engin";
		$sql .= ") VALUES ( ";
		$sql .= " ".$this->id_engin." ";
		$sql .= ")";

		$this->db->begin();
		$resql = $this->db->query($sql);
		//echo "<br>".$sql."<br>";
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error list_gasoil_lubrifiant ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {

			$sql = "SELECT MAX(rowid) as 'id_parent' FROM ";
			$sql .= MAIN_DB_PREFIX . "list_gasoil_lubrifiant";

			$resql = $this->db->query($sql);
			$id_parent ;

			if ($resql) {
				while ($obj = $this->db->fetch_object($resql)) {
						$id_parent = $obj->id_parent;
				}
				$this->db->free($resql);
				return $id_parent;
			}else
				return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'list_gasoil_lubrifiant WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
				$this->rowid 	= $obj->rowid;
				$this->id_engin = $obj->id_engin;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "list_gasoil_lubrifiant";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		//echo "<br>".$sql."<br>";
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 	= $obj->rowid;
				$line->id_engin 	= $obj->id_engin;
				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'list_gasoil_lubrifiant' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		//echo "<br>".$sql."<br>";

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'list_gasoil_lubrifiant WHERE rowid = ' . $this->rowid;
		//echo "<br>".$sql."<br>";
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {

			$sql = 'DELETE FROM ' . MAIN_DB_PREFIX . 'gasoil_lubrifiant WHERE id_list = ' . $this->rowid;
			//echo "<br>".$sql."<br>";
			$resql 	= $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();

				$this->errors[] = 'Error ' . $this->db->lasterror();
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	public function get_heur_service($id_list=0)
	{
		$sql = "SELECT sum(`heur_service`) as 'nbr_heur' FROM ";
		$sql .= MAIN_DB_PREFIX . "gasoil_lubrifiant WHERE `id_list` = ".$id_list;

		$resql = $this->db->query($sql);
		$nbr_heur = array();
		//echo "<br>".$sql."<br>";
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$nbr_heur = $obj->nbr_heur;
			}
			$this->db->free($resql);
			return $nbr_heur;
		}
	}

	public function get_part_date($date_="",$id_list=0)
	{
		$sql = "SELECT ".$date_."(`date_`) as 'date_' FROM ";
		$sql .= MAIN_DB_PREFIX . "gasoil_lubrifiant WHERE `id_list` = ".$id_list;
		//echo "<br>".$sql."<br>";
		$resql = $this->db->query($sql);
		$nbr_heur = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$nbr_heur = $obj->date_;
			}
			$this->db->free($resql);
			return $nbr_heur;
		}
	}

	public function get__date($dt = 'year' ,$filter = '')
	{
		$sql = "SELECT distinct ".$dt."(`date_`) as 'part' FROM ";
		$sql .= MAIN_DB_PREFIX . "gasoil_lubrifiant";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		//echo "<br>".$sql."<br>";
		$resql = $this->db->query($sql);
		$dates = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$dates[ $obj->part ] = $obj->part;
			}
			$this->db->free($resql);
			return $dates;
		}
	}
}

class gasoil_lubrifiant extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */

	public $errors = array();
	public $rowid;
	public $date_;
	public $heur_service;
	public $gazoil;
	public $lub15w40;
	public $lub68;
	public $lub50;
	public $lub40;
	public $nature_panne;
	public $heur_panne;
	public $autres;
	public $id_list;

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->date_ 	 = new DateTime("now");
		$this->date_ 	 = $this->date_->format('Y-m-d');
		return 1;
	}

	public function getNomUrl($withpicto = 0, $id = null,$list_id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/nc_under_modules/gestion_gasoil_lubrifiant/card_2.php?id='. $id .'&id_list='. $list_id,2) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{


		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "gasoil_lubrifiant ( ";

		$sql .= "date_";
		$sql .= ",heur_service";
		$sql .= ",gazoil";
		$sql .= ",lub15w40";
		$sql .= ",lub68";
		$sql .= ",lub50";
		$sql .= ",lub40";
		$sql .= ",nature_panne";
		$sql .= ",heur_panne";
		$sql .= ",autres";
		$sql .= ",id_list";

		$sql .= ") VALUES ( ";
		$sql .= " '".$this->date_."' ";
		$sql .= " , ".$this->heur_service."";
		$sql .= " , ".$this->gazoil." ";
		$sql .= " , ".$this->lub15w40." ";
		$sql .= " , ".$this->lub68." ";
		$sql .= " , ".$this->lub50." ";
		$sql .= " , ".$this->lub40." ";
		$sql .= " ,'".$this->nature_panne."' ";
		$sql .= " , ".$this->heur_panne." ";
		$sql .= " ,'".$this->autres."' ";
		$sql .= " , ".$this->id_list." ";
		$sql .= ")";

		$this->db->begin();
		$resql = $this->db->query($sql);
		//echo "<br>".$sql."<br>";
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error gasoil_lubrifiant ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'gasoil_lubrifiant WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 					= $this->db->fetch_object($resql);
				$this->rowid 			= $obj->rowid;
				$this->date_ 		 	= $this->db->jdate($obj->date_);
				$this->heur_service 	= $obj->heur_service;
				$this->gazoil 			= $obj->gazoil;
				$this->lub15w40 		= $obj->lub15w40;
				$this->lub68 			= $obj->lub68;
				$this->lub50 			= $obj->lub50;
				$this->lub40 			= $obj->lub40;
				$this->nature_panne 	= $obj->nature_panne;
				$this->heur_panne 		= $obj->heur_panne;
				$this->autres 			= $obj->autres;
				$this->id_list 			= $obj->id_list;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "gasoil_lubrifiant";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		//echo "<br>".$sql."<br>";

		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 			= $obj->rowid;
				$line->date_ 			= $this->db->jdate($obj->date_);
				$line->heur_service 	= $obj->heur_service;
				$line->gazoil 			= $obj->gazoil;
				$line->lub15w40 		= $obj->lub15w40;
				$line->lub68 			= $obj->lub68;
				$line->lub50 			= $obj->lub50;
				$line->lub40 			= $obj->lub40;
				$line->nature_panne 	= $obj->nature_panne;
				$line->heur_panne 		= $obj->heur_panne;
				$line->autres 			= $obj->autres;
				$line->id_list 			= $obj->id_list;
				$this->rows[] 			= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'gasoil_lubrifiant' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		//echo "<br>".$sql."<br>";

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'gasoil_lubrifiant' .' WHERE rowid = ' . $this->rowid;
		$resql 	= $this->db->query($sql);
		
		//echo "<br>".$sql."<br>";

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	public function get_part_date($dt = 'year' ,$filter = '')
	{
		$sql = "SELECT distinct ".$dt."(`date_`) as 'part' FROM ";
		$sql .= MAIN_DB_PREFIX . "gasoil_lubrifiant";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}

		//echo "<br>".$sql."<br>";

		$resql = $this->db->query($sql);
		$dates = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$dates[ $obj->part ] = $obj->part;
			}
			$this->db->free($resql);
			return $dates;
		}
	}
}


?>