<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class gestion_engin extends Commonobject{

	public $error;	
	public $errors = array();
	public $rowid;
	public $label;
	public $matr;
	public $emplacement;
	public $chauffeur;
	public $date_aquisition;
	public $etat;
	public $observation;

	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/nc_under_modules/gestion_engin/card.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@btp';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

	public function create()
	{
		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "gestion_engin ( ";
		$sql .= "label,";
		$sql .= "matr,";
		$sql .= "emplacement,";
		$sql .= "chauffeur,";
		$sql .= "date_aquisition,";
		$sql .= "etat,";
		$sql .= "observation";
		$sql .= ") VALUES ( ";
		$sql .= " '".$this->label."', ";
		$sql .= " '".$this->matr."', ";
		$sql .= " '".$this->emplacement."', ";
		$sql .= " '".$this->chauffeur."', ";
		$sql .= " ".$this->date_aquisition.", ";
		$sql .= " '".$this->etat."', ";
		$sql .= " '".$this->observation."' ";
		$sql .= ")";

		// $this->db->begin();
		$resql = $this->db->query($sql);
		// echo $sql."<br>";
		// die();
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_engin ' . $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'gestion_engin WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			= $this->db->fetch_object($resql);
				$this->rowid 	= $obj->rowid;
				$this->label 	= $obj->label;
				$this->matr 	= $obj->matr;
				$this->emplacement 	= $obj->emplacement;
				$this->chauffeur 	= $obj->chauffeur;
				$this->date_aquisition 	= $obj->date_aquisition;
				$this->observation 	= $obj->observation;
				$this->etat 	= $obj->etat;

				$this->db->free($resql);
				return 1 ;
			}else {
				return 0;
			}

		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX . "gestion_engin";

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		//echo $sql."<br>";
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 	= $obj->rowid;
				$line->label 	= $obj->label;
				$line->matr 	= $obj->matr;
				$line->emplacement 	= $obj->emplacement;
				$line->chauffeur 	= $obj->chauffeur;
				$line->date_aquisition 	= $obj->date_aquisition;
				$line->observation 	= $obj->observation;
				$line->etat 	= $obj->etat;
				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'gestion_engin' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		echo $sql."<br>";

		// $this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_engin ' . $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'gestion_engin' .' WHERE rowid = ' . $this->rowid;
		//echo $sql."<br>";
		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error gestion_engin ' . $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX."gestion_engin";
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function get_label($rowid)
	{
		$sql = "SELECT label FROM ".MAIN_DB_PREFIX."gestion_engin WHERE rowid=".$rowid;

		$resql = $this->db->query($sql);
		$label ;

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$label = $obj->label;
			}
			$this->db->free($resql);
			return $label;
		}
	}

	public function get_item($item,$rowid)
	{
		$sql = "SELECT ".$item." as 'item' FROM ".MAIN_DB_PREFIX."gestion_engin WHERE rowid=".$rowid;

		$resql = $this->db->query($sql);
		$item ;

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$item = $obj->item;
			}
			$this->db->free($resql);
			return $item;
		}
	}

}
?>