<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class receptions extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $datec;
  public $tva;
  public $note;
  public $ref ;
  public $purchase_order ;
  public $delivery_order ;
  public $cat_id ;
  public $supplier_id ;
  public $company_id ;
  public $const_site_id ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : $this->ref;
        $id  	= ($id  ?: $this->id);
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/material/receptions/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->datec= $this->datec ? $this->db->escape($this->datec): null;
	  //$this->tva = $this->tva ? $this->db->escape($this->tva): null;
	  $this->note = $this->note ? $this->db->escape($this->note): null;
	  $this->cat_id = $this->cat_id ? $this->db->escape($this->cat_id): null;
	  $this->ref = $this->ref ? $this->db->escape($this->ref): null;
	  $this->purchase_order = $this->purchase_order ? $this->db->escape($this->purchase_order): null;
	  $this->delivery_order = $this->delivery_order ? $this->db->escape($this->delivery_order): null;
	  $this->company_id = $this->company_id ? $this->db->escape($this->company_id): null;
	  $this->supplier_id	= $this->supplier_id ? $this->db->escape($this->supplier_id): null;
	  $this->const_site_id	= $this->const_site_id ? $this->db->escape($this->const_site_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'receptions' . ' (datec,tva,note,ref,purchase_order,delivery_order,';
	$sql .= 'cat_id,supplier_id,const_site_id,company_id,created_by,created_at) ';
	$sql .= 'VALUES ("'.$this->datec.'", '.$this->tva.',"'.$this->note.'","'. $this->ref.'", '.$this->purchase_order.','.$this->delivery_order.',';
	$sql .=	 $this->cat_id.', '.$this->supplier_id.', '.$this->const_site_id.', '.$this->company_id.','.$this->created_by.',"'.$this->created_at.'")';
//	die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error receptions ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'receptions';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid ;
			  $this->datec 			= $this->db->jdate($obj->datec); ;
			  $this->tva 			= $obj->tva ;
			  $this->note 			= $obj->note ;
			  $this->cat_id 			= $obj->cat_id ;
			  $this->ref 	= $obj->ref ;
			  $this->purchase_order 	= $obj->purchase_order ;
			  $this->delivery_order 	= $obj->delivery_order ;
			  $this->supplier_id	= $obj->supplier_id ;
			  $this->const_site_id	= $obj->const_site_id ;
			  $this->company_id	= $obj->company_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $ignore_id = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$ignore_id)
			$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'receptions';
		else
			$sql = 'SELECT r.*, SUM(rp.price) AS price, SUM(rp.qty)  AS qty FROM '. MAIN_DB_PREFIX . 'receptions r LEFT JOIN '. MAIN_DB_PREFIX . 'reception_products rp ON (r.rowid = rp.reception_id) GROUP BY rp.reception_id';

		if (!empty($filter)) {
			$sql .=' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}
		//die($sql);

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$tva = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				  $line->id 			= $obj->rowid;
				  $line->datec 			= $this->db->jdate($obj->datec); ;
				  $line->tva 			= $obj->tva ;
				  $line->note 			= $obj->note ;
				  $line->cat_id 		= $obj->cat_id ;
				  $line->ref 			= $obj->ref ;
				  $line->purchase_order = $obj->purchase_order ;
				  $line->delivery_order = $obj->delivery_order ;
				  $line->supplier_id	= $obj->supplier_id ;
				  $line->const_site_id	= $obj->const_site_id ;
				  $line->company_id		= $obj->company_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->price 			= $obj->price ;
				  $line->qty 			= $obj->qty ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $tva;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'receptions' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now  = $now->format('Y-m-d');
			$sql .= '`updated_at` = "'. $now.'"' ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'receptions' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getMats()
    {
    	$this->fetchAll();
    	$names = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$names[$line->id] = $line->ref;    		
    	}

    	return $names;
    }

    public function getMat($id)
    {
    	$sql = 'SELECT ref FROM ' . MAIN_DB_PREFIX . 'receptions WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$name = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$name = $obj->ref;
			}
			$this->db->free($resql);
    	}

    	return $name;
    }

    public function getStatData()
    {
    	global $langs;
    	$this->fetchAll('', '', 0, 0, '', true);
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj) {
    		$countAmount += ($obj->price*$obj->qty); 		
    	}

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('reception');
    	$object->url 	= dol_buildpath('/btp/material/receptions/index.php',1);

    	return $object;
    }

}
?>
