<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/oc_cats/class/oc_cats.class.php');
dol_include_once('/btp/material/intern_orders/class/intern_orders.class.php');
dol_include_once('/btp/settings/unit_type/class/unitType.class.php');
dol_include_once('/btp/material/oc_cats_items/class/oc_cats_items.class.php');
dol_include_once('/btp/lib/machine.lib.php');

$form 		= new Form($db);
$oc_cats   = new oc_cats($db);
$intern_orders   = new intern_orders($db);
$unit_type   = new UnitType($db);
$oc_cats_items   = new oc_cats_items($db);

$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$did 	  = GETPOST('did','int');
$search_name      		= GETPOST('search_name');
$search_qty      		= GETPOST('search_qty');
$search_unit_type    		= GETPOST('search_unit_type');
$search_oc_cats_items    		= GETPOST('search_oc_cats_items');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_name      		= '';
$search_qty      		= '';
$search_unit_type    		= '';
$search_oc_cats_items    		= '';
}
$filter .= (!empty($search_name) && $search_name != -1) ? " AND name = '". $db->escape($search_name)."'\n" : "";
$filter .= (!empty($search_qty) && $search_qty != -1) ? " AND qty = ".$db->escape($search_qty):"";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type):"";
$filter .= (!empty($search_oc_cats_items) && $search_oc_cats_items != -1) ? " AND oc_cat_item_id = ".$db->escape($search_oc_cats_items):"";
$filter .= " AND inten_order_id = ".$did;

$getoc_catss = $oc_cats->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getoc_catss == '-1') {
    print_fiche_titre($langs->trans('ListOfoc_cats'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$oc_cats->error);
    exit();
}
if ($id > 0) {
	$oc_cats->fetch($id);
	llxHeader('', $langs->trans('oc_cats'));
	print_fiche_titre($langs->trans("oc_cats"));
	$intern_orders->fetch($did);
	$intern  = demande_prepare_head($intern_orders);
	dol_fiche_head($intern, 'oc_cats', $langs->trans("oc_cats"), 0, '');

	print '<table class="border" width="100%">';
	// name
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("name").'</td>';
	print '<td colspan="2">'. $oc_cats->name .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("qty").'</td>';
	print '<td colspan="2">'. $oc_cats->qty .'</td></tr>';
	// unité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($oc_cats->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl('1') .'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("oc_cats_items").'</td>';
	$oc_cats_items->fetch($oc_cats->oc_cat_item_id);
	print '<td colspan="2">'. $oc_cats_items->getNomUrl('1') .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?did='. $did .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&did='.$did.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&did='.$did.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';

	if ($action == 'delete') {
                  print $form->formconfirm("card.php?id=".$id."&did=".$did, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('oc_cats'));
print_fiche_titre($langs->trans("ListOfoc_cats"));
	$intern_orders->fetch($did);
	$intern  = demande_prepare_head($intern_orders);
	dol_fiche_head($intern, 'oc_cats', $langs->trans("ListOfoc_cats"), 0, '');
	$moreparam = '&did='.$did;
   	
	//dol_fiche_head('', 'oc_cats', $langs->trans("ListOfoc_cats"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'?">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="did" value="'. $did .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("name"), $_SERVER["PHP_SELF"], 'name', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("qty"),$_SERVER["PHP_SELF"], "qty", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("oc_cats_items"), $_SERVER["PHP_SELF"], 'oc_cat_item_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// matricule
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_name" value="'.$search_name.'">';
	print '</td>';

	// matricule
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" size="14" name="search_qty" value="'.$search_qty.'">';
	print '</td>';

	// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_oc_cats_items', $oc_cats_items->getNames(), $search_oc_cats_items, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($oc_cats->rows)) {
		//$createdBy = new User($db);
		foreach($oc_cats->rows as $obj) {
			  $name 	   		    = $obj->name ;
			  $qty 	   		    = $obj->qty ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  $oc_cats_items->fetch($obj->oc_cat_item_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $oc_cats->getNomUrl(1,  $obj->id,$did, $name);
			print '</td>';
			 
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl('1') .'</td>';
			print '<td align="center">'. $oc_cats_items->getNomUrl('1') .'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&did='.$did.'" class="butAction">'.$langs->trans('Addoc_cats').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>