<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/location_expenses/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/location_expenses/class/location_expenses.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/settings/unit_type/class/unitType.class.php');

dol_include_once('/btp/market/market/class/market.class.php');
$market = new Market($db);


$form 		= new Form($db);
$location_expenses     = new location_expenses($db);
$machine     = new machine($db);
$ConstructionSite   = new ConstructionSite($db);
$unit_type = new unitType($db);
$User = new User($db);

$var = false;
$filter = '';
$counters_location_expensess = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_num     		= GETPOST('search_num');
$search_datec      		= '';
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_works_nature    		= GETPOST('search_works_nature');
$search_fuel_recovery    		= GETPOST('search_fuel_recovery');
$search_unit_type    		= GETPOST('search_unit_type');
$search_price    		= GETPOST('search_price');
$search_location_rate    		= GETPOST('search_location_rate');
$search_location_qty    		= GETPOST('search_location_qty');
$search_machine    		= GETPOST('search_machine');
$search_tenant    		= GETPOST('search_tenant');
$search_const_site    		= GETPOST('search_const_site');

if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_num      		= '';
$search_datec      		= '';
$search_works_nature    		= '';
$search_fuel_recovery    		= '';
$search_unit_type    		= '';
$search_price    		= '';
$search_location_rate    		= '';
$search_location_qty    		= '';
$search_machine   		= '';
$search_tenant    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ". $db->escape($search_num) : "";
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_works_nature) && $search_works_nature != -1) ? " AND works_nature LIKE '%".$db->escape($search_works_nature)."%'\n" :"";
$filter .= (!empty($search_fuel_recovery) && $search_fuel_recovery != -1) ? " AND fuel_recovery = ".$db->escape($search_fuel_recovery) : "";
$filter .= (!empty($search_unit_type) && $search_unit_type != -1) ? " AND unit_type_id = ".$db->escape($search_unit_type) : "";
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price = ".$db->escape($search_price) : "";
$filter .= (!empty($search_location_rate) && $search_location_rate != -1) ? " AND location_rate = ".$db->escape($search_location_rate) : "";
$filter .= (!empty($search_location_qty) && $search_location_qty != -1) ? " AND location_qty = ".$db->escape($search_location_qty) : "";
$filter .= (!empty($search_machine) && $search_machine != -1) ? " AND machine_id = ".$db->escape($search_machine) : "";
$filter .= (!empty($search_tenant) && $search_tenant != -1) ? " AND tenant_id = ".$db->escape($search_tenant) : "";
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = ".$db->escape($search_const_site) : "";


$getlocation_expensess = $location_expenses->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// echo $filter;
if (!empty($getlocation_expensess)  && $action == "xsl" ) {
$filename="Liste_dépenses_location.xls";
      dol_include_once('/btp/material/location_expenses/tpl/location_expenses_xsl.php');
 die();
 
}
// Si erreur SQL
if ($getlocation_expensess == '-1') {
    print_fiche_titre($langs->trans('ListOflocation_expenses'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$location_expenses->error);
    exit();
}
if ($id > 0) {
	$location_expenses->fetch($id);
	llxHeader('', $langs->trans('location_expenses'));

	print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

	print_fiche_titre($langs->trans("location_expenses"));


	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $location_expenses->num .'</td></tr>';
	// datec
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("dated").'</td>';
	print '<td colspan="2">'. dol_print_date($location_expenses->datec,'day') .'</td></tr>';
	// works_nature
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("works_nature").'</td>';
	print '<td colspan="2">'. $location_expenses->works_nature .'</td></tr>';
	// Engin
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($location_expenses->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl(1) .'</td></tr>';
	// unit_type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("unit_type").'</td>';
	$unit_type->fetch($location_expenses->unit_type_id);
	print '<td colspan="2">'. $unit_type->getNomUrl(1) .'</td></tr>';
	// Carburant
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("fuel").'</td>';
	$mark_location_expenses = array(1 => 'fuel 1', 2 => 'fuel 2');
	print '<td colspan="2">'. $mark_location_expenses[$location_expenses->fuel_id] .'</td></tr>';
	// counter
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter").'</td>';
	print '<td colspan="2">'. $location_expenses->counter .'</td></tr>';
	// année
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("fuel_recovery").'</td>';
	print '<td colspan="2">'. $location_expenses->fuel_recovery .'</td></tr>';
	// Moyenne de consommation estimée
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. number_format($location_expenses->price,  2, ",", " ") .'</td></tr>';
	// Tarif d'immobilisation 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("location_rate").'</td>';
	print '<td colspan="2">'. $location_expenses->location_rate .'</td></tr>';
	// Tarif de Location
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("location_qty").'</td>';
	print '<td colspan="2">'. $location_expenses->location_qty .'</td></tr>';
	// Nombre d'heures d'engin 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Nombre d'heures d'engin ").'</td>';
	print '<td colspan="2">'. $location_expenses->nbrheursengin .'</td></tr>';
	
	// locataire 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tenant").'</td>';
	$User->fetch($location_expenses->tenant_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ConstructionSite").'</td>';
	$ConstructionSite->fetch($location_expenses->const_site_id);
	print '<td colspan="2" class="nomchantierwidth">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	print '</table>';
	print '<br>';



	//Coût Déplacements 
	// Coût Déplacements = nombre de jours sur chantier x nombre de km entre dépôt et chantier x 2 (aller-retour) x cout au km du véhicule
	$nbrjours = $ConstructionSite->nmbrjourchantier;
	$entredepotetchantierx2 = $ConstructionSite->nmbrkmentrechantierdepot * 2;
	$coutkmmachine = $machine->immo_rate;

	$coutdeplacement = $nbrjours * $entredepotetchantierx2 * $coutkmmachine;
	print '<table class="border" width="100%">';
	// Coût Déplacements
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Coût Déplacements").'</td>';
	print '<td colspan="2" class="nomchantierwidth">'.number_format($coutdeplacement,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency).'</td></tr>';
	
	// heures utilisation engins
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("heures utilisation engin").'</td>';
	$heurs = $location_expenses->nbrheursengin * $machine->couthoraireengin;
	print '<td colspan="2" class="nomchantierwidth">'.$heurs.'</td></tr>';

	// Dépense Totale
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Dépense Totale").'</td>';
	print '<td colspan="2">';
	$tempArr = explode('/', dol_print_date($location_expenses->datec,'day'));
	$dt = date("Y-m-d", mktime(0, 0, 0, $tempArr[1], $tempArr[0], $tempArr[2]));
	$somdep = $location_expenses->getSommeLastCoutDepens($id,$dt);
	print number_format($somdep,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency);
	print '</td></tr>';

	// Bénéfice (prix total marché - dépense totale)
	$idmarket = $ConstructionSite->market_id;
	$market->fetch($idmarket);
	$FinalAmountTTC = $market->final_amount + ($market->final_amount*$market->tva/100);
	$beneficie = $FinalAmountTTC - $somdep;
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Bénéfice").'</td>';
	print '<td colspan="2">';
	print number_format($beneficie,  2, ",", " ").' '.$langs->getCurrencySymbol($conf->currency);
	print '</td></tr>';
	print '</table>';



	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
            print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('location_expensess'),'','','','',$morejs,$morecss,0,0);

print '<link rel="stylesheet" href= "'.dol_buildpath('/btp/css/fontawesome.css',2).'">';

print_fiche_titre($langs->trans("ListOflocation_expenses"));


	dol_fiche_head('', 'location_expensess', $langs->trans("Listlocation_expenses"), 1, '');
print '<div style="float: right; margin-bottom: 6px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addlocation_expenses').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_num" value="'. $search_num .'" type="hidden" />';
print '<input name="search_datec" value="'. $search_datec .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
print '<input name="search_works_nature" value="'. $search_works_nature .'" type="hidden" />';
print '<input name="search_fuel_recovery" value="'. $search_fuel_recovery .'" type="hidden" />';
print '<input name="search_nbref" value="'. $search_unit_type .'" type="hidden" />';
print '<input name="search_price" value="'. $search_price .'" type="hidden" />';
print '<input name="search_location_rate" value="'. $search_location_rate .'" type="hidden" />';
print '<input name="search_location_qty" value="'. $search_location_qty .'" type="hidden" />';
print '<input name="search_machine" value="'. $search_machine .'" type="hidden" />';
print '<input name="search_tenant" value="'. $search_tenant .'" type="hidden" />';
print '<input name="search_const_site" value="'. $search_const_site .'" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"], "num", '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("datec"),$_SERVER["PHP_SELF"],"datec", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("works_nature"), $_SERVER["PHP_SELF"], 'works_nature', '', '', 'align="center"', $sortfield, $sortorder);
	// print_liste_field_titre($langs->trans("fuel_recovery"), $_SERVER["PHP_SELF"], 'fuel_recovery', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("unit_type"), $_SERVER["PHP_SELF"], 'unit_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"],"price", '','','align="center"',$sortfield,$sortorder);
	// print_liste_field_titre($langs->trans("location_rate"), $_SERVER["PHP_SELF"], 'location_rate', '', '', 'align="center"', $sortfield, $sortorder);
	// print_liste_field_titre($langs->trans("location_qty"), $_SERVER["PHP_SELF"], 'location_qty', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("machine"), $_SERVER["PHP_SELF"], 'machine_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tenant"), $_SERVER["PHP_SELF"], 'tenant_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ConstructionSite"), $_SERVER["PHP_SELF"], 'const_site_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
    // works_nature
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="text"  name="search_works_nature" value="'.$search_works_nature.'">';
	print '</td>';
	// fuel_recovery
	// print '<td class="liste_titre" olspan="1" align="center">';
	// print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_fuel_recovery" value="'.$search_fuel_recovery.'">';
	// print '</td>';
	// unit_type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_unit_type', $unit_type->getNames(), $search_unit_type, 1, 0, 0, 'required="required"');
	print '</td>';
 	// price
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_price" value="'.$search_price.'">';
	// print '</td>';
	// // location_rate
	// print '<td class="liste_titre" olspan="1" align="center">';
	// print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_location_rate" value="'.$search_location_rate.'">';
	// print '</td>';
	// // location_qty
	// print '<td class="liste_titre" olspan="1" align="center">';
	// print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_location_qty" value="'.$search_location_qty.'">';
	// print '</td>';
	// engin
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';
	// tenant
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_tenant,'search_tenant',1);
    print '</td>';
	// const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $ConstructionSite->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($location_expenses->rows)) {
		//$createdBy = new User($db);
		foreach($location_expenses->rows as $obj) {
			  $num 				= $obj->num ;
			  $counter 			= $obj->counter ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $works_nature 	= $obj->works_nature ;
			  $fuel_recovery 	= $obj->fuel_recovery ;
			  $price  			= $obj->price ;
			  // $location_rate 	= $obj->location_rate ;
			  // $location_qty 	= $obj->location_qty ;
			  $machine->fetch($obj->machine_id) ;
			  $ConstructionSite->fetch($obj->const_site_id) ;
			  $unit_type->fetch($obj->unit_type_id) ;
			  $User->fetch($obj->tenant_id);
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $location_expenses->getNomUrl(1,  $obj->id, $num);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center" class="nomchantierwidth" style="white-space:nowrap;">'. $works_nature .'</td>';
			// print '<td align="center">'. $fuel_recovery .'</td>';
			print '<td align="center">'. $unit_type->getNomUrl(1)	 .'</td>';
			print '<td align="center">'. $price .'</td>';
			// print '<td align="center">'. $location_rate .'</td>';
			// print '<td align="center">'. $location_qty .'</td>';
			print '<td align="center" style="white-space:nowrap;">'. $machine->getNomUrl(1).'</td>';
			print '<td align="center">'. $User->getNomUrl(1).'</td>';
			print '<td align="center" class="nomchantierwidth">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="12" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';




}

llxFooter();

$db->close();


?>