<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/location/class/location.class.php');
dol_include_once('/btp/settings/machine_categories/class/MachineCategories.class.php');
dol_include_once('/btp/settings/machine_mark/class/MachineMark.class.php');
dol_include_once('/btp/settings/counter_type/class/CounterType.class.php');


$form 		= new Form($db);
$location     = new location($db);
$User = new User($db);
$machineCategories     = new MachineCategories($db);
$machineMark     = new MachineMark($db);
$counterType     = new CounterType($db);
$var = false;
$filter = '';
$types_locations = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_mat      		= GETPOST('search_mat');
$search_type    		= GETPOST('search_type');
$search_location_rate    		= GETPOST('search_location_rate');
$search_machineCat    		= GETPOST('search_machineCat');
$search_machineMark    		= GETPOST('search_machineMark');
$search_counter    		= GETPOST('search_counter');
$search_tenant    		= GETPOST('search_tenant');
$search_driver    		= GETPOST('search_driver');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_mat      		= '';
$search_type    		= '';
$search_location_rate    		= '';
$search_machineCat    		= '';
$search_machineMark    		= '';
$search_counter    		= '';
$search_tenant    		= '';
$search_driver    		= '';
}
$filter .= (!empty($search_mat) && $search_mat != -1) ? " AND regigster_num = '". $db->escape($search_mat)."'\n" : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND type = '".$db->escape($search_type)."'\n":"";
$filter .= (!empty($search_location_rate) && $search_location_rate != -1) ? " AND location_rate = ".$db->escape($search_location_rate): "";
$filter .= (!empty($search_machineCat) && $search_machineCat != -1) ? " AND machine_cat_id = ".$db->escape($search_machineCat): "";
$filter .= (!empty($search_machineMark) && $search_machineMark != -1) ? " AND machine_mark_id = ".$db->escape($search_machineMark): "";
$filter .= (!empty($search_counter) && $search_counter != -1) ? " AND counter_type_id = ".$db->escape($search_counter): "";
$filter .= (!empty($search_tenant) && $search_tenant != -1) ? " AND tenant_id = ".$db->escape($search_tenant): "";
$filter .= (!empty($search_driver) && $search_driver != -1) ? " AND driver_id = ".$db->escape($search_driver): "";


$getlocations = $location->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getlocations) && $action == "xsl" ) {
$filename="liste_location.xls";
      dol_include_once('/btp/material/location/tpl/location_exl.php');
 die();
 
}
// Si erreur SQL
if ($getlocations == '-1') {
    print_fiche_titre($langs->trans('ListOflocation'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$location->error);
    exit();
}
if ($id > 0) {
	$location->fetch($id);
	llxHeader('', $langs->trans('location'));
	print_fiche_titre($langs->trans("location"));


	print '<table class="border" width="100%">';
	// type
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Type").'</td>';
	print '<td colspan="2">'. $location->type .'</td></tr>';
	// matricule
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("regigster_num").'</td>';
	print '<td colspan="2">'. $location->regigster_num .'</td></tr>';
	// Tarif de location 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("location_rate").'</td>';
	print '<td colspan="2">'. $location->location_rate .'</td></tr>';
	// Engin Categorie 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_cat").'</td>';
    $machineCategories->fetch($location->machine_cat_id);
    print '<td colspan="2">'. $machineCategories->getNomUrl(1) .'</td></tr>';
    // Engin marque 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_mark").'</td>';
    $machineMark->fetch($location->machine_mark_id);
    print '<td colspan="2">'. $machineMark->getNomUrl(1) .'</td></tr>';
    // type compteur 
    print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter_type").'</td>';
    $counterType->fetch($location->counter_type_id);
    print '<td colspan="2">'. $counterType->getNomUrl(1) .'</td></tr>';
    
	// locataire 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("tenant").'</td>';
	$User->fetch($location->tenant_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	// conducteur 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("driver").'</td>';
	$User->fetch($location->driver_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	 if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('locations'));
print_fiche_titre($langs->trans("ListOflocation"));


	dol_fiche_head('', 'locations', $langs->trans("Listlocation"), 1, '');
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addlocation').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_mat" value="'. $search_mat .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="search_location_rate" value="'. $search_location_rate .'" type="hidden" />';
print '<input name="search_machineCat" value="'. $search_machineCat .'" type="hidden" />';
print '<input name="search_machineMark" value="'. $search_machineMark .'" type="hidden" />';
print '<input name="search_counter" value="'. $search_counter .'" type="hidden" />';
print '<input name="search_tenant" value="'. $search_tenant .'" type="hidden" />';
print '<input name="search_driver" value="'. $search_driver .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("regigster_num"), $_SERVER["PHP_SELF"], 'regigster_num', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"],"type", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("location_rate"), $_SERVER["PHP_SELF"], 'location_rate', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("machine_cat"), $_SERVER["PHP_SELF"], 'machine_cat_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("machine_mark"), $_SERVER["PHP_SELF"], 'machine_mark_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("counter_type"), $_SERVER["PHP_SELF"], 'counter_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("tenant"), $_SERVER["PHP_SELF"], 'tenant_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("driver"), $_SERVER["PHP_SELF"], 'driver_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// regigster_num
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_mat" value="'.$search_mat.'">';
	print '</td>';
	// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_type" value="'.$search_type.'">';
	print '</td>';
	 // location_rate
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0" name="search_location_rate" value="'.$search_location_rate.'">';
	print '</td>';
	// tenant
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->selectarray('search_machineCat', $machineCategories->getNames(), $search_machineCat, 1, 0, 0, 'required="required"');
	print '</td>';
    // tenant
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->selectarray('search_machineMark', $machineMark->getNames(), $search_machineMark, 1, 0, 0, 'required="required"');
	print '</td>';
    // tenant
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->selectarray('search_counter', $counterType->getNames(), $search_counter, 1, 0, 0, 'required="required"');
	print '</td>';
    // tenant
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_tenant,'search_tenant',1);
    print '</td>';
    // driver
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_driver,'search_driver',1);
    print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($location->rows)) {
		//$createdBy = new User($db);
		foreach($location->rows as $obj) {
			  $type 			= $obj->type ;
			  $regigster_num 	= $obj->regigster_num ;
			  $location_rate 	= $obj->location_rate ;
			 $machineCategories->fetch($obj->machine_cat_id);
			 $machineMark->fetch($obj->machine_mark_id);
			 $counterType->fetch($obj->counter_type_id);
			  

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $location->getNomUrl(1,  $obj->id, $regigster_num);
			print '</td>';
			 
			print '<td align="center">'.$type.'</td>';
			print '<td align="center">'. $location_rate .'</td>';
			print '<td align="center">'. $machineCategories->getNomUrl(1) .'</td>';
			print '<td align="center">'. $machineMark->getNomUrl(1) .'</td>';
			print '<td align="center">'. $counterType->getNomUrl(1) .'</td>';
			$User->fetch($obj->tenant_id);
			print '<td align="center">'. $User->getNomUrl(1) .'</td>';
			$User->fetch($obj->driver_id);
			print '<td align="center">'. $User->getNomUrl(1) .'</td>';
			print '<td align="center"></td>';
			
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';

}

llxFooter();

$db->close();


?>