<?php
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';

class location extends Commonobject{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();

  public $type;
  public $regigster_num;
  public $location_rate;
  public $machine_mark_id ;
  public $machine_cat_id ;
  public $counter_type_id ;
  public $tenant_id 	;
  public $driver_id ;
  public $created_by ;
  public $created_at ;
  public $updated_at ;
  public $rows = array();

	public $now;
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = date('Y-m-d');//$this->now->format('Y-m-d');
		return 1;
	}


	/**
     *	Return clicable mat (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/btp/material/location/index.php?id='. $id,1) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = '';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        return $result;
    }

    /**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
	  $this->type= $this->type ? $this->db->escape($this->type): null;
	  $this->regigster_num = $this->regigster_num ? $this->db->escape($this->regigster_num): null;
	  $this->location_rate = $this->location_rate ? $this->db->escape($this->location_rate): null;
	  $this->machine_mark_id = $this->machine_mark_id ? $this->db->escape($this->machine_mark_id): null;
	  $this->machine_cat_id = $this->machine_cat_id ? $this->db->escape($this->machine_cat_id): null;
	  $this->counter_type_id = $this->counter_type_id ? $this->db->escape($this->counter_type_id): null;
	  $this->tenant_id = $this->tenant_id ? $this->db->escape($this->tenant_id): null;
	  $this->driver_id = $this->driver_id ? $this->db->escape($this->driver_id): null;
	  $this->created_by = $this->created_by ? $this->db->escape($this->created_by): null;
	  $this->created_at = $this->now;
	// Insert request
	$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . 'location' . ' (type,regigster_num,';
	$sql .= 'location_rate,machine_mark_id,machine_cat_id,';
	$sql .= 'counter_type_id,tenant_id,driver_id,created_by,created_at) ';
	$sql .= 'VALUES ( "'.$this->type.'", "'.$this->regigster_num.'",'.$this->location_rate.',';
	$sql .=	$this->machine_mark_id.', '.$this->machine_cat_id.', '.$this->counter_type_id.',';
	$sql .=	$this->tenant_id.', '.$this->driver_id.',  '.$this->created_by.',';
	$sql .= '"'.$this->created_at.'")'; 
	//die($sql);
	$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error location ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
			die();
			return -1;
		} else {
			$this->db->commit();
			return 1;
			//return $this->getLasInsrtedId();
		}
	}

/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'location';
		
		if (null !== $ref) {
			$sql .= ' WHERE ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}
		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
			  $obj 					= $this->db->fetch_object($resql);
			  $this->id 			= $obj->rowid;
			  $this->type 			= $obj->type ;
			  $this->regigster_num 	= $obj->regigster_num ;
			  $this->location_rate 	= $obj->location_rate ;
			  $this->machine_mark_id = $obj->machine_mark_id ;
			  $this->machine_cat_id = $obj->machine_cat_id ;
			  $this->counter_type_id = $obj->counter_type_id ;
			  $this->tenant_id 	= $obj->tenant_id ;
			  $this->driver_id 		= $obj->driver_id ;
			  $this->created_by 	= $obj->created_by ;
			  $this->created_at 	= $this->db->jdate($obj->created_at);

			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}


	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM '. MAIN_DB_PREFIX . 'location';

		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
					$line->id 			 = $obj->rowid;
				  $line->type 			= $obj->type ;
				  $line->regigster_num 	= $obj->regigster_num ;
				  $line->location_rate 	= $obj->location_rate ;
				  $line->machine_mark_id = $obj->machine_mark_id ;
				  $line->machine_cat_id = $obj->machine_cat_id ;
				  $line->counter_type_id = $obj->counter_type_id ;
				  $line->tenant_id 	= $obj->tenant_id ;
				  $line->driver_id 		= $obj->driver_id ;
				  $line->created_by 	= $obj->created_by ;
				  $line->created_at 	= $this->db->jdate($obj->created_at);
					$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . 'location' . ' SET ';

		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
			$now = new \DateTime("now");
			$now 		 = $now->format('Y-m-d');
			$sql .= '`updated_at` = "'. $now.'"' ;

		//$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}


	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'location' .' WHERE rowid = ' . $this->id;
		$resql 	= $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}



    public function getMats()
    {
    	$this->fetchAll();
    	$camions = array();

    	if (count($this->rows))
    	foreach ($this->rows as $key => $line) {
			$camions[$line->id] = $line->regigster_num;    		
    	}

    	return $camions;
    }

    public function check_mat($mat)
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'location WHERE regigster_num ="'.$mat.'"';
    	$resql 		 = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);
			if($num > 0)
				return true;
			$this->db->free($resql);
    	}

    	return false;
    }

    public function getMat($id)
    {
    	$sql = 'SELECT regigster_num FROM ' . MAIN_DB_PREFIX . 'location WHERE rowid='.$id;
    	$resql = $this->db->query($sql);
    	$mat = '';
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$mat = $obj->regigster_num;
			}
			$this->db->free($resql);
    	}

    	return $mat;
    }

    public function getStatData()
    {
    	global $langs;
    	$this->fetchAll();
    	$countAmount = 0;

    	foreach ($this->rows as $key => $obj)
    		$countAmount += $obj->location_rate;

    	$object 		= new stdClass();
    	$object->number = count($this->rows);
    	$object->cost 	= $countAmount;
    	$object->label 	= $langs->trans('location');
    	$object->url 	= dol_buildpath('/btp/material/location/index.php',1);

    	return $object;
    }

}
?>