<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/location/class/location.class.php');
dol_include_once('/btp/settings/machine_categories/class/MachineCategories.class.php');
dol_include_once('/btp/settings/machine_mark/class/MachineMark.class.php');
dol_include_once('/btp/settings/counter_type/class/CounterType.class.php');


// Get parameters
$User = new User($db);
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$location = new location($db);

    if (!$error) {
          $location->type           = trim(GETPOST('type_'));
          $location->regigster_num  = trim(GETPOST('regigster_num_'));
          $location->location_rate  = trim(GETPOST('location_rate_'));
          $location->machine_mark_id = trim(GETPOST('machine_mark_id_'));
          $location->machine_cat_id = trim(GETPOST('machine_cat_id_'));
          $location->counter_type_id = trim(GETPOST('counter_type_id_'));
          $location->tenant_id   = trim(GETPOST('tenant_id_'));
          $location->driver_id      = trim(GETPOST('driver_id_'));
          $location->created_by     = $user->id;
            //if(!$location->check_mat($location->mat)){
                    $locationID = $location->create();
            
                    // If no SQL error we redirect to the request card
                    if ($locationID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php');
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$location->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$location->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $location_id = (int) GETPOST('location_id', 'int');

    if (!$location_id || $location_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $location = new location($db);
    $location->fetch($location_id);

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $data = array(
          'type'           =>trim(GETPOST('type_')),
          'regigster_num'  =>trim(GETPOST('regigster_num_')),
          'location_rate'  =>trim(GETPOST('location_rate_')),
          'machine_mark_id' =>trim(GETPOST('machine_mark_id_')),
          'machine_cat_id' =>trim(GETPOST('machine_cat_id_')),
          'counter_type_id' =>trim(GETPOST('counter_type_id_')),
          'tenant_id'   =>trim(GETPOST('tenant_id_')),
          'driver_id'     =>trim(GETPOST('driver_id_'))
        );

		$getlocationID = $location->update($location_id, $data);
        
                if ($getlocationID > 0) {
                    header('Location: ./index.php?id='.$location_id);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $location_id .'&action=edit&error=SQL_Create&msg='.$location->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();
	$event  = new location($db);
	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php');
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$location     = new location($db);
$machineCategories     = new MachineCategories($db);
$machineMark     = new MachineMark($db);
$counterType     = new CounterType($db);

$morejs  = array("/btp/js/location.js");
$morecss = array("");

llxHeader(array(), $langs->trans('location'),'','','','',$morejs,$morecss,0,0);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    /*if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {*/
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addlocation'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';



        //catégorie
        print '<tr><td>'.$langs->trans("machine_cat").'</td><td>'; 
        $cat_locations = $machineCategories->getNames();
        print $form->selectarray('machine_cat_id_', $cat_locations,(GETPOST('machine_cat_id_') ? GETPOST('machine_cat_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //MARQUE
        print '<tr><td>'.$langs->trans("machine_mark").'</td><td>'; 
        $mark_locations = $machineMark->getNames();
        print $form->selectarray('machine_mark_id_', $mark_locations,(GETPOST('machine_mark_id_') ? GETPOST('machine_mark_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //type
        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
         print '<input type="text" value="" name="type_" required="required" />';
        print '</td></tr>';


        //matricule
        print '<tr><td class="fieldrequired">'.$langs->trans("regigster_num").'</td><td>';
        print '<input type="text" value="" name="regigster_num_" required="required" />';
        print '</td></tr>';

        //Type compteur 
        print '<tr><td>'.$langs->trans("counter_type").'</td><td>'; 
        $mark_locations = $counterType->getNames();
        print $form->selectarray('counter_type_id_', $mark_locations,(GETPOST('counter_type_id_') ? GETPOST('counter_type_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       

        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("location_rate").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="" name="location_rate_" required="required" />';
        print '</td></tr>';

        //Locataire   
        print '<tr><td class="fieldrequired">'.$langs->trans("tenant").'</td><td>';
        print $form->select_dolusers(null,'tenant_id_');
        print '</td></tr>';

        //Conducteur 
        print '<tr><td>'.$langs->trans("driver").'</td><td>'; 
        print $form->select_dolusers(null,'driver_id_');
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createlocation") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    print_fiche_titre($langs->trans("location"));
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $location->fetch($id);

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'locations', $langs->trans("location"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="location_id" value="'.$id.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';


        //catégorie
        print '<tr><td>'.$langs->trans("machine_cat").'</td><td>'; 
        $cat_locations = $machineCategories->getNames();
        print $form->selectarray('machine_cat_id_', $cat_locations,(GETPOST('machine_cat_id_') ? GETPOST('machine_cat_id_') : $location->machine_cat_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //MARQUE
        print '<tr><td>'.$langs->trans("machine_mark").'</td><td>'; 
        $mark_locations = $machineMark->getNames();
        print $form->selectarray('machine_mark_id_', $mark_locations,(GETPOST('machine_mark_id_') ? GETPOST('machine_mark_id_') : $location->machine_mark_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //type
        print '<tr><td class="fieldrequired">'.$langs->trans("Type").'</td><td>';
         print '<input type="text" value="'.$location->type.'" name="type_" required="required" />';
        print '</td></tr>';

        //matricule
        print '<tr><td class="fieldrequired">'.$langs->trans("regigster_num").'</td><td>';
        print '<input type="text" value="'.$location->regigster_num.'" name="regigster_num_" required="required" />';
        print '</td></tr>';

        //Type compteur 
        print '<tr><td>'.$langs->trans("counter_type").'</td><td>'; 
        $mark_locations = $counterType->getNames();
        print $form->selectarray('counter_type_id_', $mark_locations,(GETPOST('counter_type_id_') ? GETPOST('counter_type_id_') : $location->counter_type_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //Tarif de Location  
        print '<tr><td class="fieldrequired">'.$langs->trans("location_rate").'</td><td>';
        print '<input type="number" step="0.01" min="0" value="'.$location->location_rate.'" name="location_rate_" required="required" />';
        print '</td></tr>';

        //Locataire
        print '<tr><td class="fieldrequired">'.$langs->trans("tenant").'</td><td>';
        print $form->select_dolusers($location->tenant_id,'tenant_id_');
        print '</td></tr>';

        //Conducteur 
        print '<tr><td>'.$langs->trans("driver").'</td><td>'; 
        print $form->select_dolusers($location->driver_id,'driver_id_');
        print '</td></tr>';


                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->btp->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>