<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/intervention_user/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/intervention_user/class/intervention_user.class.php');
dol_include_once('/btp/material/intervention/class/intervention.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/lib/machine.lib.php');



$form 		= new Form($db);
$intervention_user     = new intervention_user($db);
$intervention   = new intervention($db);
$machine     = new machine($db);
$User = new User($db);
$societe     = new Societe($db);


$var = false;
$filter = '';
       
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$iid 	  = GETPOST('iid', 'int');
$action  = GETPOST('action', 'alpha');
$search_bci      		= GETPOST('search_bci');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_user    		= GETPOST('search_user');
$search_intervention    		= GETPOST('search_intervention');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_user    		= '';
$search_intervention    		= '';
}
$filter .= (!empty($search_user) && $search_user != -1) ? " AND user_id = ".$db->escape($search_user):"";
$filter .= " AND intervention_id = ".$iid;


$getintervention_users = $intervention_user->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getintervention_users == '-1') {
    print_fiche_titre($langs->trans('ListOfintervention_user'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$intervention_user->error);
    exit();
}
$intervention->fetch($iid);
$machine->fetch($intervention->machine_id);
if ($id > 0) {
	$intervention_user->fetch($id);
	llxHeader('', $langs->trans('intervention'));
	print_fiche_titre($langs->trans("intervention_user"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'intervention', $langs->trans('intervention'), 0, '');
	//print_fiche_titre($langs->trans("intervention"));

	$intervent  = intervention_prepare_head($intervention);

	dol_fiche_head($intervent, 'intervention_user', $langs->trans("intervention_user"), 0, '');


	print '<table class="border" width="100%">';
	// user 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("user").'</td>';
	$User->fetch($intervention_user->user_id);
	print '<td colspan="2">'. $User->getNomUrl(1).'</td></tr>';
	//intervention
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("intervention").'</td>';
	$intervention->fetch($intervention_user->intervention_id);
	print '<td colspan="2">'. $intervention->getNomUrl(1) .'</td></tr>';*/
	
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?iid='. $iid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&iid='.$iid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&iid='.$iid.'" class="butAction butActionDelete" >'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
        print $form->formconfirm("card.php?id=".$id."&iid=".$iid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
        }
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

//llxHeader('', $langs->trans('intervention_users'),'','','','',$morejs,$morecss,0,0);
//print_fiche_titre($langs->trans("ListOfintervention_user"));
$intervention->fetch($iid);
$machine->fetch($intervention->machine_id);
	llxHeader('', $langs->trans('intervention'));
	print_fiche_titre($langs->trans("ListOfintervention_user"));
	$moreparam = '&mid='.$mid;
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'intervention', $langs->trans('intervention'), 0, '');
	//print_fiche_titre($langs->trans("intervention"));

	$intervent  = intervention_prepare_head($intervention);

	dol_fiche_head($intervent, 'intervention_user', $langs->trans("Listintervention_user"), 0, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="iid" value="'. $iid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'rowid', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("user"), $_SERVER["PHP_SELF"], 'user_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	//print_liste_field_titre($langs->trans("intervention"), $_SERVER["PHP_SELF"], 'intervention_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// user
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// user
	print '<td class="liste_titre" colspan="1" align="center">';
	print $form->select_dolusers($search_user,'search_user',1);
    print '</td>';
	// intervention
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_intervention', $intervention->getNames(), $search_intervention, 1, 0, 0, 'required="required"');
	print '</td>';*/

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($intervention_user->rows)) {
		//$createdBy = new User($db);
		foreach($intervention_user->rows as $obj) {
			  $intervention->fetch($obj->intervention_id) ;
			  $User->fetch($obj->user_id);
			  

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $intervention_user->getNomUrl(1,  $obj->id,$iid, $obj->id);
			print '</td>';
			 
			print '<td align="center">'. $User->getNomUrl(1) .'</td>';
			//print '<td align="center">'. $intervention->getNomUrl(1) .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&iid='.$iid.'" class="butAction">'.$langs->trans('Addintervention_user').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>