<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/intervention_systematic/class/intervention_systematic.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/settings/maintenance/class/Maintenance.class.php');
dol_include_once('/btp/settings/maintenance_point/class/MaintenancePoint.class.php');
dol_include_once('/btp/lib/machine.lib.php');


$form 		= new Form($db);
$intervention_systematic   = new intervention_systematic($db);
$maintenance   = new Maintenance($db);
$machine   = new machine($db);
$maintenance_point   = new MaintenancePoint($db);

$var = false;
$filter = '';
$types_intervention_systematics = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$mid 	  = GETPOST('mid', 'int');
$id 	  = GETPOST('id','int');
$search_machine      		= GETPOST('search_machine');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_counter    		= GETPOST('search_counter');
$search_frequency    		= GETPOST('search_frequency');
$search_alert    		= GETPOST('search_alert');
$search_maintenance    		= GETPOST('search_maintenance');
$search_maintenance_point    		= GETPOST('search_maintenance_point');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_machine      		= '';
$search_datec      		= '';
$search_counter    		= '';
$search_frequency    		= '';
$search_alert    		= '';
$search_maintenance    		= '';
$search_maintenance_point    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= " AND machine_id = ".$mid;
$filter .= (!empty($search_counter) && $search_counter != -1) ? " AND counter = ".$db->escape($search_counter):"";
$filter .= (!empty($search_frequency) && $search_frequency != -1) ? " AND frequency = ".$db->escape($search_frequency): "";
$filter .= (!empty($search_alert) && $search_alert != -1) ? " AND alert = ".$db->escape($search_alert): "";
$filter .= (!empty($search_maintenance) && $search_maintenance != -1) ? " AND maintenance_id = ".$db->escape($search_maintenance): "";
$filter .= (!empty($search_maintenance_point) && $search_maintenance_point != -1) ? " AND maintenance_point_id = ".$db->escape($search_maintenance_point): "";



// Si erreur SQL
if ($getintervention_systematics == '-1') {
    print_fiche_titre($langs->trans('ListOfintervention_systematic'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$intervention_systematic->error);
    exit();
}
if ($id > 0) {
	$intervention_systematic->fetch($id);
	$machine->fetch($intervention_systematic->machine_id);
	llxHeader('', $langs->trans('intervention_systematic'));
	print_fiche_titre($langs->trans("intervention_systematic"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'intervention_systematic', $langs->trans('intervention_systematic'), 0, '');
	//print_fiche_titre($langs->trans("intervention_systematic"));

	$intervention_sys = intervention_sys_prepare_head($intervention_systematic);
	dol_fiche_head($intervention_sys, 'intervention_systematic', $langs->trans("intervention_systematic"), 0, '');
	$html .= '<table class="border" width="100%">';
	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
	print '<table class="border" width="100%">';
	//Engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch($intervention_systematic->machine_id);
	print '<td colspan="2">'. $machine->getNomUrl(1).'</td></tr>';*/
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($intervention_systematic->datec,'day') .'</td></tr>';
	// compteur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("counter").'</td>';
	print '<td colspan="2">'. $intervention_systematic->counter .'</td></tr>';
	// quantité
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("note").'</td>';
	print '<td colspan="2">'. $intervention_systematic->note .'</td></tr>';
	// prix
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("frequency").'</td>';
	print '<td colspan="2">'. $intervention_systematic->frequency .'</td></tr>';
	// heures travaillés 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("alert").'</td>';
	print '<td colspan="2">'. $intervention_systematic->alert .'</td></tr>';
	//maintenance
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("maintenance").'</td>';
	$maintenance->fetch($intervention_systematic->maintenance_id);
	print '<td colspan="2">'. $maintenance->getNomUrl(1) .'</td></tr>';
	//maintenance_point
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("maintenance_point").'</td>';
	$maintenance_point->fetch($intervention_systematic->maintenance_point_id);
	print '<td colspan="2">'. $maintenance_point->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&mid='.$mid.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
            print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
        }
}
else {
$getintervention_systematics = $intervention_systematic->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('intervention_systematic'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfintervention_systematic"));
$machine->fetch($mid);
	$head = material_prepare_head($machine);
   	dol_fiche_head($head, 'intervention_systematic', $langs->trans('ListOfintervention_systematic'), 1, '');
   	$moreparam = '&mid='.$mid;
   	$html .= '<table class="border" width="100%">';
   	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;
	//dol_fiche_head('', 'intervention_systematic', $langs->trans("ListOfintervention_systematic"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="mid" value="'. $mid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"), $_SERVER["PHP_SELF"], 'rowid', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	//print_liste_field_titre($langs->trans("machine"), $_SERVER["PHP_SELF"], 'machine_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("counter"), $_SERVER["PHP_SELF"], 'counter', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("note"),$_SERVER["PHP_SELF"], "note", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("frequency"),$_SERVER["PHP_SELF"],"frequency", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("alert"), $_SERVER["PHP_SELF"], 'alert', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("maintenance"), $_SERVER["PHP_SELF"], 'maintenance_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("maintenance_point"), $_SERVER["PHP_SELF"], 'maintenance_point_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// id
	print '<td class="liste_titre" olspan="1" align="center">';
	print '</td>';
	// engin
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	//date
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
    // counter
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0"  name="search_counter" value="'.$search_counter.'">';
	print '</td>';
	// note
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// frequency
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" step="0.01" min="0"  name="search_frequency" value="'.$search_frequency.'">';
	print '</td>';
	// alert
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0"  name="search_alert" value="'.$search_alert.'">';
	print '</td>';
	// maintenance
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_maintenance', $maintenance->getNames(), $search_maintenance, 1, 0, 0, 'required="required"');
	print '</td>';
	// engin
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_maintenance_point', $maintenance_point->getNames(), $search_maintenance_point, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($intervention_systematic->rows)) {
		//$createdBy = new User($db);
		foreach($intervention_systematic->rows as $obj) {
			  $maintenance_point->fetch($obj->maintenance_point_id) ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $counter 			= $obj->counter ;
			  $note 	   		    = $obj->note ;
			  $frequency 		    = $obj->frequency ;
			  $alert 	= $obj->alert ;
			  $maintenance->fetch($obj->maintenance_id) ;
			  //$machine->fetch($obj->machine_id) ;
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $intervention_systematic->getNomUrl(1,  $obj->id,$mid, $obj->id);
			print '</td>';
			 
			//print '<td align="center">'. $machine->getNomUrl(1) .'</td>';
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $counter .'</td>';
			print '<td align="center">'. $note .'</td>';
			print '<td align="center">'. $frequency .'</td>';
			print '<td align="center">'. $alert .'</td>';
			print '<td align="center">'. $maintenance->getNomUrl(1) .'</td>';
			print '<td align="center">'. $maintenance_point->getNomUrl(1) .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='.$mid.'" class="butAction">'.$langs->trans('Addintervention_systematic').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>