<?php 
/* Copyright (C) 2016		Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/list.php
 *		\ingroup    list
 *		\brief      Gestion des marches
 */

$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/fuel_consoma/class/fuel_consoma.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/material/fuel/class/fuel.class.php');
dol_include_once('/btp/lib/machine.lib.php');


// Get parameters
$action  = GETPOST('action', 'alpha');
$id 	 = GETPOST('id', 'int');
$mid      = GETPOST('mid', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

//$langs->load('marches');
// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$now 	= new DateTime('now');
$now       = $now->format('Y-m-d');
$form       = new Form($db);
$error 	= false;

if ($action == 'create' && $request_method === 'POST') {
	$fuel_consoma = new fuel_consoma($db);

    if (!$error) {
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $fuel_consoma->datec         = $ety.'-'.$etm.'-'.$etd ;
        }
          $fuel_consoma->counter        = trim(GETPOST('counter_'));
          $fuel_consoma->num            = trim(GETPOST('num_'));
          $fuel_consoma->price          = trim(GETPOST('price_'));
          $fuel_consoma->qty            = trim(GETPOST('qty_'));
          $fuel_consoma->hours_worked   = trim(GETPOST('hours_worked_'));
          $fuel_consoma->hours_rate     = trim(GETPOST('hours_rate_'));
          $fuel_consoma->fuel_id        = trim(GETPOST('fuel_id_'));
          $fuel_consoma->machine_id     = (int)$mid;
          $fuel_consoma->const_site_id  = trim(GETPOST('const_site_id_'));
          $fuel_consoma->created_by     = $user->id;
            //if(!$fuel_consoma->check_mat($fuel_consoma->mat)){
                    $fuel_consomaID = $fuel_consoma->create();
            
                    // If no SQL error we redirect to the request card
                    if ($fuel_consomaID > 0) {
                        //header('Location: index.php?id='.$getMarcheID);
                        header('Location: index.php?mid='.$mid);
                        exit;
                    } else {
                        // Otherwise we display the request form with the SQL error message
                        header('Location: card.php?action=request&error=SQL_Create&msg='.$fuel_consoma->error);
                        exit;
                    }
               /* }
            else{
                $msg ='Cette marticule '.$fuel_consoma->mat.' est deja saisée !';
                 header('Location: card.php?action=request&error=SQL_Create&msg='.$msg);
                        exit;
            }*/
    }
}

if ($action == 'update' && $request_method === 'POST') {
    // If no right to modify a request
    /*if (!$user->rights->btp->write) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }*/

    $fuel_consoma_id = (int) GETPOST('fuel_consoma_id', 'int');

    if (!$fuel_consoma_id || $fuel_consoma_id <= 0) {
        header('Location: ./card.php?action=request&error=CantUpdate');
        exit;
    }

    $fuel_consoma = new fuel_consoma($db);
    $fuel_consoma->fetch($fuel_consoma_id);

   // $canedit = ($user->rights->btp->write || $user->rights->btp->write_all);
    $canedit = true ; 


    // If this is the requestor or has read/write rights
    if ($canedit) {
        $datec = '';
        if (isset($_POST['datec_']) && !empty($_POST['datec_'])) {
            list($etd, $etm, $ety) = explode("/", $_POST['datec_']);
            $datec         = $ety.'-'.$etm.'-'.$etd ;
        }
        $data = array(
          'datec'  =>$datec,
          'counter'           =>trim(GETPOST('counter_')),
          'num'    =>trim(GETPOST('num_')),
          'price' =>trim(GETPOST('price_')),
          'qty'  =>trim(GETPOST('qty_')),
          'hours_worked'      =>trim(GETPOST('hours_worked_')),
          'hours_rate' =>trim(GETPOST('hours_rate_')),
          'fuel_id' =>trim(GETPOST('fuel_id_')),
          'machine_id' =>(int)$mid,
          'const_site_id'  =>trim(GETPOST('const_site_id_')),
          'updated_at'    =>$now
        );

		$getfuel_consomaID = $fuel_consoma->update($fuel_consoma_id, $data);
        
                if ($getfuel_consomaID > 0) {
                    header('Location: ./index.php?id='.$fuel_consoma_id.'&mid='.$mid);
                    exit;
                } else {
                    // Otherwise we display the request form with the SQL error message
                    header('Location: ./card.php?id='. $fuel_consoma_id .'&action=edit&error=SQL_Create&msg='.$fuel_consoma->error);
                    exit;
                } 
    }
}

// If delete of request
if ($action == 'confirm_delete' && GETPOST('confirm') == 'yes' ) {
	$error=0;

	//$db->begin();

	$event  = new fuel_consoma($db);
	//$canedit = ($user->rights->btp->write_all || $user->rights->btp->delete);
    $canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $event->fetch($id);
		$event->delete();
	}
	else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		//$db->commit();
		header('Location: index.php?mid='.$mid);
		exit;
	}
	else {
		
        header('Location: index.php?leftmenu=marches');
        exit;
	}
}

/*
 * View
 */

$form      = new Form($db);
$fuel_consoma     = new fuel_consoma($db);
$fuel     = new fuel($db);
$ConstructionSite     = new ConstructionSite($db);
$machine     = new machine($db);

$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader(array(), $langs->trans('fuel_consoma'),'','','','',$morejs,$morecss,0,0);
$machine->fetch($mid);
        $head = material_prepare_head($machine);
        dol_fiche_head($head, 'fuel_consoma', $langs->trans('fuel_consoma'), 0, '');
        $html = '<table class="border" width="100%">';
        $html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	
        // Formulaire appel d'offre
        print_fiche_titre($langs->trans('Addfuel_consoma'));

        // Si il y a une erreur
        if (GETPOST('error')) {
            switch(GETPOST('error')) {
                case 'nobudget' :
                    $errors[] = $langs->trans('errorNoBudget');
                    break;
                case 'SQL_Create' :
                    $errors[] = $langs->trans('ErrorSQLCreateCP').' <b>'.htmlentities($_GET['msg']).'</b>';
                    break;
                case 'CantCreate' :
                    $errors[] = $langs->trans('CantCreateCP');
                    break;
                case 'nouser' :
                    $errors[] = $langs->trans('errorNoUser');
                    break;
                case 'nodatedebut' :
                    $errors[] = $langs->trans('NoDateDebut');
                    break;
                case 'nobank' :
                    $errors[] = $langs->trans('errorNoBank');
                    break;
                case 'noqc' :
                    $errors[] = $langs->trans('errorNoQc');
                    break;
                case 'alreadyExists' :
                    $errors[] = $langs->trans('alreadyExistAO');
                    break;
                case 'noref' :
                    $errors[] = $langs->trans('errorNoRef');
                    break;
            }

	        setEventMessage($errors, 'errors');
        }

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?mid='.$mid.'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        
        print '<table class="border" width="100%">';
        print '<tbody>';



        //catégorie
        print '<tr><td>'.$langs->trans("fuel").'</td><td>'; 
        $cat_fuel_consomas = array(1 => 'cat1', 2 => 'cat2');
        print $form->selectarray('fuel_id_', $cat_fuel_consomas,(GETPOST('fuel_id_') ? GETPOST('fuel_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //tarif de l'heure 
        print '<tr><td>'.$langs->trans("hours_rate").'</td><td>'; 
        print '<input type="number" step="0.01" min="0" value="" name="hours_rate_" required="required" />';
        print '</td></tr>';

       //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //Compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("counter").'</td><td>';
        print '<input type="text" value="" name="counter_" required="required" />';
        print '</td></tr>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="number" min="0" value="" name="num_" required="required" />';
        print '</td></tr>';

        //Engin 
        /*print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $mark_fuel_consomas = $machine->getMats();
        print $form->selectarray('machine_id_', $mark_fuel_consomas,(GETPOST('machine_id_') ? GETPOST('machine_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

       //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" step="0.01" min="0"  value="" name="price_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0"  value="" name="qty_" required="required" />';
        print '</td></tr>';

        //Heures Travaillés  
        print '<tr><td class="fieldrequired">'.$langs->trans("hours_worked").'</td><td>';
        print '<input type="number" value="" name="hours_worked_" required="required" />';
        print '</td></tr>';


        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites = $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : null), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        
        print '</tbody>';
        print '</table>';

        print '<div class="center">';
        print '<input type="submit" value="'. $langs->trans("Createfuel_consoma") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';
        print '</form>';
    //}
}
else {
    if ($error) {
        print '<div class="tabBar">';
        print $error;
        print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
        print '</div>';
    }
    else {
        // Affichage de la fiche d'une demande de congés payés

        if ($id > 0) {
            $fuel_consoma->fetch($id);

			//$canedit = ($user->rights->btp->delete || $user->rights->btp->write_all);

            // Si il y a une erreur
            if (GETPOST('error')) {
                switch(GETPOST('error')) {
                    case 'datefin' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorEndDateCP');
                        break;
                    case 'SQL_Create' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorSQLCreateCP').' '.$_GET['msg'];
                        break;
                    case 'CantCreate' :
                        $errors[] = $langs->transnoentitiesnoconv('CantCreateCP');
                        break;
                    case 'Valideur' :
                        $errors[] = $langs->transnoentitiesnoconv('InvalidValidatorCP');
                        break;
                    case 'nodatedebut' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateDebut');
                        break;
                    case 'nodatefin' :
                        $errors[] = $langs->transnoentitiesnoconv('NoDateFin');
                        break;
                    case 'DureeHoliday' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorDureeCP');
                        break;
                    case 'NoMotifRefuse' :
                        $errors[] = $langs->transnoentitiesnoconv('NoMotifRefuseCP');
                        break;
                    case 'mail' :
                        $errors[] = $langs->transnoentitiesnoconv('ErrorMailNotSend')."\n".$_GET['error_content'];
                        break;
                }

	            setEventMessage($errors, 'errors');
            }

            // On vérifie si l'utilisateur à le droit de lire cette demande
           // if ($canedit) {

                // Si annulation de la demande
                if ($action == 'cancel') {
                    print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleCancelSC"), $langs->trans("ConfirmCancelSC"),"confirm_cancel", '', 1, 1);
                }

                dol_fiche_head('', 'fuel_consomas', $langs->trans("fuel_consoma"), 0, '');

                if ($action == 'edit') {
                    $edit = true;
                    print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?id='.$id.'&mid='.$mid.'">'."\n";
                    print '<input type="hidden" name="action" value="update" />'."\n";
                    print '<input type="hidden" name="fuel_consoma_id" value="'.$id.'" />'."\n";
                    print '<input type="hidden" name="mid" value="'.$mid.'" />'."\n";

                    print '<table class="border" width="100%">';
                    print '<tbody>';


        //catégorie
        print '<tr><td>'.$langs->trans("fuel").'</td><td>'; 
        $cat_fuel_consomas = array(1 => 'cat1', 2 => 'cat2');
        print $form->selectarray('fuel_id_', $cat_fuel_consomas,(GETPOST('fuel_id_') ? GETPOST('fuel_id_') : $fuel_consoma->fuel_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

        //tarif de l'heure 
        print '<tr><td>'.$langs->trans("hours_rate").'</td><td>'; 
        print '<input type="number" step="0.01" min="0"  value="'.$fuel_consoma->hours_rate.'" name="hours_rate_" required="required" />';
        print '</td></tr>';

        //date
        print '<tr><td class="fieldrequired">'.$langs->trans("datec").'</td><td>';
        print '<input type="text" value="'.dol_print_date($fuel_consoma->datec,'day').'" class="datepicker" autocomplete="off"  name="datec_" required="required" readonly="readonly" /> ';
        print '</td></tr>';

        //Compteur
        print '<tr><td class="fieldrequired">'.$langs->trans("counter").'</td><td>';
        print '<input type="text" value="'.$fuel_consoma->counter.'" name="counter_" required="required" />';
        print '</td></tr>';

        //Numéro
        print '<tr><td class="fieldrequired">'.$langs->trans("num").'</td><td>';
        print '<input type="number" min="0" value="'.$fuel_consoma->num.'" name="num_" required="required" />';
        print '</td></tr>';

        //Engin 
        /*print '<tr><td>'.$langs->trans("machine").'</td><td>'; 
        $mark_fuel_consomas = $machine->getMats();
        print $form->selectarray('machine_id_', $mark_fuel_consomas,(GETPOST('machine_id_') ? GETPOST('machine_id_') : $fuel_consoma->machine_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';*/

       //Prix 
        print '<tr><td class="fieldrequired">'.$langs->trans("price").'</td><td>';
        print '<input type="number" step="0.01" min="0"  value="'.$fuel_consoma->price.'" name="price_" required="required" />';
        print '</td></tr>';

        //Quantité  
        print '<tr><td class="fieldrequired">'.$langs->trans("qty").'</td><td>';
        print '<input type="number" min="0"  value="'.$fuel_consoma->qty.'" name="qty_" required="required" />';
        print '</td></tr>';

        //Heures Travaillés  
        print '<tr><td class="fieldrequired">'.$langs->trans("hours_worked").'</td><td>';
        print '<input type="number" step="0.01" min="0" min="0"  value="'.$fuel_consoma->hours_worked.'" name="hours_worked_" required="required" />';
        print '</td></tr>';


        //Chantier 
        print '<tr><td>'.$langs->trans("const_site").'</td><td>'; 
        $const_sites =  $ConstructionSite->getNames();
        print $form->selectarray('const_site_id_', $const_sites,(GETPOST('const_site_id_') ? GETPOST('const_site_id_') : $fuel_consoma->const_site_id), 0, 0, 0, 'required="required"');
        print '</td></tr>';

       


                    print '</tbody>';
                    print '</table>';

                    print '<div class="center">';
                    print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '&nbsp; &nbsp; ';
                    print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
                    print '</div>';
                    print '</table>';
                }

                dol_fiche_end();

                if (!$edit) {
		            print '<div class="tabsAction">';

                    // Boutons d'actions
                    //if ($canedit) {
                        print '<a href="card.php?id='.$_GET['id'].'&action=edit" class="butAction">'.$langs->trans("Modify").'</a>';
                    //}

                    // If draft
                   // if ($user->rights->btp->delete)	{
                    	print '<a href="card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                   // }

                    print '</div>';
                }

        } else {
                
                print '<div class="tabBar">';
                print $langs->trans('ErrorUserViewSC');
                print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
                print '</div>';
            }

        /*} else {
            print '<div class="tabBar">';
            print $langs->trans('ErrorIDFicheSC');
            print '<br /><br /><input type="button" value="'.$langs->trans("ReturnSC").'" class="butAction" onclick="history.go(-1)" />';
            print '</div>';
        }*/

    }

}

// End of page
llxFooter();

if (is_object($db)) $db->close();

?>