<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/fuel/class/fuel.class.php');
dol_include_once('/btp/settings/fuel_type/class/FuelType.class.php');

$form 		= new Form($db);
$fuel   = new fuel($db);
$fuel_type   = new FuelType($db);
$var = false;
$filter = '';
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$id 	  = GETPOST('id','int');
$search_price      		= GETPOST('search_price');
$search_type    		= GETPOST('search_type');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_price      		= '';
$search_type    		= '';
}
$filter .= (!empty($search_price) && $search_price != -1) ? " AND price LIKE ". $db->escape($search_price): "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND fuel_type_id = ".$db->escape($search_type):"";


$getfuels = $fuel->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);
if (!empty($getfuels) && $action == "xsl" ) {
$filename="liste_fuel.xls";
      dol_include_once('/btp/material/fuel/tpl/fuel_exl.php');
 die();
 
}
// Si erreur SQL
if ($getfuels == '-1') {
    print_fiche_titre($langs->trans('ListOffuel'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$fuel->error);
    exit();
}
if ($id > 0) {
	$fuel->fetch($id);
	llxHeader('', $langs->trans('fuel'));
	print_fiche_titre($langs->trans("fuel"));


	print '<table class="border" width="100%">';
	
	// prix
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("price").'</td>';
	print '<td colspan="2">'. $fuel->price .'</td></tr>';
	// type 
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("fuel_type").'</td>';
	$fuel_type->fetch($fuel->fuel_type_id);
	print '<td colspan="2">'.$fuel_type->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                        print $form->formconfirm("card.php?id=".$id, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {

 // Both test are required to be compatible with all browsers

llxHeader('', $langs->trans('fuel'));
print_fiche_titre($langs->trans("ListOffuel"));


	dol_fiche_head('', 'fuel', $langs->trans("ListOffuel"), 1, '');
print '<div style="float: right; margin-bottom: 4px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addfuel').'</a>';
		print '</div>';
print '<div style="float: right; ">';
	   print '<form method="post" action="'.$_SERVER["PHP_SELF"].'">'."\n";
print '<input name="search_price" value="'. $search_price .'" type="hidden" />';
print '<input name="search_type" value="'. $search_type .'" type="hidden" />';
print '<input name="action" value="xsl" type="hidden" />';
	    print '<button style="margin-bottom: 8px;" class="butAction" name="submit" value="Exporter Excel">'.$langs->trans('Exporter Excel').'</button>';
	   print '</form>'."\n";
		print '</div>';    
	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("ref"),$_SERVER["PHP_SELF"],"rowid", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("price"),$_SERVER["PHP_SELF"],"price", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("fuel_type"), $_SERVER["PHP_SELF"], 'fuel_type_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	//id
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	// price
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="number" min="0" step="0.01" size="14" name="search_price" value="'.$search_price.'">';
	print '</td>';

	// type
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_type', $fuel_type->getNames(), $search_type, 1, 0, 0, 'required="required"');
	print '</td>';


	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($fuel->rows)) {
		//$createdBy = new User($db);
		foreach($fuel->rows as $obj) {
			  $price 		    = $obj->price ;
			  $fuel_type->fetch($obj->fuel_type_id) ;
			  

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $fuel->getNomUrl(1,  $obj->id, $obj->id);
			print '</td>';
			 
			print '<td align="center">'. $price .'</td>';
			print '<td align="center">'. $fuel_type->getNomUrl(1).'</td>';
			print '<td align="center"></td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


}

llxFooter();

$db->close();


?>