<?php
/* Copyright (C) 2016	Souieh Laghdaf	<laghdaf.souieh@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       /material/defect_machine/index.php
 * \ingroup    list
 * \brief      List of location expensess
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/defect_machine/class/defect_machine.class.php');
dol_include_once('/btp/material/machine/class/machine.class.php');
dol_include_once('/btp/market/construction_site/class/construction_site.class.php');
dol_include_once('/btp/lib/machine.lib.php');


$form 		= new Form($db);
$defect_machine     = new defect_machine($db);
$machine     = new machine($db);
$ConstructionSite   = new ConstructionSite($db);

$var = false;
$filter = '';
$counters_defect_machines = array(1 => $langs->trans('track'), 2 => $langs->trans('other'));
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$action  = GETPOST('action', 'alpha');
$mid 	  = GETPOST('mid', 'int');
$id 	  = GETPOST('id','int');
$search_machine_status      		= GETPOST('search_machine_status');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_machine    		= GETPOST('search_machine');
$search_const_site    		= GETPOST('search_const_site');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_machine_status      		= '';
$search_datec      		= '';
$search_machine    		= '';
$search_const_site    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_machine_status) && $search_machine_status != -1) ? " AND machine_status = '". $db->escape($search_machine_status)."'\n" : "";
$filter .= " AND machine_id = ".$mid;
$filter .= (!empty($search_const_site) && $search_const_site != -1) ? " AND const_site_id = '".$db->escape($search_const_site)."'\n" : "";



// Si erreur SQL
if ($getdefect_machines == '-1') {
    print_fiche_titre($langs->trans('ListOfdefect_machine'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$defect_machine->error);
    exit();
}
if ($id > 0) {
	$defect_machine->fetch($id);
	//llxHeader('', $langs->trans('defect_machine'));
	//print_fiche_titre($langs->trans("defect_machine"));
	$machine->fetch($defect_machine->machine_id);
	llxHeader('', $langs->trans('defect_machine'));
	print_fiche_titre($langs->trans("defect_machine"));
	$head  		= material_prepare_head($machine);
	dol_fiche_head($head, 'defect_machine', $langs->trans('defect_machine'), 0, '');
   	//print_fiche_titre($langs->trans("defect_machine"));

   	$defect  = defect_prepare_head($defect_machine);
	dol_fiche_head($defect, 'defect_machine', $langs->trans("defect_machine"), 0, '');
	$html .= '<table class="border" width="100%">';
	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;

	print '<table class="border" width="100%">';
	// description
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("description").'</td>';
	print '<td colspan="2">'. $defect_machine->description .'</td></tr>';
	// datec
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($defect_machine->datec,'day') .'</td></tr>';
	// matricule
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine_status").'</td>';
	print '<td colspan="2">'. $defect_machine->machine_status .'</td></tr>';
		// Engin
	/*print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("machine").'</td>';
	$machine->fetch();
	print '<td colspan="2">'. $machine->getNomUrl(1) .'</td></tr>';*/
	//chantier
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("ConstructionSite").'</td>';
	$ConstructionSite->fetch($defect_machine->const_site_id);
	print '<td colspan="2">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td></tr>';
	
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'&mid='.$mid.'" class="butAction">'.$langs->trans('Modify').'</a>';
		print '<a href="./index.php?action=delete&id='. $id .'&mid='.$mid.'" class="butAction butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
	if ($action == 'delete') {
                    print $form->formconfirm("card.php?id=".$id."&mid=".$mid, $langs->trans("TitleDelete"),$langs->trans("ConfirmDelete"),"confirm_delete", '', 0, 1);
                }
}
else {
	$getdefect_machines = $defect_machine->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);


 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('defect_machines'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfdefect_machine"));
	$machine->fetch($mid);
	$head = material_prepare_head($machine);
   	dol_fiche_head($head, 'defect_machine', $langs->trans('Listdefect_machine'), 1, '');
   	$moreparam = '&mid='.$mid;
   	$html .= '<table class="border" width="100%">';
	$html .= '<tr><td width="25%">'.$langs->trans("code").'</td>';
        $html .= '<td colspan="2">'. $machine->code .'</td></tr>';
        $html .= '<tr><td width="25%">'.$langs->trans("regigster_num").'</td>';
        $html .= '<td colspan="2">'. $machine->regigster_num .'</td></tr>';
    $html .= '</table><br />';
    echo $html;

	//dol_fiche_head('', 'defect_machines', $langs->trans("Listdefect_machine"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<input name="mid" value="'. $mid .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("description"), $_SERVER["PHP_SELF"], 'description', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("datec"),$_SERVER["PHP_SELF"],"datec", '',$moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("machine_status"), $_SERVER["PHP_SELF"], 'machine_status', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	//print_liste_field_titre($langs->trans("machine"), $_SERVER["PHP_SELF"], 'machine_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("ConstructionSite"), $_SERVER["PHP_SELF"], 'const_site_id', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'',$moreparam,'',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// description
	print '<td class="liste_titre" colspan="1" align="center">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// machine_status
	print '<td class="liste_titre" colspan="1" align="center">';
	print '<input class="flat" type="text" size="14" name="search_machine_status" value="'.$search_machine_status.'">';
	print '</td>';
	// engin
	/*print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_machine', $machine->getMats(), $search_machine, 1, 0, 0, 'required="required"');
	print '</td>';*/
	// const_site
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site', $ConstructionSite->getNames(), $search_const_site, 1, 0, 0, 'required="required"');
	print '</td>';

	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($defect_machine->rows)) {
		//$createdBy = new User($db);
		foreach($defect_machine->rows as $obj) {
			  $datec 			= dol_print_date($obj->datec,'day') ;
			  $machine_status 	= $obj->machine_status ;
			  $description 				= $obj->description ;
			  //$machine->fetch($obj->machine_id) ;
			  $ConstructionSite->fetch($obj->const_site_id) ;
			  
			

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $defect_machine->getNomUrl(1,  $obj->id,$mid, $description);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			print '<td align="center">'. $machine_status .'</td>';
			//print '<td align="center">'. $machine->getNomUrl(1) .'</td>';
			print '<td align="center">'. $ConstructionSite->getNomUrl(1,$ConstructionSite->id,$ConstructionSite->name,$ConstructionSite->market_id) .'</td>';

			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&mid='.$mid.'" class="butAction">'.$langs->trans('Adddefect_machine').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>