<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres/index.php
 * \ingroup    list
 * \brief      List of markets
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
dol_include_once('/btp/material/const_site_diposals/class/const_site_diposals.class.php');
dol_include_once('/btp/material/constraction_site/class/constraction_site.class.php');

$form 		= new Form($db);
$const_site_diposals   = new const_site_diposals($db);
$constraction_site   = new constraction_site($db);

$var = false;
$filter = '';
$types_const_site_diposalss = array(1 => 'Entree', 2 =>'Sortie');
$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";
$id 	  = GETPOST('id','int');
$search_num      		= GETPOST('search_num');
$search_datec      		= "";
if (GETPOST('search_datec') !=="") {
    list($etd, $etm, $ety) = explode("/", GETPOST('search_datec'));
    $search_datec         = $ety.'-'.$etm.'-'.$etd ;
}
$search_const_site_destin    		= GETPOST('search_const_site_destin');
$search_const_site_sender    		= GETPOST('search_const_site_sender');
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
$search_num      		= '';
$search_datec      		= '';
$search_const_site_destin    		= '';
$search_const_site_sender    		= '';
}
$filter .= (!empty($search_datec) && $search_datec != -1) ? " AND datec = '". $db->escape($search_datec)."'\n" : "";
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = ".$db->escape($search_num):"";
$filter .= (!empty($search_const_site_destin) && $search_const_site_destin != -1) ? " AND const_site_destin_id = ".$db->escape($search_const_site_destin) : "";
$filter .= (!empty($search_const_site_sender) && $search_const_site_destin != -1) ? " AND const_site_sender_id = ".$db->escape($search_const_site_sender) : "";


$getconst_site_diposalss = $const_site_diposals->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getconst_site_diposalss == '-1') {
    print_fiche_titre($langs->trans('ListOfconst_site_diposals'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$const_site_diposals->error);
    exit();
}
if ($id > 0) {
	$const_site_diposals->fetch($id);
	llxHeader('', $langs->trans('const_site_diposals'));
	print_fiche_titre($langs->trans("const_site_diposals"));


	print '<table class="border" width="100%">';
	// num
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("num").'</td>';
	print '<td colspan="2">'. $const_site_diposals->num .'</td></tr>';
	// date
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("datec").'</td>';
	print '<td colspan="2">'. dol_print_date($const_site_diposals->datec,'day') .'</td></tr>';
	// chantier destinataire
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_destin").'</td>';
	$constraction_site->fetch($const_site_diposals->const_site_destin_id);
	print '<td colspan="2">'. $constraction_site->getNomUrl(1) .'</td></tr>';
	//chantier émeteur
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("const_site_sender").'</td>';
	$constraction_site->fetch($const_site_diposals->const_site_sender_id);
	print '<td colspan="2">'. $constraction_site->getNomUrl(1) .'</td></tr>';
	
	print '</table>';
	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?mid='. $mid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
	print '</div>';
}
else {

 // Both test are required to be compatible with all browsers
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/btp/js/jquery/timepicker/timepicker-fr.js","/btp/js/fuel_consoma.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css");

llxHeader('', $langs->trans('const_site_diposals'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans("ListOfconst_site_diposals"));


	dol_fiche_head('', 'const_site_diposals', $langs->trans("ListOfconst_site_diposals"), 1, '');

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("num"),$_SERVER["PHP_SELF"],"num", '','','align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("datec"), $_SERVER["PHP_SELF"], 'datec', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("const_site_destin"), $_SERVER["PHP_SELF"], 'const_site_destin_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("const_site_sender"), $_SERVER["PHP_SELF"], 'const_site_sender_id', '', '', 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	// num
	print '<td class="liste_titre" olspan="1" align="center">';
	print '<input class="flat" style="width: 85px"  type="number" min="0" name="search_num" value="'.$search_num.'">';
	print '</td>';
	//datec
	print '<td class="liste_titre" olspan="1" align="center">';
    print '<input type="text" value="'.dol_print_date($search_datec,'day').'" class="datepicker" autocomplete="off"  name="search_datec"  readonly="readonly" /> ';
    print '</td>';
	// const_site_destin
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site_destin', $constraction_site->getNames(), $search_const_site_destin, 1, 0, 0, 'required="required"');
	print '</td>';
	// const_site_sender
	print '<td class="liste_titre" olspan="1" align="center">';
	print $form->selectarray('search_const_site_sender', $constraction_site->getNames(), $search_const_site_sender, 1, 0, 0, 'required="required"');
	print '</td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($const_site_diposals->rows)) {
		//$createdBy = new User($db);
		foreach($const_site_diposals->rows as $obj) {
			  $num 				= $obj->num ;
			  $datec 			= dol_print_date($obj->datec,'day') ;
			 

			print '<tr '.$bc[$var].'>';
			print '<td align="left" style ="white-space: nowrap;">';
				print $const_site_diposals->getNomUrl(1,  $obj->id, $num);
			print '</td>';
			 
			print '<td align="center">'. $datec .'</td>';
			$constraction_site->fetch($obj->const_site_destin_id) ;
			print '<td align="center">'. $constraction_site->getNomUrl(1) .'</td>';
			$constraction_site->fetch($obj->const_site_sender_id);
			print '<td align="center">'. $constraction_site->getNomUrl(1) .'</td>';

			print '<td><div style="float: right; margin-top: 8px;">';
			print '<a href="./card.php?action=delete&id='. $obj->id .'" >'.$langs->trans('Delete').'</a>';
			print '</div></td>';
			print '</tr>'."\n";

		}
	} else {
		print '<tr>';
	    print '<td colspan="9" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	print '</table>';
	print '</form>';


		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('Addconst_site_diposals').'</a>';
		print '</div>';


}

llxFooter();

$db->close();


?>