<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_supplies/index.php
 * \ingroup    list
 * \brief      List of work_supplies
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_metres/class/work_metres.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');

// Protection if external user
if (!$user) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (!$sortfield) $sortfield = "rowid";
if (!$sortorder) $sortorder = "DESC";
$fuser 	 = new User($db);

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');
$wid 	  = GETPOST('wid','int');
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');

if (!$wid)
	die("ID de travaux n'existe pas!");

$search_ref       		 = GETPOST('search_ref');
$search_mdate 		 = GETPOST('search_mdate');
$search_par        = GETPOST('search_par');
$search_qty      = GETPOST('search_qty');
$search_num		 = GETPOST('search_num');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref   	 	= "";
	$search_par   = "";
	$search_num 	= "";
    $search_qty = "";
	$search_mdate	= "";
}

$object  = new MarketWorkMetres($db);
$works   = new MarketWorks($db);
$market  = new Market($db);

llxHeader(array(), $langs->trans('Metres'), '', '', '', '', array('/btp/js/btp.js'));

// Filter
$filter .= (!empty($search_ref)) ? " AND rowid = ". $db->escape((int)$search_ref) : "";
$filter .= (isset($search_qty) && !empty($search_qty)) ? " AND qty = ". $db->escape((int)$search_qty) : '';
$filter .= isset($search_num) && !empty($search_num) ? " AND num = '". $db->escape($search_num) ."'" : '';
$filter .= (!empty($search_par) && $search_par != -1) ? " AND  fk_createdby= ". $db->escape((int)$search_par) : "";
if (isset($search_mdate) && !empty($search_mdate))
	$filter .=  " AND mdate = '". $db->escape(Tools::convertDateTo($search_mdate, 'sql'))  ."'";
//$filter .= (!empty($search_mdate)) ? " AND mdate = '". $db->escape($search_mdate) ."'" : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$getwork_metres = $object->fetchAll($wid, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getwork_metres == '-1') {
    print_fiche_titre($langs->trans('Metres'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$object->error);
    exit();
}

// Show table of vacations
$var  = true;
$num  = count($object->lines);
$form = new FormChild($db);

// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);
if ($id > 0) {
	$object->fetch($id);
	
	print_barre_liste($langs->trans("Metres"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');

	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');
	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
	$work_Head  = market_works_metre_prepare_head($object);
	dol_fiche_head($work_Head,'', $langs->trans("Metres"), 0, 'submunu1');
	$qty 	= $object->qty ? $object->qty : '';
	$cree	= $object->fk_createdby ? $object->fk_createdby : '';
	$num		= $object->num ? $object->num : '';
	$mdate = $object->mdate ? dol_print_date($object->mdate, 'day'): '';
		$fuser->fetch($object->fk_createdby);

	print '<table class="border" width="100%">';
	print '<tr><td class="">'.$langs->trans("Créé par").'</td>';
	print '<td colspan="2">'. $fuser->getNomUrl('1') .'</td></tr>';

	// Numero
	print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Numéro").'</td>';
	print '<td colspan="2">'.$num.'</td></tr>';

	// quantity
	print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td>';
	print '<td colspan="2">'. $qty .'</td></tr>';

	
	// date
	print '<tr><td class="">'.$langs->trans("Date").'</td>';
	print '<td colspan="2">'. $mdate .'</td></tr>';

	// ChargesMetres
	

	print '</table>';

	print '<br>';
	print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./index.php?wid='. $wid .'" class="butAction">'.$langs->trans('Cancel').'</a>';
	if ($user->id/* && $user->rights->btp->write_all*/) {
		print '<a href="./card.php?action=edit&id='. $id .'&wid='. $wid .'" class="butAction">'.$langs->trans('Modify').'</a>';

		// if ($user->rights->btp->delete)	{
        	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
        // }
		if ($action == 'delete') {
            // if($user->rights->btp->delete) {
				$work_Head  = market_works_metre_prepare_head($work_metresHead);
		dol_fiche_head($work_Head, 'metres', $langs->trans("Metres"), 0, 'submunu3');
            print $form->formconfirm("./card.php?wid=".$wid."&id=".$id, $langs->trans("TitleDeleteMetre"), $langs->trans("ConfirmDeleteMetre"), "confirm_delete", '', 0, 1);
                // }
        }
	}
	print '</div>';
}
else {
	print_barre_liste($langs->trans("Metres"), $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	
	$head  = market_prepare_head($market);
	dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

	$work_metresHead  = market_works_prepare_head($works);
	dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("metres"), 0, 'submunu4');

	// echo $market->getMarketHeader($wid);

	$moreparam = '&wid='.$wid;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input type="hidden" name="wid" value="'. $wid .'" />';
	print '<table class="noborder" width="100%">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "rowid", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"], 'fk_createdby', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	
	print_liste_field_titre($langs->trans("Numéro"),$_SERVER["PHP_SELF"], "num", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Quantity"), $_SERVER["PHP_SELF"], 'qty', '',  $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Date"), $_SERVER["PHP_SELF"],'mdate','', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>";

	// FILTRES
	print '<tr class="liste_titre nc_filtrage_tr">';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="14" type="text" name="search_ref" value="'.dol_escape_htmltag($search_ref).'" />';
	print '</td>';

	print '<td class="liste_titre" align="center">'.$form->select_dolusers($search_par,"search_par",1,"",0,'','',0,32).'
   </td>';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat center" size="30" type="text" name="search_num" value="'.dol_escape_htmltag($search_num).'" />';
	print '</td>';

	print '<td class="liste_titre" align="center"><input class="flat center" type="text" size="14" name="search_qty" value="'.$search_qty.'"></td>';



	//print '<td class="liste_titre" align="center"><input class=" center" type="text" size="14" name="search_mdate" value="'.$search_mdate.'"></td>';
print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="20" name="search_mdate" value="'. dol_escape_htmltag($search_mdate) .'"></td>';
	// ACTION
	print '<td align="right" style="min-width:62px;">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';
	print "</tr>\n";

	// Lines
	if (count($object->lines)) {
		foreach ($object->lines as $line) {
			$var = !$var;
			$qty= $line->qty ? $line->qty: '';
			$fuser->fetch($db->escape($line->fk_createdby));
			$num	= $line->num ? $line->num : '';
			$statut	= (int)$line->statut ? $line->statut: '';
		   $mdate = $line->mdate ? dol_print_date($line->mdate, 'day'): '';

			print '<tr '.$bc[$var].'>';
			print '<td align="left">';
				print $object->getNomUrl(1,  $line->id, $line->fk_td_work);
			print '</td>';
			print '<td align="center">'.$fuser->getNomUrl('1').'</td>';

			print '<td align="center">'.$num .'</td>';
			print '<td align="center">'. $qty .'</td>';
			print '<td align="center">'. $mdate .'</td>';
			print '<td>&nbsp;</td>';
			print '</tr>';
		}
	} else {
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'" align="center">'.$langs->trans('NoneResult').'</td>';
	    print '</tr>';
	}

	if ($user->id /*&& $user->rights->btp->write*/) {
		// $exceedingCls = $totalExceedingDays ? 'red' : 'green';
		print '<tr>';
	    print '<td colspan="7" '.$bc[false].'">';

		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&wid='. $wid .'" class="butAction">'.$langs->trans('AddMetre').'</a>';
		
		print '</div>';
	    print '</td></tr>';
	}

	print '</table>';
	print '</form>';
}

llxFooter();

$db->close();

?>