<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 */

/**
 * \file       btp/market/work_supplies/index.php
 * \ingroup    list
 * \brief      CRUD of work_supplies
 */
$res=0;
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../../main.inc.php")) $res=@include("../../../../main.inc.php"); // For "custom" 
// load css theme.css ici 
$langs->load('btp@btp');
dol_include_once('/btp/core/class/html.form.class.php');
dol_include_once('/btp/market/work_metres/class/work_metres.class.php');
dol_include_once('/btp/market/market/class/market.class.php');
dol_include_once('/btp/market/works/class/works.class.php');
dol_include_once('/btp/lib/btp.lib.php');
dol_include_once('/btp/lib/tools.lib.php');


// Protection if external user
if (!$user) accessforbidden();

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$wid 	 = GETPOST('wid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$wid && $request_method !== 'POST')
	die('ID travaux n\'existe pas!');

$error 	= false;
$object  = new MarketWorkMetres($db);
$works   = new MarketWorks($db);
$market  = new Market($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    // if (empty($user->rights->btp->write) || empty($user->rights->btp->write_all)) {
    // 	$error++;
    // 	setEventMessage($langs->trans('CantCreate'));
    // } else {
	   
	     $wid 	= (int)trim($_POST['wid']);
    	$nume	= trim($_POST['nume']);
    	$qt		= (int)trim($_POST['qty']);
    	$mdates	=trim($_POST['mdates']);
         if ($wid <= 0  || $qt <= 0 || $mdates=="" || $wid <= 0) {
			header('Location: ./card.php?action=add&wid='.$wid);
			die();
	    }
	    $object->fk_createdby 	= $user->id;
	    $object->fk_td_work  	= $wid;
	    $object->num			= $nume;
        $object->qty 			= $qt;
	    $object->mdate	= Tools::convertDateTo($mdates, 'sql');

		$getId = $object->create();

		if ($getId) {
		    header('Location: ./index.php?id='. $getId .'&wid='.$wid);
		    die();
		} else {
			header('Location: ./index.php?wid='.$wid);
		    die();
		}
    // }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['wid'] > 0 && $request_method === 'POST') {
	    $id 		= (int)trim($_POST['id']);
	    $wid 		= (int)trim($_POST['wid']);
	    $stat		= 0;
	    $num 		= trim($_POST['num']);
    	$datem		= trim($_POST['datem']);
    	$qty		= (int)trim($_POST['qty']);
	    if ($wid <= 0 || $id <= 0 || $qty<= 0 || $datem=="" || $num<=0) {
			header('Location: ./index.php?wid='.$wid);
			die();
	    }
	    $data = array(
		    'num'		 => $num,
		    'statut' 		 => $stat,
		    'qty' 			 => $qty,
		    'mdate' 		 => Tools::convertDateTo($datem, 'sql'),
		     );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&wid='.$wid);
	    die();
	$action = "edit";
}
if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes'/* && $user->rights->btp->delete*/) {
	$error = 0;
	$wid = GETPOST('wid', 'int');
	$id  = (int) GETPOST('id', 'int');
	
	if (!$wid || !$id)
		return;

	$db->begin();

	$canedit = true;
	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?wid='.$wid);
	exit;
}

$form = new FormChild($db);
// fetch works and market objects
$works->fetch($wid);
$market->fetch($works->fk_market);

llxHeader(array(), $langs->trans('work_metres'),'','','','',array('/btp/js/btp.js'),array(),0,0);
$market->fetch($wid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_metresHead  = market_works_prepare_head($works);
		dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');
        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

       
   print '<tr><td class="fieldrequired">'.$langs->trans("Numéro").'</td><td>';
        print '<input type="text" class="flat" name="nume" min="1" required="required"/>';
        print '</td></tr>';

      

        print '<tr><td class="">'.$langs->trans("Quantity").'</td><td>';
              print '<input type="number" class="flat" name="qty" min="1"required="required" />';
        print '</td></tr>';

        print '<tr><td class="">'.$langs->trans("Date").'</td><td>';
      print '<input type="text" class="datepicker" autocomplete="off"  value="" name="mdates" required="required"/>';
        print '</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateMetre") .'" name="bouton" class="butAction">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="butAction" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    // }
} else {
	if ($id > 0 && $wid > 0) {
		$object->fetch($id);
		$head  = market_prepare_head($market);
		dol_fiche_head($head, 'works', $langs->trans("Works"), 0, '');

		$work_metresHead  = market_works_prepare_head($works);
		dol_fiche_head($work_metresHead, 'work_metres', $langs->trans("Metres"), 0, 'submunu');

		$canedit = true;/*($user->rights->btp->delete || $user->rights->btp->write_all);*/

		if ($canedit) {
			if ($action == 'edit') {
				// echo $market->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="wid" value="'. $wid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

		  

				$nume	= $object->num ? $object->num : '';
				$qantite= $object->qty ? $object->qty : '';
	
				$date_metre	= $object->mdate ? dol_print_date($object->mdate, 'day') : '';
				   $id 				= (int)trim($_POST['id']);

				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

                print '<tr><td class="">'.$langs->trans("Numéro").'</td><td>';
		        print '<input type="text" class="flat" name="num" value="'. $nume.'" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Quantity").'</td><td>';
		        print '<input type="number" class="flat" name="qty" min="1" value="'. $qantite .'" required="required"/>';
		        print '</td></tr>';

		    

		        print '<tr><td class="">'.$langs->trans("Date").'</td><td>';
		     
                print '<input type="text" class="datepicker" autocomplete="off"  value="'. $date_metre .'" name="datem" required="required" />';
		        print '</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    // if ($user->rights->btp->delete)	{
                    	print '<a href="./index.php?id='.$id.'&action=delete&wid='. $wid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    // }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
